package ONVIF::Analytics::Types::ShapeDescriptor;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %BoundingBox_of :ATTR(:get<BoundingBox>);
my %CenterOfGravity_of :ATTR(:get<CenterOfGravity>);
my %Polygon_of :ATTR(:get<Polygon>);
my %Extension_of :ATTR(:get<Extension>);

__PACKAGE__->_factory(
    [ qw(        BoundingBox
        CenterOfGravity
        Polygon
        Extension

    ) ],
    {
        'BoundingBox' => \%BoundingBox_of,
        'CenterOfGravity' => \%CenterOfGravity_of,
        'Polygon' => \%Polygon_of,
        'Extension' => \%Extension_of,
    },
    {
        'BoundingBox' => 'ONVIF::Analytics::Types::Rectangle',
        'CenterOfGravity' => 'ONVIF::Analytics::Types::Vector',
        'Polygon' => 'ONVIF::Analytics::Types::Polygon',
        'Extension' => 'ONVIF::Analytics::Types::ShapeDescriptorExtension',
    },
    {

        'BoundingBox' => 'BoundingBox',
        'CenterOfGravity' => 'CenterOfGravity',
        'Polygon' => 'Polygon',
        'Extension' => 'Extension',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Analytics::Types::ShapeDescriptor

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
ShapeDescriptor from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * BoundingBox


=item * CenterOfGravity


=item * Polygon


=item * Extension




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Analytics::Types::ShapeDescriptor
   BoundingBox => ,
   CenterOfGravity => ,
   Polygon =>  { # ONVIF::Analytics::Types::Polygon
     Point => ,
   },
   Extension =>  { # ONVIF::Analytics::Types::ShapeDescriptorExtension
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

