/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui.progress;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;

public class ProgressController {
    private static final long PAUSE = 1000L;
    private final ProgressHandle _progress;
    private final Component _target;
    private boolean _used;
    private boolean _canceled;
    private boolean _finished;

    ProgressController(ProgressHandle handle, Component uiComponent) {
        if (handle == null) {
            throw new NullPointerException("handle");
        }
        if (uiComponent == null) {
            throw new NullPointerException("uiComponent");
        }
        this._progress = handle;
        this._target = uiComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        this.avoidEventDispatchThreadExecution();
        ProgressController progressController = this;
        synchronized (progressController) {
            this._progress.finish();
            this._finished = true;
        }
        Thread job = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            ProgressController.this._target.firePropertyChange("finish", 0L, 1L);
                        }
                    });
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
        }, "Progress Finish");
        job.start();
        try {
            job.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.showUIComponent(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        this.avoidEventDispatchThreadExecution();
        ProgressController progressController = this;
        synchronized (progressController) {
            this._progress.finish();
            this._finished = true;
            this._canceled = true;
        }
        Thread job = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            ProgressController.this._target.firePropertyChange("cancel", 0L, 1L);
                        }
                    });
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
        }, "Progress Cancel");
        job.start();
        try {
            job.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.showUIComponent(false);
    }

    public synchronized boolean isCanceled() {
        return this._canceled;
    }

    public synchronized boolean isFinished() {
        return this._finished;
    }

    public void progress(int workunit) {
        this._progress.progress(workunit);
    }

    public void lockout() {
        this.avoidEventDispatchThreadExecution();
        Thread job = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            ProgressController.this._target.firePropertyChange("lockout", 0L, 1L);
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
        }, "Progress Lockout");
        job.start();
        try {
            job.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void progress(String message, int workunit) {
        this.avoidEventDispatchThreadExecution();
        this._progress.progress(message, workunit);
        this.updateProgressMessage(message);
    }

    public void progress(String message) {
        this.avoidEventDispatchThreadExecution();
        this._progress.progress(message);
        this.updateProgressMessage(message);
    }

    public synchronized void start() {
        this.avoidEventDispatchThreadExecution();
        if (this._used) {
            throw new IllegalStateException("Task already started");
        }
        this.showUIComponent(true);
        this._progress.start();
        this._used = true;
    }

    public synchronized void start(int workunits) {
        this.avoidEventDispatchThreadExecution();
        if (this._used) {
            throw new IllegalStateException("Task already started");
        }
        this.showUIComponent(true);
        this._used = true;
        this._progress.start(workunits);
    }

    public synchronized void dispose() {
        this.avoidEventDispatchThreadExecution();
        if (!this._finished) {
            throw new IllegalStateException("Task not yet finished/canceled");
        }
        this.showUIComponent(false);
    }

    synchronized void setCanceled() {
        this._finished = true;
        this._canceled = true;
    }

    private void showUIComponent(final boolean show) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    ProgressController.this._target.setVisible(show);
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    private void updateProgressMessage(String message) {
        final PropertyChangeListener[] listeners = this._target.getPropertyChangeListeners();
        final PropertyChangeEvent evt = new PropertyChangeEvent(this, "update", "", message);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < listeners.length; ++i) {
                    listeners[i].propertyChange(evt);
                }
            }
        });
    }

    private void avoidEventDispatchThreadExecution() throws RuntimeException {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new RuntimeException("AWT Event Dispatch Thread used!");
        }
    }
}

