/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.pws.imex;

import com.paterva.maltego.importexport.ConfigFolderNode;
import com.paterva.maltego.pws.imex.SelectableService;
import com.paterva.maltego.pws.imex.SelectableServiceType;
import com.paterva.maltego.pws.imex.ServiceExistInfo;
import com.paterva.maltego.pws.imex.ServiceNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class ServiceTypeNode
extends ConfigFolderNode {
    ServiceTypeNode(SelectableServiceType servicetype, ServiceExistInfo existInfo) {
        this(servicetype, new InstanceContent(), existInfo);
    }

    private ServiceTypeNode(SelectableServiceType servicetype, InstanceContent content, ServiceExistInfo existInfo) {
        super((Children)new ServiceChildren(servicetype, existInfo), (Lookup)new AbstractLookup((AbstractLookup.Content)content));
        this.addLookups(content, servicetype);
        this.setName(servicetype.getServiceType());
        this.setShortDescription(servicetype.size() + " Service");
        this.setSelectedNonRecursive(servicetype.isSelected());
    }

    private void addLookups(InstanceContent content, SelectableServiceType servicetype) {
        content.add((Object)servicetype);
        content.add((Object)this);
    }

    public final void setSelectedNonRecursive(Boolean selected) {
        if (!this.isSelected().equals(selected)) {
            super.setSelectedNonRecursive(selected);
            SelectableServiceType servicetype = (SelectableServiceType)this.getLookup().lookup(SelectableServiceType.class);
            servicetype.setSelected(selected);
        }
    }

    protected boolean unselectWhenNoSelectedChildren() {
        return true;
    }

    private static class ServiceChildren
    extends Children.Keys<SelectableService> {
        private final String _serviceType;
        private final ServiceExistInfo _existInfo;

        public ServiceChildren(SelectableServiceType servicetype, ServiceExistInfo existInfo) {
            this._serviceType = servicetype.getServiceType();
            this._existInfo = existInfo;
            this.setKeys(servicetype);
        }

        protected Node[] createNodes(SelectableService service) {
            ServiceNode serviceNode = new ServiceNode(this._serviceType, service, this._existInfo);
            return new Node[]{serviceNode};
        }
    }
}

