/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.updater;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.netbeans.updater.Localization;
import org.netbeans.updater.ModuleUpdater;
import org.netbeans.updater.UpdatingContext;
import org.netbeans.updater.XMLUtil;

public final class UpdaterInternal {
    public static final String RUNNING = "RUNNING";
    public static final String FINISHED = "FINISHED";

    private UpdaterInternal() {
    }

    public static void update(final Collection<File> files, final PropertyChangeListener l, String branding) throws InterruptedException {
        Localization.setBranding(branding);
        class Context
        implements UpdatingContext {
            private Map<File, Long> modified = new HashMap<File, Long>();
            private String label;

            Context() {
            }

            @Override
            public Collection<File> forInstall() {
                return files;
            }

            @Override
            public boolean isFromIDE() {
                return true;
            }

            @Override
            public void unpackingIsRunning() {
                this.firePropertyChange(UpdaterInternal.RUNNING, null, this.label);
            }

            @Override
            public void unpackingFinished() {
                this.runningFinished();
            }

            @Override
            public void runningFinished() {
                this.firePropertyChange(UpdaterInternal.FINISHED, null, this.modified);
            }

            @Override
            public void setProgressValue(long bytesRead) {
            }

            @Override
            public void setLabel(String string) {
                this.label = string;
            }

            @Override
            public void setProgressRange(long i, long totalLength) {
            }

            @Override
            public void disposeSplash() {
            }

            private void firePropertyChange(String name, Object oldV, Object newV) {
                if (l != null) {
                    PropertyChangeEvent ev = new PropertyChangeEvent(this, name, oldV, newV);
                    l.propertyChange(ev);
                }
            }

            @Override
            public OutputStream createOS(final File file) throws FileNotFoundException {
                if (this.modified.get(file) == null) {
                    this.modified.put(file, file.lastModified());
                }
                XMLUtil.LOG.log(Level.FINE, "Creating output stream for {0}", file);
                return new FileOutputStream(file){
                    boolean closed;

                    @Override
                    public void close() throws IOException {
                        if (this.closed) {
                            return;
                        }
                        this.closed = true;
                        XMLUtil.LOG.log(Level.FINE, "Closing output stream for {0}", file);
                        super.close();
                        XMLUtil.LOG.log(Level.INFO, "File installed {0}@{1}", new Object[]{file, modified.get(file)});
                    }
                };
            }
        }
        Context c = new Context();
        ModuleUpdater mu = new ModuleUpdater(c);
        mu.start();
        mu.join();
    }
}

