/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.EditorKit;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DocumentLine;
import org.openide.text.DocumentStatus;
import org.openide.text.Line;
import org.openide.text.LineVector;
import org.openide.text.NbDocument;
import org.openide.text.UndoRedoManager;
import org.openide.text.UserQuestionExceptionHandler;
import org.openide.util.Mutex;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.UserQuestionException;
import org.openide.util.Utilities;

final class DocumentOpenClose {
    static final RequestProcessor RP = new RequestProcessor("org.openide.text Document Processing", 1, false, false);
    private static final int NULL_DOCUMENT_CLOSE_DELAY = 1000;
    private static final Logger LOG = CloneableEditorSupport.ERR;
    final CloneableEditorSupport ces;
    final Object lock;
    DocumentStatus documentStatus = DocumentStatus.CLOSED;
    DocumentLoad activeOpen;
    RequestProcessor.Task activeOpenTask;
    DocumentClose activeClose;
    RequestProcessor.Task activeCloseTask;
    Runnable preReloadEDT;
    DocumentLoad activeReload;
    RequestProcessor.Task activeReloadTask;
    DocumentRef docRef;
    final Object docRefLock;
    StyledDocument strongDocRef;
    boolean firingCloseDocument;
    StyledDocument docOpenedWhenFiringCloseDocument;

    static String getSimpleName(Object o) {
        return o != null ? o.getClass().getSimpleName() + "@" + System.identityHashCode(o) : "null";
    }

    DocumentOpenClose(CloneableEditorSupport ces) {
        this.ces = ces;
        this.lock = ces.getLock();
        this.docRefLock = new Object();
    }

    public DocumentStatus getDocumentStatusLA() {
        return this.documentStatus;
    }

    void setDocumentStatusLA(DocumentStatus documentStatus) {
        this.documentStatus = documentStatus;
    }

    StyledDocument getDocument() {
        return this.getRefDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StyledDocument getRefDocument() {
        Object object = this.docRefLock;
        synchronized (object) {
            return this.docRef != null ? (StyledDocument)this.docRef.get() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDocRef(StyledDocument doc) {
        Object object = this.docRefLock;
        synchronized (object) {
            this.docRef = doc != null ? new DocumentRef(doc) : null;
        }
    }

    void setDocumentStronglyReferenced(boolean stronglyReferenced) {
        StyledDocument doc;
        this.strongDocRef = stronglyReferenced ? (doc = this.getRefDocument()) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StyledDocument open() throws IOException {
        RequestProcessor.Task task;
        DocumentLoad load;
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, "open() requested by", new Exception());
        }
        Object object = this.lock;
        synchronized (object) {
            StyledDocument openDoc = this.retainExistingDocLA();
            if (openDoc != null) {
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.finer("open(): Existing openDoc retained.\n");
                }
                return openDoc;
            }
            switch (this.documentStatus) {
                case OPENED: {
                    if (LOG.isLoggable(Level.FINER)) {
                        LOG.finer("open(): status OPENED but doc GCed. Schedule close task followed by possible open task\n");
                    }
                    this.closeImplLA(null, false);
                    if (this.activeOpen == null) {
                        this.initLoadTaskLA();
                    }
                    load = this.activeOpen;
                    task = this.activeOpenTask;
                    break;
                }
                case CLOSED: {
                    if (LOG.isLoggable(Level.FINER)) {
                        LOG.finer("open(): status CLOSED. Schedule a synchronous open task\n");
                    }
                    if (this.activeOpen == null) {
                        this.initLoadTaskLA();
                    }
                    load = this.activeOpen;
                    task = this.activeOpenTask;
                    break;
                }
                case RELOADING: {
                    load = this.activeReload;
                    task = this.activeReloadTask;
                    break;
                }
                case LOADING: {
                    load = this.activeOpen;
                    task = this.activeOpenTask;
                    break;
                }
                default: {
                    throw this.invalidStatus();
                }
            }
        }
        if (load == null || task == null) {
            LOG.info("load=" + load + ", task=" + task + ", this: " + this);
        }
        task.waitFinished();
        if (load.loadIOException != null) {
            throw load.loadIOException;
        }
        if (load.loadRuntimeException != null) {
            throw load.loadRuntimeException;
        }
        return load.loadDoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Task openTask() {
        Object object = this.lock;
        synchronized (object) {
            final StyledDocument existingDoc = this.retainExistingDocLA();
            if (existingDoc != null) {
                Task existingDocTask = new Task(new Runnable(){
                    private final StyledDocument doc;
                    {
                        this.doc = existingDoc;
                    }

                    @Override
                    public void run() {
                    }
                });
                existingDocTask.run();
                return existingDocTask;
            }
            if (this.activeOpenTask != null) {
                return this.activeOpenTask;
            }
            switch (this.documentStatus) {
                case OPENED: {
                    this.closeImplLA(null, false);
                    this.initLoadTaskLA();
                    break;
                }
                case CLOSED: {
                    this.initLoadTaskLA();
                    break;
                }
                case RELOADING: {
                    return this.activeReloadTask;
                }
                case LOADING: {
                    assert (this.activeOpenTask != null);
                    break;
                }
                default: {
                    throw this.invalidStatus();
                }
            }
            return this.activeOpenTask;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForCloseFinish() {
        RequestProcessor.Task closeTask;
        Object object = this.lock;
        synchronized (object) {
            closeTask = this.activeCloseTask;
        }
        if (closeTask != null) {
            closeTask.waitFinished();
        }
    }

    boolean isDocumentLoadedOrLoading() {
        this.waitForCloseFinish();
        Object object = this.lock;
        synchronized (object) {
            switch (this.documentStatus) {
                case CLOSED: {
                    return false;
                }
                case OPENED: 
                case RELOADING: 
                case LOADING: {
                    return true;
                }
            }
            throw this.invalidStatus();
        }
    }

    boolean isDocumentOpened() {
        this.waitForCloseFinish();
        Object object = this.lock;
        synchronized (object) {
            switch (this.documentStatus) {
                case CLOSED: 
                case RELOADING: 
                case LOADING: {
                    return false;
                }
                case OPENED: {
                    return true;
                }
            }
            throw this.invalidStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Task reloadTask() {
        Object object = this.lock;
        synchronized (object) {
            if (this.activeReloadTask != null) {
                return this.activeReloadTask;
            }
            return Task.EMPTY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reload(JEditorPane[] openedPanes) {
        DocumentLoad reloadEDTTask = null;
        Object object = this.lock;
        synchronized (object) {
            switch (this.documentStatus) {
                case CLOSED: {
                    break;
                }
                case RELOADING: {
                    break;
                }
                case OPENED: 
                case LOADING: {
                    StyledDocument reloadDoc;
                    if (this.activeClose != null || this.activeReload != null || (reloadDoc = (StyledDocument)this.docRef.get()) == null) break;
                    this.initReloadTaskLA(reloadDoc, openedPanes);
                    reloadEDTTask = this.activeReload;
                    break;
                }
                default: {
                    throw this.invalidStatus();
                }
            }
        }
        if (reloadEDTTask != null) {
            Mutex.EVENT.readAccess(reloadEDTTask);
        }
    }

    private StyledDocument retainExistingDocLA() {
        switch (this.documentStatus) {
            case CLOSED: {
                break;
            }
            case RELOADING: 
            case LOADING: {
                this.cancelCloseLA();
                break;
            }
            case OPENED: {
                StyledDocument openDoc = this.getRefDocument();
                if (openDoc == null) break;
                this.cancelCloseLA();
                if (this.activeClose != null) break;
                return openDoc;
            }
            default: {
                throw this.invalidStatus();
            }
        }
        return null;
    }

    private void initLoadTaskLA() {
        if (this.activeOpen != null) {
            throw new IllegalStateException("Open task already inited. State:\n" + this);
        }
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("initLoadTaskLA(): Schedule open task followed by change firing task.\n");
        }
        this.activeOpen = new DocumentLoad();
        this.activeOpenTask = RP.create((Runnable)this.activeOpen);
        this.activeOpenTask.schedule(0);
        RP.create((Runnable)new DocumentOpenFire(this.activeOpen)).schedule(0);
    }

    private void initReloadTaskLA(StyledDocument reloadDoc, JEditorPane[] openedPanes) {
        assert (this.activeReload == null) : "Reload task already inited.";
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("initLoadTaskLA(): Schedule reload task.\n");
        }
        this.activeReload = new DocumentLoad(reloadDoc, openedPanes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        Object object = this.lock;
        synchronized (object) {
            StyledDocument doc = this.getRefDocument();
            this.closeImplLA(doc, doc == null);
        }
    }

    void closeImplLA(StyledDocument doc, boolean delayedClose) {
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.log(Level.FINEST, "Close requested by:\n", new Exception());
        }
        if (this.activeClose != null) {
            if (!delayedClose && this.activeClose.delayedClose) {
                this.cancelCloseLA();
                if (this.activeClose != null) {
                    if (LOG.isLoggable(Level.FINER)) {
                        LOG.finer("closeImplLA(): Delayed active close already running (can't be cancelled). Return.\n");
                    }
                    return;
                }
            } else {
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.finer("closeImplLA(): Close already in progress. Return.\n");
                }
                return;
            }
        }
        assert (this.activeClose == null);
        this.activeClose = new DocumentClose(doc, delayedClose);
        this.activeCloseTask = RP.create((Runnable)this.activeClose);
        int delay = delayedClose ? 1000 : 0;
        this.activeCloseTask.schedule(delay);
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("closeImplLA(): Scheduled close task with delay=" + delay + ".\n");
        }
    }

    void cancelCloseLA() {
        if (LOG.isLoggable(Level.FINER)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.log(Level.FINEST, "cancelCloseLA(): Attempt to cancel close by\n", new Exception());
            } else {
                LOG.finer("cancelCloseLA(): Attempt to cancel close.\n");
            }
        }
        if (this.activeClose != null && this.activeClose.cancel()) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("cancelCloseLA(): activeClose().cancel() successful.\n");
            }
            this.activeCloseTask.cancel();
            this.activeCloseTask = null;
            this.activeClose = null;
        }
    }

    void updateLines(final StyledDocument doc, final boolean close) {
        LineVector lineVector = this.ces.findLineVector();
        lineVector.updateLines(new LineVector.LineUpdater(){

            @Override
            public void updateLine(Line line) {
                if (line instanceof DocumentLine) {
                    ((DocumentLine)line).documentOpenedClosed(doc, close);
                }
            }
        });
    }

    IllegalStateException invalidStatus() {
        return new IllegalStateException("Unknown documentStatus=" + (Object)((Object)this.documentStatus));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(200);
        sb.append("DocumentOpenClose: ").append(DocumentOpenClose.getSimpleName((Object)this.ces)).append(", documentStatus=").append((Object)this.documentStatus);
        DocumentRef ref = this.docRef;
        sb.append(", docRef=");
        if (ref != null) {
            StyledDocument doc = (StyledDocument)ref.get();
            sb.append("(").append(DocumentOpenClose.getSimpleName(doc)).append(")");
        } else {
            sb.append("null");
        }
        if (this.activeOpen != null) {
            sb.append("\n  activeOpen: ").append(this.activeOpen);
        }
        if (this.activeReload != null) {
            sb.append("\n  activeReload: ").append(this.activeReload);
        }
        if (this.activeClose != null) {
            sb.append("\n  activeClose: ").append(this.activeClose);
        }
        return sb.toString();
    }

    private final class DocumentRef
    extends WeakReference<StyledDocument>
    implements Runnable {
        public DocumentRef(StyledDocument doc) {
            super(doc, Utilities.activeReferenceQueue());
            Logger.getLogger("TIMER").log(Level.FINE, "TextDocument", doc);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = DocumentOpenClose.this.lock;
            synchronized (object) {
                if (this == DocumentOpenClose.this.docRef) {
                    DocumentOpenClose.this.closeImplLA(null, true);
                }
            }
        }
    }

    private final class DocumentClose
    implements Runnable {
        final StyledDocument closeDoc;
        final boolean delayedClose;
        boolean cancelled;
        boolean started;
        boolean readLockedRun;

        public DocumentClose(StyledDocument closeDoc, boolean delayedClose) {
            this.closeDoc = closeDoc;
            this.delayedClose = delayedClose;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.readLockedRun) {
                this.readLockedRun = false;
                this.readLockedRun();
                return;
            }
            Object object = DocumentOpenClose.this.lock;
            synchronized (object) {
                if (this.cancelled) {
                    return;
                }
                this.started = true;
            }
            DocumentOpenClose.this.setDocRef(null);
            try {
                DocumentOpenClose.this.ces.setListeningOnEnv(false);
                this.readLockedRun = true;
                if (this.closeDoc != null) {
                    this.closeDoc.render(this);
                }
                DocumentOpenClose.this.ces.updateLineSet(true);
                DocumentOpenClose.this.updateLines(this.closeDoc, true);
            }
            finally {
                object = DocumentOpenClose.this.lock;
                synchronized (object) {
                    DocumentOpenClose.this.documentStatus = DocumentStatus.CLOSED;
                    DocumentOpenClose.this.activeCloseTask = null;
                    DocumentOpenClose.this.activeClose = null;
                }
                DocumentOpenClose.this.firingCloseDocument = true;
                boolean success = false;
                try {
                    DocumentOpenClose.this.ces.fireDocumentChange(this.closeDoc, true);
                    success = true;
                }
                finally {
                    DocumentOpenClose.this.firingCloseDocument = false;
                    DocumentOpenClose.this.docOpenedWhenFiringCloseDocument = null;
                    if (LOG.isLoggable(Level.FINER)) {
                        LOG.finer("documentClose(): fireDocumentChange: success=" + success + "\n");
                    }
                }
            }
        }

        void readLockedRun() {
            DocumentOpenClose.this.ces.callNotifyUnmodified();
            if (this.closeDoc != null) {
                this.closeDoc.removeUndoableEditListener((UndoableEditListener)DocumentOpenClose.this.ces.getUndoRedo());
                DocumentOpenClose.this.ces.removeDocListener(this.closeDoc);
            }
            DocumentOpenClose.this.ces.getPositionManager().documentClosed();
            DocumentOpenClose.this.ces.getUndoRedo().discardAllEdits();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean cancel() {
            Object object = DocumentOpenClose.this.lock;
            synchronized (object) {
                if (this.started) {
                    return false;
                }
                this.cancelled = true;
                return true;
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(200);
            sb.append("closeDoc=").append(DocumentOpenClose.getSimpleName(this.closeDoc)).append(", delayedClose=").append(this.delayedClose).append(", cancelled=").append(this.cancelled).append(", started=").append(this.started);
            return sb.toString();
        }
    }

    private static final class DocumentOpenFire
    implements Runnable {
        final DocumentLoad documentOpen;

        public DocumentOpenFire(DocumentLoad documentOpen) {
            this.documentOpen = documentOpen;
        }

        @Override
        public void run() {
            assert (!this.documentOpen.reload) : "This task should not be posted for reloads.";
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("documentLoad(): Going to fireDocumentChange...\n");
            }
            boolean success = false;
            try {
                this.documentOpen.fireDocumentChange();
                success = true;
            }
            finally {
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.finer("documentLoad(): fireDocumentChange: success=" + success + "\n");
                }
            }
        }
    }

    private final class DocumentLoad
    implements Runnable {
        final boolean reload;
        StyledDocument loadDoc;
        boolean loadSuccess;
        IOException loadIOException;
        RuntimeException loadRuntimeException;
        boolean userQuestionExceptionInReload;
        boolean skipInputStreamReading;
        JEditorPane[] reloadOpenPanes;
        int[] reloadCaretOffsets;
        private boolean atomicLockedRun;
        private boolean preReloadInEDT;

        DocumentLoad() {
            this.reload = false;
        }

        DocumentLoad(StyledDocument loadDoc, JEditorPane[] reloadOpenPanes) {
            assert (loadDoc != null) : "loadDoc cannot be null for reload";
            this.reload = true;
            this.preReloadInEDT = true;
            this.loadDoc = loadDoc;
            this.reloadOpenPanes = reloadOpenPanes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.preReloadInEDT) {
                this.preReloadInEDT = false;
                this.preReloadInEDT();
                return;
            }
            if (this.atomicLockedRun) {
                this.atomicLockedRun = false;
                this.atomicLockedRun();
                return;
            }
            try {
                Object object;
                Object undoRedoManager = DocumentOpenClose.this.ces.getUndoRedo();
                if (!this.userQuestionExceptionInReload) {
                    object = DocumentOpenClose.this.lock;
                    synchronized (object) {
                        if (this.reload) {
                            assert (DocumentOpenClose.this.documentStatus == DocumentStatus.OPENED) : "Invalid documentStatus=" + (Object)((Object)DocumentOpenClose.this.documentStatus) + " expected OPENED";
                            DocumentOpenClose.this.documentStatus = DocumentStatus.RELOADING;
                        } else {
                            assert (DocumentOpenClose.this.documentStatus == DocumentStatus.CLOSED) : "Invalid documentStatus=" + (Object)((Object)DocumentOpenClose.this.documentStatus) + " expected CLOSED";
                            DocumentOpenClose.this.documentStatus = DocumentStatus.LOADING;
                        }
                    }
                    if (this.reload) {
                        this.loadDoc.removeUndoableEditListener((UndoableEditListener)undoRedoManager);
                        undoRedoManager.discardAllEdits();
                    } else {
                        object = DocumentOpenClose.this.lock;
                        synchronized (object) {
                            EditorKit kit = DocumentOpenClose.this.ces.createEditorKit();
                            this.loadDoc = DocumentOpenClose.this.ces.createStyledDocument(kit);
                            assert (this.loadDoc != null) : "kit.createDefaultDocument() returned null";
                        }
                    }
                }
                this.atomicLockedRun = true;
                NbDocument.runAtomic(this.loadDoc, this);
                if (this.loadIOException == null && this.loadRuntimeException == null) {
                    if (this.reload) {
                        undoRedoManager.discardAllEdits();
                    } else {
                        DocumentOpenClose.this.ces.setListeningOnEnv(true);
                    }
                    if (undoRedoManager instanceof UndoRedoManager) {
                        ((UndoRedoManager)((Object)undoRedoManager)).markSavepoint();
                    }
                    if (this.loadDoc != null) {
                        LOG.fine("task-addUndoableEditListener");
                        this.loadDoc.addUndoableEditListener((UndoableEditListener)undoRedoManager);
                    }
                    DocumentOpenClose.this.ces.callNotifyUnmodified();
                    DocumentOpenClose.this.updateLines(this.loadDoc, false);
                    object = DocumentOpenClose.this.lock;
                    synchronized (object) {
                        DocumentOpenClose.this.documentStatus = DocumentStatus.OPENED;
                    }
                    this.loadSuccess = true;
                }
                if (this.reload && this.loadIOException instanceof UserQuestionException) {
                    this.reloadUQEThrown((UserQuestionException)((Object)this.loadIOException));
                }
            }
            catch (RuntimeException ex) {
                this.loadRuntimeException = ex;
            }
            finally {
                if (!this.userQuestionExceptionInReload) {
                    Object object = DocumentOpenClose.this.lock;
                    synchronized (object) {
                        if (!this.loadSuccess) {
                            DocumentOpenClose.this.documentStatus = DocumentStatus.CLOSED;
                            DocumentOpenClose.this.setDocRef(null);
                            DocumentOpenClose.this.ces.setListeningOnEnv(false);
                        }
                        DocumentOpenClose.this.ces.setPreventModification(false);
                        if (this.reload) {
                            DocumentOpenClose.this.activeReloadTask = null;
                            DocumentOpenClose.this.activeReload = null;
                        } else {
                            DocumentOpenClose.this.activeOpenTask = null;
                            DocumentOpenClose.this.activeOpen = null;
                        }
                        if (LOG.isLoggable(Level.FINER)) {
                            LOG.finer("documentLoad(): reload=" + this.reload + ", documentStatus=" + (Object)((Object)DocumentOpenClose.this.documentStatus) + ", loadSuccess=" + this.loadSuccess + "\n");
                        }
                    }
                }
            }
        }

        private void atomicLockedRun() {
            try {
                if (!this.userQuestionExceptionInReload) {
                    if (this.reload) {
                        DocumentOpenClose.this.ces.getPositionManager().documentClosed();
                        DocumentOpenClose.this.ces.updateLineSet(true);
                    }
                    DocumentOpenClose.this.ces.removeDocListener(this.loadDoc);
                    if (this.reload) {
                        LOG.fine("clearDocument");
                        try {
                            if (this.loadDoc.getLength() > 0) {
                                this.loadDoc.remove(0, this.loadDoc.getLength());
                            }
                        }
                        catch (BadLocationException ex) {
                            LOG.log(Level.INFO, null, ex);
                        }
                    }
                } else {
                    this.userQuestionExceptionInReload = false;
                }
                if (!this.skipInputStreamReading) {
                    try (BufferedInputStream is = new BufferedInputStream(DocumentOpenClose.this.ces.cesEnv().inputStream());){
                        DocumentOpenClose.this.ces.loadFromStreamToKit(this.loadDoc, is, DocumentOpenClose.this.ces.createEditorKit());
                    }
                }
                DocumentOpenClose.this.setDocRef(this.loadDoc);
                if (this.reload && this.reloadOpenPanes != null) {
                    DocumentOpenClose.this.ces.getPositionManager().documentOpened(new WeakReference<StyledDocument>(this.loadDoc));
                }
                DocumentOpenClose.this.ces.updateLineSet(true);
                DocumentOpenClose.this.ces.updateLastSaveTime();
                DocumentOpenClose.this.ces.addDocListener(this.loadDoc);
                if (this.reload && this.reloadCaretOffsets != null) {
                    int docLen = this.loadDoc.getLength();
                    final Position[] caretPositions = new Position[this.reloadCaretOffsets.length];
                    for (int i = 0; i < this.reloadCaretOffsets.length; ++i) {
                        try {
                            int offset = this.reloadCaretOffsets[i];
                            offset = Math.max(Math.min(offset, docLen), 0);
                            caretPositions[i] = this.loadDoc.createPosition(offset);
                            continue;
                        }
                        catch (BadLocationException ex) {
                            caretPositions[i] = null;
                        }
                    }
                    Mutex.EVENT.postReadRequest(new Runnable(){

                        @Override
                        public void run() {
                            for (int i = 0; i < DocumentLoad.this.reloadOpenPanes.length; ++i) {
                                JEditorPane pane = DocumentLoad.this.reloadOpenPanes[i];
                                if (pane.getDocument() != DocumentLoad.this.loadDoc || caretPositions[i] == null) continue;
                                DocumentLoad.this.reloadOpenPanes[i].setCaretPosition(caretPositions[i].getOffset());
                            }
                        }
                    });
                }
                DocumentOpenClose.this.ces.setPreventModification(true);
            }
            catch (BadLocationException ex) {
                this.loadRuntimeException = new IllegalStateException(ex);
            }
            catch (IOException ex) {
                this.loadIOException = ex;
            }
        }

        void preReloadInEDT() {
            boolean success = false;
            try {
                this.loadDoc.render(new Runnable(){

                    @Override
                    public void run() {
                        if (DocumentLoad.this.reloadOpenPanes != null) {
                            DocumentLoad.this.reloadCaretOffsets = new int[DocumentLoad.this.reloadOpenPanes.length];
                            for (int i = 0; i < DocumentLoad.this.reloadOpenPanes.length; ++i) {
                                DocumentLoad.this.reloadCaretOffsets[i] = DocumentLoad.this.reloadOpenPanes[i].getCaretPosition();
                            }
                        }
                    }
                });
                DocumentOpenClose.this.activeReloadTask = RP.create((Runnable)this);
                DocumentOpenClose.this.activeReloadTask.schedule(0);
                success = true;
            }
            finally {
                if (!success) {
                    DocumentOpenClose.this.activeReload = null;
                    DocumentOpenClose.this.activeReloadTask = null;
                }
            }
        }

        void reloadUQEThrown(UserQuestionException uqe) {
            this.userQuestionExceptionInReload = true;
            UserQuestionExceptionHandler handler = new UserQuestionExceptionHandler(DocumentOpenClose.this.ces, (UserQuestionException)((Object)this.loadIOException)){

                @Override
                protected StyledDocument openDocument() throws IOException {
                    DocumentLoad.this.loadIOException = null;
                    DocumentOpenClose.this.activeReloadTask.schedule(0);
                    return DocumentLoad.this.loadDoc;
                }

                @Override
                protected void openRefused() {
                    DocumentLoad.this.loadIOException = null;
                    DocumentLoad.this.skipInputStreamReading = true;
                    DocumentOpenClose.this.activeReloadTask.schedule(0);
                }
            };
            handler.runInEDT();
        }

        void fireDocumentChange() {
            if (this.loadSuccess) {
                DocumentOpenClose.this.ces.fireDocumentChange(this.loadDoc, false);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(200);
            sb.append(DocumentOpenClose.getSimpleName(this)).append(": reload=").append(this.reload).append(", loadDoc=").append(DocumentOpenClose.getSimpleName(this.loadDoc)).append(", loadSuccess=").append(this.loadSuccess);
            if (this.reload && this.reloadOpenPanes != null) {
                sb.append(", reloadOpenPanes.length=").append(this.reloadOpenPanes.length);
            }
            return sb.toString();
        }
    }
}

