/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.cloud.ui.auth;

import com.maltego.cloud.CloudAuth;
import com.maltego.cloud.crypto.CloudGraphKeystore;
import com.maltego.cloud.ui.auth.CloudAuthHtmlUtil;
import com.maltego.cloud.ui.auth.CloudAuthKeycloakInstalled;
import com.paterva.maltego.certificates.HttpAgent;
import com.paterva.maltego.licensing.LicenseManager;
import com.paterva.maltego.licensing.free.B;
import com.paterva.maltego.licensing.json.MaltegoIdProductRestrictions;
import com.paterva.maltego.licensing.mode.A;
import com.paterva.maltego.licensing.ui.LicenseWizardDisplayer;
import com.paterva.maltego.licensing.ui.product.ProductSelectionResult;
import com.paterva.maltego.licensing.ui.wizard.LicenseWizard;
import com.paterva.maltego.util.MaltegoUrl;
import com.paterva.maltego.util.NormalException;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.Version;
import com.paterva.maltego.util.http.HttpNotifier;
import com.paterva.maltego.util.http.ProxyUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.NoHttpResponseException;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthState;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.Configurable;
import org.apache.http.client.methods.HttpExecutionAware;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParamConfig;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.conn.DefaultRoutePlanner;
import org.apache.http.impl.conn.DefaultSchemePortResolver;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpParamsNames;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;
import org.keycloak.adapters.HttpClientAdapterException;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.keycloak.adapters.ServerRequest;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.RefreshToken;
import org.keycloak.representations.adapters.config.AdapterConfig;
import org.keycloak.util.TokenUtil;
import org.openide.modules.Places;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;

public class DefaultCloudAuth
extends CloudAuth {
    private static final String CLOUD_SYNC_URL = MaltegoUrl.getCurrent().getCloudSync();
    private static final String CLOUD_SYNC_US_URL = MaltegoUrl.getCurrent().getCloudSyncUS();
    private static final String CLOUD_SYNC_EU_URL = MaltegoUrl.getCurrent().getCloudSyncEU();
    private static final String CLOUD_SCHEMA_VERSION = MaltegoUrl.getCurrent().getCloudSchemaVersion();
    private static final String CLOUD_UI_URL = MaltegoUrl.getCurrent().getGotoVaultUi();
    private static final String CLOUD_CASES_URL = MaltegoUrl.getCurrent().getGotoVaultCases();
    private static final String CLOUD_CASES_TEXT = MaltegoUrl.getCurrent().getGotoVaultCasesText();
    private static final String BROWSER_GRAPH_URL_PREFIX = MaltegoUrl.getCurrent().getGotoBrowserGraphPrefix();
    private static final String KEYCLOAK_ISSUER_URL_PREFIX = MaltegoUrl.getCurrent().getAuthIssuerPrefix();
    private static final String KEYCLOAK_REALM = MaltegoUrl.getCurrent().getAuthRealm();
    private static final String KEYCLOAK_CLIENT_ID = MaltegoUrl.getCurrent().getAuthClientId();
    private static final String PREF_REFRESH_TOKEN = "maltego.auth.refresh.token";
    private static final String PREF_LOGGED_OUT = "maltego.auth.logged.out";
    private static final String PREF_ORG_REGION = "maltego.auth.org.region";
    private static final String KEY_ORG_NAME = "organization";
    private static final String KEY_REGION = "region";
    private static final int REFRESH_BUFFER_SECONDS = 90;
    private static final Logger LOG = Logger.getLogger(DefaultCloudAuth.class.getName());
    private String cloudSyncUrl = CLOUD_SYNC_URL;
    private boolean usingDebugCloudUrl = false;
    private String cloudSchemaVersion = CLOUD_SCHEMA_VERSION;
    private String cloudUiUrl = CLOUD_UI_URL;
    private String cloudCasesUrl = CLOUD_CASES_URL;
    private String cloudCasesText = CLOUD_CASES_TEXT;
    private String browserGraphUrlPrefix = BROWSER_GRAPH_URL_PREFIX;
    private String keycloakIssuerUrlPrefix = KEYCLOAK_ISSUER_URL_PREFIX;
    private String keycloakRealm = KEYCLOAK_REALM;
    private String keycloakClientId = KEYCLOAK_CLIENT_ID;
    private boolean cloudAuthEnabled = false;
    private CloudAuthKeycloakInstalled authResult;
    private Instant nextTokenExpiration;
    private int refreshSeconds = (int)Duration.ofMinutes(50L).getSeconds();
    private boolean commsIssueOnRefresh = false;
    private Timer timer;

    public void init(boolean showCloudCasesUrl) {
        this.readCloudDebugConfig();
        this.loadRefreshToken(showCloudCasesUrl);
        ProxyUtils.addPreferenceChangeListener((PreferenceChangeListener)new ProxySettingsListener());
    }

    public void setCloudAuthEnabled(boolean cloudAuthEnabled) {
        this.cloudAuthEnabled = cloudAuthEnabled;
    }

    public boolean isCloudAuthEnabled() {
        boolean isCloudAuth = this.cloudAuthEnabled;
        if (!isCloudAuth) {
            A licenseMode = LicenseManager.A().A(false);
            isCloudAuth = MaltegoIdProductRestrictions.isCloudGraphAllowed((A)licenseMode);
        }
        return isCloudAuth;
    }

    public String getCloudSyncUrl() {
        return this.cloudSyncUrl;
    }

    public String getCloudSchemaVersion() {
        return this.cloudSchemaVersion;
    }

    public String getCloudUiUrl() {
        return this.cloudUiUrl;
    }

    public String getCloudCasesUrl() {
        return this.cloudCasesUrl;
    }

    public String getBrowserGraphUrlPrefix() {
        return this.browserGraphUrlPrefix;
    }

    public boolean isAuthorized() {
        boolean authorized;
        this.printTokenSpecs(false);
        boolean bl = authorized = this.authResult != null && this.nextTokenExpiration != null && this.getAccessToken() != null;
        if (authorized) {
            boolean tryRefresh = false;
            if (!Instant.now().isBefore(this.nextTokenExpiration)) {
                LOG.log(Level.WARNING, "isAuthorized false: {0}", this.getProblemMessage(true));
                RefreshToken refreshToken = this.getRefreshToken();
                this.nextTokenExpiration = this.getNextTokenExpirationInstant(refreshToken, true);
                if (!Instant.now().isBefore(this.nextTokenExpiration)) {
                    LOG.log(Level.INFO, "Checking next token expiration of refresh token only");
                    this.nextTokenExpiration = this.getNextTokenExpirationInstant(refreshToken, false);
                }
                tryRefresh = true;
            } else if (!this.getAccessToken().isActive()) {
                LOG.log(Level.WARNING, "isAuthorized false: Access isActive is false");
                tryRefresh = true;
            }
            if (tryRefresh && Instant.now().isBefore(this.nextTokenExpiration) && !this.getAccessToken().isActive()) {
                LOG.log(Level.INFO, "Access isActive: false; Refresh exp: {0}", this.nextTokenExpiration);
                if (LicenseManager.J()) {
                    LOG.log(Level.INFO, "Maltego ID endpoint is reachable: checking whether authorised");
                    this.loadRefreshToken(false);
                } else {
                    LOG.log(Level.WARNING, "Maltego ID endpoint NOT reachable: checking whether authorised");
                }
            }
        } else if (this.commsIssueOnRefresh && this.authResult == null && this.nextTokenExpiration == null) {
            if (LicenseManager.J()) {
                LOG.log(Level.INFO, "Maltego ID endpoint is reachable - network was down before");
                this.loadRefreshToken(false);
                if (this.authResult != null && this.nextTokenExpiration != null) {
                    this.commsIssueOnRefresh = false;
                }
            }
        } else {
            LOG.log(Level.WARNING, "Maltego ID NOT authorised");
        }
        return authorized && Instant.now().isBefore(this.nextTokenExpiration) && this.getAccessToken().isActive();
    }

    public String getProblemMessage(boolean log) {
        return this.printTokenSpecs(log);
    }

    public AccessToken getAccessToken() {
        return this.authResult.getToken();
    }

    public String getAccessTokenString() {
        return this.authResult.getTokenString();
    }

    public void login(boolean canResetRetriesForFailedRefresh, boolean useSystemBrowser, boolean showCloudCasesUrl, boolean enforceReAuthentication, boolean showOrgSelection) throws Exception {
        int retriesForFailedRefresh;
        if (this.isAuthorized()) {
            return;
        }
        boolean refreshSuccess = false;
        int n = retriesForFailedRefresh = canResetRetriesForFailedRefresh ? 2 : 0;
        if (this.nextTokenExpiration != null && Instant.now().isAfter(this.nextTokenExpiration)) {
            refreshSuccess = this.tryRefreshAccessToken(canResetRetriesForFailedRefresh, retriesForFailedRefresh);
        }
        if (!refreshSuccess) {
            this.loginToKeycloakWithBrowser(canResetRetriesForFailedRefresh, retriesForFailedRefresh, useSystemBrowser, showCloudCasesUrl, enforceReAuthentication, showOrgSelection);
            this.nextTokenExpiration = this.getNextTokenExpiration();
        }
        NbPreferences.forModule(((Object)((Object)this)).getClass()).remove(PREF_LOGGED_OUT);
    }

    public void logout(boolean silent) throws Exception {
        LOG.log(Level.INFO, "Logging out from Maltego ID. silent = {0}", silent);
        if (this.authResult == null) {
            LOG.log(Level.WARNING, "Maltego is not logged in yet!");
            return;
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        try {
            this.authResult.logout(silent);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "logout(silent=" + silent + ") caused an error", e);
            throw e;
        }
        finally {
            LOG.info("Cleanup auth after logout");
            this.authResult = null;
            this.nextTokenExpiration = null;
            Preferences prefs = NbPreferences.forModule(((Object)((Object)this)).getClass());
            prefs.remove(PREF_REFRESH_TOKEN);
            prefs.putBoolean(PREF_LOGGED_OUT, true);
            CloudGraphKeystore.getDefault().reset();
        }
    }

    public boolean isLoggedOut() {
        return NbPreferences.forModule(((Object)((Object)this)).getClass()).getBoolean(PREF_LOGGED_OUT, false);
    }

    public void resetLoggedOut() {
        NbPreferences.forModule(((Object)((Object)this)).getClass()).remove(PREF_LOGGED_OUT);
    }

    public void reset() throws Exception {
        if (this.authResult != null) {
            String refreshToken = NbPreferences.forModule(((Object)((Object)this)).getClass()).get(PREF_REFRESH_TOKEN, "");
            LOG.log(Level.FINE, "Loaded refresh token: {0}", refreshToken);
            if (!StringUtilities.isNullOrEmpty((String)refreshToken)) {
                LOG.info("Refreshing access token - after reset");
                this.authResult.refreshToken(refreshToken);
                LOG.info("Access token refreshed - after reset");
                this.refreshAccessTokenRelatedInfos();
            }
        }
    }

    public String getAuthUrl(boolean showCloudCasesUrl, boolean enforceReAuthentication, boolean showOrgSelection) {
        String authUrl = null;
        try {
            this.authResult = this.createKeycloakClient(showCloudCasesUrl);
            authUrl = this.authResult.getLoginDesktopUrl(enforceReAuthentication, showOrgSelection);
        }
        catch (Exception ex) {
            NormalException.logStackTrace((Throwable)ex);
        }
        return authUrl;
    }

    public String getLogoutUrl() {
        if (this.authResult == null) {
            return null;
        }
        return this.authResult.getLogoutDesktopUrl(false);
    }

    private void scheduleRefresh(long expiresInSeconds, boolean canResetRetriesForFailedRefresh, int retriesForFailedRefresh) {
        String refreshToken = this.authResult.getRefreshToken();
        if (StringUtilities.isNullOrEmpty((String)refreshToken) || expiresInSeconds <= 0L) {
            return;
        }
        this.scheduleRefresh(refreshToken, expiresInSeconds, canResetRetriesForFailedRefresh, retriesForFailedRefresh);
    }

    private void scheduleRefresh(String refreshToken, long expiresInSeconds, final boolean canResetRetriesForFailedRefresh, final int retriesForFailedRefresh) {
        if (refreshToken == null || expiresInSeconds <= 0L) {
            return;
        }
        long delaySeconds = Math.min((long)this.refreshSeconds, expiresInSeconds - 90L);
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        this.timer = new Timer("Token Refresh", true);
        this.timer.schedule(new TimerTask(){
            final boolean localCanResetRetriesForFailedRefresh;
            final int localRetries;
            {
                this.localCanResetRetriesForFailedRefresh = canResetRetriesForFailedRefresh;
                this.localRetries = retriesForFailedRefresh;
            }

            @Override
            public void run() {
                boolean refreshSuccess = DefaultCloudAuth.this.tryRefreshAccessToken(this.localCanResetRetriesForFailedRefresh, this.localRetries);
                if (refreshSuccess || this.localRetries <= 0) {
                    boolean maltegoIdOnlineActivated;
                    boolean maltegoReachable = true;
                    if (!refreshSuccess) {
                        maltegoReachable = LicenseManager.J();
                        if (maltegoReachable) {
                            LOG.log(Level.WARNING, "Maltego ID endpoint is reachable: trying to refresh token");
                            DefaultCloudAuth.this.authResult = null;
                            DefaultCloudAuth.this.nextTokenExpiration = null;
                        } else {
                            LOG.log(Level.INFO, "Maltego ID endpoint NOT reachable: trying to refresh token");
                        }
                    }
                    DefaultCloudAuth.this.saveRefreshToken();
                    A licenseMode = LicenseManager.A().A(false);
                    boolean bl = maltegoIdOnlineActivated = licenseMode.U() && !licenseMode.S();
                    if (!refreshSuccess && maltegoReachable && (maltegoIdOnlineActivated || licenseMode.L())) {
                        LOG.log(Level.WARNING, "Re-doing login in scheduled refresh");
                        DefaultCloudAuth.this.redoLogin();
                    }
                }
            }
        }, Math.max(1L, delaySeconds * 1000L));
    }

    private boolean tryRefreshAccessToken(boolean canResetRetriesForFailedRefresh, int retriesForFailedRefresh) {
        if (this.authResult != null) {
            try {
                this.refreshAccessToken(canResetRetriesForFailedRefresh);
                this.nextTokenExpiration = this.getNextTokenExpiration();
                return true;
            }
            catch (Exception ex) {
                String msg = ex.getMessage();
                boolean validCommsIssue = !StringUtilities.isNullOrEmpty((String)msg) && (msg.contains("timed out") || msg.contains("Connection reset"));
                validCommsIssue = validCommsIssue || !StringUtilities.isNullOrEmpty((String)msg) && msg.contains("Unable to tunnel through proxy. Proxy returns");
                validCommsIssue = validCommsIssue || ex instanceof SSLHandshakeException && !StringUtilities.isNullOrEmpty((String)msg) && msg.contains("PKIX path building failed");
                validCommsIssue = validCommsIssue || ex instanceof UnknownHostException || ex instanceof SocketTimeoutException || ex instanceof SocketException;
                LOG.log(Level.WARNING, "Token could not be refreshed: {0} - {1}", new Object[]{ex.getClass(), msg});
                if (retriesForFailedRefresh > 0 && validCommsIssue) {
                    LOG.log(Level.WARNING, "Scheduling token refresh");
                    this.scheduleRefresh(120L, canResetRetriesForFailedRefresh, retriesForFailedRefresh - 1);
                }
                return false;
            }
        }
        return false;
    }

    private void refreshAccessToken(boolean canResetRetriesForFailedRefresh) throws Exception {
        this.authResult.refreshToken();
        LOG.info("Access token refreshed");
        this.refreshAccessTokenRelatedInfos();
        if (canResetRetriesForFailedRefresh) {
            this.scheduleRefresh(this.getExpiresIn(), true, 2);
        } else {
            this.scheduleRefresh(this.getExpiresIn(), false, 0);
        }
    }

    private void loginToKeycloakWithBrowser(boolean canResetRetriesForFailedRefresh, int retriesForFailedRefresh, boolean useSystemBrowser, boolean showCloudCasesUrl, boolean enforceReAuthentication, boolean showOrgSelection) throws Exception {
        CloudAuthKeycloakInstalled previousAuthResult = this.authResult;
        if (this.authResult != null) {
            this.authResult = null;
        }
        this.authResult = this.loginToKeycloak(previousAuthResult, useSystemBrowser, showCloudCasesUrl, enforceReAuthentication, showOrgSelection);
        String accessToken = this.authResult.getTokenString();
        this.saveRefreshToken();
        if (!StringUtilities.isNullOrEmpty((String)accessToken)) {
            LOG.info("Received access token");
            this.refreshAccessTokenRelatedInfos();
            this.scheduleRefresh(this.getExpiresIn(), canResetRetriesForFailedRefresh, retriesForFailedRefresh);
        } else {
            LOG.severe("Did not receive access token");
        }
    }

    private CloudAuthKeycloakInstalled loginToKeycloak(CloudAuthKeycloakInstalled keycloak, boolean useSystemBrowser, boolean showCloudCasesUrl, boolean enforceReAuthentication, boolean showOrgSelection) throws Exception {
        if (keycloak == null || useSystemBrowser) {
            keycloak = this.createKeycloakClient(showCloudCasesUrl);
        }
        keycloak.loginDesktop(useSystemBrowser, enforceReAuthentication, showOrgSelection);
        return keycloak;
    }

    private void saveRefreshToken() {
        String refreshToken = "";
        if (this.authResult != null) {
            refreshToken = this.authResult.getRefreshToken();
        }
        LOG.log(Level.FINE, "Saving refresh token: {0}", refreshToken);
        if (StringUtilities.isNullOrEmpty((String)refreshToken)) {
            LOG.log(Level.WARNING, "Saving refresh token, but it is null or empty: {0}", refreshToken);
        }
        NbPreferences.forModule(((Object)((Object)this)).getClass()).put(PREF_REFRESH_TOKEN, refreshToken);
    }

    private void loadRefreshToken(boolean showCloudCasesUrl) {
        try {
            String refreshToken = NbPreferences.forModule(((Object)((Object)this)).getClass()).get(PREF_REFRESH_TOKEN, "");
            LOG.log(Level.FINE, "Loaded refresh token: {0}", refreshToken);
            A licenseMode = LicenseManager.A().A(false);
            if (!StringUtilities.isNullOrEmpty((String)refreshToken)) {
                boolean cloudActivated;
                boolean maltegoIdOnlineActivated = licenseMode.U() && !licenseMode.S();
                boolean bl = cloudActivated = maltegoIdOnlineActivated || licenseMode.L();
                if (!cloudActivated) {
                    LOG.info("Removing refresh token since no longer cloud activated");
                    NbPreferences.forModule(((Object)((Object)this)).getClass()).remove(PREF_REFRESH_TOKEN);
                    return;
                }
                LOG.info("Refreshing access token - during loading");
                this.authResult = this.createKeycloakClient(showCloudCasesUrl);
                this.authResult.refreshToken(refreshToken);
                LOG.info("Access token refreshed - during loading");
                this.refreshAccessTokenRelatedInfos();
                NbPreferences.forModule(((Object)((Object)this)).getClass()).remove(PREF_LOGGED_OUT);
                this.scheduleRefresh(this.getExpiresIn(), true, 2);
                this.nextTokenExpiration = this.getNextTokenExpiration();
            } else {
                boolean maltegoIdOnlineActivated;
                LOG.info("Refresh token not found");
                boolean bl = maltegoIdOnlineActivated = licenseMode.U() && !licenseMode.S();
                if (maltegoIdOnlineActivated || licenseMode.L()) {
                    LOG.log(Level.WARNING, "Re-doing login after trying to load a refresh token");
                    this.redoLogin();
                }
            }
        }
        catch (ServerRequest.HttpFailure ex) {
            LOG.log(Level.WARNING, "Re-doing login after loading refresh token failure");
            this.redoLogin(ex);
        }
        catch (Exception ex) {
            boolean testReachable = false;
            boolean proxyIssue = false;
            boolean networkIssue = false;
            if (ex instanceof NullPointerException) {
                LOG.log(Level.INFO, "Network down on startup");
                testReachable = true;
            } else if (ex instanceof SocketTimeoutException || ex instanceof HttpClientAdapterException || ex instanceof IOException && ex.getMessage() != null && ex.getMessage().contains("timeout")) {
                LOG.log(Level.INFO, "Network down");
                testReachable = true;
            } else if (ex instanceof NoHttpResponseException) {
                LOG.log(Level.INFO, "NoHttpResponseException");
                proxyIssue = true;
            } else {
                Throwable cause = ex.getCause();
                String msg = cause == null ? null : cause.getMessage();
                boolean bl = networkIssue = cause instanceof SSLException && !StringUtilities.isNullOrEmpty((String)msg) && msg.contains("Connection reset");
            }
            if (proxyIssue || networkIssue) {
                this.commsIssueOnRefresh = true;
            } else if (testReachable) {
                if (!this.isKeycloakReachable()) {
                    LOG.log(Level.WARNING, "Maltego ID auth endpoint NOT reachable: trying to load refresh token");
                    this.commsIssueOnRefresh = true;
                } else if (!LicenseManager.J()) {
                    LOG.log(Level.WARNING, "Maltego ID endpoint NOT reachable: trying to load refresh token");
                    this.commsIssueOnRefresh = true;
                } else {
                    LOG.log(Level.WARNING, "Maltego ID endpoint is reachable: trying to load refresh token");
                }
            }
            this.authResult = null;
            this.nextTokenExpiration = null;
            if (this.commsIssueOnRefresh) {
                NormalException.logStackTrace((Throwable)ex);
            }
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void setKeycloakTimeout() {
        if (this.authResult != null && this.authResult.getDeployment() != null && this.authResult.getDeployment().getAdapterConfig() != null) {
            AdapterConfig adapterConfig = this.authResult.getDeployment().getAdapterConfig();
            long connectionTimeout = adapterConfig.getConnectionTimeout();
            long socketTimeout = adapterConfig.getSocketTimeout();
            if (connectionTimeout == -1L && socketTimeout == -1L) {
                adapterConfig.setConnectionTimeout(8000L);
                adapterConfig.setSocketTimeout(8000L);
            }
        }
    }

    private void resetKeycloakTimeout() {
        if (this.authResult != null && this.authResult.getDeployment() != null && this.authResult.getDeployment().getAdapterConfig() != null) {
            AdapterConfig adapterConfig = this.authResult.getDeployment().getAdapterConfig();
            adapterConfig.setConnectionTimeout(-1L);
            adapterConfig.setSocketTimeout(-1L);
        }
    }

    private boolean isKeycloakReachable() {
        boolean reachable = true;
        if (this.authResult != null && this.authResult.getDeployment() != null && this.authResult.getDeployment().getAdapterConfig() != null) {
            try {
                String tokenUrl = this.authResult.getDeployment().getTokenUrl();
                if (tokenUrl == null) {
                    reachable = false;
                    AdapterConfig adapterConfig = this.authResult.getDeployment().getAdapterConfig();
                    String proxyUrl = adapterConfig.getProxyUrl();
                    if (!StringUtilities.isNullOrEmpty((String)proxyUrl)) {
                        HttpNotifier notifier = HttpNotifier.getDefault();
                        notifier.show(proxyUrl);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return reachable;
    }

    private void redoLogin() {
        this.redoLogin(true);
    }

    private void redoLogin(ServerRequest.HttpFailure ex) {
        this.redoLogin(ex.getStatus() == 400);
    }

    private void redoLogin(boolean showWizard) {
        NbPreferences.forModule(((Object)((Object)this)).getClass()).putBoolean(PREF_LOGGED_OUT, true);
        this.authResult = null;
        this.nextTokenExpiration = null;
        if (showWizard) {
            try {
                LicenseManager licMan = LicenseManager.A();
                A licenseMode = licMan.A(false);
                if (licenseMode.L()) {
                    LicenseWizard.setProductSelectionResult((ProductSelectionResult)ProductSelectionResult.RUN_CE);
                    LicenseWizardDisplayer.getDefault().run();
                } else if (licenseMode.U() && !licenseMode.S()) {
                    LicenseWizard.setProductSelectionResult((ProductSelectionResult)ProductSelectionResult.ACTIVATE_GATEWAY_MALTEGO_ID);
                    LicenseWizardDisplayer.getDefault().run();
                }
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void readCloudDebugConfig() {
        File configFile = new File(Places.getUserDirectory(), "etc/cloud-debug.conf");
        try (FileInputStream in = new FileInputStream(configFile);){
            Properties properties = new Properties();
            properties.load(in);
            this.cloudSyncUrl = properties.getProperty("cloud-sync-url", CLOUD_SYNC_URL).trim();
            this.usingDebugCloudUrl = properties.containsKey("cloud-sync-url");
            this.cloudSchemaVersion = properties.getProperty("cloud-schema-version", CLOUD_SCHEMA_VERSION).trim();
            this.cloudUiUrl = properties.getProperty("cloud-ui-url", CLOUD_UI_URL).trim();
            this.cloudCasesUrl = properties.getProperty("cloud-cases-url", CLOUD_CASES_URL).trim();
            this.cloudCasesText = properties.getProperty("cloud-cases-text", CLOUD_CASES_TEXT).trim();
            this.browserGraphUrlPrefix = properties.getProperty("browser-graph-url-prefix", BROWSER_GRAPH_URL_PREFIX).trim();
            this.keycloakIssuerUrlPrefix = properties.getProperty("keycloak-issuer-url-prefix", KEYCLOAK_ISSUER_URL_PREFIX).trim();
            this.keycloakRealm = properties.getProperty("keycloak-realm", KEYCLOAK_REALM).trim();
            this.keycloakClientId = properties.getProperty("keycloak-client-id", KEYCLOAK_CLIENT_ID).trim();
            String refreshSecondsStr = properties.getProperty("token-refresh-seconds", "").trim();
            if (!StringUtilities.isNullOrEmpty((String)refreshSecondsStr)) {
                try {
                    this.refreshSeconds = Integer.parseInt(refreshSecondsStr);
                }
                catch (NumberFormatException ex) {
                    LOG.log(Level.SEVERE, "Failed to parse token refresh seconds: {0}", refreshSecondsStr);
                }
            }
        }
        catch (FileNotFoundException ex) {
            LOG.log(Level.FINE, "Cannot open Cloud Debug config file", ex);
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, "Error opening Cloud Debug config file", ex);
        }
    }

    private CloudAuthKeycloakInstalled createKeycloakClient(boolean showCloudCasesUrl) throws Exception {
        this.readCloudDebugConfig();
        AdapterConfig adapterConfig = new AdapterConfig();
        adapterConfig.setRealm(this.keycloakRealm);
        adapterConfig.setAuthServerUrl(this.keycloakIssuerUrlPrefix);
        adapterConfig.setResource(this.keycloakClientId);
        adapterConfig.setPublicClient(true);
        adapterConfig.setUseResourceRoleMappings(true);
        adapterConfig.setPkce(true);
        adapterConfig.setDisableTrustManager(true);
        KeycloakDeployment deployment = KeycloakDeploymentBuilder.build((AdapterConfig)adapterConfig);
        WrappedHttpClient httpClient = new WrappedHttpClient();
        deployment.setClient((HttpClient)httpClient);
        CloudAuthKeycloakInstalled keycloak = new CloudAuthKeycloakInstalled(deployment);
        keycloak.setIsMessageHTML(true);
        String successHtml = CloudAuthHtmlUtil.getAuthenticationCompleteHtml(showCloudCasesUrl, this.cloudCasesUrl, this.cloudCasesText);
        keycloak.setMessageLoginSuccess(successHtml);
        String logoutSuccessHtml = CloudAuthHtmlUtil.getLogoutCompleteHtml();
        keycloak.setMessageLogoutSuccess(logoutSuccessHtml);
        String errorHtml = CloudAuthHtmlUtil.getBrowserErrorHtml();
        keycloak.setMessageError(errorHtml);
        keycloak.setLocale(Locale.ENGLISH);
        return keycloak;
    }

    private RefreshToken getRefreshToken() {
        try {
            String refreshTokenString = this.authResult.getRefreshToken();
            RefreshToken refreshToken = TokenUtil.getRefreshToken((String)refreshTokenString);
            return refreshToken;
        }
        catch (Exception ex) {
            NormalException.logStackTrace((Throwable)ex);
            return null;
        }
    }

    private Instant getNextTokenExpirationInstant(RefreshToken refreshToken, boolean checkAccessToken) {
        try {
            Long accessTokenExp = checkAccessToken ? this.getAccessToken().getExp() * 1000L : Long.MAX_VALUE;
            return new Date(Math.min(accessTokenExp, refreshToken.getExp() * 1000L)).toInstant();
        }
        catch (Exception ex) {
            NormalException.logStackTrace((Throwable)ex);
            return this.getNextTokenExpiration();
        }
    }

    private Instant getNextTokenExpiration() {
        return Instant.now().plus(this.getExpiresIn(), ChronoUnit.SECONDS);
    }

    private long getExpiresIn() {
        return Math.min(this.authResult.getTokenResponse().getExpiresIn(), this.authResult.getTokenResponse().getRefreshExpiresIn());
    }

    private void refreshAccessTokenRelatedInfos() {
        B.A().A(this.authResult.getToken());
        this.refreshOrgRegion();
    }

    private void refreshOrgRegion() {
        boolean regionChanged;
        Object region;
        if (this.usingDebugCloudUrl) {
            LOG.log(Level.FINE, "Using debug values, region changes ignored");
            return;
        }
        Preferences prefs = NbPreferences.forModule(((Object)((Object)this)).getClass());
        String oldRegion = prefs.get(PREF_ORG_REGION, null);
        String newRegion = null;
        LinkedHashMap organizationMap = (LinkedHashMap)this.authResult.getToken().getOtherClaims().get(KEY_ORG_NAME);
        if (organizationMap != null && (region = organizationMap.get(KEY_REGION)) != null) {
            newRegion = region.toString();
        }
        boolean bl = regionChanged = !StringUtilities.areEqual((String)oldRegion, newRegion);
        if (regionChanged) {
            LOG.log(Level.INFO, "Organization region has changed, resetting graph keystore. Old region: {0}, New region : {1}", new Object[]{oldRegion, newRegion});
            CloudGraphKeystore.getDefault().reset();
        }
        if (null == newRegion) {
            prefs.remove(PREF_ORG_REGION);
            LOG.log(Level.INFO, "Organization region not set, using default region");
            this.cloudSyncUrl = CLOUD_SYNC_URL;
        } else {
            prefs.put(PREF_ORG_REGION, newRegion);
            switch (newRegion) {
                case "US": {
                    LOG.log(Level.INFO, "Organization region is US");
                    this.cloudSyncUrl = CLOUD_SYNC_US_URL;
                    break;
                }
                case "EU": {
                    LOG.log(Level.INFO, "Organization region EU");
                    this.cloudSyncUrl = CLOUD_SYNC_EU_URL;
                    break;
                }
                default: {
                    LOG.log(Level.INFO, "Organization region is not recognized ( {0} ), using default region", newRegion);
                    this.cloudSyncUrl = CLOUD_SYNC_URL;
                }
            }
        }
        LOG.log(Level.FINE, "Cloud sync URL : {0}", this.cloudSyncUrl);
    }

    private String printTokenSpecs(boolean forceLog) {
        if (!forceLog) {
            forceLog = this.isDebugging();
        }
        String msg = "";
        if (forceLog && this.authResult != null && this.getAccessToken() != null) {
            Level level = Level.FINEST;
            LOG.log(level, "============");
            LOG.log(level, "System UNIX time");
            long currentMillis = System.currentTimeMillis();
            LOG.log(level, "  date: {0}: {1}", new Object[]{currentMillis, new Date(currentMillis)});
            msg = msg + "System UNIX time: " + currentMillis;
            LOG.log(level, "-------------");
            LOG.log(level, "Access Token");
            Long exp = this.getAccessToken().getExp();
            LOG.log(level, "  exp (expiry time): {0}: {1}", new Object[]{exp, new Date(exp * 1000L)});
            msg = msg + "; Access exp: " + exp * 1000L;
            Long iat = this.getAccessToken().getIat();
            LOG.log(level, "  iat (issued at): {0}: {1}", new Object[]{iat, new Date(iat * 1000L)});
            Long authTime = this.getAccessToken().getAuth_time();
            LOG.log(Level.FINEST, "  auth_time: {0}: {1}", new Object[]{authTime, new Date(authTime * 1000L)});
            LOG.log(level, "  aud (audience): {0}", this.getAccessToken().getAudience());
            Long nbf = this.getAccessToken().getNbf();
            LOG.log(Level.FINEST, "  notBefore: {0}", nbf);
            Long lifespanSeconds = nbf == null ? this.getAccessToken().getExp() - this.getAccessToken().getIat() : this.getAccessToken().getExp() - nbf;
            LOG.log(level, "  access token lifespan (seconds): {0}", lifespanSeconds);
            LOG.log(level, "  access token lifespan (minutes): {0}", lifespanSeconds / 60L);
            LOG.log(level, "  access token expires in minutes: {0}", this.authResult.getTokenResponse().getExpiresIn() / 60L);
            if (this.isDevDebugging()) {
                LOG.log(Level.FINEST, "  email: {0}", this.getAccessToken().getEmail());
                LOG.log(Level.FINEST, "  azp (Authorized Parties): {0}", this.getAccessToken().getIssuedFor());
            }
            LOG.log(level, "  active: {0}", this.getAccessToken().isActive());
            msg = msg + ", active: " + this.getAccessToken().isActive();
            LOG.log(level, "  isExpired: {0}", this.getAccessToken().isExpired());
            msg = msg + ", isExpired: " + this.getAccessToken().isExpired();
            if (this.isDevDebugging()) {
                LOG.log(Level.FINEST, "  access token string : {0}", this.getAccessTokenString());
            }
            LOG.log(level, "-------------");
            LOG.log(level, "Refresh Token");
            String refreshTokenString = this.authResult.getRefreshToken();
            try {
                msg = msg + "; Refresh ";
                boolean offline = TokenUtil.isOfflineToken((String)refreshTokenString);
                msg = msg + "offline: " + offline;
                LOG.log(level, "  offline: {0}", offline);
                RefreshToken refreshToken = TokenUtil.getRefreshToken((String)refreshTokenString);
                exp = refreshToken.getExp();
                LOG.log(level, "  exp (expiry time): {0}: {1}", new Object[]{exp, new Date(exp * 1000L)});
                msg = msg + ", exp: " + exp * 1000L;
                iat = refreshToken.getIat();
                LOG.log(level, "  iat (issued at): {0}: {1}", new Object[]{iat, new Date(iat * 1000L)});
                nbf = refreshToken.getNbf();
                LOG.log(Level.FINEST, "  notBefore: {0}", nbf);
                lifespanSeconds = nbf == null ? refreshToken.getExp() - refreshToken.getIat() : refreshToken.getExp() - nbf;
                LOG.log(level, "  refresh token lifespan (seconds): {0}", lifespanSeconds);
                LOG.log(level, "  refresh token lifespan (minutes): {0}", lifespanSeconds / 60L);
                LOG.log(level, "  refresh token expires in minutes: {0}", this.authResult.getTokenResponse().getRefreshExpiresIn() / 60L);
                if (this.isDevDebugging()) {
                    LOG.log(Level.FINEST, "  azp (Authorized Parties): {0}", refreshToken.getIssuedFor());
                }
            }
            catch (JWSInputException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            if (this.isDevDebugging()) {
                LOG.log(Level.FINEST, "  refresh token string: {0}", refreshTokenString);
            }
        }
        return msg;
    }

    private boolean isDevDebugging() {
        return Version.getCurrent().isDevBuild() && this.isDebugging();
    }

    private boolean isDebugging() {
        return LOG.isLoggable(Level.FINEST);
    }

    private static class WrappedHttpClient
    extends CloseableHttpClient {
        private final RequestConfig defaultConfig = RequestConfig.DEFAULT;
        private final HttpRoutePlanner routePlanner = new DefaultRoutePlanner((SchemePortResolver)DefaultSchemePortResolver.INSTANCE);

        private WrappedHttpClient() {
        }

        protected CloseableHttpResponse doExecute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
            Args.notNull((Object)request, (String)"HTTP request");
            HttpExecutionAware execAware = null;
            if (request instanceof HttpExecutionAware) {
                execAware = (HttpExecutionAware)request;
            }
            try {
                HttpParams params;
                HttpRequestWrapper wrapper = HttpRequestWrapper.wrap((HttpRequest)request, (HttpHost)target);
                HttpClientContext localcontext = HttpClientContext.adapt((HttpContext)(context != null ? context : new BasicHttpContext()));
                RequestConfig config = null;
                if (request instanceof Configurable) {
                    config = ((Configurable)request).getConfig();
                }
                if (config == null) {
                    params = request.getParams();
                    if (params instanceof HttpParamsNames) {
                        if (!((HttpParamsNames)params).getNames().isEmpty()) {
                            config = HttpClientParamConfig.getRequestConfig((HttpParams)params, (RequestConfig)this.defaultConfig);
                        }
                    } else {
                        config = HttpClientParamConfig.getRequestConfig((HttpParams)params, (RequestConfig)this.defaultConfig);
                    }
                }
                if (config != null) {
                    localcontext.setRequestConfig(config);
                }
                this.setupContext(localcontext);
                params = this.determineRoute(target, (HttpRequest)wrapper, (HttpContext)localcontext);
            }
            catch (HttpException httpException) {
                throw new ClientProtocolException((Throwable)httpException);
            }
            int TIMEOUT_MILLIS = 30000;
            URL url = new URL(request.getRequestLine().getUri());
            HttpAgent httpAgent = new HttpAgent(url);
            httpAgent.setConnectTimeout(TIMEOUT_MILLIS);
            httpAgent.setReadTimeout(TIMEOUT_MILLIS);
            HttpAgent.HttpMethod method = HttpAgent.HttpMethod.valueOf((String)request.getRequestLine().getMethod());
            switch (method) {
                case GET: {
                    boolean acceptEncodingSet = false;
                    Header[] headers = request.getAllHeaders();
                    if (headers != null) {
                        for (Header header : headers) {
                            String key = header.getName();
                            if (key == null || key.isEmpty()) continue;
                            key = key.trim();
                            httpAgent.setRequestHeader(key, header.getValue());
                            if (!"accept-encoding".equalsIgnoreCase(key)) continue;
                            acceptEncodingSet = true;
                        }
                    }
                    if (!acceptEncodingSet) {
                        // empty if block
                    }
                    httpAgent.doGet();
                    break;
                }
                case POST: {
                    HttpPost post;
                    HttpEntity entity;
                    Header header2;
                    boolean acceptEncodingSet = false;
                    Header[] headers = request.getAllHeaders();
                    if (headers != null) {
                        for (Header header2 : headers) {
                            String key = header2.getName();
                            if (key == null || key.isEmpty()) continue;
                            key = key.trim();
                            httpAgent.setRequestHeader(header2.getName(), header2.getValue());
                            if (!"accept-encoding".equalsIgnoreCase(key)) continue;
                            acceptEncodingSet = true;
                        }
                    }
                    if (!(request instanceof HttpPost) || !((entity = (post = (HttpPost)request).getEntity()) instanceof UrlEncodedFormEntity)) break;
                    if (!acceptEncodingSet) {
                        // empty if block
                    }
                    UrlEncodedFormEntity formEntity = (UrlEncodedFormEntity)entity;
                    header2 = formEntity.getContentType();
                    String charset = null;
                    httpAgent.doPost(header2.getValue(), StringUtilities.toString((InputStream)formEntity.getContent(), charset).trim());
                    break;
                }
                case DELETE: {
                    LOG.log(Level.WARNING, "Maltego ID auth HTTP method NOT supported: {0}", HttpAgent.HttpMethod.DELETE);
                    break;
                }
                case OPTIONS: {
                    LOG.log(Level.WARNING, "Maltego ID auth HTTP method NOT supported: {0}", HttpAgent.HttpMethod.OPTIONS);
                    break;
                }
                case PUT: {
                    LOG.log(Level.WARNING, "Maltego ID auth HTTP method NOT supported: {0}", HttpAgent.HttpMethod.PUT);
                    break;
                }
                case HEAD: {
                    LOG.log(Level.WARNING, "Maltego ID auth HTTP method NOT supported: {0}", HttpAgent.HttpMethod.HEAD);
                    break;
                }
                default: {
                    LOG.log(Level.WARNING, "Maltego ID auth HTTP method NOT supported: Unknown method");
                }
            }
            int responseCode = httpAgent.getResponseCode();
            InputStream responseStream = responseCode >= 400 ? httpAgent.getErrorStream() : httpAgent.getInputStream();
            InputStreamEntity entity = new InputStreamEntity(responseStream, httpAgent.getContentLength());
            BasicCloseableHttpResponse httpResponse = new BasicCloseableHttpResponse(responseCode, entity);
            httpResponse.setEntity(entity);
            return httpResponse;
        }

        private HttpRoute determineRoute(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
            HttpHost host = target;
            if (host == null) {
                host = (HttpHost)request.getParams().getParameter("http.default-host");
            }
            return this.routePlanner.determineRoute(host, request, context);
        }

        private void setupContext(HttpClientContext context) {
            if (context.getAttribute("http.auth.target-scope") == null) {
                context.setAttribute("http.auth.target-scope", (Object)new AuthState());
            }
            if (context.getAttribute("http.auth.proxy-scope") == null) {
                context.setAttribute("http.auth.proxy-scope", (Object)new AuthState());
            }
            if (context.getAttribute("http.request-config") == null) {
                context.setAttribute("http.request-config", (Object)this.defaultConfig);
            }
        }

        public HttpParams getParams() {
            return null;
        }

        public ClientConnectionManager getConnectionManager() {
            return null;
        }

        public void close() throws IOException {
            LOG.log(Level.WARNING, "Trying to close BasicCloseableHttpResponse");
        }

        public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
            return (T)super.execute(target, request, responseHandler, context);
        }

        public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
            return (T)super.execute(target, request, responseHandler);
        }

        public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
            return (T)super.execute(request, responseHandler, context);
        }

        public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
            return (T)super.execute(request, responseHandler);
        }

        public CloseableHttpResponse execute(HttpHost target, HttpRequest request) throws IOException, ClientProtocolException {
            return super.execute(target, request);
        }

        public CloseableHttpResponse execute(HttpUriRequest request) throws IOException, ClientProtocolException {
            return super.execute(request);
        }

        public CloseableHttpResponse execute(HttpUriRequest request, HttpContext context) throws IOException, ClientProtocolException {
            return super.execute(request, context);
        }

        public CloseableHttpResponse execute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
            return super.execute(target, request, context);
        }

        private static class BasicCloseableHttpResponse
        extends BasicHttpResponse
        implements CloseableHttpResponse {
            private final HttpEntity entity;

            public BasicCloseableHttpResponse(int statusCode, HttpEntity entity) {
                super(null, statusCode, "");
                this.entity = entity;
            }

            public void close() throws IOException {
                if (this.entity != null) {
                    this.entity.getContent().close();
                }
            }

            public String toString() {
                return super.toString();
            }

            public void setLocale(Locale locale) {
                super.setLocale(locale);
            }

            public void setEntity(HttpEntity entity) {
                super.setEntity(entity);
            }

            public void setReasonPhrase(String reason) {
                super.setReasonPhrase(reason);
            }

            public void setStatusCode(int code) {
                super.setStatusCode(code);
            }

            public void setStatusLine(ProtocolVersion ver, int code, String reason) {
                super.setStatusLine(ver, code, reason);
            }

            public void setStatusLine(ProtocolVersion ver, int code) {
                super.setStatusLine(ver, code);
            }

            public void setStatusLine(StatusLine statusline) {
                super.setStatusLine(statusline);
            }

            public Locale getLocale() {
                return super.getLocale();
            }

            public HttpEntity getEntity() {
                return super.getEntity();
            }

            public StatusLine getStatusLine() {
                return super.getStatusLine();
            }

            public ProtocolVersion getProtocolVersion() {
                return super.getProtocolVersion();
            }

            protected String getReason(int code) {
                return super.getReason(code);
            }

            public void setParams(HttpParams params) {
                super.setParams(params);
            }

            public HttpParams getParams() {
                return super.getParams();
            }

            public HeaderIterator headerIterator(String name) {
                return super.headerIterator(name);
            }

            public HeaderIterator headerIterator() {
                return super.headerIterator();
            }

            public void removeHeaders(String name) {
                super.removeHeaders(name);
            }

            public void removeHeader(Header header) {
                super.removeHeader(header);
            }

            public void setHeaders(Header[] headers) {
                super.setHeaders(headers);
            }

            public void setHeader(String name, String value) {
                super.setHeader(name, value);
            }

            public void setHeader(Header header) {
                super.setHeader(header);
            }

            public void addHeader(String name, String value) {
                super.addHeader(name, value);
            }

            public void addHeader(Header header) {
                super.addHeader(header);
            }

            public Header[] getAllHeaders() {
                return super.getAllHeaders();
            }

            public Header getLastHeader(String name) {
                return super.getLastHeader(name);
            }

            public Header getFirstHeader(String name) {
                return super.getFirstHeader(name);
            }

            public Header[] getHeaders(String name) {
                return super.getHeaders(name);
            }

            public boolean containsHeader(String name) {
                return super.containsHeader(name);
            }
        }

        private static class InputStreamEntity
        implements HttpEntity {
            private final InputStream content;
            private final long length;

            public InputStreamEntity(InputStream content, long length) {
                this.content = content;
                this.length = length;
            }

            public boolean isRepeatable() {
                return false;
            }

            public boolean isChunked() {
                return false;
            }

            public long getContentLength() {
                return this.length;
            }

            public InputStream getContent() throws IOException {
                return this.content;
            }

            public void writeTo(OutputStream outstream) throws IOException {
                int bytesRead;
                byte[] buffer = new byte[1024];
                while ((bytesRead = this.content.read(buffer)) != -1) {
                    outstream.write(buffer, 0, bytesRead);
                }
            }

            public boolean isStreaming() {
                return true;
            }

            public void consumeContent() throws IOException {
                this.content.close();
            }

            public Header getContentType() {
                return null;
            }

            public Header getContentEncoding() {
                return null;
            }
        }
    }

    private class ProxySettingsListener
    implements PreferenceChangeListener {
        private ProxySettingsListener() {
        }

        @Override
        public void preferenceChange(PreferenceChangeEvent evt) {
            if (evt.getKey().startsWith("proxy") || evt.getKey().startsWith("useProxy")) {
                // empty if block
            }
        }
    }
}

