/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.text.StringEscapeUtils;

public class XMLEscapeUtils {
    private XMLEscapeUtils() {
    }

    public static String escape(String str) {
        if (str == null) {
            return null;
        }
        str = XMLEscapeUtils.escapeUnicode(str);
        return StringEscapeUtils.escapeXml11((String)str);
    }

    public static String unescape(String str) {
        if (str == null) {
            return null;
        }
        str = StringEscapeUtils.unescapeXml((String)str);
        return XMLEscapeUtils.unescapeUnicode(str);
    }

    public static String escapeUnicode(String str) {
        if (str == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch < ' ' || ch >= '\u007f' || ch == '[' || ch == ']') {
                char intValue = ch;
                buf.append("&#");
                buf.append((int)intValue);
                buf.append(';');
                continue;
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    public static String unescapeUnicode(String str) {
        if (str == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(str.length());
        Pattern p = Pattern.compile("&#(\\d+);", 8);
        Matcher matcher = p.matcher(str);
        int pos = 0;
        while (matcher.find()) {
            String normal = str.substring(pos, matcher.start());
            buf.append(normal);
            buf.append((char)Integer.parseInt(matcher.group(1)));
            pos = matcher.end();
        }
        buf.append(str.substring(pos));
        return buf.toString();
    }
}

