/*
 * Decompiled with CFR 0.152.
 */
package com.maltego.guided.tour.ui;

import com.maltego.guided.tour.TourStep;
import com.maltego.guided.tour.ui.StepNavigationPanel;
import com.maltego.guided.tour.ui.TitlePanel;
import com.maltego.guided.tour.ui.TourDialog;
import com.maltego.guided.tour.ui.TourDialogPresenter;
import com.maltego.guided.tour.ui.TutorialDefaults;
import com.paterva.maltego.util.MaltegoUrl;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class NewGraphDialog
extends TourDialog {
    private TourStep tourStep = TourStep.DEFAULT;
    private StepNavigationPanel navigationPanel;
    private TitlePanel titlePanel;

    public NewGraphDialog(Frame frame) {
        super(frame);
        this.setMinimumSize(new Dimension(360, 0));
        this.initComponents();
        this.adjustLocation();
        this.adjustShape();
        this.getContentPane().setBackground(TutorialDefaults.COLOR_STEP_BACKGROUND);
        this.navigationPanel.setCustomNextAction(() -> {
            List actionsForPath = Utilities.actionsForPath((String)"Actions/File");
            Optional<Action> newGraphAction = actionsForPath.stream().filter(action -> {
                String name = action.getClass().getSimpleName();
                return name.equals("NewGraphAction");
            }).findFirst();
            newGraphAction.orElseThrow(() -> new IllegalStateException("New Graph needs to be created to go on with the guided tour")).actionPerformed(null);
            RequestProcessor.getDefault().post(() -> SwingUtilities.invokeLater(() -> this.tourStep.next()), 1500, 10);
        });
    }

    @Override
    protected Point getRelativeLocation() {
        return new Point(11, 140);
    }

    @Override
    public void setTourStep(TourStep tourStep) {
        this.tourStep = tourStep;
        this.titlePanel.setTourStep(tourStep);
        this.navigationPanel.setTourStep(tourStep);
    }

    private void adjustShape() {
        Area rectangle = new Area(new Rectangle(0, 10, this.getWidth(), this.getHeight()));
        Area triangle = new Area(new Polygon(new int[]{20, 10, 30}, new int[]{0, 10, 10}, 3));
        rectangle.add(triangle);
        this.setShape(rectangle);
    }

    private void initComponents() {
        this.titlePanel = new TitlePanel();
        JTextArea contentTextArea = new JTextArea();
        this.navigationPanel = new StepNavigationPanel();
        this.setDefaultCloseOperation(2);
        this.titlePanel.setTitle(NbBundle.getMessage(NewGraphDialog.class, (String)"NewGraphDialog.titlePanel.title"));
        contentTextArea.setEditable(false);
        contentTextArea.setColumns(20);
        contentTextArea.setFont(contentTextArea.getFont().deriveFont((float)contentTextArea.getFont().getSize() + 3.0f));
        contentTextArea.setLineWrap(true);
        contentTextArea.setRows(3);
        contentTextArea.setText(NbBundle.getMessage(NewGraphDialog.class, (String)"NewGraphDialog.contentTextArea.text"));
        contentTextArea.setWrapStyleWord(true);
        contentTextArea.setBorder(null);
        contentTextArea.setDisabledTextColor(TutorialDefaults.COLOR_TEXT);
        contentTextArea.setEnabled(false);
        contentTextArea.setOpaque(false);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(15, 15, 15).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.titlePanel, -1, -1, Short.MAX_VALUE).addComponent(contentTextArea).addComponent(this.navigationPanel, -2, 0, Short.MAX_VALUE)).addGap(15, 15, 15)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(25, 25, 25).addComponent(this.titlePanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(contentTextArea, -2, -1, -2).addGap(32, 32, 32).addComponent(this.navigationPanel, -2, -1, -2).addContainerGap(15, Short.MAX_VALUE)));
        this.pack();
    }

    public static class Presenter
    extends TourDialogPresenter<NewGraphDialog> {
        @Override
        protected NewGraphDialog createTourDialog(Frame frame) {
            return new NewGraphDialog(frame);
        }

        @Override
        public Supplier<Rectangle> getFocusArea() {
            return () -> new Rectangle(8, 58, 37, 71);
        }

        @Override
        public Consumer<Graphics2D> getPainter() {
            return g2d -> {
                g2d.setStroke(new BasicStroke(2.0f));
                g2d.setColor(Color.WHITE);
                g2d.drawRect(8, 58, 37, 71);
            };
        }

        @Override
        public String learnMoreLink() {
            return MaltegoUrl.getCurrent().getGotoOnboardingFirstGraph();
        }
    }
}

