/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.builtins.SharedArrayBufferFunctionBuiltins;
import com.oracle.truffle.js.builtins.SharedArrayBufferPrototypeBuiltins;
import com.oracle.truffle.js.runtime.JSAgentWaiterList;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.builtins.JSAbstractBuffer;
import com.oracle.truffle.js.runtime.builtins.JSArrayBufferObject;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.util.DirectByteBufferHelper;
import java.nio.ByteBuffer;

public final class JSSharedArrayBuffer
extends JSAbstractBuffer
implements JSConstructorFactory.WithFunctionsAndSpecies,
PrototypeSupplier {
    public static final String CLASS_NAME = "SharedArrayBuffer";
    public static final String PROTOTYPE_NAME = "SharedArrayBuffer.prototype";
    public static final JSSharedArrayBuffer INSTANCE = new JSSharedArrayBuffer();

    private JSSharedArrayBuffer() {
    }

    public static DynamicObject createSharedArrayBuffer(JSContext context, JSRealm realm, int length) {
        return JSSharedArrayBuffer.createSharedArrayBuffer(context, realm, DirectByteBufferHelper.allocateDirect(length));
    }

    public static DynamicObject createSharedArrayBuffer(JSContext context, JSRealm realm, ByteBuffer buffer) {
        assert (buffer != null);
        JSObjectFactory factory = context.getSharedArrayBufferFactory();
        DynamicObject obj = JSArrayBufferObject.createSharedArrayBuffer(factory.getShape(realm), buffer, new JSAgentWaiterList());
        factory.initProto(obj, realm);
        assert (JSSharedArrayBuffer.isJSSharedArrayBuffer(obj));
        return context.trackAllocation(obj);
    }

    @Override
    public DynamicObject createPrototype(JSRealm realm, DynamicObject ctor) {
        JSContext context = realm.getContext();
        DynamicObject arrayBufferPrototype = JSObjectUtil.createOrdinaryPrototypeObject(realm);
        JSObjectUtil.putConstructorProperty(context, arrayBufferPrototype, ctor);
        JSObjectUtil.putFunctionsFromContainer(realm, arrayBufferPrototype, SharedArrayBufferPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putBuiltinAccessorProperty(arrayBufferPrototype, "byteLength", realm.lookupAccessor(SharedArrayBufferPrototypeBuiltins.BUILTINS, "byteLength"));
        JSObjectUtil.putToStringTag(arrayBufferPrototype, CLASS_NAME);
        return arrayBufferPrototype;
    }

    @Override
    public Shape makeInitialShape(JSContext context, DynamicObject prototype) {
        Shape initialShape = JSObjectUtil.getProtoChildShape(prototype, INSTANCE, context);
        return initialShape;
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm, SharedArrayBufferFunctionBuiltins.BUILTINS);
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public String getClassName(DynamicObject object) {
        return this.getClassName();
    }

    public static boolean isJSSharedArrayBuffer(Object obj) {
        return obj instanceof JSArrayBufferObject.Shared;
    }

    public static ByteBuffer getDirectByteBuffer(DynamicObject thisObj) {
        assert (JSSharedArrayBuffer.isJSSharedArrayBuffer(thisObj));
        return JSArrayBufferObject.getDirectByteBuffer(thisObj);
    }

    public static JSAgentWaiterList getWaiterList(DynamicObject thisObj) {
        assert (JSSharedArrayBuffer.isJSSharedArrayBuffer(thisObj));
        return JSArrayBufferObject.getWaiterList(thisObj);
    }

    public static void setWaiterList(DynamicObject thisObj, JSAgentWaiterList wl) {
        assert (JSSharedArrayBuffer.isJSSharedArrayBuffer(thisObj));
        JSArrayBufferObject.setWaiterList(thisObj, wl);
    }

    @Override
    public DynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getSharedArrayBufferPrototype();
    }
}

