/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.protocol;

import com.paterva.maltego.transform.descriptor.ProtocolVersion;
import com.paterva.maltego.transform.protocol.api.TransformServerSeedInfo;
import com.paterva.maltego.transform.protocol.api.TransformSource;
import com.paterva.maltego.transform.protocol.api.TransformSourceFactory;
import com.paterva.maltego.transform.protocol.v2api.V2TransformSource;
import com.paterva.maltego.transform.protocol.v3.api.V3ProtocolEnabledProcessor;
import com.paterva.maltego.transform.protocol.v3.api.V3TransformSource;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultTransformSourceFactory
implements TransformSourceFactory {
    private static final Logger LOG = Logger.getLogger(DefaultTransformSourceFactory.class.getName());

    public TransformSource get(String seedUrl, List<Exception> errors) {
        if (V3ProtocolEnabledProcessor.V3_PROTOCOL_ENABLED) {
            TransformServerSeedInfo seedInfo = new TransformServerSeedInfo();
            ProtocolVersion protocolVersion = seedInfo.getProtocolVersion(seedUrl, true, "", errors);
            LOG.log(Level.INFO, "Detected transfom protocol {0} for server {1}", new Object[]{protocolVersion, seedUrl});
            return this.get(protocolVersion);
        }
        LOG.log(Level.INFO, "Using default protocol {0} for server {1} (V3 protocol disabled)", new Object[]{ProtocolVersion.V2_0, seedUrl});
        return this.get(ProtocolVersion.V2_0);
    }

    public TransformSource get(ProtocolVersion protocolVersion) {
        if (protocolVersion.equals((Object)ProtocolVersion.V2_0)) {
            return new V2TransformSource(protocolVersion);
        }
        if (protocolVersion.compareTo(ProtocolVersion.V3_0) >= 0) {
            return new V3TransformSource(protocolVersion);
        }
        throw new IllegalArgumentException(String.format("Failed to create a TransformSource for unsupported protocol version %s", protocolVersion));
    }
}

