/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.form;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;

public class VerticalFlowLayout
extends FlowLayout {
    public static final int TOP = 0;
    public static final int MIDDLE = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 3;
    public static final int CENTER = 4;
    public static final int RIGHT = 5;
    int xAlign;
    int yAlign;
    int horizontalGap;
    int verticalGap;
    boolean fill;

    public VerticalFlowLayout(int vgap) {
        this(3, 0, 5, vgap, true);
    }

    public VerticalFlowLayout() {
        this(3, 0, 5, 5, true);
    }

    public VerticalFlowLayout(boolean fill) {
        this(3, 0, 5, 5, fill);
    }

    public VerticalFlowLayout(int xAlign, int yAlign) {
        this(xAlign, yAlign, 5, 5, false);
    }

    public VerticalFlowLayout(int yAlign, boolean fill) {
        this(3, yAlign, 5, 5, fill);
    }

    public VerticalFlowLayout(int xAlign, int yAlign, int hgap, int vgap, boolean fill) {
        this.xAlign = xAlign;
        this.yAlign = yAlign;
        this.horizontalGap = hgap;
        this.verticalGap = vgap;
        this.fill = fill;
    }

    public void setFill(boolean value) {
        this.fill = value;
    }

    public boolean getFill() {
        return this.fill;
    }

    @Override
    public Dimension preferredLayoutSize(Container target) {
        Dimension tarsiz = new Dimension(0, 0);
        for (int i = 0; i < target.getComponentCount(); ++i) {
            Component m = target.getComponent(i);
            if (!m.isVisible()) continue;
            Dimension d = m.getPreferredSize();
            tarsiz.width = Math.max(tarsiz.width, d.width);
            if (i > 0) {
                tarsiz.height += this.verticalGap;
            }
            tarsiz.height += d.height;
        }
        Insets insets = target.getInsets();
        tarsiz.width += insets.left + insets.right + this.horizontalGap * 2;
        tarsiz.height += insets.top + insets.bottom + this.verticalGap * 2;
        return tarsiz;
    }

    @Override
    public Dimension minimumLayoutSize(Container target) {
        return this.preferredLayoutSize(target);
    }

    private void placethem(Container target, Insets insets, int x, int y, int width, int height, int first, int last) {
        switch (this.xAlign) {
            case 3: {
                if (this.yAlign == 1) {
                    y += height / 2;
                }
                if (this.yAlign == 2) {
                    y += height;
                }
                for (int i = first; i < last; ++i) {
                    Component m = target.getComponent(i);
                    Dimension md = m.getSize();
                    if (!m.isVisible()) continue;
                    m.setLocation(x, y);
                    y += this.verticalGap + md.height;
                }
                break;
            }
            case 4: {
                x += width / 2;
                x = target.getSize().width / 2;
                if (this.yAlign == 1) {
                    y += height / 2;
                }
                if (this.yAlign == 2) {
                    y += height;
                }
                for (int i = first; i < last; ++i) {
                    Component m = target.getComponent(i);
                    Dimension md = m.getSize();
                    if (!m.isVisible()) continue;
                    m.setLocation(x - md.width / 2, y);
                    y += this.verticalGap + md.height;
                }
                break;
            }
            case 5: {
                x += width;
                x = target.getSize().width - insets.right;
                if (this.yAlign == 1) {
                    y += height / 2;
                }
                if (this.yAlign == 2) {
                    y += height;
                }
                for (int i = first; i < last; ++i) {
                    Component m = target.getComponent(i);
                    Dimension md = m.getSize();
                    int cx = md.width;
                    if (!m.isVisible()) continue;
                    m.setLocation(x - md.width, y);
                    y += this.verticalGap + md.height;
                }
                break;
            }
        }
    }

    @Override
    public void layoutContainer(Container target) {
        Insets insets = target.getInsets();
        if (target.getSize().height >= this.minimumLayoutSize((Container)target).height) {
            int maxheight = target.getSize().height - (insets.top + insets.bottom + this.verticalGap * 2);
            int maxwidth = target.getSize().width - (insets.left + insets.right + this.horizontalGap * 2);
            int numcomp = target.getComponentCount();
            int y = 0;
            int x = insets.left + this.horizontalGap;
            int colw = 0;
            int start = 0;
            for (int i = 0; i < numcomp; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                Dimension d = m.getPreferredSize();
                if (this.fill) {
                    m.setSize(maxwidth, d.height);
                    d.width = maxwidth;
                } else {
                    m.setSize(d.width, d.height);
                }
                if (y > maxheight) {
                    this.placethem(target, insets, x, insets.top + this.verticalGap, colw, maxheight - y, start, i);
                    y = d.height;
                    x += this.horizontalGap + colw;
                    colw = d.width;
                    start = i;
                    continue;
                }
                if (y > 0) {
                    y += this.verticalGap;
                }
                y += d.height;
                colw = Math.max(colw, d.width);
            }
            this.placethem(target, insets, x, insets.top + this.verticalGap, colw, maxheight - y, start, numcomp);
        } else {
            int wide = target.getSize().width;
            target.setSize(wide, this.minimumLayoutSize((Container)target).height);
            this.layoutContainer(target);
        }
    }
}

