/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jbosh;

import com.kenai.jbosh.AbstractBody;
import com.kenai.jbosh.BOSHClientConfig;
import com.kenai.jbosh.CMSessionParams;
import com.kenai.jbosh.HTTPResponse;
import com.kenai.jbosh.HTTPSender;
import com.kenai.jbosh.XLightWebResponse;
import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.client.HttpClient;

final class XLightWebSender
implements HTTPSender {
    private static final Logger LOG = Logger.getLogger(XLightWebSender.class.getName());
    private final Lock lock = new ReentrantLock();
    private HttpClient client;
    private BOSHClientConfig cfg;

    XLightWebSender() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(BOSHClientConfig session) {
        this.lock.lock();
        try {
            this.cfg = session;
            this.client = new HttpClient();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.lock.lock();
        try {
            if (this.client != null) {
                this.client.close();
            }
        }
        catch (IOException iox) {
            LOG.log(Level.FINEST, "Ignoring exception on close", iox);
        }
        finally {
            this.client = null;
            this.cfg = null;
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTTPResponse send(CMSessionParams params, AbstractBody body) {
        BOSHClientConfig mCfg;
        HttpClient mClient;
        this.lock.lock();
        try {
            mClient = this.client;
            mCfg = this.cfg;
        }
        finally {
            this.lock.unlock();
        }
        return new XLightWebResponse(mClient, mCfg, params, body);
    }
}

