/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.AbstractHttpConnection;
import org.xlightweb.HttpUtils;
import org.xlightweb.IBodyCompleteListener;
import org.xlightweb.IHttpConnectHandler;
import org.xlightweb.IHttpConnection;
import org.xlightweb.IHttpDisconnectHandler;
import org.xlightweb.IHttpExchange;
import org.xlightweb.IHttpRequest;
import org.xlightweb.IHttpRequestHandler;
import org.xlightweb.IHttpRequestTimeoutHandler;
import org.xlightweb.RequestHandlerInfo;
import org.xsocket.Execution;
import org.xsocket.ILifeCycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Execution(value=0)
public class Context
implements IHttpRequestHandler,
IHttpRequestTimeoutHandler,
IHttpConnectHandler,
IHttpDisconnectHandler,
ILifeCycle,
Cloneable {
    private static final Logger LOG = Logger.getLogger(Context.class.getName());
    private final List<IHttpRequestHandler> handlers = new ArrayList<IHttpRequestHandler>();
    private final List<ILifeCycle> lifeCycleChain = new ArrayList<ILifeCycle>();
    private final List<IHolder> holders = new ArrayList<IHolder>();
    private final Map<String, IHolder> holderCache = HttpUtils.newMapCache(40);
    private boolean isOnConnectPathMultithreaded = false;
    private final List<IHttpConnectHandler> connectHandlerChain = new ArrayList<IHttpConnectHandler>();
    private boolean isOnRequestTimeoutPathMultithreaded = false;
    private final List<IHttpRequestTimeoutHandler> requestTimeoutHandlerChain = new ArrayList<IHttpRequestTimeoutHandler>();
    private boolean isOnDisconnectPathMultithreaded = false;
    private final List<IHttpDisconnectHandler> disconnectHandlerChain = new ArrayList<IHttpDisconnectHandler>();
    private final String contextPath;

    public Context(String contextPath) {
        this.contextPath = contextPath;
    }

    public Context(String contextPath, Map<String, IHttpRequestHandler> handlers) {
        this.contextPath = contextPath;
        for (Map.Entry<String, IHttpRequestHandler> entry : handlers.entrySet()) {
            this.addHandler(entry.getKey(), entry.getValue());
        }
    }

    public Context(Context parentContext, String contextPath) {
        this.contextPath = contextPath;
        parentContext.addContext(this);
    }

    private void addContext(Context ctx) {
        this.holders.add(new ContextHolder(ctx));
        this.sortHolderList();
    }

    public void addHandler(String pattern, IHttpRequestHandler requestHandler) {
        this.holders.add(new RequestHandlerHolder(pattern, requestHandler, HttpUtils.getRequestHandlerInfo(requestHandler)));
        this.sortHolderList();
        this.handlers.add(requestHandler);
        this.computePath();
    }

    private void computePath() {
        this.lifeCycleChain.clear();
        this.requestTimeoutHandlerChain.clear();
        this.isOnRequestTimeoutPathMultithreaded = false;
        for (IHttpRequestHandler handler : this.handlers) {
            RequestHandlerInfo requestHandlerInfo;
            if (ILifeCycle.class.isAssignableFrom(handler.getClass())) {
                this.lifeCycleChain.add((ILifeCycle)handler);
            }
            if (!(requestHandlerInfo = HttpUtils.getRequestHandlerInfo(handler)).isRequestTimeoutHandler()) continue;
            this.requestTimeoutHandlerChain.add((IHttpRequestTimeoutHandler)((Object)handler));
            this.isOnRequestTimeoutPathMultithreaded = this.isOnRequestTimeoutPathMultithreaded || requestHandlerInfo.isRequestTimeoutHandlerMultithreaded();
        }
    }

    private void sortHolderList() {
        Comparator<IHolder> comparator = new Comparator<IHolder>(){

            @Override
            public int compare(IHolder o1, IHolder o2) {
                return 0 - o1.getPattern().compareTo(o2.getPattern());
            }
        };
        Collections.sort(this.holders, comparator);
    }

    public void onInit() {
        for (IHolder holder : this.holders) {
            holder.onInit();
        }
    }

    public void onDestroy() throws IOException {
        for (IHolder holder : this.holders) {
            holder.onDestroy();
        }
    }

    public String getContextPath() {
        return this.contextPath;
    }

    List<String> getMapping() {
        ArrayList<String> result = new ArrayList<String>();
        for (IHolder holder : this.holders) {
            result.add("[" + holder.getPattern() + "] -> " + holder.getTarget());
        }
        Collections.sort(result);
        return result;
    }

    public List<IHttpRequestHandler> getHandlers() {
        ArrayList<IHttpRequestHandler> result = new ArrayList<IHttpRequestHandler>();
        for (IHolder holder : this.holders) {
            result.add(holder.getTarget());
        }
        return result;
    }

    @Override
    public boolean onConnect(IHttpConnection httpConnection) throws IOException {
        if (this.connectHandlerChain.isEmpty()) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("no connect handler set. ignore callback");
            }
            return false;
        }
        if (this.isOnConnectPathMultithreaded) {
            ((AbstractHttpConnection)httpConnection).getExecutor().processMultithreaded(new OnConnectCaller(httpConnection));
        } else {
            ((AbstractHttpConnection)httpConnection).getExecutor().processNonthreaded(new OnConnectCaller(httpConnection));
        }
        return true;
    }

    private boolean callOnConnectCallback(IHttpConnection connection) throws IOException {
        boolean handled = false;
        for (IHttpConnectHandler connectHandler : this.connectHandlerChain) {
            boolean result = connectHandler.onConnect(connection);
            handled = handled || result;
        }
        return handled;
    }

    @Override
    public boolean onDisconnect(IHttpConnection httpConnection) throws IOException {
        if (this.disconnectHandlerChain.isEmpty()) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("no disconnect handler set. ignore callback");
            }
            return false;
        }
        if (this.isOnDisconnectPathMultithreaded) {
            ((AbstractHttpConnection)httpConnection).getExecutor().processMultithreaded(new OnDisconnectCaller(httpConnection));
        } else {
            ((AbstractHttpConnection)httpConnection).getExecutor().processNonthreaded(new OnDisconnectCaller(httpConnection));
        }
        return true;
    }

    private boolean callOnDisconnectCallback(IHttpConnection connection) throws IOException {
        boolean handled = false;
        for (IHttpDisconnectHandler disconnectHandler : this.disconnectHandlerChain) {
            boolean result = disconnectHandler.onDisconnect(connection);
            handled = handled || result;
        }
        return handled;
    }

    @Override
    public void onRequest(IHttpExchange exchange) throws IOException {
        String path = exchange.getRequest().getRequestURI();
        if (path.startsWith(this.contextPath)) {
            path = path.substring(this.contextPath.length(), path.length());
            this.onRequest(path, exchange, this.contextPath);
        } else {
            this.sendNotFoundError(exchange);
        }
    }

    private void onRequest(String path, IHttpExchange exchange, String totalContextPath) throws IOException {
        if (this.holderCache.containsKey(path)) {
            this.holderCache.get(path).onRequest(path, exchange, totalContextPath);
            return;
        }
        for (IHolder holder : this.holders) {
            if (!holder.match(path)) continue;
            this.holderCache.put(path, holder);
            holder.onRequest(path, exchange, totalContextPath);
            return;
        }
        this.sendNotFoundError(exchange);
    }

    private void sendNotFoundError(IHttpExchange exchange) {
        if (HttpUtils.isShowDetailedError()) {
            StringBuilder sb = new StringBuilder("Not found\r\n\r\nsupported context:\r\n");
            for (IHolder holder : this.holders) {
                sb.append("<a href=\"" + holder.getPattern() + "\">" + holder.getPattern() + "</a><br>");
            }
            exchange.sendError(404, sb.toString());
        } else {
            exchange.sendError(404);
        }
    }

    @Override
    public boolean onRequestTimeout(IHttpConnection connection) throws IOException {
        if (this.requestTimeoutHandlerChain.isEmpty()) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.finer("no request timeout handler set. ignore callback");
            }
            return false;
        }
        AbstractHttpConnection httpConnection = (AbstractHttpConnection)connection;
        if (this.isOnRequestTimeoutPathMultithreaded) {
            httpConnection.getExecutor().processMultithreaded(new OnRequestTimeoutCaller(httpConnection));
        } else {
            httpConnection.getExecutor().processNonthreaded(new OnRequestTimeoutCaller(httpConnection));
        }
        return true;
    }

    private boolean callOnRequestTimeoutCallback(IHttpConnection connection) throws IOException {
        for (IHttpRequestTimeoutHandler requestTimeoutHandler : this.requestTimeoutHandlerChain) {
            boolean result = requestTimeoutHandler.onRequestTimeout(connection);
            if (!result) continue;
            return true;
        }
        return false;
    }

    protected Object clone() throws CloneNotSupportedException {
        Context copy = (Context)super.clone();
        return copy;
    }

    Context copy() {
        try {
            return (Context)this.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new RuntimeException(cnse.toString());
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("\"" + this.contextPath + "\"->{");
        for (IHolder holder : this.holders) {
            sb.append(holder + " ");
        }
        return sb.toString().trim() + "}";
    }

    private static final class OnRequestCaller
    implements Runnable {
        private IHttpRequestHandler handler = null;
        private IHttpExchange exchange = null;

        public OnRequestCaller(IHttpRequestHandler handler, IHttpExchange exchange) {
            this.handler = handler;
            this.exchange = exchange;
        }

        public void run() {
            try {
                this.handler.onRequest(this.exchange);
            }
            catch (Exception e) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("error occured by calling on request " + this.handler + " " + e.toString());
                }
                throw new RuntimeException(e);
            }
        }
    }

    private static final class BodyCompleteListener
    implements IBodyCompleteListener {
        private IHttpExchange exchange = null;
        private RequestHandlerHolder requestHandlerHolder = null;

        public BodyCompleteListener(IHttpExchange exchange, RequestHandlerHolder requestHandlerHolder) {
            this.exchange = exchange;
            this.requestHandlerHolder = requestHandlerHolder;
        }

        @Execution(value=0)
        public void onComplete() {
            this.requestHandlerHolder.performOnRequest(this.exchange);
        }
    }

    private static final class RequestHandlerHolder
    implements IHolder {
        private String path = null;
        private String pattern = null;
        private boolean isWildcardPath = false;
        private boolean isWildcardPathExt = false;
        private IHttpRequestHandler handler = null;
        private RequestHandlerInfo handlerInfo = null;

        RequestHandlerHolder(String pattern, IHttpRequestHandler handler, RequestHandlerInfo handlerInfo) {
            this.handler = handler;
            this.handlerInfo = handlerInfo;
            this.pattern = pattern;
            this.path = pattern;
            if (pattern.endsWith("/*")) {
                this.isWildcardPath = true;
                this.path = pattern.substring(0, pattern.indexOf("/*"));
            } else if (pattern.startsWith("*")) {
                this.path = pattern.substring(1, pattern.length());
                this.isWildcardPathExt = true;
            } else {
                this.isWildcardPath = false;
                this.path = pattern;
            }
        }

        public void onInit() {
            if (this.handlerInfo.isLifeCycle()) {
                ((ILifeCycle)this.handler).onInit();
            }
        }

        public void onDestroy() throws IOException {
            if (this.handlerInfo.isLifeCycle()) {
                ((ILifeCycle)this.handler).onDestroy();
            }
        }

        @Execution(value=0)
        public void onRequest(String reqPath, IHttpExchange exchange, String totalContextPath) throws IOException {
            IHttpRequest request = exchange.getRequest();
            if (request == null) {
                exchange.destroy();
                return;
            }
            request.setContextPath(totalContextPath);
            request.setRequestHandlerPath(this.path);
            if (this.handlerInfo.isRequestHandlerInvokeOnMessageReceived()) {
                if (request.hasBody()) {
                    BodyCompleteListener completeListener = new BodyCompleteListener(exchange, this);
                    request.getNonBlockingBody().addCompleteListener(completeListener);
                } else {
                    this.performOnRequest(exchange);
                }
            } else {
                this.performOnRequest(exchange);
            }
        }

        private void performOnRequest(IHttpExchange exchange) {
            OnRequestCaller task = new OnRequestCaller(this.handler, exchange);
            if (this.handlerInfo.isRequestHandlerMultithreaded()) {
                ((AbstractHttpConnection)exchange.getConnection()).getExecutor().processMultithreaded(task);
            } else {
                ((AbstractHttpConnection)exchange.getConnection()).getExecutor().processNonthreaded(task);
            }
        }

        public boolean match(String requestedRessource) {
            if (this.isWildcardPath) {
                return requestedRessource.startsWith(this.path) || requestedRessource.equals(this.path);
            }
            if (this.isWildcardPathExt) {
                return requestedRessource.endsWith(this.path);
            }
            return requestedRessource.equals(this.path);
        }

        public String getPattern() {
            return this.pattern;
        }

        public IHttpRequestHandler getTarget() {
            return this.handler;
        }

        public String toString() {
            return "\"" + this.pattern + "\"->" + this.handler.getClass().getSimpleName();
        }
    }

    private final class OnRequestTimeoutCaller
    implements Runnable {
        private IHttpConnection httpConnection = null;

        public OnRequestTimeoutCaller(IHttpConnection httpConnection) {
            this.httpConnection = httpConnection;
        }

        public void run() {
            block2: {
                try {
                    Context.this.callOnRequestTimeoutCallback(this.httpConnection);
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) break block2;
                    LOG.fine("Error occured by calling onRequestTimeout callback " + ioe.toString());
                }
            }
        }
    }

    private final class OnDisconnectCaller
    implements Runnable {
        private IHttpConnection httpConnection = null;

        public OnDisconnectCaller(IHttpConnection httpConnection) {
            this.httpConnection = httpConnection;
        }

        public void run() {
            block2: {
                try {
                    Context.this.callOnDisconnectCallback(this.httpConnection);
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) break block2;
                    LOG.fine("Error occured by calling onDisconnect callback " + ioe.toString());
                }
            }
        }
    }

    private final class OnConnectCaller
    implements Runnable {
        private IHttpConnection httpConnection = null;

        public OnConnectCaller(IHttpConnection httpConnection) {
            this.httpConnection = httpConnection;
        }

        public void run() {
            block2: {
                try {
                    Context.this.callOnConnectCallback(this.httpConnection);
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) break block2;
                    LOG.fine("Error occured by calling onConnect callback " + ioe.toString());
                }
            }
        }
    }

    private static final class ContextHolder
    implements IHolder {
        private Context context = null;

        ContextHolder(Context context) {
            this.context = context.copy();
        }

        public void onInit() {
            this.context.onInit();
        }

        public void onDestroy() throws IOException {
            this.context.onDestroy();
        }

        @Execution(value=0)
        public void onRequest(String path, IHttpExchange exchange, String totalContextPath) throws IOException {
            path = path.substring(this.context.contextPath.length(), path.length());
            this.context.onRequest(path, exchange, totalContextPath + this.context.contextPath);
        }

        public boolean match(String requestedRessource) {
            return requestedRessource.startsWith(this.context.contextPath) || requestedRessource.equals(this.context.contextPath);
        }

        public String getPattern() {
            return this.context.contextPath;
        }

        public IHttpRequestHandler getTarget() {
            return this.context;
        }

        public String toString() {
            return this.context.toString();
        }
    }

    private static interface IHolder {
        public void onInit();

        public void onDestroy() throws IOException;

        public void onRequest(String var1, IHttpExchange var2, String var3) throws IOException;

        public boolean match(String var1);

        public String getPattern();

        public IHttpRequestHandler getTarget();
    }
}

