/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.xlightweb.AbstractHttpMessage;
import org.xlightweb.BlockingBodyDataSource;
import org.xlightweb.BodyType;
import org.xlightweb.HttpResponseHeader;
import org.xlightweb.IHttpHeader;
import org.xlightweb.IHttpResponse;
import org.xlightweb.IHttpResponseHeader;
import org.xlightweb.NonBlockingBodyDataSource;
import org.xsocket.DataConverter;

public class HttpResponse
extends AbstractHttpMessage
implements IHttpResponse {
    private final IHttpResponseHeader responseHeader;

    public HttpResponse(IHttpResponseHeader responseHeader) {
        this.responseHeader = responseHeader;
    }

    public HttpResponse(IHttpResponseHeader responseHeader, NonBlockingBodyDataSource bodyDataSource) throws IOException {
        this.responseHeader = responseHeader;
        this.setBodyDataSource(bodyDataSource);
    }

    public HttpResponse(String contentType, NonBlockingBodyDataSource bodyDataSource) throws IOException {
        this.responseHeader = new HttpResponseHeader(200, contentType);
        this.setBodyDataSource(bodyDataSource);
    }

    public HttpResponse(String contentType, BlockingBodyDataSource bodyDataSource) throws IOException {
        this.responseHeader = new HttpResponseHeader(200, contentType);
        this.setBodyDataSource(bodyDataSource.getUnderliyingBodyDataSource());
    }

    public HttpResponse(String contentType, String body) throws IOException {
        this(200, contentType, body);
    }

    public HttpResponse(String body) throws IOException {
        this((IHttpResponseHeader)new HttpResponseHeader(200), body);
    }

    public HttpResponse(File file) throws IOException {
        this((IHttpResponseHeader)new HttpResponseHeader(200), new NonBlockingBodyDataSource(BodyType.IN_MEMORY, "ISO-8859-1"));
        this.setContentType(HttpResponse.getContentTypeByFileExtension(file));
        this.setContentLength((int)file.length());
        this.removeHeader("Transfer-Encoding");
        RandomAccessFile raf = new RandomAccessFile(file, "r");
        FileChannel fc = raf.getChannel();
        ByteBuffer buffer = ByteBuffer.allocate(this.getContentLength());
        fc.read(buffer);
        fc.close();
        raf.close();
        buffer.flip();
        this.getNonBlockingBody().append(true, buffer);
        this.getNonBlockingBody().setComplete(true);
    }

    public HttpResponse(int status) {
        this.responseHeader = new HttpResponseHeader(status);
    }

    public HttpResponse(int status, String contentType, String body) throws IOException {
        this(status, contentType, new ByteBuffer[]{DataConverter.toByteBuffer((String)body, (String)"UTF-8")}, "UTF-8");
    }

    public HttpResponse(int status, String body) throws IOException {
        this((IHttpResponseHeader)new HttpResponseHeader(status), new ByteBuffer[]{DataConverter.toByteBuffer((String)body, (String)"ISO-8859-1")});
    }

    public HttpResponse(String contentType, byte[] body) throws IOException {
        this(200, contentType, body);
    }

    public HttpResponse(int status, String contentType, int contentLength, NonBlockingBodyDataSource body) throws IOException {
        this.responseHeader = new HttpResponseHeader(status, contentType);
        this.responseHeader.setContentLength(contentLength);
        this.setBodyDataSource(body);
    }

    public HttpResponse(int status, String contentType, int contentLength, BlockingBodyDataSource body) throws IOException {
        this.responseHeader = new HttpResponseHeader(status, contentType);
        this.responseHeader.setContentLength(contentLength);
        this.setBodyDataSource(body.getUnderliyingBodyDataSource());
    }

    public HttpResponse(int status, String contentType, NonBlockingBodyDataSource body) throws IOException {
        if (body == null) {
            throw new NullPointerException("body has to be set");
        }
        this.responseHeader = new HttpResponseHeader(status, contentType);
        this.setBodyDataSource(body);
    }

    public HttpResponse(int status, String contentType, BlockingBodyDataSource body) throws IOException {
        this.responseHeader = new HttpResponseHeader(status, contentType);
        this.setBodyDataSource(body.getUnderliyingBodyDataSource());
    }

    public HttpResponse(int status, String contentType, byte[] body) throws IOException {
        this.responseHeader = new HttpResponseHeader(status, contentType);
        this.responseHeader.setContentLength(body.length);
        this.setBodyDataSource(body, this.responseHeader.getCharacterEncoding());
    }

    public HttpResponse(String contentType, ByteBuffer[] body) throws IOException {
        this(200, contentType, body);
    }

    public HttpResponse(int status, String contentType, ByteBuffer[] body) throws IOException {
        this(status, contentType, body, "UTF-8");
    }

    HttpResponse(int status, String contentType, ByteBuffer[] body, String encoding) throws IOException {
        this.responseHeader = new HttpResponseHeader(status, contentType + "; charset=" + encoding);
        try {
            this.setBodyDataSource(body, encoding);
        }
        catch (UnsupportedEncodingException use) {
            throw new RuntimeException(use.toString());
        }
        this.responseHeader.setContentLength(this.getNonBlockingBody().available());
    }

    public HttpResponse(IHttpResponseHeader responseHeader, String body) throws IOException {
        this.responseHeader = responseHeader;
        try {
            this.setBodyDataSource(body, responseHeader.getCharacterEncoding());
        }
        catch (UnsupportedEncodingException use) {
            throw new RuntimeException(use.toString());
        }
    }

    public HttpResponse(IHttpResponseHeader responseHeader, byte[] body) throws IOException {
        this.responseHeader = responseHeader;
        try {
            this.setBodyDataSource(body, responseHeader.getCharacterEncoding());
        }
        catch (UnsupportedEncodingException use) {
            throw new RuntimeException(use.toString());
        }
    }

    public HttpResponse(IHttpResponseHeader responseHeader, ByteBuffer[] body) throws IOException {
        this.responseHeader = responseHeader;
        try {
            this.setBodyDataSource(body, responseHeader.getCharacterEncoding());
        }
        catch (UnsupportedEncodingException use) {
            throw new RuntimeException(use.toString());
        }
    }

    public final int getStatus() {
        return this.responseHeader.getStatus();
    }

    public final void setStatus(int status) {
        this.responseHeader.setStatus(status);
    }

    public String getServer() {
        return this.responseHeader.getServer();
    }

    public void setServer(String server) {
        this.responseHeader.setServer(server);
    }

    public void setDate(String date) {
        this.responseHeader.setDate(date);
    }

    public String getDate() {
        return this.responseHeader.getDate();
    }

    public final String getReason() {
        return this.responseHeader.getReason();
    }

    public void setReason(String reason) {
        this.responseHeader.setReason(reason);
    }

    public String getProtocol() {
        return this.responseHeader.getProtocol();
    }

    public String getProtocolVersion() {
        return this.responseHeader.getProtocolVersion();
    }

    public final void setProtocol(String protocol) {
        this.responseHeader.setProtocol(protocol);
    }

    public final IHttpResponseHeader getResponseHeader() {
        return this.responseHeader;
    }

    public IHttpHeader getMessageHeader() {
        return this.getResponseHeader();
    }
}

