/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.view.customization.ui.main;

import com.paterva.maltego.imgfactory.icons.IconSelector;
import com.paterva.maltego.imgfactoryapi.IconRegistry;
import com.paterva.maltego.imgfactoryapi.RegistryIcon;
import com.paterva.maltego.imgfactoryapi.VirtualIcon;
import com.paterva.maltego.util.IconSize;
import com.paterva.maltego.util.ui.ListUtil;
import com.paterva.maltego.util.ui.dialog.EditDialogDescriptor;
import com.paterva.maltego.util.ui.laf.MaltegoLAF;
import com.paterva.maltego.util.ui.table.EditableTableDecorator;
import com.paterva.maltego.util.ui.table.ImageTableCellRenderer;
import com.paterva.maltego.util.ui.table.PaddedTableCellRenderer;
import com.paterva.maltego.util.ui.table.TableButtonCallback;
import com.paterva.maltego.util.ui.table.TableButtonEvent;
import com.paterva.maltego.util.ui.table.TableButtonListener;
import com.paterva.maltego.view.customization.api.Binding;
import com.paterva.maltego.view.customization.api.CustomizableRegistry;
import com.paterva.maltego.view.customization.api.CustomizableView;
import com.paterva.maltego.view.customization.api.Viewlet;
import com.paterva.maltego.view.customization.ui.binding.BindingController;
import com.paterva.maltego.view.customization.ui.binding.BindingImpl;
import com.paterva.maltego.view.customization.ui.binding.BindingTableModel;
import com.paterva.maltego.view.customization.ui.main.NewViewletController;
import com.paterva.maltego.view.customization.ui.main.ViewletImpl;
import com.paterva.maltego.view.customization.ui.main.ViewletPaddedTableCellRenderer;
import com.paterva.maltego.view.customization.ui.main.ViewletTableModel;
import com.paterva.maltego.view.customization.ui.script.BindingScriptImpl;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.UIDefaults;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.netbeans.swing.etable.ETable;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ViewletPanel
extends JPanel {
    private static final UIDefaults LAF = MaltegoLAF.getLookAndFeelDefaults();
    private final Color gridColor = LAF.getColor("viewlet-manager-grid-color");
    private final Color panelBackground3 = LAF.getColor("viewlet-manager-panel-bg3");
    private final Color bindingTableReadonlyColor = LAF.getColor("viewlet-manager-binding-table-readonly");
    private final Color bindingTableReadWriteColor = new JTable().getForeground();
    private final Color borderColor = LAF.getColor("7-border-color");
    private final Font labelFont = LAF.getFont("Label.font");
    private static final String CARD_SHOW_BINDINGS = "ShowBindingsCard";
    private static final String CARD_SELECT_VIEWLET = "SelectViewletCard";
    private static final String CARD_NO_BINDINGS = "NoBindingsCard";
    private final CustomizableView _view;
    private BindingTableModel _bindingTableModel;
    private ViewletTableModel _viewletTableModel;
    private List<Binding> _copiedBindings;
    private JButton _addBindingButton;
    private ETable _bindingTable;
    private JPanel _bindingsCardPanel;
    private JButton _changeIconButton;
    private JButton _copyButton;
    private JButton _downButton;
    private JButton _newViewletButton;
    private JButton _pasteButton;
    private JButton _upButton;
    private ETable _viewletTable;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel11;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;

    public ViewletPanel(CustomizableView view) {
        this._view = view;
        this.initComponents();
        this.initViewletTable();
        this.initBindingTable();
        this.initKeyboardShortcuts();
        this.onSelectedViewletChanged();
    }

    private void initViewletTable() {
        this._viewletTableModel = new ViewletTableModel();
        this._viewletTable.setModel((TableModel)((Object)this._viewletTableModel));
        EditableTableDecorator decorator = new EditableTableDecorator();
        decorator.addEditDelete((JTable)this._viewletTable, (TableButtonListener)new ViewletTableDeleteButtonListener(), null, (TableButtonCallback)new ViewletTableDeleteButtonCallback());
        this._viewletTable.setDefaultRenderer(Image.class, (TableCellRenderer)new ImageTableCellRenderer());
        this._viewletTable.setDefaultRenderer(String.class, (TableCellRenderer)new PaddedTableCellRenderer());
        TableColumnModel columnModel = this._viewletTable.getColumnModel();
        columnModel.getColumn(5).setCellRenderer(new DisabledCheckboxRenderer());
        columnModel.getColumn(0).setPreferredWidth(20);
        columnModel.getColumn(0).setMaxWidth(20);
        columnModel.getColumn(1).setPreferredWidth(300);
        columnModel.getColumn(2).setPreferredWidth(50);
        columnModel.getColumn(3).setPreferredWidth(70);
        columnModel.getColumn(4).setPreferredWidth(60);
        columnModel.getColumn(5).setPreferredWidth(70);
        this._viewletTable.setAutoCreateColumnsFromModel(false);
        this._viewletTable.setSelectionMode(0);
        this._viewletTable.getSelectionModel().addListSelectionListener(new ViewletTableSelectionListener());
    }

    private void initBindingTable() {
        this._bindingTableModel = new BindingTableModel();
        this._bindingTable.setModel((TableModel)((Object)this._bindingTableModel));
        EditableTableDecorator decorator = new EditableTableDecorator();
        BindingTableDeleteListener deleteListener = new BindingTableDeleteListener();
        BindingTableEditListener editListener = new BindingTableEditListener();
        decorator.addEditDelete((JTable)this._bindingTable, (TableButtonListener)deleteListener, (TableButtonListener)editListener, (TableButtonCallback)new BindingTableButtonCallback());
        this._bindingTable.setDefaultRenderer(String.class, (TableCellRenderer)((Object)new ViewletPaddedTableCellRenderer()));
        this._bindingTable.setAutoCreateColumnsFromModel(false);
        TableColumnModel columnModel = this._bindingTable.getColumnModel();
        columnModel.getColumn(0).setPreferredWidth(50);
        columnModel.getColumn(0).setMaxWidth(50);
        columnModel.getColumn(1).setPreferredWidth(100);
        columnModel.getColumn(2).setPreferredWidth(400);
        this._bindingTable.getSelectionModel().addListSelectionListener(new BindingTableSelectionListener());
    }

    private void initKeyboardShortcuts() {
        KeyStroke copy = KeyStroke.getKeyStroke(67, 2, false);
        KeyStroke paste = KeyStroke.getKeyStroke(86, 2, false);
        ClipboardListener clipboardListener = new ClipboardListener();
        this.registerKeyboardAction(clipboardListener, "Copy", copy, 2);
        this.registerKeyboardAction(clipboardListener, "Paste", paste, 2);
        this._viewletTable.registerKeyboardAction((ActionListener)clipboardListener, "Copy", copy, 1);
        this._viewletTable.registerKeyboardAction((ActionListener)clipboardListener, "Paste", paste, 1);
        this._bindingTable.registerKeyboardAction((ActionListener)clipboardListener, "Copy", copy, 1);
        this._bindingTable.registerKeyboardAction((ActionListener)clipboardListener, "Paste", paste, 1);
        KeyStroke delete = KeyStroke.getKeyStroke(127, 0, false);
        this._viewletTable.registerKeyboardAction((ActionListener)new ViewletDeleteKeyListener(), "Delete", delete, 1);
        this._bindingTable.registerKeyboardAction((ActionListener)new BindingDeleteKeyListener(), "Delete", delete, 1);
    }

    public void setViewlets(Collection<Viewlet> viewlets) {
        ArrayList<Viewlet> list = new ArrayList<Viewlet>(viewlets);
        Collections.sort(list);
        this._viewletTableModel.setRows(list);
    }

    public List<Viewlet> getViewlets() {
        return this._viewletTableModel.getRows();
    }

    public void setActiveViewlet(Viewlet viewlet) {
        this._viewletTableModel.setActive(viewlet);
        int row = this._viewletTableModel.getRows().indexOf(viewlet);
        this._viewletTable.getSelectionModel().setSelectionInterval(row, row);
    }

    public Viewlet getActiveViewlet() {
        return this._viewletTableModel.getActive();
    }

    public Viewlet getSelectedViewlet() {
        int selectedRow = this._viewletTable.getSelectedRow();
        Viewlet viewlet = null;
        if (selectedRow != -1) {
            int row = this._viewletTable.convertRowIndexToModel(selectedRow);
            viewlet = (Viewlet)this._viewletTableModel.getRow(row);
        }
        return viewlet;
    }

    private List<Binding> getSelectedBindings() {
        int[] selectedRows;
        ArrayList<Binding> selectedBindings = new ArrayList<Binding>();
        for (int row : selectedRows = this._bindingTable.getSelectedRows()) {
            selectedBindings.add((Binding)this._bindingTableModel.getRow(this._bindingTable.convertRowIndexToModel(row)));
        }
        return selectedBindings;
    }

    private void onSelectedViewletChanged() {
        Viewlet selected = this.getSelectedViewlet();
        if (selected != null) {
            this._bindingTableModel.setRows(selected.getBindings());
            boolean readOnly = selected.isReadOnly();
            Color fg = readOnly ? this.bindingTableReadonlyColor : this.bindingTableReadWriteColor;
            this._bindingTable.setForeground(fg);
            this._bindingTable.putClientProperty((Object)"selectionForeground", (Object)fg);
        }
        this.updateBindingsCardLayout();
        this._changeIconButton.setEnabled(selected != null);
        this._addBindingButton.setEnabled(selected != null && !selected.isReadOnly());
        this.onSelectedBindingsChanged();
    }

    private void onSelectedBindingsChanged() {
        boolean canDown;
        boolean canUp;
        if (this._bindingTable.getSelectionModel().getValueIsAdjusting()) {
            return;
        }
        Viewlet viewlet = this.getSelectedViewlet();
        if (viewlet == null || viewlet.isReadOnly()) {
            canUp = false;
            canDown = false;
        } else {
            int selectedRowCount = this._bindingTable.getSelectedRowCount();
            if (selectedRowCount == 1) {
                int row = this._bindingTable.convertRowIndexToModel(this._bindingTable.getSelectedRow());
                canUp = row != 0;
                canDown = row != this._bindingTableModel.getRowCount() - 1;
            } else {
                canDown = canUp = selectedRowCount > 0;
            }
        }
        this._upButton.setEnabled(canUp);
        this._downButton.setEnabled(canDown);
        this.updateClipboardButtons();
    }

    private void updateBindingsCardLayout() {
        CardLayout layout = (CardLayout)this._bindingsCardPanel.getLayout();
        Viewlet selected = this.getSelectedViewlet();
        String card = selected == null ? CARD_SELECT_VIEWLET : (selected.getBindings().isEmpty() ? CARD_NO_BINDINGS : CARD_SHOW_BINDINGS);
        layout.show(this._bindingsCardPanel, card);
    }

    private boolean addOrEditBinding(Binding binding, String title, boolean readonly) {
        List customizables = CustomizableRegistry.getDefault().get(this._view.getCustomizableViewID());
        BindingController controller = new BindingController(binding, customizables, readonly);
        EditDialogDescriptor nd = new EditDialogDescriptor(title, (WizardDescriptor.Panel)controller);
        if (DialogDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)nd))) {
            return controller.update(binding);
        }
        return false;
    }

    private void updateClipboardButtons() {
        Viewlet selectedViewlet = this.getSelectedViewlet();
        List<Binding> selectedBindings = this.getSelectedBindings();
        this._copyButton.setEnabled(selectedBindings != null && !selectedBindings.isEmpty());
        this._pasteButton.setEnabled(this._copiedBindings != null && !this._copiedBindings.isEmpty() && selectedViewlet != null && !selectedViewlet.isReadOnly());
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this._viewletTable = new ETable();
        this.jPanel5 = new JPanel();
        this.jPanel8 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jPanel3 = new JPanel();
        this._newViewletButton = new JButton();
        this._changeIconButton = new JButton();
        this.jPanel4 = new JPanel();
        this.jPanel6 = new JPanel();
        this.jPanel7 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jPanel2 = new JPanel();
        this._addBindingButton = new JButton();
        this._upButton = new JButton();
        this._downButton = new JButton();
        this._copyButton = new JButton();
        this._pasteButton = new JButton();
        this._bindingsCardPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this._bindingTable = new ETable();
        this.jPanel10 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jPanel11 = new JPanel();
        this.jLabel4 = new JLabel();
        this.setPreferredSize(new Dimension(600, 500));
        this.setLayout(new BorderLayout());
        this.jSplitPane1.setDividerLocation(280);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(0.5);
        this.jPanel1.setLayout(new BorderLayout());
        this._viewletTable.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this._viewletTable.setFillsViewportHeight(true);
        this._viewletTable.setGridColor(this.gridColor);
        this.jScrollPane2.setViewportView((Component)this._viewletTable);
        this.jPanel1.add((Component)this.jScrollPane2, "Center");
        this.jPanel5.setLayout(new BorderLayout());
        this.jPanel8.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, this.borderColor));
        this.jPanel8.setLayout(new FlowLayout(1, 2, 3));
        this.jLabel1.setFont(new Font(this.labelFont.getFamily(), 1, this.labelFont.getSize() + 1));
        this.jLabel1.setText(NbBundle.getMessage(ViewletPanel.class, (String)"ViewletPanel.jLabel1.text"));
        this.jPanel8.add(this.jLabel1);
        this.jPanel5.add((Component)this.jPanel8, "North");
        this.jPanel3.setLayout(new GridBagLayout());
        this._newViewletButton.setText(NbBundle.getMessage(ViewletPanel.class, (String)"ViewletPanel._newViewletButton.text"));
        this._newViewletButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewletPanel.this._newViewletButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.jPanel3.add((Component)this._newViewletButton, gridBagConstraints);
        this._changeIconButton.setText(NbBundle.getMessage(ViewletPanel.class, (String)"ViewletPanel._changeIconButton.text"));
        this._changeIconButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewletPanel.this._changeIconButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 6, 6);
        this.jPanel3.add((Component)this._changeIconButton, gridBagConstraints);
        this.jPanel5.add((Component)this.jPanel3, "Center");
        this.jPanel1.add((Component)this.jPanel5, "North");
        this.jSplitPane1.setTopComponent(this.jPanel1);
        this.jPanel4.setLayout(new BorderLayout());
        this.jPanel6.setLayout(new BorderLayout());
        this.jPanel7.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, this.borderColor));
        this.jPanel7.setLayout(new FlowLayout(1, 3, 3));
        this.jLabel2.setFont(new Font(this.labelFont.getFamily(), 1, this.labelFont.getSize() + 1));
        this.jLabel2.setText(NbBundle.getMessage(ViewletPanel.class, (String)"ViewletPanel.jLabel2.text"));
        this.jPanel7.add(this.jLabel2);
        this.jPanel6.add((Component)this.jPanel7, "North");
        this.jPanel2.setLayout(new GridBagLayout());
        this._addBindingButton.setIcon(new ImageIcon(this.getClass().getResource("/com/paterva/maltego/view/customization/ui/resources/Add.png")));
        this._addBindingButton.setText(NbBundle.getMessage(ViewletPanel.class, (String)"ViewletPanel._addBindingButton.text"));
        this._addBindingButton.setToolTipText(NbBundle.getMessage(ViewletPanel.class, (String)"ViewletPanel._addBindingButton.toolTipText"));
        this._addBindingButton.setFocusPainted(false);
        this._addBindingButton.setMargin(new Insets(2, 5, 2, 5));
        this._addBindingButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewletPanel.this._addBindingButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(6, 6, 6, 6);
        this.jPanel2.add((Component)this._addBindingButton, gridBagConstraints);
        this._upButton.setIcon(new ImageIcon(this.getClass().getResource("/com/paterva/maltego/view/customization/ui/resources/Up.png")));
        this._upButton.setText(NbBundle.getMessage(ViewletPanel.class, (String)"ViewletPanel._upButton.text"));
        this._upButton.setToolTipText(NbBundle.getMessage(ViewletPanel.class, (String)"ViewletPanel._upButton.toolTipText"));
        this._upButton.setFocusPainted(false);
        this._upButton.setMargin(new Insets(2, 5, 2, 5));
        this._upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewletPanel.this._upButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.jPanel2.add((Component)this._upButton, gridBagConstraints);
        this._downButton.setIcon(new ImageIcon(this.getClass().getResource("/com/paterva/maltego/view/customization/ui/resources/Down.png")));
        this._downButton.setText(NbBundle.getMessage(ViewletPanel.class, (String)"ViewletPanel._downButton.text"));
        this._downButton.setToolTipText(NbBundle.getMessage(ViewletPanel.class, (String)"ViewletPanel._downButton.toolTipText"));
        this._downButton.setFocusPainted(false);
        this._downButton.setMargin(new Insets(2, 5, 2, 5));
        this._downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewletPanel.this._downButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.jPanel2.add((Component)this._downButton, gridBagConstraints);
        this._copyButton.setIcon(new ImageIcon(this.getClass().getResource("/com/paterva/maltego/view/customization/ui/resources/Copy.png")));
        this._copyButton.setText(NbBundle.getMessage(ViewletPanel.class, (String)"ViewletPanel._copyButton.text_1"));
        this._copyButton.setToolTipText(NbBundle.getMessage(ViewletPanel.class, (String)"ViewletPanel._copyButton.toolTipText"));
        this._copyButton.setFocusPainted(false);
        this._copyButton.setMargin(new Insets(2, 5, 2, 5));
        this._copyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewletPanel.this._copyButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.jPanel2.add((Component)this._copyButton, gridBagConstraints);
        this._pasteButton.setIcon(new ImageIcon(this.getClass().getResource("/com/paterva/maltego/view/customization/ui/resources/Paste.png")));
        this._pasteButton.setText(NbBundle.getMessage(ViewletPanel.class, (String)"ViewletPanel._pasteButton.text"));
        this._pasteButton.setToolTipText(NbBundle.getMessage(ViewletPanel.class, (String)"ViewletPanel._pasteButton.toolTipText"));
        this._pasteButton.setFocusPainted(false);
        this._pasteButton.setMargin(new Insets(2, 5, 2, 5));
        this._pasteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ViewletPanel.this._pasteButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        this.jPanel2.add((Component)this._pasteButton, gridBagConstraints);
        this.jPanel6.add((Component)this.jPanel2, "West");
        this._bindingsCardPanel.setLayout(new CardLayout());
        this.jScrollPane1.setBorder(null);
        this._bindingTable.setModel((TableModel)new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this._bindingTable.setFillsViewportHeight(true);
        this._bindingTable.setPreferredScrollableViewportSize(new Dimension(250, 300));
        this.jScrollPane1.setViewportView((Component)this._bindingTable);
        this._bindingsCardPanel.add((Component)this.jScrollPane1, CARD_SHOW_BINDINGS);
        this.jPanel10.setBackground(this.panelBackground3);
        this.jPanel10.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, this.gridColor));
        this.jPanel10.setLayout(new BorderLayout());
        this.jLabel3.setHorizontalAlignment(0);
        this.jLabel3.setText(NbBundle.getMessage(ViewletPanel.class, (String)"ViewletPanel.jLabel3.text"));
        this.jPanel10.add((Component)this.jLabel3, "Center");
        this._bindingsCardPanel.add((Component)this.jPanel10, CARD_SELECT_VIEWLET);
        this.jPanel11.setBackground(this.panelBackground3);
        this.jPanel11.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, this.gridColor));
        this.jPanel11.setLayout(new BorderLayout());
        this.jLabel4.setHorizontalAlignment(0);
        this.jLabel4.setText(NbBundle.getMessage(ViewletPanel.class, (String)"ViewletPanel.jLabel4.text"));
        this.jPanel11.add((Component)this.jLabel4, "Center");
        this._bindingsCardPanel.add((Component)this.jPanel11, CARD_NO_BINDINGS);
        this.jPanel6.add((Component)this._bindingsCardPanel, "Center");
        this.jPanel4.add((Component)this.jPanel6, "Center");
        this.jSplitPane1.setBottomComponent(this.jPanel4);
        this.add((Component)this.jSplitPane1, "Center");
    }

    private void _addBindingButtonActionPerformed(ActionEvent evt) {
        BindingImpl binding = new BindingImpl();
        binding.setScript(new BindingScriptImpl("JavaScript"));
        if (this.addOrEditBinding(binding, "Add Binding", false)) {
            Viewlet selected = this.getSelectedViewlet();
            selected.getBindings().add(binding);
            this.onSelectedViewletChanged();
        }
    }

    private void _upButtonActionPerformed(ActionEvent evt) {
        List bindings = this.getSelectedViewlet().getBindings();
        List<Binding> selectedBindings = this.getSelectedBindings();
        ListUtil.moveSelectedUp((List)bindings, selectedBindings);
        this._bindingTableModel.fireTableDataChanged();
        this.setSelection(selectedBindings);
    }

    private void _downButtonActionPerformed(ActionEvent evt) {
        List bindings = this.getSelectedViewlet().getBindings();
        List<Binding> selectedBindings = this.getSelectedBindings();
        ListUtil.moveSelectedDown((List)bindings, selectedBindings);
        this._bindingTableModel.fireTableDataChanged();
        this.setSelection(selectedBindings);
    }

    private void _newViewletButtonActionPerformed(ActionEvent evt) {
        List viewlets = this._viewletTableModel.getRows();
        NewViewletController controller = new NewViewletController(viewlets);
        EditDialogDescriptor nd = new EditDialogDescriptor("Viewlet Name", (WizardDescriptor.Panel)controller);
        if (DialogDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)nd))) {
            String viewletName = controller.getViewletName();
            ViewletImpl viewlet = new ViewletImpl(viewletName);
            viewlets.add(viewlet);
            this.setViewlets(viewlets);
            this.setActiveViewlet(viewlet);
        }
    }

    private void _copyButtonActionPerformed(ActionEvent evt) {
        this._copiedBindings = this.getSelectedBindings();
        this.updateClipboardButtons();
    }

    private void _pasteButtonActionPerformed(ActionEvent evt) {
        if (this._copiedBindings != null) {
            try {
                Viewlet selected = this.getSelectedViewlet();
                ArrayList<Binding> newBindings = new ArrayList<Binding>();
                for (Binding binding : this._copiedBindings) {
                    Binding newBinding = (Binding)binding.clone();
                    newBindings.add(newBinding);
                    selected.getBindings().add(newBinding);
                }
                this._bindingTableModel.fireTableDataChanged();
                this.setSelection(newBindings);
                this.updateBindingsCardLayout();
            }
            catch (CloneNotSupportedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void _changeIconButtonActionPerformed(ActionEvent evt) {
        Viewlet viewlet = this.getSelectedViewlet();
        if (viewlet != null) {
            String iconResource = viewlet.getIcon();
            RegistryIcon icon = VirtualIcon.parse((String)iconResource).flatMap(arg_0 -> ((IconRegistry)IconRegistry.getDefault()).findRegistryIcon(arg_0)).orElse(null);
            icon = icon != null ? IconSelector.getDefault().getIcon(IconSize.TINY, icon) : IconSelector.getDefault().getIcon(IconSize.TINY, "Viewlets");
            if (icon != null) {
                viewlet.setIcon(icon.toVirualIcon().toString());
                int row = this._viewletTable.convertRowIndexToModel(this._viewletTable.getSelectedRow());
                this._viewletTableModel.fireTableRowsUpdated(row, row);
            }
        }
    }

    private void setSelection(List<Binding> selectedBindings) {
        ListSelectionModel selectionModel = this._bindingTable.getSelectionModel();
        selectionModel.setValueIsAdjusting(true);
        selectionModel.clearSelection();
        for (int i = 0; i < this._bindingTable.getRowCount(); ++i) {
            if (!selectedBindings.contains(this._bindingTableModel.getRow(i))) continue;
            int row = this._bindingTable.convertRowIndexToView(i);
            selectionModel.addSelectionInterval(row, row);
        }
        selectionModel.setValueIsAdjusting(false);
    }

    private void deleteSelectedViewlet() {
        Viewlet selected = this.getSelectedViewlet();
        if (selected != null && !selected.isReadOnly()) {
            String message = "Are you sure you want to delete the selected viewlet?";
            NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)message, "Delete Viewlet", 2);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)nd) == NotifyDescriptor.OK_OPTION) {
                if (selected.equals(this.getActiveViewlet())) {
                    this.setActiveViewlet(null);
                }
                List<Viewlet> viewlets = this.getViewlets();
                viewlets.remove(selected);
                this.setViewlets(viewlets);
            }
        }
    }

    private void deleteSelectedBindings() {
        List<Binding> bindings = this.getSelectedBindings();
        if (bindings != null && !bindings.isEmpty()) {
            String message = bindings.size() > 1 ? "Are you sure you want to delete these " + bindings.size() + " selected bindings?" : "Are you sure you want to delete the selected binding?";
            NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)message, "Delete Binding", 2);
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)nd) == NotifyDescriptor.OK_OPTION) {
                bindings = this.getSelectedBindings();
                for (Binding binding : bindings) {
                    this.getSelectedViewlet().getBindings().remove(binding);
                }
                this._bindingTableModel.fireTableDataChanged();
                this.updateBindingsCardLayout();
            }
        }
    }

    private class BindingDeleteKeyListener
    implements ActionListener {
        private BindingDeleteKeyListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ViewletPanel.this.deleteSelectedBindings();
        }
    }

    private class BindingTableDeleteListener
    implements TableButtonListener {
        private BindingTableDeleteListener() {
        }

        public void actionPerformed(TableButtonEvent evt) {
            ViewletPanel.this.deleteSelectedBindings();
        }
    }

    private class ViewletDeleteKeyListener
    implements ActionListener {
        private ViewletDeleteKeyListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ViewletPanel.this.deleteSelectedViewlet();
        }
    }

    private class ViewletTableDeleteButtonListener
    implements TableButtonListener {
        private ViewletTableDeleteButtonListener() {
        }

        public void actionPerformed(TableButtonEvent evt) {
            ViewletPanel.this.deleteSelectedViewlet();
        }
    }

    private class ClipboardListener
    implements ActionListener {
        private ClipboardListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if ("Copy".equals(e.getActionCommand())) {
                if (ViewletPanel.this._copyButton.isEnabled()) {
                    ViewletPanel.this._copyButtonActionPerformed(null);
                }
            } else if ("Paste".equals(e.getActionCommand()) && ViewletPanel.this._pasteButton.isEnabled()) {
                ViewletPanel.this._pasteButtonActionPerformed(null);
            }
        }
    }

    private class BindingTableButtonCallback
    implements TableButtonCallback {
        private BindingTableButtonCallback() {
        }

        public boolean isButtonEnabled(JTable table, String action, int row) {
            if ("delete".equals(action)) {
                Viewlet viewlet = ViewletPanel.this.getSelectedViewlet();
                return viewlet != null && !viewlet.isReadOnly();
            }
            return true;
        }
    }

    private class BindingTableSelectionListener
    implements ListSelectionListener {
        private BindingTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            ViewletPanel.this.onSelectedBindingsChanged();
        }
    }

    private class ViewletTableSelectionListener
    implements ListSelectionListener {
        private ViewletTableSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            ViewletPanel.this.onSelectedViewletChanged();
        }
    }

    private static class DisabledCheckboxRenderer
    extends JCheckBox
    implements TableCellRenderer {
        public DisabledCheckboxRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setSelected((Boolean)value);
            this.setEnabled(table.isCellEditable(row, column));
            Component stringComponent = table.getDefaultRenderer(String.class).getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setBackground(stringComponent.getBackground());
            return this;
        }
    }

    private class ViewletTableDeleteButtonCallback
    implements TableButtonCallback {
        private ViewletTableDeleteButtonCallback() {
        }

        public boolean isButtonEnabled(JTable table, String action, int row) {
            row = ViewletPanel.this._viewletTable.convertRowIndexToModel(row);
            Viewlet viewlet = (Viewlet)ViewletPanel.this._viewletTableModel.getRow(row);
            return !viewlet.isReadOnly();
        }
    }

    private class BindingTableEditListener
    implements TableButtonListener {
        private BindingTableEditListener() {
        }

        public void actionPerformed(TableButtonEvent evt) {
            String title;
            Viewlet selected = ViewletPanel.this.getSelectedViewlet();
            int index = ViewletPanel.this._bindingTable.convertRowIndexToModel(evt.getSelectedRows()[0]);
            Binding binding = (Binding)ViewletPanel.this._bindingTableModel.getRow(index);
            if (ViewletPanel.this.addOrEditBinding(binding, title = selected.isReadOnly() ? "View Binding (Read-only)" : "Edit Binding", selected.isReadOnly())) {
                ViewletPanel.this._bindingTableModel.fireTableRowsUpdated(index, index);
            }
        }
    }
}

