/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.merge;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.merging.EntityFilter;
import com.paterva.maltego.merging.GraphMergeStrategy;
import com.paterva.maltego.merging.PartMergeStrategy;
import com.paterva.maltego.ui.graph.merge.MergeUtils;
import com.paterva.maltego.ui.graph.merge.PositioningGraphMerger;
import com.paterva.maltego.util.SimilarStrings;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public class InteractiveGraphMerger
extends PositioningGraphMerger {
    private final AtomicBoolean _cancelled = new AtomicBoolean(false);
    private Map<MaltegoEntity, PartMergeStrategy> _partMergeStrats;
    private Set<MaltegoEntity> _skipped;

    public InteractiveGraphMerger(GraphID destGraphID, GraphID srcGraphID, SimilarStrings description) {
        super(destGraphID, srcGraphID, description);
        this.init();
    }

    private void init() {
        this.setGraphMergeStrat(new UserGraphMergeStrategy());
        this.setGraphMerger(this.createGraphMerger(new SkippedEntityFilter()));
    }

    public void promptMergeGraphs() {
        this._cancelled.set(false);
        this._skipped = new HashSet<MaltegoEntity>();
        this._partMergeStrats = MergeUtils.promptForEntityMergeStrategies(this.getGraphMerger(), this.getDestGraphID(), this.getSrcGraphID(), this._skipped, this._cancelled);
    }

    @Override
    public void mergeGraphs() {
        if (!this._cancelled.get()) {
            super.mergeGraphs();
        }
    }

    @Override
    public void selectSourceNodes() {
        if (!this._cancelled.get()) {
            super.selectSourceNodes();
        }
        this.setGraphMerger(null);
        this._partMergeStrats = null;
    }

    private class SkippedEntityFilter
    implements EntityFilter {
        private SkippedEntityFilter() {
        }

        public boolean accept(MaltegoEntity entity) {
            return !InteractiveGraphMerger.this._skipped.contains(entity);
        }
    }

    private class UserGraphMergeStrategy
    implements GraphMergeStrategy {
        private UserGraphMergeStrategy() {
        }

        public PartMergeStrategy getEntityMergeStrategy(MaltegoEntity destEntity, MaltegoEntity srcEntity) {
            return (PartMergeStrategy)InteractiveGraphMerger.this._partMergeStrats.get(srcEntity);
        }

        public PartMergeStrategy getLinkMergeStrategy(MaltegoLink destLink, MaltegoLink srcLink) {
            return PartMergeStrategy.PreferNew;
        }
    }
}

