/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.imgfactoryapi;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.imgfactoryapi.ImageCache;
import com.paterva.maltego.util.ImageCallback;
import java.awt.Image;
import javax.swing.ImageIcon;
import org.openide.util.Lookup;

public abstract class ImageFactory {
    private static ImageFactory _default;

    public static ImageFactory getDefault() {
        if (_default == null && (_default = (ImageFactory)Lookup.getDefault().lookup(ImageCache.class)) == null) {
            throw new IllegalStateException("No image factory found.");
        }
        return _default;
    }

    public abstract Image getImage(GraphID var1, Object var2, ImageCallback var3);

    public Image getImage(GraphID graphID, Object imageKey) {
        return this.getImage(graphID, imageKey, null);
    }

    public Image getImage(Object imageKey, ImageCallback cb) {
        return this.getImage(null, imageKey, cb);
    }

    public Image getImage(Object imageKey) {
        return this.getImage(null, imageKey, null);
    }

    public ImageIcon getImageIcon(GraphID graphID, Object imageKey) {
        Image image = this.getImage(graphID, imageKey);
        return image == null ? null : new ImageIcon(image);
    }

    public ImageIcon getImageIcon(Object imageKey) {
        return this.getImageIcon(null, imageKey);
    }

    public abstract Image getImage(GraphID var1, Object var2, int var3, int var4, ImageCallback var5);

    public Image getImage(GraphID graphID, Object imageKey, int width, int height) {
        return this.getImage(graphID, imageKey, width, height, null);
    }

    public Image getImage(Object imageKey, int width, int height, ImageCallback cb) {
        return this.getImage(null, imageKey, width, height, cb);
    }

    public Image getImage(Object imageKey, int width, int height) {
        return this.getImage(null, imageKey, width, height, null);
    }

    public ImageIcon getImageIcon(GraphID graphID, Object imageKey, int width, int height) {
        Image image = this.getImage(graphID, imageKey, width, height);
        return image == null ? null : new ImageIcon(image);
    }

    public ImageIcon getImageIcon(Object imageKey, int width, int height) {
        return this.getImageIcon(null, imageKey, width, height);
    }
}

