/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildevents;

import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.StartParameter;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.execution.TaskExecutionGraphListener;
import org.gradle.api.initialization.Settings;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.configuration.LoggingConfiguration;
import org.gradle.initialization.BuildRequestMetaData;
import org.gradle.internal.InternalListener;
import org.gradle.internal.buildevents.BuildExceptionReporter;
import org.gradle.internal.buildevents.BuildResultLogger;
import org.gradle.internal.buildevents.BuildStartedTime;
import org.gradle.internal.logging.format.DurationFormatter;
import org.gradle.internal.logging.format.TersePrettyDurationFormatter;
import org.gradle.internal.logging.text.StyledTextOutputFactory;
import org.gradle.internal.time.Clock;

public class BuildLogger
implements BuildListener,
TaskExecutionGraphListener,
InternalListener {
    private final Logger logger;
    private final BuildExceptionReporter exceptionReporter;
    private final BuildResultLogger resultLogger;
    private String action;

    public BuildLogger(Logger logger, StyledTextOutputFactory textOutputFactory, StartParameter startParameter, BuildRequestMetaData requestMetaData, BuildStartedTime buildStartedTime, Clock clock) {
        this.logger = logger;
        this.exceptionReporter = new BuildExceptionReporter(textOutputFactory, (LoggingConfiguration)startParameter, requestMetaData.getClient());
        this.resultLogger = new BuildResultLogger(textOutputFactory, buildStartedTime, clock, (DurationFormatter)new TersePrettyDurationFormatter());
    }

    public void buildStarted(Gradle gradle) {
        StartParameter startParameter = gradle.getStartParameter();
        this.logger.info("Starting Build");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Gradle user home: {}", (Object)startParameter.getGradleUserHomeDir());
            this.logger.debug("Current dir: {}", (Object)startParameter.getCurrentDir());
            this.logger.debug("Settings file: {}", (Object)startParameter.getSettingsFile());
            this.logger.debug("Build file: {}", (Object)startParameter.getBuildFile());
        }
    }

    public void settingsEvaluated(Settings settings) {
        SettingsInternal settingsInternal = (SettingsInternal)settings;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Settings evaluated using {}.", (Object)settingsInternal.getSettingsScript().getDisplayName());
        }
    }

    public void projectsLoaded(Gradle gradle) {
        if (this.logger.isInfoEnabled()) {
            ProjectInternal projectInternal = (ProjectInternal)gradle.getRootProject();
            this.logger.info("Projects loaded. Root project using {}.", (Object)projectInternal.getBuildScriptSource().getDisplayName());
            this.logger.info("Included projects: {}", (Object)projectInternal.getAllprojects());
        }
    }

    public void projectsEvaluated(Gradle gradle) {
        this.logger.info("All projects evaluated.");
    }

    public void graphPopulated(TaskExecutionGraph graph) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Tasks to be executed: {}", (Object)graph.getAllTasks());
        }
    }

    public void buildFinished(BuildResult result) {
        this.action = result.getAction();
    }

    public void logResult(Throwable buildFailure) {
        if (this.action == null) {
            return;
        }
        BuildResult buildResult = new BuildResult(this.action, null, buildFailure);
        this.exceptionReporter.buildFinished(buildResult);
        this.resultLogger.buildFinished(buildResult);
    }
}

