//
//  Alerter.m
//  Cosmic Debris
//
//  Created by John Schilling on 11/23/04.
//  Copyright 2004 John Schilling. All rights reserved.
//

#import "Alerter.h"
#import "Controller.h"

#define DEFAULT_AUTOCLOSE_SECS  300.0

@implementation Alerter

#pragma mark
#pragma mark PRIVATE INSTANCE METHODS
#pragma mark

- (id)init
{
    if( ![super init] ) return nil;
    _lastAppPath    = [[NSMutableString alloc] init];
    return self;
}

- (void)awakeFromNib
{

}

- (BOOL)windowShouldClose:(id)sender
{
    [self returnFocusToLastApplication];
    [self stopCloseTimer];
    return YES;
}

- (void)dealloc
{
    [_lastAppPath release];
    [super dealloc];
}






- (void)runSingleAlertWindowForLevel:(int)level description:(NSString *)description autoClose:(BOOL)autoClose
{    
    _isSingleAlertMessage = YES;
    
    NSString *message = [NSString stringWithFormat:@"Aurora Event Alert! The Aurora Event Probability has been upgraded to \"%@\"", description];
    [_singleAlertMessageText setStringValue:message];
    
    [_singleAlertIconView setImage:[NSImage imageNamed:[NSString stringWithFormat:@"AlertIcon%d", level]]];
    
    [self setLastApplicationPath];
    [NSApp activateIgnoringOtherApps:YES];
    [_singleAlertWindow center];
    [_singleAlertWindow makeKeyAndOrderFront:self];
    [_singleAlertWindow display];
    if (autoClose) [self startCloseTimer];
}

- (void)runMultiAlertWindowWithHighLat:(NSString *)highLat 
                                midLat:(NSString *)midLat 
                                lowLat:(NSString *)lowLat 
                                PCAF:(NSString *)PCAF 
                                autoClose:(BOOL)autoClose
{
    _isSingleAlertMessage = NO;
    
    [_multiAlertHighText setStringValue:highLat];
    [_multiAlertMidText setStringValue:midLat];
    [_multiAlertLowText setStringValue:lowLat];
    [_multiAlertPCAFText setStringValue:PCAF];
    
    [_multiAlertIconView setImage:[NSImage imageNamed:@"AlertIcon2"]];
    
    [self setLastApplicationPath];
    [NSApp activateIgnoringOtherApps:YES];
    [_multiAlertWindow center];
    [_multiAlertWindow makeKeyAndOrderFront:self];
    [_multiAlertWindow display];
    if (autoClose) [self startCloseTimer];
}

- (IBAction)toggleAlertWithMessage:(id)sender
{
    [SharedController turnOffAlertWithMessage:![sender state]];
}

- (void)startCloseTimer
{
    [self stopCloseTimer];
    
    NSTimer *timer = [NSTimer scheduledTimerWithTimeInterval:(float)DEFAULT_AUTOCLOSE_SECS
                            target:self 
                            selector:@selector(closeTimerFired:) 
                            userInfo:nil 
                            repeats:NO];
    if (timer) _closeTimer = [timer retain];
}

- (void)stopCloseTimer
{
    if (_closeTimer) [_closeTimer invalidate];
    if (_closeTimer) [_closeTimer release];
    _closeTimer = nil;
}

- (void)closeTimerFired:(NSTimer *)timer
{
    if (_isSingleAlertMessage) {
        [_singleAlertWindow close];
    } else {
        [_multiAlertWindow close];
    }
}



- (void)setLastApplicationPath
{
    NSDictionary *appDict = [[NSWorkspace sharedWorkspace] activeApplication];
    if (appDict == nil) {
        _lastAppPath = nil;
        return;
    }
    NSString *myPath = [[NSBundle mainBundle] bundlePath];
    NSString *appPath = [appDict objectForKey:@"NSApplicationPath"];
    if (![myPath isEqualToString:appPath]) {
        [_lastAppPath setString: appPath];
    }
}

- (void)returnFocusToLastApplication
{
    if (_lastAppPath == nil || ([_lastAppPath length] < 1)) return;
    NSArray *activeApps = [[NSWorkspace sharedWorkspace] launchedApplications];
    
    NSEnumerator *appsEnum = [activeApps objectEnumerator];
    id anApp;
    while (anApp = [appsEnum nextObject]) {
        NSString *appPath = [anApp objectForKey:@"NSApplicationPath"];
        NSString *appName = [anApp objectForKey:@"NSApplicationName"];
        if ([appPath isEqualToString:_lastAppPath] && ![appName isEqualToString:@"Finder"]) {
            [[NSWorkspace sharedWorkspace] launchApplication: _lastAppPath];
        }
    }
}


@end
