/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol.handler;

import java.io.StringWriter;
import java.util.Arrays;
import java.util.stream.Stream;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import org.openstreetmap.josm.data.preferences.JosmUrls;
import org.openstreetmap.josm.io.remotecontrol.PermissionPrefWithDefault;
import org.openstreetmap.josm.io.remotecontrol.RemoteControl;
import org.openstreetmap.josm.io.remotecontrol.RequestProcessor;
import org.openstreetmap.josm.io.remotecontrol.handler.RequestHandler;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class OpenApiHandler
extends RequestHandler {
    public static final String command = "openapi.json";

    @Override
    protected void handleRequest() {
        JsonObjectBuilder openapi = this.getOpenApi();
        StringWriter stringWriter = new StringWriter();
        Json.createWriter(stringWriter).write(openapi.build());
        this.content = stringWriter.toString();
        this.contentType = "application/json";
    }

    private JsonObjectBuilder getOpenApi() {
        return Json.createObjectBuilder().add("openapi", "3.0.0").add("info", Json.createObjectBuilder().add("title", "JOSM RemoteControl").add("version", RemoteControl.getVersion()).add("contact", Json.createObjectBuilder().add("name", "JOSM").add("url", JosmUrls.getInstance().getJOSMWebsite()))).add("servers", Json.createArrayBuilder().add(Json.createObjectBuilder().add("url", "http://localhost:8111/"))).add("paths", this.getHandlers());
    }

    private JsonObjectBuilder getHandlers() {
        JsonObjectBuilder paths = Json.createObjectBuilder();
        RequestProcessor.getHandlersInfo(null).forEach(handler -> paths.add("/" + handler.getCommand(), this.getHandler((RequestHandler)handler)));
        return paths;
    }

    private JsonObjectBuilder getHandler(RequestHandler handler) {
        JsonArrayBuilder parameters = Json.createArrayBuilder();
        Stream.concat(Arrays.stream(handler.getMandatoryParams()), Arrays.stream(handler.getOptionalParams())).distinct().map(param -> Json.createObjectBuilder().add("name", (String)param).add("in", "query").add("required", Arrays.asList(handler.getMandatoryParams()).contains(param)).add("schema", Json.createObjectBuilder().add("type", "string"))).forEach(parameters::add);
        return Json.createObjectBuilder().add("get", Json.createObjectBuilder().add("description", this.getDescription(handler)).add("operationId", handler.getCommand()).add("parameters", parameters).add("responses", Json.createObjectBuilder().add("200", Json.createObjectBuilder().add("description", "successful operation"))));
    }

    private String getDescription(RequestHandler handler) {
        return Utils.firstNonNull(handler.getUsage(), "") + "\n\n* " + String.join((CharSequence)"\n* ", handler.getUsageExamples());
    }

    @Override
    public String getUsage() {
        return "JOSM RemoteControl as OpenAPI Specification";
    }

    @Override
    public String[] getUsageExamples() {
        return new String[]{"https://petstore.swagger.io/?url=http://localhost:8111/openapi.json", "https://swagger.io/specification/"};
    }

    @Override
    public String getPermissionMessage() {
        return I18n.tr("Remote Control has been asked to report its supported features. This enables web sites to guess a running JOSM version", new Object[0]);
    }

    @Override
    public PermissionPrefWithDefault getPermissionPref() {
        return PermissionPrefWithDefault.READ_PROTOCOL_VERSION;
    }

    @Override
    public String[] getMandatoryParams() {
        return new String[0];
    }

    @Override
    protected void validateRequest() {
    }
}

