/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.Data;
import org.openstreetmap.josm.data.DataSource;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxImageEntry;
import org.openstreetmap.josm.data.osm.QuadBuckets;
import org.openstreetmap.josm.gui.layer.geoimage.ImageEntry;
import org.openstreetmap.josm.tools.ListenerList;

public class ImageData
implements Data {
    private final List<ImageEntry> data;
    private final List<Integer> selectedImagesIndex = new ArrayList<Integer>();
    private final ListenerList<ImageDataUpdateListener> listeners = ListenerList.create();
    private final QuadBuckets<ImageEntry> geoImages = new QuadBuckets();

    public ImageData() {
        this(null);
    }

    public ImageData(List<ImageEntry> data) {
        if (data != null) {
            Collections.sort(data);
            this.data = data;
            this.data.forEach(image -> image.setDataSet(this));
        } else {
            this.data = new ArrayList<ImageEntry>();
        }
        this.geoImages.addAll((Collection<ImageEntry>)this.data);
        this.selectedImagesIndex.add(-1);
    }

    public List<ImageEntry> getImages() {
        return this.data;
    }

    public boolean isModified() {
        return this.data.stream().anyMatch(GpxImageEntry::hasNewGpsData);
    }

    public void mergeFrom(ImageData otherData) {
        this.data.addAll(otherData.getImages());
        this.geoImages.addAll((Collection<ImageEntry>)otherData.getImages());
        Collections.sort(this.data);
        ImageEntry selected = otherData.getSelectedImage();
        if (this.data.size() > 1) {
            ImageEntry prev = this.data.get(this.data.size() - 1);
            for (int i = this.data.size() - 2; i >= 0; --i) {
                ImageEntry cur = this.data.get(i);
                if (cur.getFile().equals(prev.getFile())) {
                    this.data.remove(i);
                    continue;
                }
                prev = cur;
            }
        }
        if (selected != null) {
            this.setSelectedImageIndex(this.data.indexOf(selected));
        }
    }

    public ImageEntry getSelectedImage() {
        int selectedImageIndex;
        int n = selectedImageIndex = this.selectedImagesIndex.isEmpty() ? -1 : this.selectedImagesIndex.get(0);
        if (selectedImageIndex > -1) {
            return this.data.get(selectedImageIndex);
        }
        return null;
    }

    public List<ImageEntry> getSelectedImages() {
        return this.selectedImagesIndex.stream().filter(i -> i > -1 && i < this.data.size()).map(this.data::get).collect(Collectors.toList());
    }

    public void selectFirstImage() {
        if (!this.data.isEmpty()) {
            this.setSelectedImageIndex(0);
        }
    }

    public void selectLastImage() {
        this.setSelectedImageIndex(this.data.size() - 1);
    }

    public boolean hasNextImage() {
        return this.selectedImagesIndex.size() == 1 && this.selectedImagesIndex.get(0) != this.data.size() - 1;
    }

    public Collection<ImageEntry> searchImages(Bounds bounds) {
        return this.geoImages.search(bounds.toBBox());
    }

    public void selectNextImage() {
        if (this.hasNextImage()) {
            this.setSelectedImageIndex(this.selectedImagesIndex.get(0) + 1);
        }
    }

    public boolean hasPreviousImage() {
        return this.selectedImagesIndex.size() == 1 && this.selectedImagesIndex.get(0) - 1 > -1;
    }

    public void selectPreviousImage() {
        if (this.data.isEmpty()) {
            return;
        }
        this.setSelectedImageIndex(Integer.max(0, this.selectedImagesIndex.get(0) - 1));
    }

    public void setSelectedImage(ImageEntry image) {
        this.setSelectedImageIndex(this.data.indexOf(image));
    }

    public void addImageToSelection(ImageEntry image) {
        int index = this.data.indexOf(image);
        if (this.selectedImagesIndex.get(0) == -1) {
            this.setSelectedImage(image);
        } else if (!this.selectedImagesIndex.contains(index)) {
            this.selectedImagesIndex.add(index);
            this.listeners.fireEvent(l -> l.selectedImageChanged(this));
        }
    }

    public void fireNodeMoved(ImageEntry gpxImageEntry) {
        this.geoImages.remove(gpxImageEntry);
        this.geoImages.add(gpxImageEntry);
    }

    public void removeImageToSelection(ImageEntry image) {
        int index = this.data.indexOf(image);
        this.selectedImagesIndex.remove(this.selectedImagesIndex.indexOf(index));
        if (this.selectedImagesIndex.isEmpty()) {
            this.selectedImagesIndex.add(-1);
        }
        this.listeners.fireEvent(l -> l.selectedImageChanged(this));
    }

    public void clearSelectedImage() {
        this.setSelectedImageIndex(-1);
    }

    private void setSelectedImageIndex(int index) {
        this.setSelectedImageIndex(index, false);
    }

    private void setSelectedImageIndex(int index, boolean forceTrigger) {
        if (this.selectedImagesIndex.size() > 1) {
            this.selectedImagesIndex.clear();
            this.selectedImagesIndex.add(-1);
        }
        if (index == this.selectedImagesIndex.get(0) && !forceTrigger) {
            return;
        }
        this.selectedImagesIndex.set(0, index);
        this.listeners.fireEvent(l -> l.selectedImageChanged(this));
    }

    public void removeSelectedImages() {
        this.removeImages(this.getSelectedImages());
    }

    private void removeImages(List<ImageEntry> selectedImages) {
        if (selectedImages.isEmpty()) {
            return;
        }
        for (ImageEntry img : this.getSelectedImages()) {
            this.removeImage(img, false);
        }
        this.updateSelectedImage();
    }

    public void updateSelectedImage() {
        int size = this.data.size();
        Integer firstSelectedImageIndex = this.selectedImagesIndex.get(0);
        if (firstSelectedImageIndex >= size) {
            this.setSelectedImageIndex(size - 1);
        } else {
            this.setSelectedImageIndex(firstSelectedImageIndex, true);
        }
    }

    public boolean isImageSelected(ImageEntry image) {
        return this.selectedImagesIndex.contains(this.data.indexOf(image));
    }

    public void removeImage(ImageEntry img) {
        this.removeImage(img, true);
    }

    public void removeImage(ImageEntry img, boolean fireUpdateEvent) {
        this.data.remove(img);
        this.geoImages.remove(img);
        if (fireUpdateEvent) {
            this.notifyImageUpdate();
        }
    }

    public void updateImagePosition(ImageEntry img, LatLon newPos) {
        img.setPos(newPos);
        this.geoImages.remove(img);
        this.geoImages.add(img);
        this.afterImageUpdated(img);
    }

    public void updateImageDirection(ImageEntry img, double direction) {
        img.setExifImgDir(direction);
        this.afterImageUpdated(img);
    }

    public void notifyImageUpdate() {
        this.listeners.fireEvent(l -> l.imageDataUpdated(this));
    }

    private void afterImageUpdated(ImageEntry img) {
        img.flagNewGpsData();
        this.notifyImageUpdate();
    }

    public void addImageDataUpdateListener(ImageDataUpdateListener listener) {
        this.listeners.addListener(listener);
    }

    public void removeImageDataUpdateListener(ImageDataUpdateListener listener) {
        this.listeners.removeListener(listener);
    }

    @Override
    public Collection<DataSource> getDataSources() {
        return Collections.emptyList();
    }

    public static interface ImageDataUpdateListener {
        public void imageDataUpdated(ImageData var1);

        public void selectedImageChanged(ImageData var1);
    }
}

