/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.LayerPositionStrategy;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.bugreport.BugReport;

public class LayerManager {
    private volatile List<Layer> layers = Collections.emptyList();
    private final List<LayerChangeListener> layerChangeListeners = new CopyOnWriteArrayList<LayerChangeListener>();

    public void addLayer(Layer layer) {
        this.addLayer(layer, true);
    }

    public void addLayer(Layer layer, boolean initialZoom) {
        GuiHelper.runInEDTAndWaitWithException(() -> this.realAddLayer(layer, initialZoom));
    }

    protected synchronized void realAddLayer(Layer layer, boolean initialZoom) {
        if (this.containsLayer(layer)) {
            throw new IllegalArgumentException("Cannot add a layer twice: " + layer);
        }
        LayerPositionStrategy positionStrategy = layer.getDefaultLayerPosition();
        int position = positionStrategy.getPosition(this);
        this.checkPosition(position);
        this.insertLayerAt(layer, position);
        this.fireLayerAdded(layer, initialZoom);
        if (MainApplication.getMap() != null) {
            layer.hookUpMapView();
        }
    }

    public void removeLayer(Layer layer) {
        GuiHelper.runInEDTAndWaitWithException(() -> this.realRemoveLayer(layer));
    }

    protected synchronized void realRemoveLayer(Layer layer) {
        GuiHelper.assertCallFromEdt();
        Set toRemove = Collections.newSetFromMap(new IdentityHashMap());
        toRemove.add(layer);
        while (!toRemove.isEmpty()) {
            Iterator iterator = toRemove.iterator();
            Layer layerToRemove = (Layer)iterator.next();
            iterator.remove();
            this.checkContainsLayer(layerToRemove);
            Collection<Layer> newToRemove = this.realRemoveSingleLayer(layerToRemove);
            toRemove.addAll(newToRemove);
        }
    }

    protected Collection<Layer> realRemoveSingleLayer(Layer layerToRemove) {
        this.updateLayers(mutableLayers -> mutableLayers.remove(layerToRemove));
        return this.fireLayerRemoving(layerToRemove);
    }

    public void moveLayer(Layer layer, int position) {
        GuiHelper.runInEDTAndWaitWithException(() -> this.realMoveLayer(layer, position));
    }

    protected synchronized void realMoveLayer(Layer layer, int position) {
        this.checkContainsLayer(layer);
        this.checkPosition(position);
        int curLayerPos = this.getLayers().indexOf(layer);
        if (position == curLayerPos) {
            return;
        }
        this.updateLayers(mutableLayers -> {
            mutableLayers.remove(curLayerPos);
            LayerManager.insertLayerAt(mutableLayers, layer, position);
        });
        this.fireLayerOrderChanged();
    }

    private void insertLayerAt(Layer layer, int position) {
        this.updateLayers(mutableLayers -> LayerManager.insertLayerAt(mutableLayers, layer, position));
    }

    private static void insertLayerAt(List<Layer> layers, Layer layer, int position) {
        if (position == layers.size()) {
            layers.add(layer);
        } else {
            layers.add(position, layer);
        }
    }

    private void checkPosition(int position) {
        if (position < 0 || position > this.getLayers().size()) {
            throw new IndexOutOfBoundsException("Position " + position + " out of range.");
        }
    }

    private void updateLayers(Consumer<List<Layer>> mutator) {
        GuiHelper.assertCallFromEdt();
        ArrayList<Layer> newLayers = new ArrayList<Layer>(this.getLayers());
        mutator.accept(newLayers);
        this.layers = Collections.unmodifiableList(newLayers);
    }

    public List<Layer> getLayers() {
        return this.layers;
    }

    public <T extends Layer> List<T> getLayersOfType(Class<T> ofType) {
        return new ArrayList(Utils.filteredCollection(this.getLayers(), ofType));
    }

    public boolean containsLayer(Layer layer) {
        return this.getLayers().contains(layer);
    }

    protected void checkContainsLayer(Layer layer) {
        if (!this.containsLayer(layer)) {
            throw new IllegalArgumentException(layer + " is not managed by us.");
        }
    }

    public synchronized void addLayerChangeListener(LayerChangeListener listener) {
        if (this.layerChangeListeners.contains(listener)) {
            throw new IllegalArgumentException("Listener already registered.");
        }
        this.layerChangeListeners.add(listener);
    }

    public synchronized void addAndFireLayerChangeListener(LayerChangeListener listener) {
        this.addLayerChangeListener(listener);
        for (Layer l : this.getLayers()) {
            listener.layerAdded(new LayerAddEvent(this, l, true));
        }
    }

    public synchronized void removeLayerChangeListener(LayerChangeListener listener) {
        if (!this.layerChangeListeners.remove(listener)) {
            throw new IllegalArgumentException("Listener was not registered before: " + listener);
        }
    }

    public synchronized void removeAndFireLayerChangeListener(LayerChangeListener listener) {
        this.removeLayerChangeListener(listener);
        for (Layer l : this.getLayers()) {
            listener.layerRemoving(new LayerRemoveEvent(this, l));
        }
    }

    private void fireLayerAdded(Layer layer, boolean initialZoom) {
        GuiHelper.assertCallFromEdt();
        LayerAddEvent e = new LayerAddEvent(this, layer, initialZoom);
        for (LayerChangeListener l : this.layerChangeListeners) {
            try {
                l.layerAdded(e);
            }
            catch (IllegalArgumentException | IllegalStateException | JosmRuntimeException t) {
                throw BugReport.intercept(t).put("listener", l).put("event", e);
            }
        }
    }

    private Collection<Layer> fireLayerRemoving(Layer layer) {
        GuiHelper.assertCallFromEdt();
        LayerRemoveEvent e = new LayerRemoveEvent(this, layer);
        for (LayerChangeListener l : this.layerChangeListeners) {
            try {
                l.layerRemoving(e);
            }
            catch (IllegalArgumentException | IllegalStateException | JosmRuntimeException t) {
                throw BugReport.intercept(t).put("listener", l).put("event", e).put("layer", layer);
            }
        }
        if (layer instanceof OsmDataLayer) {
            ((OsmDataLayer)layer).clear();
        }
        return e.scheduleForRemoval;
    }

    private void fireLayerOrderChanged() {
        GuiHelper.assertCallFromEdt();
        LayerOrderChangeEvent e = new LayerOrderChangeEvent(this);
        for (LayerChangeListener l : this.layerChangeListeners) {
            try {
                l.layerOrderChanged(e);
            }
            catch (IllegalArgumentException | IllegalStateException | JosmRuntimeException t) {
                throw BugReport.intercept(t).put("listener", l).put("event", e);
            }
        }
    }

    public void resetState() {
        GuiHelper.runInEDTAndWaitWithException(this::realResetState);
    }

    protected synchronized void realResetState() {
        while (!this.getLayers().isEmpty()) {
            this.removeLayer(this.getLayers().get(0));
        }
        this.layerChangeListeners.clear();
    }

    public static interface LayerChangeListener {
        public void layerAdded(LayerAddEvent var1);

        public void layerRemoving(LayerRemoveEvent var1);

        public void layerOrderChanged(LayerOrderChangeEvent var1);
    }

    public static class LayerAddEvent
    extends LayerManagerEvent {
        private final Layer addedLayer;
        private final boolean requiresZoom;

        LayerAddEvent(LayerManager source, Layer addedLayer, boolean requiresZoom) {
            super(source);
            this.addedLayer = addedLayer;
            this.requiresZoom = requiresZoom;
        }

        public Layer getAddedLayer() {
            return this.addedLayer;
        }

        public final boolean isZoomRequired() {
            return this.requiresZoom;
        }

        public String toString() {
            return "LayerAddEvent [addedLayer=" + this.addedLayer + ']';
        }
    }

    public static class LayerRemoveEvent
    extends LayerManagerEvent {
        private final Layer removedLayer;
        private final boolean lastLayer;
        private final Collection<Layer> scheduleForRemoval = new ArrayList<Layer>();

        LayerRemoveEvent(LayerManager source, Layer removedLayer) {
            super(source);
            this.removedLayer = removedLayer;
            this.lastLayer = source.getLayers().size() == 1;
        }

        public Layer getRemovedLayer() {
            return this.removedLayer;
        }

        public boolean isLastLayer() {
            return this.lastLayer;
        }

        public void scheduleRemoval(Collection<? extends Layer> layers) {
            for (Layer layer : layers) {
                this.getSource().checkContainsLayer(layer);
            }
            this.scheduleForRemoval.addAll(layers);
        }

        public String toString() {
            return "LayerRemoveEvent [removedLayer=" + this.removedLayer + ", lastLayer=" + this.lastLayer + ']';
        }
    }

    public static class LayerOrderChangeEvent
    extends LayerManagerEvent {
        LayerOrderChangeEvent(LayerManager source) {
            super(source);
        }

        public String toString() {
            return "LayerOrderChangeEvent []";
        }
    }

    protected static class LayerManagerEvent {
        private final LayerManager source;

        LayerManagerEvent(LayerManager source) {
            this.source = source;
        }

        public LayerManager getSource() {
            return this.source;
        }
    }
}

