/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.ac;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import javax.swing.text.StyleConstants;
import org.openstreetmap.josm.tools.I18n;

public class MaxLengthDocumentFilter
extends DocumentFilter {
    private int maxLength = -1;
    private static final String DIFFERENT = I18n.tr("<different>", new Object[0]);

    public void setMaxLength(int length) {
        this.maxLength = length;
    }

    @Override
    public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
        if (this.mustInsertOrReplace(fb, 0, string, attr)) {
            super.insertString(fb, offset, string, attr);
        }
    }

    @Override
    public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String string, AttributeSet attr) throws BadLocationException {
        if (this.mustInsertOrReplace(fb, length, string, attr)) {
            super.replace(fb, offset, length, string, attr);
        }
    }

    private boolean mustInsertOrReplace(DocumentFilter.FilterBypass fb, int length, String string, AttributeSet attr) {
        int newLen = fb.getDocument().getLength() - length + (string == null ? 0 : string.length());
        return this.maxLength == -1 || newLen <= this.maxLength || DIFFERENT.equals(string) || attr != null && attr.isDefined(StyleConstants.ComposedTextAttribute);
    }
}

