/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Collectors;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.coor.conversion.CoordinateFormatManager;
import org.openstreetmap.josm.data.coor.conversion.ICoordinateFormat;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.datatransfer.ClipboardUtils;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class CopyCoordinatesAction
extends JosmAction {
    public CopyCoordinatesAction() {
        super(I18n.tr("Copy Coordinates", new Object[0]), "copy", I18n.tr("Copy coordinates of selected nodes to clipboard.", new Object[0]), Shortcut.registerShortcut("copy:coordinates", I18n.tr("Edit: {0}", I18n.tr("Copy Coordinates", new Object[0])), 67, 5009), false);
        this.setToolbarId("copy/coordinates");
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        ICoordinateFormat coordinateFormat = CoordinateFormatManager.getDefaultFormat();
        String string = this.getSelectedNodes().stream().map(Node::getCoor).filter(Objects::nonNull).map(c -> coordinateFormat.toString((ILatLon)c, ", ")).collect(Collectors.joining("\n"));
        ClipboardUtils.copyString(string);
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(!this.getSelectedNodes().isEmpty());
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.updateEnabledState();
    }

    private Collection<Node> getSelectedNodes() {
        DataSet ds = this.getLayerManager().getActiveDataSet();
        if (ds == null) {
            return Collections.emptyList();
        }
        return ds.getSelectedNodes();
    }
}

