/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import org.openstreetmap.josm.actions.RestartAction;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.PreferencesUtils;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.download.DownloadSelection;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.gui.widgets.JosmTextArea;
import org.openstreetmap.josm.io.NetworkManager;
import org.openstreetmap.josm.io.OfflineAccessException;
import org.openstreetmap.josm.plugins.DynamicURLClassLoader;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginClassLoader;
import org.openstreetmap.josm.plugins.PluginDownloadTask;
import org.openstreetmap.josm.plugins.PluginException;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.PluginPreferenceFactory;
import org.openstreetmap.josm.plugins.PluginProxy;
import org.openstreetmap.josm.plugins.ReadLocalPluginInformationTask;
import org.openstreetmap.josm.plugins.ReadRemotePluginInformationTask;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.Destroyable;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.ResourceProvider;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;
import org.openstreetmap.josm.tools.Utils;

public final class PluginHandler {
    static final List<DeprecatedPlugin> DEPRECATED_PLUGINS;
    static final List<String> UNMAINTAINED_PLUGINS;
    public static final int DEFAULT_TIME_BASED_UPDATE_INTERVAL = 30;
    static final Collection<PluginProxy> pluginList;
    static final Collection<PluginInformation> pluginListNotLoaded;
    static final Map<String, Throwable> pluginLoadingExceptions;
    private static DynamicURLClassLoader joinedPluginResourceCL;
    private static final List<ClassLoader> sources;
    private static final Map<String, PluginClassLoader> classLoaders;
    private static PluginDownloadTask pluginDownloadTask;

    private PluginHandler() {
    }

    public static List<PluginInformation> getPlugins() {
        return pluginList.stream().map(Plugin::getPluginInformation).sorted(Comparator.comparing(PluginInformation::getName)).collect(Collectors.toList());
    }

    public static Collection<ClassLoader> getResourceClassLoaders() {
        return Collections.unmodifiableCollection(sources);
    }

    public static Collection<PluginClassLoader> getPluginClassLoaders() {
        return Collections.unmodifiableCollection(classLoaders.values());
    }

    static void filterDeprecatedPlugins(Component parent, Collection<String> plugins) {
        TreeSet<DeprecatedPlugin> removedPlugins = new TreeSet<DeprecatedPlugin>();
        for (DeprecatedPlugin depr : DEPRECATED_PLUGINS) {
            if (!plugins.contains(depr.name)) continue;
            plugins.remove(depr.name);
            PreferencesUtils.removeFromList(Config.getPref(), "plugins", depr.name);
            removedPlugins.add(depr);
        }
        if (removedPlugins.isEmpty()) {
            return;
        }
        JOptionPane.showMessageDialog(parent, PluginHandler.getRemovedPluginsMessage(removedPlugins), I18n.tr("Warning", new Object[0]), 2);
    }

    static String getRemovedPluginsMessage(Collection<DeprecatedPlugin> removedPlugins) {
        StringBuilder sb = new StringBuilder(32);
        sb.append("<html>").append(I18n.trn("The following plugin is no longer necessary and has been deactivated:", "The following plugins are no longer necessary and have been deactivated:", removedPlugins.size(), new Object[0])).append("<ul>");
        for (DeprecatedPlugin depr : removedPlugins) {
            sb.append("<li>").append(depr.name);
            if (depr.reason != null) {
                sb.append(" (").append(depr.reason).append(')');
            }
            sb.append("</li>");
        }
        sb.append("</ul></html>");
        return sb.toString();
    }

    static void filterUnmaintainedPlugins(Component parent, Collection<String> plugins) {
        for (String unmaintained : UNMAINTAINED_PLUGINS) {
            if (!plugins.contains(unmaintained) || !PluginHandler.confirmDisablePlugin(parent, PluginHandler.getUnmaintainedPluginMessage(unmaintained), unmaintained)) continue;
            PreferencesUtils.removeFromList(Config.getPref(), "plugins", unmaintained);
            plugins.remove(unmaintained);
        }
    }

    static String getUnmaintainedPluginMessage(String unmaintained) {
        return I18n.tr("<html>Loading of the plugin \"{0}\" was requested.<br>This plugin is no longer developed and very likely will produce errors.<br>It should be disabled.<br>Delete from preferences?</html>", Utils.escapeReservedCharactersHTML(unmaintained));
    }

    public static boolean checkAndConfirmPluginUpdate(Component parent) {
        String policy;
        if (Preferences.main().getPluginSites().stream().anyMatch(NetworkManager::isOffline)) {
            Logging.info(OfflineAccessException.forResource(I18n.tr("Plugin update", new Object[0])).getMessage());
            return false;
        }
        String message = null;
        String togglePreferenceKey = null;
        int v = Version.getInstance().getVersion();
        if (Config.getPref().getInt("pluginmanager.version", 0) < v) {
            message = "<html>" + I18n.tr("You updated your JOSM software.<br>To prevent problems the plugins should be updated as well.<br><br>Update plugins now?", new Object[0]) + "</html>";
            togglePreferenceKey = "pluginmanager.version-based-update.policy";
        } else {
            long tim = System.currentTimeMillis();
            long last = Config.getPref().getLong("pluginmanager.lastupdate", 0L);
            Integer maxTime = Config.getPref().getInt("pluginmanager.time-based-update.interval", 30);
            long d = TimeUnit.MILLISECONDS.toDays(tim - last);
            if (last <= 0L || maxTime <= 0) {
                Config.getPref().put("pluginmanager.lastupdate", Long.toString(tim));
            } else if (d > (long)maxTime.intValue()) {
                message = "<html>" + I18n.tr("Last plugin update more than {0} days ago.", d) + "</html>";
                togglePreferenceKey = "pluginmanager.time-based-update.policy";
            }
        }
        if (message == null) {
            return false;
        }
        UpdatePluginsMessagePanel pnlMessage = new UpdatePluginsMessagePanel();
        pnlMessage.setMessage(message);
        pnlMessage.initDontShowAgain(togglePreferenceKey);
        switch (policy = Config.getPref().get(togglePreferenceKey, "ask").trim().toLowerCase(Locale.ENGLISH)) {
            case "never": {
                if ("pluginmanager.version-based-update.policy".equals(togglePreferenceKey)) {
                    Logging.info(I18n.tr("Skipping plugin update after JOSM upgrade. Automatic update at startup is disabled.", new Object[0]));
                } else if ("pluginmanager.time-based-update.policy".equals(togglePreferenceKey)) {
                    Logging.info(I18n.tr("Skipping plugin update after elapsed update interval. Automatic update at startup is disabled.", new Object[0]));
                }
                return false;
            }
            case "always": {
                if ("pluginmanager.version-based-update.policy".equals(togglePreferenceKey)) {
                    Logging.info(I18n.tr("Running plugin update after JOSM upgrade. Automatic update at startup is enabled.", new Object[0]));
                } else if ("pluginmanager.time-based-update.policy".equals(togglePreferenceKey)) {
                    Logging.info(I18n.tr("Running plugin update after elapsed update interval. Automatic update at startup is disabled.", new Object[0]));
                }
                return true;
            }
            case "ask": {
                break;
            }
            default: {
                Logging.warn(I18n.tr("Unexpected value ''{0}'' for preference ''{1}''. Assuming value ''ask''.", policy, togglePreferenceKey));
            }
        }
        HelpAwareOptionPane.ButtonSpec[] options = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Update plugins", new Object[0]), new ImageProvider("dialogs", "refresh"), I18n.tr("Click to update the activated plugins", new Object[0]), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Skip update", new Object[0]), new ImageProvider("cancel"), I18n.tr("Click to skip updating the activated plugins", new Object[0]), null)};
        int ret = HelpAwareOptionPane.showOptionDialog(parent, pnlMessage, I18n.tr("Update plugins", new Object[0]), 2, null, options, options[0], HelpUtil.ht("/Preferences/Plugins#AutomaticUpdate"));
        if (pnlMessage.isRememberDecision()) {
            switch (ret) {
                case 0: {
                    Config.getPref().put(togglePreferenceKey, "always");
                    break;
                }
                case -1: 
                case 1: {
                    Config.getPref().put(togglePreferenceKey, "never");
                    break;
                }
            }
        } else {
            Config.getPref().put(togglePreferenceKey, "ask");
        }
        return ret == 0;
    }

    private static void alertMissingRequiredPlugin(Component parent, String plugin, Set<String> missingRequiredPlugin) {
        StringBuilder sb = new StringBuilder(48);
        sb.append("<html>").append(I18n.trn("Plugin {0} requires a plugin which was not found. The missing plugin is:", "Plugin {0} requires {1} plugins which were not found. The missing plugins are:", missingRequiredPlugin.size(), Utils.escapeReservedCharactersHTML(plugin), missingRequiredPlugin.size())).append(Utils.joinAsHtmlUnorderedList(missingRequiredPlugin)).append("</html>");
        HelpAwareOptionPane.ButtonSpec[] specs = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Download and restart", new Object[0]), new ImageProvider("restart"), I18n.trn("Click to download missing plugin and restart JOSM", "Click to download missing plugins and restart JOSM", missingRequiredPlugin.size(), new Object[0]), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Continue", new Object[0]), new ImageProvider("ok"), I18n.trn("Click to continue without this plugin", "Click to continue without these plugins", missingRequiredPlugin.size(), new Object[0]), null)};
        if (0 == HelpAwareOptionPane.showOptionDialog(parent, sb.toString(), I18n.tr("Error", new Object[0]), 0, null, specs, specs[0], HelpUtil.ht("/Plugin/Loading#MissingRequiredPlugin"))) {
            PluginHandler.downloadRequiredPluginsAndRestart(parent, missingRequiredPlugin);
        }
    }

    private static void downloadRequiredPluginsAndRestart(Component parent, Set<String> missingRequiredPlugin) {
        ReadRemotePluginInformationTask pluginInfoDownloadTask = new ReadRemotePluginInformationTask(Preferences.main().getOnlinePluginSites());
        MainApplication.worker.submit(pluginInfoDownloadTask);
        MainApplication.worker.submit(() -> {
            HashSet<PluginInformation> toDownload = new HashSet<PluginInformation>(pluginInfoDownloadTask.getAvailablePlugins());
            toDownload.removeIf(info -> !missingRequiredPlugin.contains(info.getName()));
            if (!toDownload.isEmpty()) {
                PluginDownloadTask task = new PluginDownloadTask(parent, toDownload, I18n.tr("Download plugins", new Object[0]));
                MainApplication.worker.submit(task);
                MainApplication.worker.submit(() -> {
                    if (!task.getDownloadedPlugins().isEmpty()) {
                        HashSet<String> plugins = new HashSet<String>(Config.getPref().getList("plugins"));
                        for (PluginInformation plugin : task.getDownloadedPlugins()) {
                            plugins.add(plugin.name);
                        }
                        Config.getPref().putList("plugins", new ArrayList<String>(plugins));
                        RestartAction.restartJOSM();
                    } else {
                        Logging.warn("No plugin downloaded, restart canceled");
                    }
                });
            } else {
                Logging.warn("No plugin to download, operation canceled");
            }
        });
    }

    private static void logWrongPlatform(String plugin, String pluginPlatform) {
        Logging.warn(I18n.tr("Plugin {0} must be run on a {1} platform.", plugin, pluginPlatform));
    }

    private static void logJavaUpdateRequired(String plugin, int requiredVersion) {
        Logging.warn(I18n.tr("Plugin {0} requires Java version {1}. The current Java version is {2}. You have to update Java in order to use this plugin.", plugin, Integer.toString(requiredVersion), Utils.getJavaVersion()));
    }

    private static void alertJOSMUpdateRequired(Component parent, String plugin, int requiredVersion) {
        HelpAwareOptionPane.showOptionDialog(parent, I18n.tr("<html>Plugin {0} requires JOSM version {1}. The current JOSM version is {2}.<br>You have to update JOSM in order to use this plugin.</html>", plugin, Integer.toString(requiredVersion), Version.getInstance().getVersionString()), I18n.tr("Warning", new Object[0]), 2, HelpUtil.ht("/Plugin/Loading#JOSMUpdateRequired"));
    }

    public static boolean checkLoadPreconditions(Component parent, Collection<PluginInformation> plugins, PluginInformation plugin) {
        if (!plugin.isForCurrentPlatform()) {
            PluginHandler.logWrongPlatform(plugin.name, plugin.platform);
            return false;
        }
        if (plugin.localminjavaversion > Utils.getJavaVersion()) {
            PluginHandler.logJavaUpdateRequired(plugin.name, plugin.localminjavaversion);
            return false;
        }
        int josmVersion = Version.getInstance().getVersion();
        if (plugin.localmainversion > josmVersion && josmVersion != 0) {
            PluginHandler.alertJOSMUpdateRequired(parent, plugin.name, plugin.localmainversion);
            return false;
        }
        HashSet<PluginInformation> allPlugins = new HashSet<PluginInformation>(plugins);
        for (PluginProxy proxy : pluginList) {
            allPlugins.add(proxy.getPluginInformation());
        }
        allPlugins.addAll(pluginListNotLoaded);
        return PluginHandler.checkRequiredPluginsPreconditions(parent, allPlugins, plugin, true);
    }

    public static boolean checkRequiredPluginsPreconditions(Component parent, Collection<PluginInformation> plugins, PluginInformation plugin, boolean local) {
        String requires;
        String string = requires = local ? plugin.localrequires : plugin.requires;
        if (requires != null) {
            HashSet<String> pluginNames = new HashSet<String>();
            for (PluginInformation pi : plugins) {
                pluginNames.add(pi.name);
                if (pi.provides == null) continue;
                pluginNames.add(pi.provides);
            }
            HashSet<String> missingPlugins = new HashSet<String>();
            List<String> requiredPlugins = local ? plugin.getLocalRequiredPlugins() : plugin.getRequiredPlugins();
            for (String requiredPlugin : requiredPlugins) {
                if (pluginNames.contains(requiredPlugin)) continue;
                missingPlugins.add(requiredPlugin);
            }
            if (!missingPlugins.isEmpty()) {
                if (parent != null) {
                    PluginHandler.alertMissingRequiredPlugin(parent, plugin.name, missingPlugins);
                }
                return false;
            }
        }
        return true;
    }

    private static synchronized DynamicURLClassLoader getJoinedPluginResourceCL() {
        if (joinedPluginResourceCL == null) {
            joinedPluginResourceCL = AccessController.doPrivileged(() -> new DynamicURLClassLoader(new URL[0], PluginHandler.class.getClassLoader()));
            sources.add(0, joinedPluginResourceCL);
        }
        return joinedPluginResourceCL;
    }

    private static void extendJoinedPluginResourceCL(Collection<PluginInformation> plugins) {
        File pluginDir = Preferences.main().getPluginsDirectory();
        DynamicURLClassLoader cl = PluginHandler.getJoinedPluginResourceCL();
        for (PluginInformation info : plugins) {
            if (info.libraries == null) continue;
            for (URL libUrl : info.libraries) {
                cl.addURL(libUrl);
            }
            File pluginJar = new File(pluginDir, info.name + ".jar");
            I18n.addTexts(pluginJar);
            URL pluginJarUrl = Utils.fileToURL(pluginJar);
            cl.addURL(pluginJarUrl);
        }
    }

    private static void loadPlugin(Component parent, PluginInformation plugin, PluginClassLoader pluginClassLoader) {
        String msg = I18n.tr("Could not load plugin {0}. Delete from preferences?", "'" + plugin.name + "'");
        try {
            Class<?> klass = plugin.loadClass(pluginClassLoader);
            if (klass != null) {
                Logging.info(I18n.tr("loading plugin ''{0}'' (version {1})", plugin.name, plugin.localversion));
                PluginProxy pluginProxy = plugin.load(klass, pluginClassLoader);
                pluginList.add(pluginProxy);
                MainApplication.addAndFireMapFrameListener(pluginProxy);
            }
            msg = null;
        }
        catch (PluginException e) {
            pluginLoadingExceptions.put(plugin.name, e);
            Logging.error(e);
            if (e.getCause() instanceof ClassNotFoundException) {
                msg = I18n.tr("<html>Could not load plugin {0} because the plugin<br>main class ''{1}'' was not found.<br>Delete from preferences?</html>", "'" + Utils.escapeReservedCharactersHTML(plugin.name) + "'", plugin.className);
            }
        }
        catch (RuntimeException e) {
            pluginLoadingExceptions.put(plugin.name, e);
            Logging.error(e);
        }
        if (msg != null && PluginHandler.confirmDisablePlugin(parent, msg, plugin.name)) {
            PreferencesUtils.removeFromList(Config.getPref(), "plugins", plugin.name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadPlugins(Component parent, Collection<PluginInformation> plugins, ProgressMonitor monitor) {
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        try {
            PluginClassLoader cl;
            monitor.beginTask(I18n.tr("Loading plugins ...", new Object[0]));
            monitor.subTask(I18n.tr("Checking plugin preconditions...", new Object[0]));
            LinkedList<PluginInformation> toLoad = new LinkedList<PluginInformation>();
            for (PluginInformation pi : plugins) {
                if (PluginHandler.checkLoadPreconditions(parent, plugins, pi)) {
                    toLoad.add(pi);
                    continue;
                }
                pluginListNotLoaded.add(pi);
            }
            toLoad.sort(Comparator.comparingInt(o -> o.stage));
            if (toLoad.isEmpty()) {
                return;
            }
            for (PluginInformation info : toLoad) {
                cl = AccessController.doPrivileged(() -> new PluginClassLoader(info.libraries.toArray(new URL[0]), PluginHandler.class.getClassLoader(), null));
                classLoaders.put(info.name, cl);
            }
            for (PluginInformation info : toLoad) {
                cl = classLoaders.get(info.name);
                block7: for (String depName : info.getLocalRequiredPlugins()) {
                    for (PluginInformation depInfo : toLoad) {
                        if (!PluginHandler.isDependency(depInfo, depName)) continue;
                        cl.addDependency(classLoaders.get(depInfo.name));
                        continue block7;
                    }
                    for (PluginProxy proxy : pluginList) {
                        if (!PluginHandler.isDependency(proxy.getPluginInformation(), depName)) continue;
                        cl.addDependency(proxy.getClassLoader());
                        continue block7;
                    }
                    Logging.error("unable to find dependency " + depName + " for plugin " + info.getName());
                }
            }
            PluginHandler.extendJoinedPluginResourceCL(toLoad);
            ResourceProvider.addAdditionalClassLoaders(PluginHandler.getResourceClassLoaders());
            monitor.setTicksCount(toLoad.size());
            for (PluginInformation info : toLoad) {
                monitor.setExtraText(I18n.tr("Loading plugin ''{0}''...", info.name));
                PluginHandler.loadPlugin(parent, info, classLoaders.get(info.name));
                monitor.worked(1);
            }
        }
        finally {
            monitor.finishTask();
        }
    }

    private static boolean isDependency(PluginInformation pi, String depName) {
        return depName.equals(pi.getName()) || depName.equals(pi.provides);
    }

    public static void loadVeryEarlyPlugins() {
        List<PluginInformation> veryEarlyPlugins = PluginHandler.buildListOfPluginsToLoad(null, null).stream().filter(pi -> pi.early && pi.stage < 0).collect(Collectors.toList());
        PluginHandler.loadPlugins(null, veryEarlyPlugins, null);
    }

    public static void loadEarlyPlugins(Component parent, Collection<PluginInformation> plugins, ProgressMonitor monitor) {
        List<PluginInformation> earlyPlugins = plugins.stream().filter(pi -> pi.early && pi.stage >= 0).collect(Collectors.toList());
        PluginHandler.loadPlugins(parent, earlyPlugins, monitor);
    }

    public static void loadLatePlugins(Component parent, Collection<PluginInformation> plugins, ProgressMonitor monitor) {
        List<PluginInformation> latePlugins = plugins.stream().filter(pi -> !pi.early).collect(Collectors.toList());
        PluginHandler.loadPlugins(parent, latePlugins, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static Map<String, PluginInformation> loadLocallyAvailablePluginInformation(ProgressMonitor monitor) {
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        try {
            ReadLocalPluginInformationTask task = new ReadLocalPluginInformationTask(monitor);
            Future<?> future = MainApplication.worker.submit(task);
            try {
                future.get();
            }
            catch (ExecutionException e) {
                Logging.error(e);
                Map<String, PluginInformation> map = null;
                monitor.finishTask();
                return map;
            }
            catch (InterruptedException e) {
                Logging.warn("InterruptedException in " + PluginHandler.class.getSimpleName() + " while loading locally available plugin information");
                Map<String, PluginInformation> map = null;
                monitor.finishTask();
                return map;
            }
            HashMap<String, PluginInformation> ret = new HashMap<String, PluginInformation>();
            for (PluginInformation pi : task.getAvailablePlugins()) {
                ret.put(pi.name, pi);
            }
            HashMap<String, PluginInformation> hashMap = ret;
            return hashMap;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            monitor.finishTask();
        }
    }

    private static void alertMissingPluginInformation(Component parent, Collection<String> plugins) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>").append(I18n.trn("JOSM could not find information about the following plugin:", "JOSM could not find information about the following plugins:", plugins.size(), new Object[0])).append(Utils.joinAsHtmlUnorderedList(plugins)).append(I18n.trn("The plugin is not going to be loaded.", "The plugins are not going to be loaded.", plugins.size(), new Object[0])).append("</html>");
        HelpAwareOptionPane.showOptionDialog(parent, sb.toString(), I18n.tr("Warning", new Object[0]), 2, HelpUtil.ht("/Plugin/Loading#MissingPluginInfos"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<PluginInformation> buildListOfPluginsToLoad(Component parent, ProgressMonitor monitor) {
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        try {
            monitor.beginTask(I18n.tr("Determining plugins to load...", new Object[0]));
            HashSet<String> plugins = new HashSet<String>(Config.getPref().getList("plugins", new LinkedList<String>()));
            Logging.debug("Plugins list initialized to {0}", plugins);
            String systemProp = Utils.getSystemProperty("josm.plugins");
            if (systemProp != null) {
                plugins.addAll(Arrays.asList(systemProp.split(",", -1)));
                Logging.debug("josm.plugins system property set to ''{0}''. Plugins list is now {1}", systemProp, plugins);
            }
            monitor.subTask(I18n.tr("Removing deprecated plugins...", new Object[0]));
            PluginHandler.filterDeprecatedPlugins(parent, plugins);
            monitor.subTask(I18n.tr("Removing unmaintained plugins...", new Object[0]));
            PluginHandler.filterUnmaintainedPlugins(parent, plugins);
            Logging.debug("Plugins list is finally set to {0}", plugins);
            Map<String, PluginInformation> infos = PluginHandler.loadLocallyAvailablePluginInformation(monitor.createSubTaskMonitor(1, false));
            LinkedList<PluginInformation> ret = new LinkedList<PluginInformation>();
            if (infos != null) {
                Iterator it = plugins.iterator();
                while (it.hasNext()) {
                    String plugin = (String)it.next();
                    if (!infos.containsKey(plugin)) continue;
                    ret.add(infos.get(plugin));
                    it.remove();
                }
            }
            if (!plugins.isEmpty() && parent != null) {
                PluginHandler.alertMissingPluginInformation(parent, plugins);
            }
            LinkedList<PluginInformation> linkedList = ret;
            return linkedList;
        }
        finally {
            monitor.finishTask();
        }
    }

    private static void alertFailedPluginUpdate(Component parent, Collection<PluginInformation> plugins) {
        StringBuilder sb = new StringBuilder(128);
        sb.append("<html>").append(I18n.trn("Updating the following plugin has failed:", "Updating the following plugins has failed:", plugins.size(), new Object[0])).append("<ul>");
        for (PluginInformation pi : plugins) {
            sb.append("<li>").append(Utils.escapeReservedCharactersHTML(pi.name)).append("</li>");
        }
        sb.append("</ul>").append(I18n.trn("Please open the Preference Dialog after JOSM has started and try to update it manually.", "Please open the Preference Dialog after JOSM has started and try to update them manually.", plugins.size(), new Object[0])).append("</html>");
        HelpAwareOptionPane.showOptionDialog(parent, sb.toString(), I18n.tr("Plugin update failed", new Object[0]), 0, HelpUtil.ht("/Plugin/Loading#FailedPluginUpdated"));
    }

    private static Set<PluginInformation> findRequiredPluginsToDownload(Collection<PluginInformation> pluginsToUpdate, List<PluginInformation> allPlugins, Set<PluginInformation> pluginsToDownload) {
        HashSet<PluginInformation> result = new HashSet<PluginInformation>();
        for (PluginInformation pi : pluginsToUpdate) {
            for (String name : pi.getRequiredPlugins()) {
                try {
                    PluginInformation installedPlugin = PluginInformation.findPlugin(name);
                    if (installedPlugin != null) continue;
                    PluginInformation reqPlugin = null;
                    for (PluginInformation pi2 : allPlugins) {
                        if (!pi2.getName().equals(name)) continue;
                        reqPlugin = pi2;
                        break;
                    }
                    if (reqPlugin == null || pluginsToDownload.contains(reqPlugin)) continue;
                    result.add(reqPlugin);
                }
                catch (PluginException e) {
                    Logging.warn(I18n.tr("Failed to find plugin {0}", name));
                    Logging.error(e);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Collection<PluginInformation> updatePlugins(Component parent, Collection<PluginInformation> pluginsWanted, ProgressMonitor monitor, boolean displayErrMsg) {
        Collection<PluginInformation> plugins;
        block20: {
            plugins = null;
            pluginDownloadTask = null;
            if (monitor == null) {
                monitor = NullProgressMonitor.INSTANCE;
            }
            try {
                monitor.beginTask("");
                ReadRemotePluginInformationTask task1 = new ReadRemotePluginInformationTask(monitor.createSubTaskMonitor(1, false), Preferences.main().getOnlinePluginSites(), displayErrMsg);
                List<PluginInformation> allPlugins = null;
                Future<?> future = MainApplication.worker.submit(task1);
                try {
                    future.get();
                    allPlugins = task1.getAvailablePlugins();
                    plugins = PluginHandler.buildListOfPluginsToLoad(parent, monitor.createSubTaskMonitor(1, false));
                    if (!Utils.isEmpty(pluginsWanted)) {
                        Collection<String> pluginsWantedName = Utils.transform(pluginsWanted, piw -> piw.name);
                        plugins = SubclassFilteredCollection.filter(plugins, pi -> pluginsWantedName.contains(pi.name));
                    }
                }
                catch (ExecutionException e) {
                    Logging.warn(I18n.tr("Failed to download plugin information list", new Object[0]) + ": ExecutionException");
                    Logging.error(e);
                }
                catch (InterruptedException e) {
                    Logging.warn(I18n.tr("Failed to download plugin information list", new Object[0]) + ": InterruptedException");
                }
                ArrayList<PluginInformation> pluginsToUpdate = new ArrayList<PluginInformation>();
                if (plugins != null) {
                    for (PluginInformation pi2 : plugins) {
                        if (!pi2.isUpdateRequired()) continue;
                        pluginsToUpdate.add(pi2);
                    }
                }
                if (pluginsToUpdate.isEmpty()) break block20;
                HashSet<PluginInformation> pluginsToDownload = new HashSet<PluginInformation>(pluginsToUpdate);
                if (allPlugins != null) {
                    Set<PluginInformation> additionalPlugins = PluginHandler.findRequiredPluginsToDownload(pluginsToUpdate, allPlugins, pluginsToDownload);
                    pluginsToDownload.addAll(additionalPlugins);
                    while (!additionalPlugins.isEmpty()) {
                        if (plugins != null) {
                            plugins.addAll(additionalPlugins);
                        }
                        additionalPlugins = PluginHandler.findRequiredPluginsToDownload(additionalPlugins, allPlugins, pluginsToDownload);
                        pluginsToDownload.addAll(additionalPlugins);
                    }
                }
                pluginDownloadTask = new PluginDownloadTask(monitor.createSubTaskMonitor(1, false), pluginsToDownload, I18n.tr("Update plugins", new Object[0]));
                future = MainApplication.worker.submit(pluginDownloadTask);
                try {
                    future.get();
                }
                catch (ExecutionException e) {
                    Logging.error(e);
                    PluginHandler.alertFailedPluginUpdate(parent, pluginsToUpdate);
                    Collection<PluginInformation> collection = plugins;
                    monitor.finishTask();
                    return collection;
                }
                catch (InterruptedException e) {
                    Logging.warn("InterruptedException in " + PluginHandler.class.getSimpleName() + " while updating plugins");
                    PluginHandler.alertFailedPluginUpdate(parent, pluginsToUpdate);
                    Collection<PluginInformation> collection = plugins;
                    monitor.finishTask();
                    return collection;
                }
                PluginHandler.refreshLocalUpdatedPluginInfo(pluginDownloadTask.getDownloadedPlugins());
                if (!pluginDownloadTask.getFailedPlugins().isEmpty()) {
                    PluginHandler.alertFailedPluginUpdate(parent, pluginDownloadTask.getFailedPlugins());
                    Collection<PluginInformation> collection = plugins;
                    return collection;
                }
                break block20;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                monitor.finishTask();
            }
        }
        if (pluginsWanted == null) {
            Config.getPref().putInt("pluginmanager.version", Version.getInstance().getVersion());
            Config.getPref().put("pluginmanager.lastupdate", Long.toString(System.currentTimeMillis()));
        }
        return plugins;
    }

    public static boolean confirmDisablePlugin(Component parent, String reason, String name) {
        HelpAwareOptionPane.ButtonSpec[] options = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Disable plugin", new Object[0]), new ImageProvider("dialogs", "delete"), I18n.tr("Click to delete the plugin ''{0}''", name), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Keep plugin", new Object[0]), new ImageProvider("cancel"), I18n.tr("Click to keep the plugin ''{0}''", name), null)};
        return 0 == HelpAwareOptionPane.showOptionDialog(parent, reason, I18n.tr("Disable plugin", new Object[0]), 2, null, options, options[0], null);
    }

    public static Object getPlugin(String name) {
        for (PluginProxy plugin : pluginList) {
            if (!plugin.getPluginInformation().name.equals(name)) continue;
            return plugin.getPlugin();
        }
        return null;
    }

    public static PluginClassLoader getPluginClassLoader(String name) {
        for (PluginProxy plugin : pluginList) {
            if (!plugin.getPluginInformation().name.equals(name)) continue;
            return plugin.getClassLoader();
        }
        return null;
    }

    public static void addDownloadSelection(List<DownloadSelection> downloadSelections) {
        for (PluginProxy p : pluginList) {
            p.addDownloadSelection(downloadSelections);
        }
    }

    public static Collection<PreferenceSettingFactory> getPreferenceSetting() {
        ArrayList<PreferenceSettingFactory> settings = new ArrayList<PreferenceSettingFactory>();
        for (PluginProxy plugin : pluginList) {
            settings.add(new PluginPreferenceFactory(plugin));
        }
        return settings;
    }

    public static void installDownloadedPlugins(Collection<PluginInformation> pluginsToLoad, boolean dowarn) {
        File pluginDir = Preferences.main().getPluginsDirectory();
        if (!(pluginDir.exists() && pluginDir.isDirectory() && pluginDir.canWrite())) {
            return;
        }
        File[] files = pluginDir.listFiles((dir, name) -> name.endsWith(".jar.new"));
        if (files == null) {
            return;
        }
        for (File updatedPlugin : files) {
            String filePath = updatedPlugin.getPath();
            File plugin = new File(filePath.substring(0, filePath.length() - 4));
            String pluginName = updatedPlugin.getName().substring(0, updatedPlugin.getName().length() - 8);
            try {
                new JarFile(updatedPlugin).close();
            }
            catch (IOException e) {
                if (!dowarn) continue;
                Logging.log(Logging.LEVEL_WARN, I18n.tr("Failed to install plugin ''{0}'' from temporary download file ''{1}''. {2}", plugin.toString(), updatedPlugin.toString(), e.getLocalizedMessage()), e);
                continue;
            }
            if (plugin.exists() && !plugin.delete() && dowarn) {
                Logging.warn(I18n.tr("Failed to delete outdated plugin ''{0}''.", plugin.toString()));
                Logging.warn(I18n.tr("Failed to install already downloaded plugin ''{0}''. Skipping installation. JOSM is still going to load the old plugin version.", pluginName));
                continue;
            }
            if (updatedPlugin.renameTo(plugin)) {
                try {
                    Object tUpdatedPlugin;
                    URL newPluginURL = plugin.toURI().toURL();
                    URL oldPluginURL = updatedPlugin.toURI().toURL();
                    pluginsToLoad.stream().filter(x -> x.libraries.contains(oldPluginURL)).forEach(x -> Collections.replaceAll(x.libraries, oldPluginURL, newPluginURL));
                    PluginInformation tInfo = pluginsToLoad.parallelStream().filter(x -> x.libraries.contains(newPluginURL)).findAny().orElse(null);
                    if (tInfo == null || !((tUpdatedPlugin = PluginHandler.getPlugin(tInfo.name)) instanceof Destroyable)) continue;
                    ((Destroyable)tUpdatedPlugin).destroy();
                    PluginHandler.loadPlugins(PluginHandler.getInfoPanel(), Collections.singleton(tInfo), NullProgressMonitor.INSTANCE);
                }
                catch (MalformedURLException e) {
                    Logging.warn(e);
                }
                continue;
            }
            if (!dowarn) continue;
            Logging.warn(I18n.tr("Failed to install plugin ''{0}'' from temporary download file ''{1}''. Renaming failed.", plugin.toString(), updatedPlugin.toString()));
            Logging.warn(I18n.tr("Failed to install already downloaded plugin ''{0}''. Skipping installation. JOSM is still going to load the old plugin version.", pluginName));
        }
    }

    public static boolean isValidJar(File jar) {
        if (jar != null && jar.exists() && jar.canRead()) {
            try {
                new JarFile(jar).close();
            }
            catch (IOException e) {
                Logging.warn(e);
                return false;
            }
            return true;
        }
        if (jar != null) {
            Logging.debug("Invalid jar file ''" + jar + "'' (exists: " + jar.exists() + ", canRead: " + jar.canRead() + ')');
        }
        return false;
    }

    public static File findUpdatedJar(String name) {
        File pluginDir = Preferences.main().getPluginsDirectory();
        File downloadedPluginFile = new File(pluginDir, name + ".jar.new");
        if (!PluginHandler.isValidJar(downloadedPluginFile) && !PluginHandler.isValidJar(downloadedPluginFile = new File(pluginDir, name + ".jar"))) {
            return null;
        }
        return downloadedPluginFile;
    }

    public static void refreshLocalUpdatedPluginInfo(Collection<PluginInformation> updatedPlugins) {
        if (updatedPlugins == null) {
            return;
        }
        for (PluginInformation pi : updatedPlugins) {
            File downloadedPluginFile = PluginHandler.findUpdatedJar(pi.name);
            if (downloadedPluginFile == null) continue;
            try {
                pi.updateFromJar(new PluginInformation(downloadedPluginFile, pi.name));
            }
            catch (PluginException e) {
                Logging.error(e);
            }
        }
    }

    private static int askUpdateDisableKeepPluginAfterException(PluginProxy plugin) {
        HelpAwareOptionPane.ButtonSpec[] options = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Update plugin", new Object[0]), new ImageProvider("dialogs", "refresh"), I18n.tr("Click to update the plugin ''{0}''", plugin.getPluginInformation().name), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Disable plugin", new Object[0]), new ImageProvider("dialogs", "delete"), I18n.tr("Click to disable the plugin ''{0}''", plugin.getPluginInformation().name), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Keep plugin", new Object[0]), new ImageProvider("cancel"), I18n.tr("Click to keep the plugin ''{0}''", plugin.getPluginInformation().name), null)};
        StringBuilder msg = new StringBuilder(256);
        msg.append("<html>").append(I18n.tr("An unexpected exception occurred that may have come from the ''{0}'' plugin.", Utils.escapeReservedCharactersHTML(plugin.getPluginInformation().name))).append("<br>");
        if (plugin.getPluginInformation().author != null) {
            msg.append(I18n.tr("According to the information within the plugin, the author is {0}.", Utils.escapeReservedCharactersHTML(plugin.getPluginInformation().author))).append("<br>");
        }
        msg.append(I18n.tr("Try updating to the newest version of this plugin before reporting a bug.", new Object[0])).append("</html>");
        try {
            FutureTask<Integer> task = new FutureTask<Integer>(() -> HelpAwareOptionPane.showOptionDialog(MainApplication.getMainFrame(), msg.toString(), I18n.tr("Update plugins", new Object[0]), 3, null, options, options[0], HelpUtil.ht("/ErrorMessages#ErrorInPlugin")));
            GuiHelper.runInEDT(task);
            return task.get();
        }
        catch (InterruptedException | ExecutionException e) {
            Logging.warn(e);
            return -1;
        }
    }

    private static PluginProxy getPluginCausingException(Throwable ex) {
        PluginProxy err = null;
        ArrayList<StackTraceElement> stack = new ArrayList<StackTraceElement>();
        HashSet<Throwable> seen = new HashSet<Throwable>();
        Throwable current = ex;
        while (current != null) {
            seen.add(current);
            stack.addAll(Arrays.asList(current.getStackTrace()));
            Throwable cause = current.getCause();
            if (cause != null && seen.contains(cause)) break;
            current = cause;
        }
        int pos = stack.size();
        for (PluginProxy p : pluginList) {
            String baseClass = p.getPluginInformation().className;
            baseClass = baseClass.substring(0, baseClass.lastIndexOf(46));
            for (int elpos = 0; elpos < pos; ++elpos) {
                if (!((StackTraceElement)stack.get(elpos)).getClassName().startsWith(baseClass)) continue;
                pos = elpos;
                err = p;
            }
        }
        return err;
    }

    public static PluginDownloadTask updateOrdisablePluginAfterException(Throwable e) {
        PluginProxy plugin = null;
        if (e instanceof PluginException) {
            plugin = ((PluginException)e).plugin;
        }
        if (plugin == null) {
            plugin = PluginHandler.getPluginCausingException(e);
        }
        if (plugin == null) {
            return null;
        }
        HashSet<String> plugins = new HashSet<String>(Config.getPref().getList("plugins"));
        PluginInformation pluginInfo = plugin.getPluginInformation();
        if (!plugins.contains(pluginInfo.name)) {
            return null;
        }
        switch (PluginHandler.askUpdateDisableKeepPluginAfterException(plugin)) {
            case 0: {
                PluginHandler.updatePlugins(MainApplication.getMainFrame(), Collections.singleton(pluginInfo), null, true);
                return pluginDownloadTask;
            }
            case 1: {
                plugins.remove(plugin.getPluginInformation().name);
                Config.getPref().putList("plugins", new ArrayList<String>(plugins));
                GuiHelper.runInEDTAndWait(() -> JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("The plugin has been removed from the configuration. Please restart JOSM to unload the plugin.", new Object[0]), I18n.tr("Information", new Object[0]), 1));
                return null;
            }
        }
        return null;
    }

    public static Collection<String> getBugReportInformation() {
        TreeSet<String> pl = new TreeSet<String>(Config.getPref().getList("plugins", new LinkedList<String>()));
        for (PluginProxy pp : pluginList) {
            PluginInformation pi = pp.getPluginInformation();
            pl.remove(pi.name);
            pl.add(pi.name + " (" + (!Utils.isEmpty(pi.localversion) ? pi.localversion : "unknown") + ')');
        }
        return pl;
    }

    public static JPanel getInfoPanel() {
        JPanel pluginTab = new JPanel(new GridBagLayout());
        for (PluginInformation info : PluginHandler.getPlugins()) {
            String name = info.name + (!Utils.isEmpty(info.localversion) ? " Version: " + info.localversion : "");
            pluginTab.add((Component)new JLabel(name), GBC.std());
            pluginTab.add(Box.createHorizontalGlue(), GBC.std().fill(2));
            pluginTab.add((Component)new JButton(new PluginInformationAction(info)), GBC.eol());
            JosmTextArea description = new JosmTextArea(info.description == null ? I18n.tr("no description available", new Object[0]) : info.description);
            description.setEditable(false);
            description.setFont(new JLabel().getFont().deriveFont(2));
            description.setLineWrap(true);
            description.setWrapStyleWord(true);
            description.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
            description.setBackground(UIManager.getColor("Panel.background"));
            description.setCaretPosition(0);
            pluginTab.add((Component)description, GBC.eop().fill(2));
        }
        return pluginTab;
    }

    public static Set<String> getDeprecatedAndUnmaintainedPlugins() {
        HashSet<String> result = new HashSet<String>(DEPRECATED_PLUGINS.size() + UNMAINTAINED_PLUGINS.size());
        for (DeprecatedPlugin dp : DEPRECATED_PLUGINS) {
            result.add(dp.name);
        }
        result.addAll(UNMAINTAINED_PLUGINS);
        return result;
    }

    public static boolean removePlugins(List<PluginInformation> deactivatedPlugins) {
        boolean restartNeeded;
        List<Destroyable> noRestart = deactivatedPlugins.parallelStream().map(info -> PluginHandler.getPlugin(info.name)).filter(Destroyable.class::isInstance).map(Destroyable.class::cast).collect(Collectors.toList());
        try {
            noRestart.forEach(Destroyable::destroy);
            new ArrayList<PluginProxy>(pluginList).stream().filter(proxy -> noRestart.contains(proxy.getPlugin())).forEach(pluginList::remove);
            restartNeeded = deactivatedPlugins.size() != noRestart.size();
        }
        catch (Exception e) {
            Logging.error(e);
            restartNeeded = true;
        }
        return restartNeeded;
    }

    static {
        String inCore = I18n.tr("integrated into main program", new Object[0]);
        String replacedByPlugin = I18n.marktr("replaced by new {0} plugin");
        String noLongerRequired = I18n.tr("no longer required", new Object[0]);
        DEPRECATED_PLUGINS = Arrays.asList(new DeprecatedPlugin("mappaint", inCore), new DeprecatedPlugin("unglueplugin", inCore), new DeprecatedPlugin("lang-de", inCore), new DeprecatedPlugin("lang-en_GB", inCore), new DeprecatedPlugin("lang-fr", inCore), new DeprecatedPlugin("lang-it", inCore), new DeprecatedPlugin("lang-pl", inCore), new DeprecatedPlugin("lang-ro", inCore), new DeprecatedPlugin("lang-ru", inCore), new DeprecatedPlugin("ewmsplugin", inCore), new DeprecatedPlugin("ywms", inCore), new DeprecatedPlugin("tways-0.2", inCore), new DeprecatedPlugin("geotagged", inCore), new DeprecatedPlugin("landsat", I18n.tr(replacedByPlugin, "scanaerial")), new DeprecatedPlugin("namefinder", inCore), new DeprecatedPlugin("waypoints", inCore), new DeprecatedPlugin("slippy_map_chooser", inCore), new DeprecatedPlugin("tcx-support", I18n.tr(replacedByPlugin, "dataimport")), new DeprecatedPlugin("usertools", inCore), new DeprecatedPlugin("AgPifoJ", inCore), new DeprecatedPlugin("utilsplugin", inCore), new DeprecatedPlugin("ghost", inCore), new DeprecatedPlugin("validator", inCore), new DeprecatedPlugin("multipoly", inCore), new DeprecatedPlugin("multipoly-convert", inCore), new DeprecatedPlugin("remotecontrol", inCore), new DeprecatedPlugin("imagery", inCore), new DeprecatedPlugin("slippymap", inCore), new DeprecatedPlugin("wmsplugin", inCore), new DeprecatedPlugin("ParallelWay", inCore), new DeprecatedPlugin("dumbutils", I18n.tr(replacedByPlugin, "utilsplugin2")), new DeprecatedPlugin("ImproveWayAccuracy", inCore), new DeprecatedPlugin("Curves", I18n.tr(replacedByPlugin, "utilsplugin2")), new DeprecatedPlugin("epsg31287", inCore), new DeprecatedPlugin("licensechange", noLongerRequired), new DeprecatedPlugin("restart", inCore), new DeprecatedPlugin("wayselector", inCore), new DeprecatedPlugin("openstreetbugs", inCore), new DeprecatedPlugin("nearclick", noLongerRequired), new DeprecatedPlugin("notes", inCore), new DeprecatedPlugin("mirrored_download", inCore), new DeprecatedPlugin("ImageryCache", inCore), new DeprecatedPlugin("commons-imaging", I18n.tr(replacedByPlugin, "apache-commons")), new DeprecatedPlugin("missingRoads", I18n.tr(replacedByPlugin, "ImproveOsm")), new DeprecatedPlugin("trafficFlowDirection", I18n.tr(replacedByPlugin, "ImproveOsm")), new DeprecatedPlugin("kendzi3d-jogl", I18n.tr(replacedByPlugin, "jogl")), new DeprecatedPlugin("josm-geojson", inCore), new DeprecatedPlugin("proj4j", inCore), new DeprecatedPlugin("OpenStreetView", I18n.tr(replacedByPlugin, "OpenStreetCam")), new DeprecatedPlugin("imageryadjust", inCore), new DeprecatedPlugin("walkingpapers", I18n.tr(replacedByPlugin, "fieldpapers")), new DeprecatedPlugin("czechaddress", noLongerRequired), new DeprecatedPlugin("kendzi3d_Improved_by_Andrei", noLongerRequired), new DeprecatedPlugin("videomapping", noLongerRequired), new DeprecatedPlugin("public_transport_layer", I18n.tr(replacedByPlugin, "pt_assistant")), new DeprecatedPlugin("lakewalker", I18n.tr(replacedByPlugin, "scanaerial")), new DeprecatedPlugin("download_along", inCore), new DeprecatedPlugin("plastic_laf", noLongerRequired), new DeprecatedPlugin("osmarender", noLongerRequired), new DeprecatedPlugin("geojson", inCore), new DeprecatedPlugin("gpxfilter", inCore), new DeprecatedPlugin("tag2link", inCore), new DeprecatedPlugin("rapid", I18n.tr(replacedByPlugin, "MapWithAI")), new DeprecatedPlugin("MovementAlert", inCore), new DeprecatedPlugin("OpenStreetCam", I18n.tr(replacedByPlugin, "KartaView")), new DeprecatedPlugin("scoutsigns", I18n.tr(replacedByPlugin, "KartaView")), new DeprecatedPlugin("javafx-osx", inCore), new DeprecatedPlugin("javafx-unixoid", inCore), new DeprecatedPlugin("javafx-windows", inCore), new DeprecatedPlugin("wikidata", I18n.tr(replacedByPlugin, "osmwiki-dataitem")), new DeprecatedPlugin("mapdust", noLongerRequired));
        Collections.sort(DEPRECATED_PLUGINS);
        UNMAINTAINED_PLUGINS = Collections.unmodifiableList(Arrays.asList("irsrectify", "surveyor2", "gpsbabelgui", "Intersect_way", "ContourOverlappingMerge", "LaneConnector", "Remove.redundant.points"));
        pluginList = new CopyOnWriteArrayList<PluginProxy>();
        pluginListNotLoaded = new LinkedList<PluginInformation>();
        pluginLoadingExceptions = new HashMap<String, Throwable>();
        sources = new LinkedList<ClassLoader>();
        try {
            sources.add(ClassLoader.getSystemClassLoader());
            sources.add(PluginHandler.class.getClassLoader());
        }
        catch (SecurityException ex) {
            Logging.debug(ex);
            sources.add(ImageProvider.class.getClassLoader());
        }
        classLoaders = new HashMap<String, PluginClassLoader>();
    }

    public static class DeprecatedPlugin
    implements Comparable<DeprecatedPlugin> {
        public final String name;
        public final String reason;

        public DeprecatedPlugin(String name, String reason) {
            this.name = name;
            this.reason = reason;
        }

        public int hashCode() {
            return Objects.hash(this.name, this.reason);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DeprecatedPlugin other = (DeprecatedPlugin)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.reason == null ? other.reason != null : !this.reason.equals(other.reason));
        }

        @Override
        public int compareTo(DeprecatedPlugin o) {
            int d = this.name.compareTo(o.name);
            if (d == 0) {
                d = this.reason.compareTo(o.reason);
            }
            return d;
        }
    }

    private static class UpdatePluginsMessagePanel
    extends JPanel {
        private final JMultilineLabel lblMessage = new JMultilineLabel("");
        private final JCheckBox cbDontShowAgain = new JCheckBox(I18n.tr("Do not ask again and remember my decision (go to Preferences->Plugins to change it later)", new Object[0]));

        UpdatePluginsMessagePanel() {
            this.build();
        }

        protected final void build() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.anchor = 18;
            gc.fill = 1;
            gc.weightx = 1.0;
            gc.weighty = 1.0;
            gc.insets = new Insets(5, 5, 5, 5);
            this.add((Component)this.lblMessage, gc);
            this.lblMessage.setFont(this.lblMessage.getFont().deriveFont(0));
            gc.gridy = 1;
            gc.fill = 2;
            gc.weighty = 0.0;
            this.add((Component)this.cbDontShowAgain, gc);
            this.cbDontShowAgain.setFont(this.cbDontShowAgain.getFont().deriveFont(0));
        }

        public void setMessage(String message) {
            this.lblMessage.setText(message);
        }

        @Override
        public String toString() {
            return Utils.stripHtml(this.lblMessage.getText());
        }

        public void initDontShowAgain(String preferencesKey) {
            String policy = Config.getPref().get(preferencesKey, "ask");
            this.cbDontShowAgain.setSelected(!"ask".equals(policy = policy.trim().toLowerCase(Locale.ENGLISH)));
        }

        public boolean isRememberDecision() {
            return this.cbDontShowAgain.isSelected();
        }
    }

    static final class PluginInformationAction
    extends AbstractAction {
        private final PluginInformation info;

        PluginInformationAction(PluginInformation info) {
            super(I18n.tr("Information", new Object[0]));
            this.info = info;
        }

        public String getText() {
            StringBuilder b = new StringBuilder();
            TreeMap<Object, Object> sorted = new TreeMap<Object, Object>(Comparator.comparing(String::valueOf));
            sorted.putAll(this.info.attr);
            for (Map.Entry e : sorted.entrySet()) {
                b.append(e.getKey());
                b.append(": ");
                b.append(e.getValue());
                b.append('\n');
            }
            return b.toString();
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String text = this.getText();
            JosmTextArea a = new JosmTextArea(10, 40);
            a.setEditable(false);
            a.setText(text);
            a.setCaretPosition(0);
            JOptionPane.showMessageDialog(MainApplication.getMainFrame(), new JScrollPane(a), I18n.tr("Plugin information", new Object[0]), 1);
        }
    }
}

