/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.data.osm.ChangesetDataSet;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;

public class ChangesetContentTableModel
extends AbstractTableModel {
    private final transient List<ChangesetContentEntry> data = new ArrayList<ChangesetContentEntry>();
    private final DefaultListSelectionModel selectionModel;

    public ChangesetContentTableModel(DefaultListSelectionModel selectionModel) {
        this.selectionModel = selectionModel;
    }

    public boolean hasSelectedPrimitives() {
        return this.selectionModel.getMinSelectionIndex() >= 0;
    }

    public void setSelectedByIdx(int row) {
        this.selectionModel.setSelectionInterval(row, row);
    }

    public DefaultListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public Set<HistoryOsmPrimitive> getSelectedPrimitives(JTable table) {
        int[] selection = table.getSelectedRows();
        return Arrays.stream(selection).mapToObj(i -> this.data.get(table.convertRowIndexToModel(i)).getPrimitive()).collect(Collectors.toSet());
    }

    public void populate(ChangesetDataSet ds) {
        this.data.clear();
        if (ds == null) {
            this.fireTableDataChanged();
            return;
        }
        Iterator<ChangesetDataSet.ChangesetDataSetEntry> it = ds.iterator();
        while (it.hasNext()) {
            this.data.add(new ChangesetContentEntry(it.next()));
        }
        this.sort();
        this.fireTableDataChanged();
    }

    protected void sort() {
        this.data.sort(Comparator.comparing(ChangesetContentEntry::getModificationType).thenComparingLong(c -> c.getPrimitive().getId()));
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                return this.data.get(row).getModificationType();
            }
        }
        return this.data.get(row).getPrimitive();
    }

    private static class ChangesetContentEntry
    implements ChangesetDataSet.ChangesetDataSetEntry {
        private final ChangesetDataSet.ChangesetModificationType modificationType;
        private final HistoryOsmPrimitive primitive;

        ChangesetContentEntry(ChangesetDataSet.ChangesetModificationType modificationType, HistoryOsmPrimitive primitive) {
            this.modificationType = modificationType;
            this.primitive = primitive;
        }

        ChangesetContentEntry(ChangesetDataSet.ChangesetDataSetEntry entry) {
            this(entry.getModificationType(), entry.getPrimitive());
        }

        @Override
        public ChangesetDataSet.ChangesetModificationType getModificationType() {
            return this.modificationType;
        }

        @Override
        public HistoryOsmPrimitive getPrimitive() {
            return this.primitive;
        }
    }
}

