/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.styleelement;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.Objects;
import org.openstreetmap.josm.data.osm.INode;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.data.osm.visitor.paint.StyledMapRenderer;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.Keyword;
import org.openstreetmap.josm.gui.mappaint.styleelement.StyleElement;
import org.openstreetmap.josm.gui.mappaint.styleelement.TextLabel;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class BoxTextElement
extends StyleElement {
    private static volatile Color defaultTextColorCache;
    public TextLabel text;
    public int xOffset;
    public int yOffset;
    public HorizontalTextAlignment hAlign;
    public VerticalTextAlignment vAlign;
    protected BoxProvider boxProvider;

    public BoxTextElement(Cascade c, TextLabel text, BoxProvider boxProvider, int offsetX, int offsetY, HorizontalTextAlignment hAlign, VerticalTextAlignment vAlign) {
        super(c, 5.0f);
        this.xOffset = offsetX;
        this.yOffset = offsetY;
        CheckParameterUtil.ensureParameterNotNull(text);
        CheckParameterUtil.ensureParameterNotNull((Object)hAlign);
        CheckParameterUtil.ensureParameterNotNull((Object)vAlign);
        this.text = text;
        this.boxProvider = boxProvider;
        this.hAlign = hAlign;
        this.vAlign = vAlign;
    }

    public static BoxTextElement create(Environment env, BoxProvider boxProvider) {
        VerticalTextAlignment vAlign;
        HorizontalTextAlignment hAlign;
        BoxTextElement.initDefaultParameters();
        TextLabel text = TextLabel.create(env, defaultTextColorCache, false);
        if (text == null) {
            return null;
        }
        if (text.labelCompositionStrategy.compose(env.osm) == null) {
            return null;
        }
        Cascade c = env.getCascade();
        switch (c.get((String)"text-anchor-horizontal", Keyword.RIGHT, Keyword.class).val) {
            case "left": {
                hAlign = HorizontalTextAlignment.LEFT;
                break;
            }
            case "center": {
                hAlign = HorizontalTextAlignment.CENTER;
                break;
            }
            default: {
                hAlign = HorizontalTextAlignment.RIGHT;
            }
        }
        switch (c.get((String)"text-anchor-vertical", Keyword.BOTTOM, Keyword.class).val) {
            case "above": {
                vAlign = VerticalTextAlignment.ABOVE;
                break;
            }
            case "top": {
                vAlign = VerticalTextAlignment.TOP;
                break;
            }
            case "center": {
                vAlign = VerticalTextAlignment.CENTER;
                break;
            }
            case "below": {
                vAlign = VerticalTextAlignment.BELOW;
                break;
            }
            default: {
                vAlign = VerticalTextAlignment.BOTTOM;
            }
        }
        Point2D offset = TextLabel.getTextOffset(c);
        return new BoxTextElement(c, text, boxProvider, (int)offset.getX(), (int)(-offset.getY()), hAlign, vAlign);
    }

    public Rectangle getBox() {
        return this.boxProvider.get().getBox();
    }

    private static void initDefaultParameters() {
        if (defaultTextColorCache != null) {
            return;
        }
        defaultTextColorCache = PaintColors.TEXT.get();
    }

    @Override
    public void paintPrimitive(IPrimitive osm, MapPaintSettings settings, StyledMapRenderer painter, boolean selected, boolean outermember, boolean member) {
        if (osm instanceof INode) {
            painter.drawBoxText((INode)osm, this);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        BoxTextElement that = (BoxTextElement)obj;
        return this.hAlign == that.hAlign && this.vAlign == that.vAlign && this.xOffset == that.xOffset && this.yOffset == that.yOffset && Objects.equals(this.text, that.text) && Objects.equals(this.boxProvider, that.boxProvider);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.text, this.boxProvider, this.hAlign, this.vAlign, this.xOffset, this.yOffset});
    }

    @Override
    public String toString() {
        return "BoxTextElement{" + super.toString() + ' ' + this.text.toStringImpl() + " box=" + this.getBox() + " hAlign=" + (Object)((Object)this.hAlign) + " vAlign=" + (Object)((Object)this.vAlign) + " xOffset=" + this.xOffset + " yOffset=" + this.yOffset + '}';
    }

    @FunctionalInterface
    public static interface BoxProvider {
        public BoxProviderResult get();
    }

    public static enum HorizontalTextAlignment {
        LEFT,
        CENTER,
        RIGHT;

    }

    public static enum VerticalTextAlignment {
        ABOVE,
        TOP,
        CENTER,
        BOTTOM,
        BELOW;

    }

    public static class BoxProviderResult {
        private final Rectangle box;
        private final boolean temporary;

        public BoxProviderResult(Rectangle box, boolean temporary) {
            this.box = box;
            this.temporary = temporary;
        }

        public Rectangle getBox() {
            return this.box;
        }

        public boolean isTemporary() {
            return this.temporary;
        }
    }

    public static class SimpleBoxProvider
    implements BoxProvider {
        private final Rectangle box;

        public SimpleBoxProvider(Rectangle box) {
            this.box = box;
        }

        @Override
        public BoxProviderResult get() {
            return new BoxProviderResult(this.box, false);
        }

        public int hashCode() {
            return Objects.hash(this.box);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            SimpleBoxProvider that = (SimpleBoxProvider)obj;
            return Objects.equals(this.box, that.box);
        }
    }
}

