/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.ShowStatusReportAction;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.gui.widgets.JosmTextArea;
import org.openstreetmap.josm.gui.widgets.UrlLabel;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public final class AboutAction
extends JosmAction {
    public AboutAction() {
        super(I18n.tr("About", new Object[0]), "logo", I18n.tr("Display the about screen.", new Object[0]), Shortcut.registerShortcut("system:about", I18n.tr("Help: {0}", I18n.tr("About", new Object[0])), 112, 5005), true, false);
    }

    JPanel buildAboutPanel() {
        JTabbedPane about = new JTabbedPane();
        Version version = Version.getInstance();
        JosmTextArea readme = new JosmTextArea();
        readme.setFont(GuiHelper.getMonospacedFont(readme));
        readme.setEditable(false);
        this.setTextFromResourceFile(readme, "/README");
        readme.setCaretPosition(0);
        JosmTextArea revision = new JosmTextArea();
        revision.setFont(GuiHelper.getMonospacedFont(revision));
        revision.setEditable(false);
        revision.setText(version.getReleaseAttributes());
        revision.setCaretPosition(0);
        JosmTextArea contribution = new JosmTextArea();
        contribution.setEditable(false);
        this.setTextFromResourceFile(contribution, "/CONTRIBUTION");
        contribution.setCaretPosition(0);
        JosmTextArea license = new JosmTextArea();
        license.setEditable(false);
        this.setTextFromResourceFile(license, "/LICENSE");
        license.setCaretPosition(0);
        JPanel info = new JPanel(new GridBagLayout());
        JMultilineLabel label = new JMultilineLabel("<html><h1>JOSM \u2013 " + I18n.tr("Java OpenStreetMap Editor", new Object[0]) + "</h1><p style='font-size:75%'></p><p>" + I18n.tr("Version {0}", version.getVersionString()) + "</p><p style='font-size:50%'></p><p>" + I18n.tr("Last change at {0}", version.getTime()) + "</p><p style='font-size:50%'></p><p>" + I18n.tr("Java Version {0}", Utils.getSystemProperty("java.version")) + "</p><p style='font-size:50%'></p></html>");
        info.add((Component)label, GBC.eol().fill(2).insets(10, 0, 0, 10));
        info.add((Component)new JLabel(I18n.tr("Homepage", new Object[0])), GBC.std().insets(10, 0, 10, 0));
        info.add((Component)new UrlLabel(Config.getUrls().getJOSMWebsite(), 2), GBC.eol());
        info.add((Component)new JLabel(I18n.tr("Translations", new Object[0])), GBC.std().insets(10, 0, 10, 0));
        info.add((Component)new UrlLabel("https://translations.launchpad.net/josm", 2), GBC.eol());
        info.add((Component)new JLabel(I18n.tr("Follow us on", new Object[0])), GBC.std().insets(10, 10, 10, 0));
        JPanel logos = new JPanel(new FlowLayout());
        logos.add(AboutAction.createImageLink("OpenStreetMap", "openstreetmap", "https://www.openstreetmap.org/user/josmeditor/diary"));
        logos.add(AboutAction.createImageLink("Mastodon", "mastodon", "https://en.osm.town/@josmeditor"));
        logos.add(AboutAction.createImageLink("Twitter", "twitter-square", "https://twitter.com/josmeditor"));
        logos.add(AboutAction.createImageLink("Facebook", "facebook-square", "https://www.facebook.com/josmeditor"));
        logos.add(AboutAction.createImageLink("GitHub", "github-square", "https://github.com/JOSM"));
        info.add((Component)logos, GBC.eol().insets(0, 10, 0, 0));
        info.add(GBC.glue(0, 5), GBC.eol());
        JPanel inst = new JPanel(new GridBagLayout());
        inst.add((Component)new JLabel(I18n.tr("Preferences are stored in {0}", AboutAction.getPathToPreferences())), GBC.eol().insets(0, 0, 0, 10));
        inst.add((Component)new JLabel(I18n.tr("Symbolic names for directories and the actual paths:", new Object[0])), GBC.eol().insets(0, 0, 0, 10));
        for (Map.Entry<String, String> entry : ShowStatusReportAction.getAnonimicDirectorySymbolMap().entrySet()) {
            AboutAction.addInstallationLine(inst, entry.getValue(), entry.getKey());
        }
        about.addTab(I18n.tr("Info", new Object[0]), info);
        about.addTab(I18n.tr("Readme", new Object[0]), AboutAction.createScrollPane(readme));
        about.addTab(I18n.tr("Revision", new Object[0]), AboutAction.createScrollPane(revision));
        about.addTab(I18n.tr("Contribution", new Object[0]), AboutAction.createScrollPane(contribution));
        about.addTab(I18n.tr("License", new Object[0]), AboutAction.createScrollPane(license));
        about.addTab(I18n.tr("Plugins", new Object[0]), new JScrollPane(PluginHandler.getInfoPanel()));
        about.addTab(I18n.tr("Installation Details", new Object[0]), inst);
        String translators = I18n.tr("translator-credits", new Object[0]);
        if (!Utils.isEmpty(translators) && !"translator-credits".equals(translators)) {
            about.addTab(I18n.tr("Translators", new Object[0]), AboutAction.createScrollPane(new JosmTextArea(translators)));
        }
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setPreferredSize(new Dimension(890, 300));
        panel.add((Component)new JLabel("", ImageProvider.get("logo.svg", ImageProvider.ImageSizes.ABOUT_LOGO), 0), GBC.std().insets(0, 5, 0, 0));
        panel.add((Component)about, GBC.std().fill());
        return panel;
    }

    private static String getPathToPreferences() {
        File preferenceFile = Preferences.main().getPreferenceFile();
        try {
            return ShowStatusReportAction.paramCleanup(preferenceFile.getAbsolutePath());
        }
        catch (SecurityException e) {
            Logging.warn(e);
            return ShowStatusReportAction.paramCleanup(preferenceFile.getPath());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JPanel panel = this.buildAboutPanel();
        GuiHelper.prepareResizeableOptionPane(panel, panel.getPreferredSize());
        ExtendedDialog dlg = new ExtendedDialog((Component)MainApplication.getMainFrame(), I18n.tr("About JOSM...", new Object[0]), I18n.tr("OK", new Object[0]), I18n.tr("Report bug", new Object[0]));
        int ret = dlg.setButtonIcons("ok", "bug").configureContextsensitiveHelp(HelpUtil.ht("Action/About"), true).setContent(panel, false).showDialog().getValue();
        if (2 == ret) {
            MainApplication.getMenu().reportbug.actionPerformed(null);
        }
        GuiHelper.destroyComponents(panel, false);
        dlg.dispose();
    }

    private static void addInstallationLine(JPanel inst, String dir, String source) {
        if (source == null) {
            return;
        }
        JLabel symbol = new JLabel(source);
        symbol.setFont(GuiHelper.getMonospacedFont(symbol));
        JosmTextArea dirLabel = new JosmTextArea();
        if (!Utils.isEmpty(dir)) {
            dirLabel.setText(dir);
            dirLabel.setEditable(false);
        } else {
            dirLabel.setText("<" + I18n.tr("unset", new Object[0]) + ">");
            dirLabel.setFont(dirLabel.getFont().deriveFont(2));
            dirLabel.setEditable(false);
        }
        inst.add((Component)symbol, GBC.std().insets(5, 0, 0, 0));
        inst.add(GBC.glue(10, 0), GBC.std());
        dirLabel.setFont(GuiHelper.getMonospacedFont(dirLabel));
        dirLabel.setOpaque(false);
        inst.add((Component)dirLabel, GBC.std().fill(2));
        JButton btn = new JButton(new OpenDirAction(dir));
        btn.setToolTipText(I18n.tr("Open directory", new Object[0]));
        inst.add((Component)btn, GBC.eol().insets(0, 0, 5, 0));
    }

    private static JLabel createImageLink(String tooltip, String icon, String link) {
        return new UrlLabel(link, tooltip, ImageProvider.get("dialogs/about", icon, ImageProvider.ImageSizes.LARGEICON));
    }

    private void setTextFromResourceFile(JTextArea ta, String filePath) {
        InputStream is = Utils.getResourceAsStream(this.getClass(), filePath);
        if (is == null) {
            AboutAction.displayErrorMessage(ta, I18n.tr("Failed to locate resource ''{0}''.", filePath));
        } else {
            try (BufferedReader br = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                String line;
                while ((line = br.readLine()) != null) {
                    ta.append(line + "\n");
                }
            }
            catch (IOException e) {
                Logging.warn(e);
                AboutAction.displayErrorMessage(ta, I18n.tr("Failed to load resource ''{0}'', error is {1}.", filePath, e.toString()));
            }
        }
    }

    private static void displayErrorMessage(JTextArea ta, String msg) {
        Logging.warn(msg);
        ta.setForeground(new Color(200, 0, 0));
        ta.setText(msg);
    }

    private static JScrollPane createScrollPane(JosmTextArea area) {
        area.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        area.setOpaque(false);
        JScrollPane sp = new JScrollPane(area);
        sp.setBorder(null);
        sp.setOpaque(false);
        return sp;
    }

    private static class OpenDirAction
    extends AbstractAction {
        final String dir;

        OpenDirAction(String dir) {
            this.putValue("Name", "...");
            this.dir = dir;
            try {
                this.setEnabled(dir != null && new File(dir).isDirectory());
            }
            catch (SecurityException e) {
                this.setEnabled(false);
                Logging.warn(e);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            OpenBrowser.displayUrl(new File(this.dir).toURI());
        }
    }
}

