/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.RepaintManager;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.widgets.JosmPasswordField;
import org.openstreetmap.josm.gui.widgets.OrientationAction;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.gui.widgets.TextContextualPopupMenu;
import org.openstreetmap.josm.tools.Destroyable;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class JosmTextField
extends JTextField
implements Destroyable,
ComponentListener,
FocusListener,
PropertyChangeListener {
    private final PopupMenuLauncher launcher;
    private String hint;
    private Icon icon;
    private Point iconPos;
    private Insets originalMargin;
    private OrientationAction orientationAction;

    public JosmTextField(Document doc, String text, int columns) {
        this(doc, text, columns, true);
    }

    public JosmTextField(Document doc, String text, int columns, boolean undoRedo) {
        super(doc, text, columns);
        this.launcher = TextContextualPopupMenu.enableMenuFor(this, undoRedo);
        this.getDocument().putProperty("i18n", Boolean.TRUE);
        this.orientationAction = new OrientationAction(this);
        this.orientationAction.addPropertyChangeListener(this);
        JPopupMenu menu = this.launcher.getMenu();
        menu.addSeparator();
        menu.add(new JMenuItem(this.orientationAction));
        this.getInputMap().put(OrientationAction.getShortcutKey(), this.orientationAction);
        if (columns > 0) {
            this.setMinimumSize(this.getPreferredSize());
        }
        this.addFocusListener(this);
        this.addComponentListener(this);
        JosmPasswordField.workaroundJdkBug6322854(this);
        this.originalMargin = this.getMargin();
    }

    public JosmTextField(String text, int columns) {
        this(null, text, columns);
    }

    public JosmTextField(String text) {
        this(null, text, 0);
    }

    public JosmTextField(int columns) {
        this(null, null, columns);
    }

    public JosmTextField() {
        this(null, null, 0);
    }

    public final String getHint() {
        return this.hint;
    }

    public String setHint(String hint) {
        String old = this.hint;
        this.hint = hint;
        return old;
    }

    public boolean displayHint() {
        return !Utils.isEmpty(this.hint) && this.getText().isEmpty() && !this.isFocusOwner();
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
        if (icon == null) {
            this.setMargin(this.originalMargin);
        }
        this.positionIcon();
    }

    private void positionIcon() {
        if (this.icon != null) {
            Insets margin = (Insets)this.originalMargin.clone();
            int hGap = (this.getHeight() - this.icon.getIconHeight()) / 2;
            if (this.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT) {
                margin.right += this.icon.getIconWidth() + 2 * hGap;
                this.iconPos = new Point(this.getWidth() - this.icon.getIconWidth() - hGap, hGap);
            } else {
                margin.left += this.icon.getIconWidth() + 2 * hGap;
                this.iconPos = new Point(hGap, hGap);
            }
            this.setMargin(margin);
        }
    }

    @Override
    public void setComponentOrientation(ComponentOrientation o) {
        if (o.isLeftToRight() != this.getComponentOrientation().isLeftToRight()) {
            super.setComponentOrientation(o);
            this.positionIcon();
        }
    }

    public final void discardAllUndoableEdits() {
        this.launcher.discardAllUndoableEdits();
    }

    public static Color getHintTextColor() {
        Color color = UIManager.getColor("TextField[Disabled].textForeground");
        if (color == null) {
            color = UIManager.getColor("TextField.inactiveForeground");
        }
        if (color == null) {
            color = Color.GRAY;
        }
        return color;
    }

    public static Font getHintFont() {
        return UIManager.getFont("TextField.font");
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.icon != null) {
            this.icon.paintIcon(this, g, this.iconPos.x, this.iconPos.y);
        }
        if (this.displayHint()) {
            this.drawHint(g);
        }
    }

    public void drawHint(Graphics g) {
        int x;
        try {
            x = (int)Math.round(this.modelToView2D(0).getX());
        }
        catch (BadLocationException exc) {
            Logging.trace(exc);
            return;
        }
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        g.setColor(JosmTextField.getHintTextColor());
        g.setFont(JosmTextField.getHintFont());
        if (this.getComponentOrientation().isLeftToRight()) {
            g.drawString(this.getHint(), x, this.getBaseline(this.getWidth(), this.getHeight()));
        } else {
            FontMetrics metrics = g.getFontMetrics(g.getFont());
            int dx = metrics.stringWidth(this.getHint());
            g.drawString(this.getHint(), x - dx, this.getBaseline(this.getWidth(), this.getHeight()));
        }
        RepaintManager.currentManager(this).markCompletelyClean(this);
    }

    @Override
    public void focusGained(FocusEvent e) {
        MapFrame map = MainApplication.getMap();
        if (map != null) {
            map.keyDetector.setEnabled(false);
        }
        if (e != null && e.getOppositeComponent() != null) {
            this.selectAll();
        }
        this.positionIcon();
        this.repaint();
    }

    @Override
    public void focusLost(FocusEvent e) {
        MapFrame map = MainApplication.getMap();
        if (map != null) {
            map.keyDetector.setEnabled(true);
        }
        this.repaint();
    }

    @Override
    public void destroy() {
        this.removeFocusListener(this);
        TextContextualPopupMenu.disableMenuFor(this, this.launcher);
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.positionIcon();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("orientationAction".equals(evt.getPropertyName())) {
            this.setComponentOrientation((ComponentOrientation)evt.getNewValue());
        }
    }
}

