/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.TextAnalyzer;
import org.openstreetmap.josm.tools.Utils;

public final class TextTagParser {
    private static final int MAX_KEY_LENGTH = Config.getPref().getInt("tags.paste.max-key-length", 50);
    private static final int MAX_KEY_COUNT = Config.getPref().getInt("tags.paste.max-key-count", 30);
    private static final String KEY_PATTERN = Config.getPref().get("tags.paste.tag-pattern", "[0-9a-zA-Z:_-]*");
    private static final int MAX_VALUE_LENGTH = 255;

    private TextTagParser() {
    }

    static String unescape(String k) {
        if (!k.startsWith("\"") || !k.endsWith("\"")) {
            if (k.contains("=")) {
                return null;
            }
            return k;
        }
        String text = k.substring(1, k.length() - 1);
        return new TextAnalyzer(text).parseString("\r\t\n");
    }

    public static Map<String, String> readTagsByRegexp(String text, String splitRegex, String tagRegex, boolean unescapeTextInQuotes) {
        String[] lines = text.split(splitRegex, -1);
        Pattern p = Pattern.compile(tagRegex);
        LinkedHashMap<String, String> tags = new LinkedHashMap<String, String>();
        for (String line : lines) {
            if (line.trim().isEmpty()) continue;
            Matcher m = p.matcher(line);
            if (m.matches()) {
                String k = Utils.removeWhiteSpaces(m.group(1));
                String v = Utils.removeWhiteSpaces(m.group(2));
                if (unescapeTextInQuotes) {
                    k = TextTagParser.unescape(k);
                    v = TextTagParser.unescape(v);
                    if (k == null || v == null) {
                        return null;
                    }
                }
                tags.put(k, v);
                continue;
            }
            return null;
        }
        if (!tags.isEmpty()) {
            return tags;
        }
        return null;
    }

    public static Map<String, String> getValidatedTagsFromText(String buf, TagWarningCallback callback) {
        Map<String, String> tags = TextTagParser.readTagsFromText(buf);
        return TextTagParser.validateTags(tags, callback) ? tags : null;
    }

    public static Map<String, String> readTagsFromText(String buf) {
        Map<String, String> tags = TextTagParser.readTagsByRegexp(buf, "[\\r\\n]+", ".*?([a-zA-Z0-9:_]+).*\\t(.*?)", false);
        if (tags != null) {
            return tags;
        }
        tags = TextTagParser.readTagsByRegexp(buf, "[\\n\\t\\r]+", "(.*?)=(.*?)", true);
        if (tags != null) {
            return tags;
        }
        String bufJson = buf.trim();
        if (bufJson.startsWith("{") && bufJson.endsWith("}")) {
            bufJson = bufJson.substring(1, bufJson.length() - 1);
        }
        if ((tags = TextTagParser.readTagsByRegexp(bufJson, "[\\s]*,[\\s]*", "[\\s]*(\\\".*?[^\\\\]\\\")[\\s]*:[\\s]*(\\\".*?[^\\\\]\\\")[\\s]*", true)) != null) {
            return tags;
        }
        return new TextAnalyzer(buf).getFreeParsedTags();
    }

    public static boolean validateTags(Map<String, String> tags, TagWarningCallback callback) {
        int r;
        int s = tags.size();
        if (s > MAX_KEY_COUNT) {
            r = callback.warning(I18n.trn("There was {0} tag found in the buffer, it is suspicious!", "There were {0} tags found in the buffer, it is suspicious!", s, s), "", "tags.paste.toomanytags");
            if (r == 2 || r == 3) {
                return false;
            }
            if (r == 4) {
                return true;
            }
        }
        for (Map.Entry<String, String> entry : tags.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (key.length() > MAX_KEY_LENGTH) {
                r = callback.warning(I18n.tr("Key is too long (max {0} characters):", MAX_KEY_LENGTH), key + "=" + value, "tags.paste.keytoolong");
                if (r == 2 || r == 3) {
                    return false;
                }
                if (r == 4) {
                    return true;
                }
            }
            if (!key.matches(KEY_PATTERN)) {
                r = callback.warning(I18n.tr("Suspicious characters in key:", new Object[0]), key, "tags.paste.keydoesnotmatch");
                if (r == 2 || r == 3) {
                    return false;
                }
                if (r == 4) {
                    return true;
                }
            }
            if (value.length() <= 255) continue;
            r = callback.warning(I18n.tr("Value is too long (max {0} characters):", 255), value, "tags.paste.valuetoolong");
            if (r == 2 || r == 3) {
                return false;
            }
            if (r != 4) continue;
            return true;
        }
        return true;
    }

    @FunctionalInterface
    public static interface TagWarningCallback {
        public int warning(String var1, String var2, String var3);
    }
}

