/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs.auxiliary;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractAuxiliaryCacheMonitor
extends Thread {
    protected final Log log = LogFactory.getLog(this.getClass());
    protected static long idlePeriod = 20000L;
    protected AtomicBoolean allright = new AtomicBoolean(true);
    private AtomicBoolean shutdown = new AtomicBoolean(false);
    private Lock lock = new ReentrantLock();
    private Condition trigger = this.lock.newCondition();

    public AbstractAuxiliaryCacheMonitor(String name) {
        super(name);
    }

    public static void setIdlePeriod(long idlePeriod) {
        if (idlePeriod > AbstractAuxiliaryCacheMonitor.idlePeriod) {
            AbstractAuxiliaryCacheMonitor.idlePeriod = idlePeriod;
        }
    }

    public void notifyError() {
        if (this.allright.compareAndSet(true, false)) {
            this.signalTrigger();
        }
    }

    public void notifyShutdown() {
        if (this.shutdown.compareAndSet(false, true)) {
            this.signalTrigger();
        }
    }

    private void signalTrigger() {
        try {
            this.lock.lock();
            this.trigger.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    protected abstract void dispose();

    protected abstract void doWork();

    @Override
    public void run() {
        while (true) {
            if (this.log.isDebugEnabled()) {
                if (this.allright.get()) {
                    this.log.debug("ERROR DRIVEN MODE: allright = true, cache monitor will wait for an error.");
                } else {
                    this.log.debug("ERROR DRIVEN MODE: allright = false cache monitor running.");
                }
            }
            if (this.allright.get()) {
                try {
                    this.lock.lock();
                    this.trigger.await();
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    this.lock.unlock();
                }
            }
            if (this.shutdown.get()) {
                this.log.info("Shutting down cache monitor");
                this.dispose();
                return;
            }
            this.allright.set(true);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Cache monitor running.");
            }
            this.doWork();
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Cache monitor sleeping for " + idlePeriod + " between runs.");
                }
                Thread.sleep(idlePeriod);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }
}

