/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery;

import java.awt.Component;
import java.awt.Point;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.ListSelectionModel;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.Projected;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.TileRange;
import org.openstreetmap.gui.jmapviewer.TileXY;
import org.openstreetmap.gui.jmapviewer.interfaces.ICoordinate;
import org.openstreetmap.gui.jmapviewer.interfaces.IProjected;
import org.openstreetmap.gui.jmapviewer.interfaces.TemplatedTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.AbstractTMSTileSource;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.imagery.CoordinateConversion;
import org.openstreetmap.josm.data.imagery.DefaultLayer;
import org.openstreetmap.josm.data.imagery.GetCapabilitiesParseHelper;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.WMTSCapabilities;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionRegistry;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.NativeScaleLayer;
import org.openstreetmap.josm.gui.layer.imagery.WMTSLayerSelection;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class WMTSTileSource
extends AbstractTMSTileSource
implements TemplatedTileSource {
    public static final String WMTS_NS_URL = "http://www.opengis.net/wmts/1.0";
    private static final QName QN_CONTENTS = new QName("http://www.opengis.net/wmts/1.0", "Contents");
    private static final QName QN_DEFAULT = new QName("http://www.opengis.net/wmts/1.0", "Default");
    private static final QName QN_DIMENSION = new QName("http://www.opengis.net/wmts/1.0", "Dimension");
    private static final QName QN_FORMAT = new QName("http://www.opengis.net/wmts/1.0", "Format");
    private static final QName QN_LAYER = new QName("http://www.opengis.net/wmts/1.0", "Layer");
    private static final QName QN_MATRIX_WIDTH = new QName("http://www.opengis.net/wmts/1.0", "MatrixWidth");
    private static final QName QN_MATRIX_HEIGHT = new QName("http://www.opengis.net/wmts/1.0", "MatrixHeight");
    private static final QName QN_RESOURCE_URL = new QName("http://www.opengis.net/wmts/1.0", "ResourceURL");
    private static final QName QN_SCALE_DENOMINATOR = new QName("http://www.opengis.net/wmts/1.0", "ScaleDenominator");
    private static final QName QN_STYLE = new QName("http://www.opengis.net/wmts/1.0", "Style");
    private static final QName QN_TILEMATRIX = new QName("http://www.opengis.net/wmts/1.0", "TileMatrix");
    private static final QName QN_TILEMATRIXSET = new QName("http://www.opengis.net/wmts/1.0", "TileMatrixSet");
    private static final QName QN_TILEMATRIX_SET_LINK = new QName("http://www.opengis.net/wmts/1.0", "TileMatrixSetLink");
    private static final QName QN_TILE_WIDTH = new QName("http://www.opengis.net/wmts/1.0", "TileWidth");
    private static final QName QN_TILE_HEIGHT = new QName("http://www.opengis.net/wmts/1.0", "TileHeight");
    private static final QName QN_TOPLEFT_CORNER = new QName("http://www.opengis.net/wmts/1.0", "TopLeftCorner");
    private static final QName QN_VALUE = new QName("http://www.opengis.net/wmts/1.0", "Value");
    private static final String PATTERN_HEADER = "\\{header\\(([^,]+),([^}]+)\\)\\}";
    private static final String URL_GET_ENCODING_PARAMS = "SERVICE=WMTS&REQUEST=GetTile&VERSION=1.0.0&LAYER={layer}&STYLE={style}&FORMAT={format}&tileMatrixSet={TileMatrixSet}&tileMatrix={TileMatrix}&tileRow={TileRow}&tileCol={TileCol}";
    private static final String[] ALL_PATTERNS = new String[]{"\\{header\\(([^,]+),([^}]+)\\)\\}"};
    private int cachedTileSize = -1;
    private final Map<String, String> headers = new ConcurrentHashMap<String, String>();
    private final Collection<Layer> layers;
    private Layer currentLayer;
    private TileMatrixSet currentTileMatrixSet;
    private double crsScale;
    private final GetCapabilitiesParseHelper.TransferMode transferMode;
    private NativeScaleLayer.ScaleList nativeScaleList;
    private final DefaultLayer defaultLayer;
    private Projection tileProjection;

    public WMTSTileSource(ImageryInfo info) throws IOException, WMTSGetCapabilitiesException {
        super(info);
        CheckParameterUtil.ensureThat(info.getDefaultLayers().size() < 2, "At most 1 default layer for WMTS is supported");
        this.headers.putAll(info.getCustomHttpHeaders());
        this.baseUrl = GetCapabilitiesParseHelper.normalizeCapabilitiesUrl(this.handleTemplate(info.getUrl()));
        WMTSCapabilities capabilities = WMTSTileSource.getCapabilities(this.baseUrl, this.headers);
        this.layers = capabilities.getLayers();
        this.baseUrl = capabilities.getBaseUrl();
        this.transferMode = capabilities.getTransferMode();
        if (info.getDefaultLayers().isEmpty()) {
            Logging.warn(I18n.tr("No default layer selected, choosing first layer.", new Object[0]));
            if (!this.layers.isEmpty()) {
                Layer first = this.layers.iterator().next();
                int maxZoom = info.getMaxZoom();
                if (first.getMaxZoom() < maxZoom) {
                    first = this.layers.stream().filter(l -> l.getMaxZoom() >= maxZoom).findFirst().orElse(first);
                }
                if (info.getBounds() != null && first.getBbox() != null) {
                    LatLon center = info.getBounds().getCenter();
                    if (!first.getBbox().bounds(center)) {
                        Layer ffirst = first;
                        first = this.layers.stream().filter(l -> l.getMaxZoom() >= maxZoom && l.getBbox() != null && l.getBbox().bounds(center)).findFirst().orElseGet(() -> this.layers.stream().filter(l -> l.getBbox() != null && l.getBbox().bounds(center)).findFirst().orElse(ffirst));
                    }
                }
                this.defaultLayer = new DefaultLayer(info.getImageryType(), first.identifier, first.style, first.tileMatrixSet.identifier);
            } else {
                this.defaultLayer = null;
            }
        } else {
            this.defaultLayer = info.getDefaultLayers().get(0);
        }
        if (this.layers.isEmpty()) {
            throw new IllegalArgumentException(I18n.tr("No layers defined by getCapabilities document: {0}", info.getUrl()));
        }
    }

    public WMTSTileSource(ImageryInfo info, Projection projection) throws IOException, WMTSGetCapabilitiesException {
        this(info);
        this.initProjection(projection);
    }

    public DefaultLayer userSelectLayer() {
        List ls;
        Map<String, List<Layer>> layerById = this.layers.stream().collect(Collectors.groupingBy(x -> ((Layer)x).identifier));
        if (layerById.size() == 1 && (ls = layerById.entrySet().iterator().next().getValue().stream().filter(u -> ((Layer)u).tileMatrixSet.crs.equals(ProjectionRegistry.getProjection().toCode())).collect(Collectors.toList())).size() == 1) {
            Layer selectedLayer = (Layer)ls.get(0);
            return new DefaultLayer(ImageryInfo.ImageryType.WMTS, selectedLayer.identifier, selectedLayer.style, selectedLayer.tileMatrixSet.identifier);
        }
        SelectLayerDialog layerSelection = new SelectLayerDialog(this.layers);
        if (layerSelection.showDialog().getValue() == 1) {
            return layerSelection.getSelectedLayer();
        }
        return null;
    }

    private String handleTemplate(String url) {
        Pattern pattern = Pattern.compile(PATTERN_HEADER);
        StringBuffer output = new StringBuffer();
        Matcher matcher = pattern.matcher(url);
        while (matcher.find()) {
            this.headers.put(matcher.group(1), matcher.group(2));
            matcher.appendReplacement(output, "");
        }
        matcher.appendTail(output);
        return output.toString();
    }

    /*
     * Exception decompiling
     */
    public static WMTSCapabilities getCapabilities(String url, Map<String, String> headers) throws IOException, WMTSGetCapabilitiesException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Collection<Layer> parseContents(XMLStreamReader reader) throws XMLStreamException {
        ConcurrentHashMap<String, TileMatrixSet> matrixSetById = new ConcurrentHashMap<String, TileMatrixSet>();
        ArrayList<Layer> layers = new ArrayList<Layer>();
        int event = reader.getEventType();
        while (reader.hasNext() && (event != 2 || !QN_CONTENTS.equals(reader.getName()))) {
            if (event == 1) {
                QName qName = reader.getName();
                if (QN_LAYER.equals(qName)) {
                    Layer l = WMTSTileSource.parseLayer(reader);
                    if (l != null) {
                        layers.add(l);
                    }
                } else if (QN_TILEMATRIXSET.equals(qName)) {
                    TileMatrixSet entry = WMTSTileSource.parseTileMatrixSet(reader);
                    matrixSetById.put(entry.identifier, entry);
                }
            }
            event = reader.next();
        }
        ArrayList<Layer> ret = new ArrayList<Layer>();
        for (Layer l : layers) {
            for (String tileMatrixId : l.tileMatrixSetLinks) {
                Layer newLayer = new Layer(l);
                newLayer.tileMatrixSet = (TileMatrixSet)matrixSetById.get(tileMatrixId);
                ret.add(newLayer);
            }
        }
        return ret;
    }

    private static Layer parseLayer(XMLStreamReader reader) throws XMLStreamException {
        Layer layer = new Layer();
        LinkedList<QName> tagStack = new LinkedList<QName>();
        ArrayList<String> supportedMimeTypes = new ArrayList<String>(Arrays.asList(ImageIO.getReaderMIMETypes()));
        supportedMimeTypes.add("image/jpgpng");
        supportedMimeTypes.add("image/png8");
        if (supportedMimeTypes.contains("image/jpeg")) {
            supportedMimeTypes.add("image/jpg");
        }
        ArrayList<String> unsupportedFormats = new ArrayList<String>();
        int event = reader.getEventType();
        while (reader.hasNext() && (event != 2 || !QN_LAYER.equals(reader.getName()))) {
            QName start;
            if (event == 1) {
                QName qName = reader.getName();
                tagStack.push(qName);
                if (tagStack.size() == 2) {
                    if (QN_FORMAT.equals(qName)) {
                        String format = reader.getElementText();
                        if (supportedMimeTypes.contains(format)) {
                            layer.format = format;
                        } else {
                            unsupportedFormats.add(format);
                        }
                    } else if (GetCapabilitiesParseHelper.QN_OWS_IDENTIFIER.equals(qName)) {
                        layer.identifier = reader.getElementText();
                    } else if (GetCapabilitiesParseHelper.QN_OWS_TITLE.equals(qName)) {
                        layer.title = reader.getElementText();
                    } else if (QN_RESOURCE_URL.equals(qName) && "tile".equals(reader.getAttributeValue("", "resourceType"))) {
                        layer.baseUrl = reader.getAttributeValue("", "template");
                    } else if (QN_STYLE.equals(qName) && "true".equals(reader.getAttributeValue("", "isDefault"))) {
                        if (GetCapabilitiesParseHelper.moveReaderToTag(reader, GetCapabilitiesParseHelper.QN_OWS_IDENTIFIER)) {
                            layer.style = reader.getElementText();
                            tagStack.push(reader.getName());
                        }
                    } else if (QN_DIMENSION.equals(qName)) {
                        layer.dimensions.add(WMTSTileSource.parseDimension(reader));
                    } else if (QN_TILEMATRIX_SET_LINK.equals(qName)) {
                        layer.tileMatrixSetLinks.add(WMTSTileSource.parseTileMatrixSetLink(reader));
                    } else if (GetCapabilitiesParseHelper.QN_OWS_WGS84_BOUNDING_BOX.equals(qName)) {
                        layer.bbox = WMTSTileSource.parseBoundingBox(reader);
                    } else {
                        GetCapabilitiesParseHelper.moveReaderToEndCurrentTag(reader);
                    }
                }
            }
            if (reader.getEventType() == 2 && !(start = (QName)tagStack.pop()).equals(reader.getName())) {
                throw new IllegalStateException(I18n.tr("WMTS Parser error - start element {0} has different name than end element {2}", start, reader.getName()));
            }
            event = reader.next();
        }
        if (layer.style == null) {
            layer.style = "";
        }
        if (layer.format == null) {
            Logging.warn(I18n.tr("Can''t use layer {0} because no supported formats where found. Layer is available in formats: {1}", layer.getUserTitle(), String.join((CharSequence)", ", unsupportedFormats)));
            return null;
        }
        return layer;
    }

    private static Dimension parseDimension(XMLStreamReader reader) throws XMLStreamException {
        Dimension ret = new Dimension();
        int event = reader.getEventType();
        while (reader.hasNext() && (event != 2 || !QN_DIMENSION.equals(reader.getName()))) {
            if (event == 1) {
                QName qName = reader.getName();
                if (GetCapabilitiesParseHelper.QN_OWS_IDENTIFIER.equals(qName)) {
                    ret.identifier = reader.getElementText();
                } else if (QN_DEFAULT.equals(qName)) {
                    ret.defaultValue = reader.getElementText();
                } else if (QN_VALUE.equals(qName)) {
                    ret.values.add(reader.getElementText());
                }
            }
            event = reader.next();
        }
        return ret;
    }

    private static String parseTileMatrixSetLink(XMLStreamReader reader) throws XMLStreamException {
        String ret = null;
        int event = reader.getEventType();
        while (reader.hasNext() && (event != 2 || !QN_TILEMATRIX_SET_LINK.equals(reader.getName()))) {
            if (event == 1 && QN_TILEMATRIXSET.equals(reader.getName())) {
                ret = reader.getElementText();
            }
            event = reader.next();
        }
        return ret;
    }

    private static TileMatrixSet parseTileMatrixSet(XMLStreamReader reader) throws XMLStreamException {
        TileMatrixSetBuilder matrixSet = new TileMatrixSetBuilder();
        int event = reader.getEventType();
        while (reader.hasNext() && (event != 2 || !QN_TILEMATRIXSET.equals(reader.getName()))) {
            if (event == 1) {
                QName qName = reader.getName();
                if (GetCapabilitiesParseHelper.QN_OWS_IDENTIFIER.equals(qName)) {
                    matrixSet.identifier = reader.getElementText();
                } else if (GetCapabilitiesParseHelper.QN_OWS_SUPPORTED_CRS.equals(qName)) {
                    matrixSet.crs = GetCapabilitiesParseHelper.crsToCode(reader.getElementText());
                } else if (QN_TILEMATRIX.equals(qName)) {
                    matrixSet.tileMatrix.add(WMTSTileSource.parseTileMatrix(reader, matrixSet.crs));
                }
            }
            event = reader.next();
        }
        return matrixSet.build();
    }

    private static TileMatrix parseTileMatrix(XMLStreamReader reader, String matrixCrs) throws XMLStreamException {
        Projection matrixProj = Optional.ofNullable(Projections.getProjectionByCode(matrixCrs)).orElseGet(ProjectionRegistry::getProjection);
        TileMatrix ret = new TileMatrix();
        int event = reader.getEventType();
        while (reader.hasNext() && (event != 2 || !QN_TILEMATRIX.equals(reader.getName()))) {
            if (event == 1) {
                QName qName = reader.getName();
                if (GetCapabilitiesParseHelper.QN_OWS_IDENTIFIER.equals(qName)) {
                    ret.identifier = reader.getElementText();
                } else if (QN_SCALE_DENOMINATOR.equals(qName)) {
                    ret.scaleDenominator = Double.parseDouble(reader.getElementText());
                } else if (QN_TOPLEFT_CORNER.equals(qName)) {
                    ret.topLeftCorner = WMTSTileSource.parseEastNorth(reader.getElementText(), matrixProj.switchXY());
                } else if (QN_TILE_HEIGHT.equals(qName)) {
                    ret.tileHeight = Integer.parseInt(reader.getElementText());
                } else if (QN_TILE_WIDTH.equals(qName)) {
                    ret.tileWidth = Integer.parseInt(reader.getElementText());
                } else if (QN_MATRIX_HEIGHT.equals(qName)) {
                    ret.matrixHeight = Integer.parseInt(reader.getElementText());
                } else if (QN_MATRIX_WIDTH.equals(qName)) {
                    ret.matrixWidth = Integer.parseInt(reader.getElementText());
                }
            }
            event = reader.next();
        }
        if (ret.tileHeight != ret.tileWidth) {
            throw new AssertionError((Object)I18n.tr("Only square tiles are supported. {0}x{1} returned by server for TileMatrix identifier {2}", ret.tileHeight, ret.tileWidth, ret.identifier));
        }
        return ret;
    }

    private static <T> T parseCoor(String coor, boolean switchXY, BiFunction<String, String, T> function) {
        String[] parts = coor.split(" ");
        if (switchXY) {
            return function.apply(parts[1], parts[0]);
        }
        return function.apply(parts[0], parts[1]);
    }

    private static EastNorth parseEastNorth(String coor, boolean switchXY) {
        return WMTSTileSource.parseCoor(coor, switchXY, (e, n) -> new EastNorth(Double.parseDouble(e), Double.parseDouble(n)));
    }

    private static LatLon parseLatLon(String coor, boolean switchXY) {
        return WMTSTileSource.parseCoor(coor, switchXY, (lon, lat) -> new LatLon(Double.parseDouble(lat), Double.parseDouble(lon)));
    }

    private static BBox parseBoundingBox(XMLStreamReader reader) throws XMLStreamException {
        LatLon lowerCorner = null;
        LatLon upperCorner = null;
        int event = reader.getEventType();
        while (reader.hasNext() && (event != 2 || !GetCapabilitiesParseHelper.QN_OWS_WGS84_BOUNDING_BOX.equals(reader.getName()))) {
            if (event == 1) {
                QName qName = reader.getName();
                if (GetCapabilitiesParseHelper.QN_OWS_LOWER_CORNER.equals(qName)) {
                    lowerCorner = WMTSTileSource.parseLatLon(reader.getElementText(), false);
                } else if (GetCapabilitiesParseHelper.QN_OWS_UPPER_CORNER.equals(qName)) {
                    upperCorner = WMTSTileSource.parseLatLon(reader.getElementText(), false);
                }
            }
            event = reader.next();
        }
        if (lowerCorner != null && upperCorner != null) {
            return new BBox(lowerCorner, upperCorner);
        }
        return null;
    }

    private static WMTSCapabilities parseOperationMetadata(XMLStreamReader reader) throws XMLStreamException {
        int event = reader.getEventType();
        while (reader.hasNext() && (event != 2 || !GetCapabilitiesParseHelper.QN_OWS_OPERATIONS_METADATA.equals(reader.getName()))) {
            if (event == 1 && GetCapabilitiesParseHelper.QN_OWS_OPERATION.equals(reader.getName()) && "GetTile".equals(reader.getAttributeValue("", "name")) && GetCapabilitiesParseHelper.moveReaderToTag(reader, GetCapabilitiesParseHelper.QN_OWS_DCP, GetCapabilitiesParseHelper.QN_OWS_HTTP, GetCapabilitiesParseHelper.QN_OWS_GET)) {
                return new WMTSCapabilities(reader.getAttributeValue("http://www.w3.org/1999/xlink", "href"), GetCapabilitiesParseHelper.getTransferMode(reader));
            }
            event = reader.next();
        }
        return null;
    }

    public void initProjection(Projection proj) {
        if (proj.equals(this.tileProjection)) {
            return;
        }
        List matchingLayers = this.layers.stream().filter(l -> ((Layer)l).identifier.equals(this.defaultLayer.getLayerName()) && ((Layer)l).tileMatrixSet.crs.equals(proj.toCode())).collect(Collectors.toList());
        if (matchingLayers.size() > 1) {
            this.currentLayer = matchingLayers.stream().filter(l -> ((Layer)l).tileMatrixSet.identifier.equals(this.defaultLayer.getTileMatrixSet())).findFirst().orElse((Layer)matchingLayers.get(0));
            this.tileProjection = proj;
        } else if (matchingLayers.size() == 1) {
            this.currentLayer = (Layer)matchingLayers.get(0);
            this.tileProjection = proj;
        } else if (this.currentLayer == null) {
            this.tileProjection = null;
            for (Layer layer : this.layers) {
                Projection pr;
                if (!layer.identifier.equals(this.defaultLayer.getLayerName()) || (pr = Projections.getProjectionByCode(layer.tileMatrixSet.crs)) == null) continue;
                this.currentLayer = layer;
                this.tileProjection = pr;
                break;
            }
            if (this.currentLayer == null) {
                throw new IllegalArgumentException(this.layers.stream().map(l -> ((Layer)l).tileMatrixSet).collect(Collectors.toList()).toString());
            }
        }
        if (this.currentLayer != null) {
            this.currentTileMatrixSet = this.currentLayer.tileMatrixSet;
            ArrayList<Double> scales = new ArrayList<Double>(this.currentTileMatrixSet.tileMatrix.size());
            for (TileMatrix tileMatrix : this.currentTileMatrixSet.tileMatrix) {
                scales.add(tileMatrix.scaleDenominator * 2.8E-4);
            }
            this.nativeScaleList = new NativeScaleLayer.ScaleList(scales);
        }
        this.crsScale = (double)this.getTileSize() * 2.8E-4 / this.tileProjection.getMetersPerUnit();
    }

    @Override
    public int getTileSize() {
        if (this.cachedTileSize > 0) {
            return this.cachedTileSize;
        }
        if (this.currentTileMatrixSet != null) {
            this.cachedTileSize = ((TileMatrix)this.currentTileMatrixSet.tileMatrix.get(0)).tileHeight;
            return this.cachedTileSize;
        }
        Logging.warn("WMTS: Could not determine tile size. Using default tile size of: {0}", this.getDefaultTileSize());
        return this.getDefaultTileSize();
    }

    @Override
    public String getTileUrl(int zoom, int tilex, int tiley) {
        String url;
        if (this.currentLayer == null) {
            return "";
        }
        if (this.currentLayer.baseUrl != null && this.transferMode == null) {
            url = this.currentLayer.baseUrl;
        } else {
            switch (this.transferMode) {
                case KVP: {
                    url = this.baseUrl + URL_GET_ENCODING_PARAMS;
                    break;
                }
                case REST: {
                    url = this.currentLayer.baseUrl;
                    break;
                }
                default: {
                    url = "";
                }
            }
        }
        TileMatrix tileMatrix = this.getTileMatrix(zoom);
        if (tileMatrix == null) {
            return "";
        }
        url = url.replaceAll("\\{layer\\}", this.currentLayer.identifier).replaceAll("\\{format\\}", this.currentLayer.format).replaceAll("\\{TileMatrixSet\\}", this.currentTileMatrixSet.identifier).replaceAll("\\{TileMatrix\\}", tileMatrix.identifier).replaceAll("\\{TileRow\\}", Integer.toString(tiley)).replaceAll("\\{TileCol\\}", Integer.toString(tilex)).replaceAll("(?i)\\{style\\}", this.currentLayer.style);
        for (Dimension d : this.currentLayer.dimensions) {
            url = url.replaceAll("(?i)\\{" + d.identifier + "\\}", d.defaultValue);
        }
        return url;
    }

    private TileMatrix getTileMatrix(int zoom) {
        if (zoom > this.getMaxZoom()) {
            return null;
        }
        if (zoom < 0) {
            return null;
        }
        return (TileMatrix)this.currentTileMatrixSet.tileMatrix.get(zoom);
    }

    @Override
    public double getDistance(double lat1, double lon1, double lat2, double lon2) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public ICoordinate tileXYToLatLon(Tile tile) {
        return this.tileXYToLatLon(tile.getXtile(), tile.getYtile(), tile.getZoom());
    }

    @Override
    public ICoordinate tileXYToLatLon(TileXY xy, int zoom) {
        return this.tileXYToLatLon(xy.getXIndex(), xy.getYIndex(), zoom);
    }

    @Override
    public ICoordinate tileXYToLatLon(int x, int y, int zoom) {
        TileMatrix matrix = this.getTileMatrix(zoom);
        if (matrix == null) {
            return CoordinateConversion.llToCoor(this.tileProjection.getWorldBoundsLatLon().getCenter());
        }
        double scale = matrix.scaleDenominator * this.crsScale;
        EastNorth ret = new EastNorth(matrix.topLeftCorner.east() + (double)x * scale, matrix.topLeftCorner.north() - (double)y * scale);
        return CoordinateConversion.llToCoor(this.tileProjection.eastNorth2latlon(ret));
    }

    @Override
    public TileXY latLonToTileXY(double lat, double lon, int zoom) {
        TileMatrix matrix = this.getTileMatrix(zoom);
        if (matrix == null) {
            return new TileXY(0.0, 0.0);
        }
        EastNorth enPoint = this.tileProjection.latlon2eastNorth(new LatLon(lat, lon));
        double scale = matrix.scaleDenominator * this.crsScale;
        return new TileXY((enPoint.east() - matrix.topLeftCorner.east()) / scale, (matrix.topLeftCorner.north() - enPoint.north()) / scale);
    }

    @Override
    public TileXY latLonToTileXY(ICoordinate point, int zoom) {
        return this.latLonToTileXY(point.getLat(), point.getLon(), zoom);
    }

    @Override
    public int getTileXMax(int zoom) {
        return this.getTileXMax(zoom, this.tileProjection);
    }

    @Override
    public int getTileYMax(int zoom) {
        return this.getTileYMax(zoom, this.tileProjection);
    }

    @Override
    public Point latLonToXY(double lat, double lon, int zoom) {
        TileMatrix matrix = this.getTileMatrix(zoom);
        if (matrix == null) {
            return new Point(0, 0);
        }
        double scale = matrix.scaleDenominator * this.crsScale;
        EastNorth point = this.tileProjection.latlon2eastNorth(new LatLon(lat, lon));
        return new Point((int)Math.round((point.east() - matrix.topLeftCorner.east()) / scale), (int)Math.round((matrix.topLeftCorner.north() - point.north()) / scale));
    }

    @Override
    public Point latLonToXY(ICoordinate point, int zoom) {
        return this.latLonToXY(point.getLat(), point.getLon(), zoom);
    }

    @Override
    public Coordinate xyToLatLon(Point point, int zoom) {
        return this.xyToLatLon(point.x, point.y, zoom);
    }

    @Override
    public Coordinate xyToLatLon(int x, int y, int zoom) {
        TileMatrix matrix = this.getTileMatrix(zoom);
        if (matrix == null) {
            return new Coordinate(0.0, 0.0);
        }
        double scale = matrix.scaleDenominator * this.crsScale;
        EastNorth ret = new EastNorth(matrix.topLeftCorner.east() + (double)x * scale, matrix.topLeftCorner.north() - (double)y * scale);
        LatLon ll = this.tileProjection.eastNorth2latlon(ret);
        return new Coordinate(ll.lat(), ll.lon());
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public int getMaxZoom() {
        if (this.currentTileMatrixSet != null) {
            return this.currentTileMatrixSet.getMaxZoom();
        }
        return 0;
    }

    @Override
    public String getTileId(int zoom, int tilex, int tiley) {
        return this.getTileUrl(zoom, tilex, tiley);
    }

    public static void checkUrl(String url) {
        CheckParameterUtil.ensureParameterNotNull(url, "url");
        Matcher m = Pattern.compile("\\{[^}]*\\}").matcher(url);
        while (m.find()) {
            boolean isSupportedPattern = false;
            for (String pattern : ALL_PATTERNS) {
                if (!m.group().matches(pattern)) continue;
                isSupportedPattern = true;
                break;
            }
            if (isSupportedPattern) continue;
            throw new IllegalArgumentException(I18n.tr("{0} is not a valid WMS argument. Please check this server URL:\n{1}", m.group(), url));
        }
    }

    public static List<Map.Entry<String, List<Layer>>> groupLayersByNameAndTileMatrixSet(Collection<Layer> layers) {
        Map<String, List<Layer>> layerByName = layers.stream().collect(Collectors.groupingBy(x -> ((Layer)x).identifier + '\u001c' + ((Layer)x).tileMatrixSet.identifier));
        return layerByName.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toList());
    }

    public Collection<String> getSupportedProjections() {
        LinkedHashSet<String> ret = new LinkedHashSet<String>();
        if (this.currentLayer == null) {
            for (Layer layer : this.layers) {
                ret.add(layer.tileMatrixSet.crs);
            }
        } else {
            for (Layer layer : this.layers) {
                if (!this.currentLayer.identifier.equals(layer.identifier)) continue;
                ret.add(layer.tileMatrixSet.crs);
            }
        }
        return ret;
    }

    private int getTileYMax(int zoom, Projection proj) {
        TileMatrix matrix = this.getTileMatrix(zoom);
        if (matrix == null) {
            return 0;
        }
        if (matrix.matrixHeight != -1) {
            return matrix.matrixHeight;
        }
        double scale = matrix.scaleDenominator * this.crsScale;
        EastNorth min = matrix.topLeftCorner;
        EastNorth max = proj.latlon2eastNorth(proj.getWorldBoundsLatLon().getMax());
        return (int)Math.ceil(Math.abs(max.north() - min.north()) / scale);
    }

    private int getTileXMax(int zoom, Projection proj) {
        TileMatrix matrix = this.getTileMatrix(zoom);
        if (matrix == null) {
            return 0;
        }
        if (matrix.matrixWidth != -1) {
            return matrix.matrixWidth;
        }
        double scale = matrix.scaleDenominator * this.crsScale;
        EastNorth min = matrix.topLeftCorner;
        EastNorth max = proj.latlon2eastNorth(proj.getWorldBoundsLatLon().getMax());
        return (int)Math.ceil(Math.abs(max.east() - min.east()) / scale);
    }

    public NativeScaleLayer.ScaleList getNativeScales() {
        return this.nativeScaleList;
    }

    public Projection getTileProjection() {
        return this.tileProjection;
    }

    @Override
    public IProjected tileXYtoProjected(int x, int y, int zoom) {
        TileMatrix matrix = this.getTileMatrix(zoom);
        if (matrix == null) {
            return new Projected(0.0, 0.0);
        }
        double scale = matrix.scaleDenominator * this.crsScale;
        return new Projected(matrix.topLeftCorner.east() + (double)x * scale, matrix.topLeftCorner.north() - (double)y * scale);
    }

    @Override
    public TileXY projectedToTileXY(IProjected projected, int zoom) {
        TileMatrix matrix = this.getTileMatrix(zoom);
        if (matrix == null) {
            return new TileXY(0.0, 0.0);
        }
        double scale = matrix.scaleDenominator * this.crsScale;
        return new TileXY((projected.getEast() - matrix.topLeftCorner.east()) / scale, -(projected.getNorth() - matrix.topLeftCorner.north()) / scale);
    }

    private EastNorth tileToEastNorth(int x, int y, int z) {
        return CoordinateConversion.projToEn(this.tileXYtoProjected(x, y, z));
    }

    private ProjectionBounds getTileProjectionBounds(Tile tile) {
        ProjectionBounds pb = new ProjectionBounds(this.tileToEastNorth(tile.getXtile(), tile.getYtile(), tile.getZoom()));
        pb.extend(this.tileToEastNorth(tile.getXtile() + 1, tile.getYtile() + 1, tile.getZoom()));
        return pb;
    }

    @Override
    public boolean isInside(Tile inner, Tile outer) {
        ProjectionBounds pbInner = this.getTileProjectionBounds(inner);
        ProjectionBounds pbOuter = this.getTileProjectionBounds(outer);
        double epsilon = 1.0E-7 * (pbOuter.maxEast - pbOuter.minEast);
        return pbOuter.minEast <= pbInner.minEast + epsilon && pbOuter.minNorth <= pbInner.minNorth + epsilon && pbOuter.maxEast >= pbInner.maxEast - epsilon && pbOuter.maxNorth >= pbInner.maxNorth - epsilon;
    }

    @Override
    public TileRange getCoveringTileRange(Tile tile, int newZoom) {
        TileMatrix matrixNew = this.getTileMatrix(newZoom);
        if (matrixNew == null) {
            return new TileRange(new TileXY(0.0, 0.0), new TileXY(0.0, 0.0), newZoom);
        }
        IProjected p0 = this.tileXYtoProjected(tile.getXtile(), tile.getYtile(), tile.getZoom());
        IProjected p1 = this.tileXYtoProjected(tile.getXtile() + 1, tile.getYtile() + 1, tile.getZoom());
        TileXY tMin = this.projectedToTileXY(p0, newZoom);
        TileXY tMax = this.projectedToTileXY(p1, newZoom);
        double epsilon = 1.0E-7 * (tMax.getX() - tMin.getX());
        int minX = (int)Math.floor(tMin.getX() + epsilon);
        int minY = (int)Math.floor(tMin.getY() + epsilon);
        int maxX = (int)Math.ceil(tMax.getX() - epsilon) - 1;
        int maxY = (int)Math.ceil(tMax.getY() - epsilon) - 1;
        return new TileRange(new TileXY(minX, minY), new TileXY(maxX, maxY), newZoom);
    }

    @Override
    public String getServerCRS() {
        return this.tileProjection != null ? this.tileProjection.toCode() : null;
    }

    public Collection<Layer> getLayers() {
        return Collections.unmodifiableCollection(this.layers);
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }

    private static final class SelectLayerDialog
    extends ExtendedDialog {
        private final WMTSLayerSelection list;

        SelectLayerDialog(Collection<Layer> layers) {
            super((Component)MainApplication.getMainFrame(), I18n.tr("Select WMTS layer", new Object[0]), I18n.tr("Add layers", new Object[0]), I18n.tr("Cancel", new Object[0]));
            this.list = new WMTSLayerSelection(WMTSTileSource.groupLayersByNameAndTileMatrixSet(layers));
            this.setContent(this.list);
        }

        @Override
        public void setupDialog() {
            super.setupDialog();
            ((JButton)this.buttons.get(0)).setEnabled(false);
            ListSelectionModel selectionModel = this.list.getTable().getSelectionModel();
            selectionModel.addListSelectionListener(e -> ((JButton)this.buttons.get(0)).setEnabled(!selectionModel.isSelectionEmpty()));
        }

        public DefaultLayer getSelectedLayer() {
            Layer selectedLayer = this.list.getSelectedLayer();
            return selectedLayer == null ? null : new DefaultLayer(ImageryInfo.ImageryType.WMTS, selectedLayer.identifier, selectedLayer.style, selectedLayer.tileMatrixSet.identifier);
        }
    }

    public static class WMTSGetCapabilitiesException
    extends Exception {
        public WMTSGetCapabilitiesException(String cause) {
            super(cause);
        }

        public WMTSGetCapabilitiesException(String cause, Throwable t) {
            super(cause, t);
        }
    }

    public static class Layer {
        private String format;
        private String identifier;
        private String title;
        private TileMatrixSet tileMatrixSet;
        private String baseUrl;
        private String style;
        private BBox bbox;
        private final Collection<String> tileMatrixSetLinks = new ArrayList<String>();
        private final Collection<Dimension> dimensions = new ArrayList<Dimension>();

        Layer(Layer l) {
            Objects.requireNonNull(l);
            this.format = l.format;
            this.identifier = l.identifier;
            this.title = l.title;
            this.baseUrl = l.baseUrl;
            this.style = l.style;
            this.bbox = l.bbox;
            this.tileMatrixSet = new TileMatrixSet(l.tileMatrixSet);
            this.dimensions.addAll(l.dimensions);
        }

        Layer() {
        }

        public String getUserTitle() {
            return this.title != null ? this.title : this.identifier;
        }

        public String toString() {
            return "Layer [identifier=" + this.identifier + ", title=" + this.title + ", tileMatrixSet=" + this.tileMatrixSet + ", baseUrl=" + this.baseUrl + ", style=" + this.style + ']';
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public String getStyle() {
            return this.style;
        }

        public TileMatrixSet getTileMatrixSet() {
            return this.tileMatrixSet;
        }

        public int getMaxZoom() {
            return this.tileMatrixSet != null ? this.tileMatrixSet.getMaxZoom() : 0;
        }

        public BBox getBbox() {
            return this.bbox;
        }
    }

    private static class Dimension {
        private String identifier;
        private String defaultValue;
        private final List<String> values = new ArrayList<String>();

        private Dimension() {
        }
    }

    public static class TileMatrixSet {
        private final List<TileMatrix> tileMatrix;
        private final String crs;
        private final String identifier;

        TileMatrixSet(TileMatrixSet tileMatrixSet) {
            if (tileMatrixSet != null) {
                this.tileMatrix = new ArrayList<TileMatrix>(tileMatrixSet.tileMatrix);
                this.crs = tileMatrixSet.crs;
                this.identifier = tileMatrixSet.identifier;
            } else {
                this.tileMatrix = Collections.emptyList();
                this.crs = null;
                this.identifier = null;
            }
        }

        TileMatrixSet(TileMatrixSetBuilder builder) {
            this.tileMatrix = new ArrayList<TileMatrix>(builder.tileMatrix);
            this.crs = builder.crs;
            this.identifier = builder.identifier;
        }

        public String toString() {
            return "TileMatrixSet [crs=" + this.crs + ", identifier=" + this.identifier + ']';
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public String getCrs() {
            return this.crs;
        }

        public int getMaxZoom() {
            return this.tileMatrix.size() - 1;
        }
    }

    private static class TileMatrixSetBuilder {
        SortedSet<TileMatrix> tileMatrix = new TreeSet<TileMatrix>((o1, o2) -> -1 * Double.compare(((TileMatrix)o1).scaleDenominator, ((TileMatrix)o2).scaleDenominator));
        private String crs;
        private String identifier;

        private TileMatrixSetBuilder() {
        }

        TileMatrixSet build() {
            return new TileMatrixSet(this);
        }
    }

    private static class TileMatrix {
        private String identifier;
        private double scaleDenominator;
        private EastNorth topLeftCorner;
        private int tileWidth;
        private int tileHeight;
        private int matrixWidth = -1;
        private int matrixHeight = -1;

        private TileMatrix() {
        }
    }
}

