/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import com.kitfox.svg.SVGDiagram;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.GuiSizesHelper;
import org.openstreetmap.josm.tools.HiDPISupport;
import org.openstreetmap.josm.tools.ImageOverlay;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;

public class ImageResource {
    private final Map<Dimension, BufferedImage> imgCache = new ConcurrentHashMap<Dimension, BufferedImage>(4);
    private SVGDiagram svg;
    public static final Dimension DEFAULT_DIMENSION = new Dimension(-1, -1);
    protected List<ImageOverlay> overlayInfo;
    protected boolean isDisabled;
    private Image baseImage;

    public ImageResource(Image img) {
        CheckParameterUtil.ensureParameterNotNull(img);
        this.baseImage = img;
    }

    public ImageResource(SVGDiagram svg) {
        CheckParameterUtil.ensureParameterNotNull(svg);
        this.svg = svg;
    }

    public ImageResource(ImageResource res, List<ImageOverlay> overlayInfo) {
        this.svg = res.svg;
        this.baseImage = res.baseImage;
        this.overlayInfo = overlayInfo;
    }

    public ImageResource setDisabled(boolean disabled) {
        this.isDisabled = disabled;
        return this;
    }

    public void attachImageIcon(AbstractAction a) {
        Dimension iconDimension = ImageProvider.ImageSizes.SMALLICON.getImageDimension();
        ImageIcon icon = this.getImageIconBounded(iconDimension);
        a.putValue("SmallIcon", icon);
        iconDimension = ImageProvider.ImageSizes.LARGEICON.getImageDimension();
        icon = this.getImageIconBounded(iconDimension);
        a.putValue("SwingLargeIconKey", icon);
    }

    public void attachImageIcon(AbstractAction a, boolean attachImageResource) {
        this.attachImageIcon(a);
        if (attachImageResource) {
            a.putValue("ImageResource", this);
        }
    }

    public ImageIcon getImageIcon() {
        return this.getImageIcon(DEFAULT_DIMENSION);
    }

    public ImageIcon getImageIcon(Dimension dim) {
        return this.getImageIcon(dim, true);
    }

    public ImageIcon getImageIcon(Dimension dim, boolean multiResolution) {
        CheckParameterUtil.ensureThat(!(dim.width <= 0 && dim.width != -1 || dim.height <= 0 && dim.height != -1), () -> dim + " is invalid");
        BufferedImage img = this.imgCache.get(dim);
        if (img == null) {
            if (this.svg != null) {
                Dimension realDim = GuiSizesHelper.getDimensionDpiAdjusted(dim);
                img = ImageProvider.createImageFromSvg(this.svg, realDim);
                if (img == null) {
                    return null;
                }
            } else {
                if (this.baseImage == null) {
                    throw new AssertionError();
                }
                int realWidth = GuiSizesHelper.getSizeDpiAdjusted(dim.width);
                int realHeight = GuiSizesHelper.getSizeDpiAdjusted(dim.height);
                ImageIcon icon = new ImageIcon(this.baseImage);
                if (realWidth == -1 && realHeight == -1) {
                    realWidth = GuiSizesHelper.getSizeDpiAdjusted(icon.getIconWidth());
                    realHeight = GuiSizesHelper.getSizeDpiAdjusted(icon.getIconHeight());
                } else if (realWidth == -1) {
                    realWidth = Math.max(1, icon.getIconWidth() * realHeight / icon.getIconHeight());
                } else if (realHeight == -1) {
                    realHeight = Math.max(1, icon.getIconHeight() * realWidth / icon.getIconWidth());
                }
                Image i = icon.getImage().getScaledInstance(realWidth, realHeight, 4);
                img = new BufferedImage(realWidth, realHeight, 2);
                img.getGraphics().drawImage(i, 0, 0, null);
            }
            if (this.overlayInfo != null) {
                for (ImageOverlay o : this.overlayInfo) {
                    o.process(img);
                }
            }
            if (this.isDisabled) {
                Icon disabledIcon = UIManager.getLookAndFeel().getDisabledIcon(null, new ImageIcon(img));
                if (disabledIcon == null) {
                    return null;
                }
                img = new BufferedImage(img.getWidth(), img.getHeight(), 6);
                disabledIcon.paintIcon(new JPanel(), img.getGraphics(), 0, 0);
            }
            this.imgCache.put(dim, img);
        }
        if (!multiResolution) {
            return new ImageIcon(img);
        }
        try {
            Image mrImg = HiDPISupport.getMultiResolutionImage(img, this);
            return new ImageIcon(mrImg);
        }
        catch (NoClassDefFoundError e) {
            Logging.trace(e);
            return new ImageIcon(img);
        }
    }

    public ImageIcon getImageIconBounded(Dimension maxSize) {
        return this.getImageIconBounded(maxSize, true);
    }

    public ImageIcon getImageIconBounded(Dimension maxSize, boolean multiResolution) {
        float sourceHeight;
        float sourceWidth;
        CheckParameterUtil.ensureThat(!(maxSize.width <= 0 && maxSize.width != -1 || maxSize.height <= 0 && maxSize.height != -1), () -> maxSize + " is invalid");
        int maxWidth = maxSize.width;
        int maxHeight = maxSize.height;
        if (this.svg != null) {
            sourceWidth = this.svg.getWidth();
            sourceHeight = this.svg.getHeight();
        } else {
            if (this.baseImage == null) {
                throw new AssertionError();
            }
            ImageIcon icon = new ImageIcon(this.baseImage);
            sourceWidth = icon.getIconWidth();
            sourceHeight = icon.getIconHeight();
            if (sourceWidth <= (float)maxWidth) {
                maxWidth = -1;
            }
            if (sourceHeight <= (float)maxHeight) {
                maxHeight = -1;
            }
        }
        if (maxWidth == -1 && maxHeight == -1) {
            return this.getImageIcon(DEFAULT_DIMENSION, multiResolution);
        }
        if (maxWidth == -1) {
            return this.getImageIcon(new Dimension(-1, maxHeight), multiResolution);
        }
        if (maxHeight == -1) {
            return this.getImageIcon(new Dimension(maxWidth, -1), multiResolution);
        }
        if (sourceWidth / (float)maxWidth > sourceHeight / (float)maxHeight) {
            return this.getImageIcon(new Dimension(maxWidth, -1), multiResolution);
        }
        return this.getImageIcon(new Dimension(-1, maxHeight), multiResolution);
    }

    public ImageIcon getPaddedIcon(Dimension iconSize) {
        Dimension cacheKey = new Dimension(-iconSize.width, -iconSize.height);
        BufferedImage image = this.imgCache.get(cacheKey);
        if (image == null) {
            image = ImageProvider.createPaddedIcon(this.getImageIcon().getImage(), iconSize);
            this.imgCache.put(cacheKey, image);
        }
        return new ImageIcon(image);
    }

    public String toString() {
        return "ImageResource [" + (this.svg != null ? "svg=" + this.svg : "") + (this.baseImage != null ? "baseImage=" + this.baseImage : "") + ']';
    }
}

