/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonReader;
import javax.json.JsonValue;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.Utils;

public final class Tag2Link {
    static final MultiMap<String, String> wikidataRules = new MultiMap();
    static final Map<String, UnaryOperator<String>> valueFormatter = Collections.singletonMap("ref:bag", v -> String.format("%16s", v).replace(' ', '0'));
    static final String languagePattern = LanguageInfo.getLanguageCodes(null).stream().map(Pattern::quote).collect(Collectors.joining("|"));

    private Tag2Link() {
    }

    public static void initialize() {
        try {
            wikidataRules.clear();
            Tag2Link.fetchRulesViaSPARQL("resource://data/tag2link.wikidata.sparql", Config.getUrls().getJOSMWebsite() + "/remote/wikidata-sparql");
            Tag2Link.fetchRulesViaSPARQL("resource://data/tag2link.sophox.sparql", Config.getUrls().getJOSMWebsite() + "/remote/sophox-sparql");
        }
        catch (Exception e) {
            Logging.error("Failed to initialize tag2link rules");
            Logging.error(e);
        }
    }

    private static void fetchRulesViaSPARQL(String query, String server) throws IOException {
        JsonArray rules;
        String sparql;
        int initialSize = wikidataRules.size();
        try (CachedFile cachedFile = new CachedFile(query);){
            sparql = new String(cachedFile.getByteContent(), StandardCharsets.UTF_8);
        }
        try (CachedFile cachedFile = new CachedFile(server + "?query=" + Utils.encodeUrl(sparql));
             BufferedReader reader = cachedFile.setHttpAccept("application/json").getContentReader();
             JsonReader jsonReader = Json.createReader(reader);){
            rules = jsonReader.read().asJsonObject().getJsonObject("results").getJsonArray("bindings");
        }
        for (JsonValue rule : rules) {
            String key = rule.asJsonObject().getJsonObject("OSM_key").getString("value");
            String url = rule.asJsonObject().getJsonObject("formatter_URL").getString("value");
            if (!key.startsWith("Key:")) continue;
            wikidataRules.put(key.substring("Key:".length()), url);
        }
        Stream.of("image", "url", "website", "wikidata", "wikimedia_commons").forEach(wikidataRules::remove);
        int size = wikidataRules.size() - initialSize;
        Logging.info(I18n.trn("Obtained {0} Tag2Link rule from {1}", "Obtained {0} Tag2Link rules from {1}", size, size, server));
    }

    public static void getLinksForTag(String key, String value, LinkConsumer linkConsumer) {
        String validURL;
        if (value == null || value.isEmpty()) {
            return;
        }
        if (key.matches("^(.+[:_])?name([:_]" + languagePattern + ")?$")) {
            linkConsumer.acceptLink(I18n.tr("Search on DuckDuckGo", new Object[0]), "https://duckduckgo.com/?q=" + value);
        }
        String string = value.startsWith("http:") || value.startsWith("https:") ? value : (validURL = value.startsWith("www.") ? "http://" + value : null);
        if (key.matches("^(.+[:_])?website([:_].+)?$") && validURL != null) {
            linkConsumer.acceptLink(Tag2Link.getLinkName(validURL, key), validURL);
        }
        if (key.matches("^(.+[:_])?source([:_].+)?$") && validURL != null) {
            linkConsumer.acceptLink(Tag2Link.getLinkName(validURL, key), validURL);
        }
        if (key.matches("^(.+[:_])?url([:_].+)?$") && validURL != null) {
            linkConsumer.acceptLink(Tag2Link.getLinkName(validURL, key), validURL);
        }
        if (key.matches("image") && validURL != null) {
            linkConsumer.acceptLink(I18n.tr("View image", new Object[0]), validURL);
        }
        Matcher keyMatcher = Pattern.compile("wikipedia(:(?<lang>\\p{Lower}{2,}))?").matcher(key);
        Matcher valueMatcher = Pattern.compile("((?<lang>\\p{Lower}{2,}):)?(?<article>.*)").matcher(value);
        if (keyMatcher.matches() && valueMatcher.matches()) {
            String lang = Utils.firstNotEmptyString("en", keyMatcher.group("lang"), valueMatcher.group("lang"));
            linkConsumer.acceptLink(I18n.tr("View Wikipedia article", new Object[0]), "https://" + lang + ".wikipedia.org/wiki/" + valueMatcher.group("article"));
        }
        if (key.matches("(.*:)?wikidata")) {
            OsmUtils.splitMultipleValues(value).forEach(q -> linkConsumer.acceptLink(I18n.tr("View Wikidata item", new Object[0]), "https://www.wikidata.org/wiki/" + q));
        }
        if (key.matches("(.*:)?species")) {
            String url = "https://species.wikimedia.org/wiki/" + value;
            linkConsumer.acceptLink(Tag2Link.getLinkName(url, key), url);
        }
        if (key.matches("wikimedia_commons|image") && value.matches("(?i:File):.*")) {
            linkConsumer.acceptLink(I18n.tr("View image on Wikimedia Commons", new Object[0]), "https://commons.wikimedia.org/wiki/" + value);
        }
        if (key.matches("wikimedia_commons|image") && value.matches("(?i:Category):.*")) {
            linkConsumer.acceptLink(I18n.tr("View category on Wikimedia Commons", new Object[0]), "https://commons.wikimedia.org/wiki/" + value);
        }
        wikidataRules.getValues(key).forEach(urlFormatter -> {
            String formattedValue = (String)valueFormatter.getOrDefault(key, x -> x).apply(value);
            String url = urlFormatter.replace("$1", formattedValue);
            linkConsumer.acceptLink(Tag2Link.getLinkName(url, key), url);
        });
    }

    private static String getLinkName(String url, String fallback) {
        try {
            return I18n.tr("Open {0}", new URL(url).getHost());
        }
        catch (MalformedURLException e) {
            return I18n.tr("Open {0}", fallback);
        }
    }

    @FunctionalInterface
    public static interface LinkConsumer {
        public void acceptLink(String var1, String var2);
    }
}

