/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Optional;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JToggleButton;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.gui.HideableButton;
import org.openstreetmap.josm.gui.ShowHideButtonListener;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.Destroyable;

public class IconToggleButton
extends JToggleButton
implements HideableButton,
PropertyChangeListener,
Destroyable,
ExpertToggleAction.ExpertModeChangeListener {
    private transient ShowHideButtonListener listener;
    private boolean hideIfDisabled;
    private boolean isExpert;

    public IconToggleButton(Action action) {
        this(action, false);
    }

    public IconToggleButton(Action action, boolean isExpert) {
        super(action);
        CheckParameterUtil.ensureParameterNotNull(action, "action");
        this.isExpert = isExpert;
        this.setText(null);
        Object o = action.getValue("ShortDescription");
        if (o != null) {
            this.setToolTipText(o.toString());
        }
        action.addPropertyChangeListener(this);
        ExpertToggleAction.addExpertModeChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("active".equals(evt.getPropertyName())) {
            this.setSelected((Boolean)evt.getNewValue());
            this.requestFocusInWindow();
        } else if ("selected".equals(evt.getPropertyName())) {
            this.setSelected((Boolean)evt.getNewValue());
        }
    }

    @Override
    public void destroy() {
        Action action = this.getAction();
        if (action instanceof Destroyable) {
            ((Destroyable)((Object)action)).destroy();
        }
        if (action != null) {
            action.removePropertyChangeListener(this);
        }
    }

    String getPreferenceKey() {
        String s = (String)this.getSafeActionValue("toolbar");
        if (s == null && this.getAction() != null) {
            s = this.getAction().getClass().getName();
        }
        return "sidetoolbar.hidden." + s;
    }

    @Override
    public void expertChanged(boolean isExpert) {
        this.applyButtonHiddenPreferences();
    }

    @Override
    public void applyButtonHiddenPreferences() {
        boolean alwaysHideDisabled = Config.getPref().getBoolean("sidetoolbar.hideDisabledButtons", false);
        if (!this.isEnabled() && (this.hideIfDisabled || alwaysHideDisabled)) {
            this.setVisible(false);
        } else {
            boolean hiddenFlag = false;
            String hiddenFlagStr = Config.getPref().get(this.getPreferenceKey(), null);
            if (hiddenFlagStr == null) {
                if (this.isExpert && !ExpertToggleAction.isExpert()) {
                    hiddenFlag = true;
                }
            } else {
                hiddenFlag = Boolean.parseBoolean(hiddenFlagStr);
            }
            this.setVisible(!hiddenFlag);
        }
    }

    @Override
    public void setButtonHidden(boolean b) {
        this.setVisible(!b);
        if (this.listener != null) {
            if (!b) {
                this.listener.buttonShown();
            } else {
                this.listener.buttonHidden();
            }
        }
        if (b && this.isExpert && !ExpertToggleAction.isExpert() || !b && this.isExpert && ExpertToggleAction.isExpert()) {
            Config.getPref().put(this.getPreferenceKey(), null);
        } else {
            Config.getPref().putBoolean(this.getPreferenceKey(), b);
        }
    }

    public void setAutoHideDisabledButton(boolean b) {
        this.hideIfDisabled = b;
        if (b && !this.isEnabled()) {
            this.setVisible(false);
        }
    }

    @Override
    public void showButton() {
        this.setButtonHidden(false);
    }

    @Override
    public void hideButton() {
        this.setButtonHidden(true);
    }

    @Override
    public String getActionName() {
        return (String)this.getSafeActionValue("Name");
    }

    @Override
    public Icon getIcon() {
        return (Icon)Optional.ofNullable(this.getSafeActionValue("SwingLargeIconKey")).orElseGet(() -> this.getSafeActionValue("SmallIcon"));
    }

    @Override
    public boolean isButtonVisible() {
        return this.isVisible();
    }

    @Override
    public boolean isExpert() {
        return this.isExpert;
    }

    @Override
    public void setShowHideButtonListener(ShowHideButtonListener l) {
        this.listener = l;
    }

    protected final Object getSafeActionValue(String key) {
        return this.getAction() != null ? this.getAction().getValue(key) : null;
    }
}

