/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.io.ChangesetCommentModel;
import org.openstreetmap.josm.gui.io.ChangesetReviewModel;
import org.openstreetmap.josm.gui.io.UploadParameterSummaryPanel;
import org.openstreetmap.josm.gui.io.UploadTextComponentValidator;
import org.openstreetmap.josm.gui.widgets.HistoryComboBox;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class BasicUploadSettingsPanel
extends JPanel {
    public static final String HISTORY_KEY = "upload.comment.history";
    public static final String HISTORY_LAST_USED_KEY = "upload.comment.last-used";
    public static final String HISTORY_MAX_AGE_KEY = "upload.comment.max-age";
    public static final String SOURCE_HISTORY_KEY = "upload.source.history";
    private final HistoryComboBox hcbUploadComment = new HistoryComboBox();
    private final HistoryComboBox hcbUploadSource = new HistoryComboBox();
    private final transient JCheckBox obtainSourceAutomatically = new JCheckBox(I18n.tr("Automatically obtain source from current layers", new Object[0]));
    private final UploadParameterSummaryPanel pnlUploadParameterSummary = new UploadParameterSummaryPanel();
    private final JCheckBox cbRequestReview = new JCheckBox(I18n.tr("I would like someone to review my edits.", new Object[0]));
    private final JLabel areaValidatorFeedback = new JLabel();
    private final UploadTextComponentValidator.UploadAreaValidator areaValidator = new UploadTextComponentValidator.UploadAreaValidator((JTextComponent)new JTextField(), this.areaValidatorFeedback);
    private final transient ChangesetCommentModel changesetCommentModel;
    private final transient ChangesetCommentModel changesetSourceModel;
    private final transient ChangesetReviewModel changesetReviewModel;
    private final transient JLabel uploadCommentFeedback = new JLabel();
    private final transient UploadTextComponentValidator.UploadCommentValidator uploadCommentValidator = new UploadTextComponentValidator.UploadCommentValidator((JTextComponent)this.hcbUploadComment.getEditorComponent(), this.uploadCommentFeedback);
    private final transient JLabel hcbUploadSourceFeedback = new JLabel();
    private final transient UploadTextComponentValidator.UploadSourceValidator uploadSourceValidator = new UploadTextComponentValidator.UploadSourceValidator((JTextComponent)this.hcbUploadSource.getEditorComponent(), this.hcbUploadSourceFeedback);

    protected JPanel buildUploadCommentPanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        pnl.setBorder(BorderFactory.createTitledBorder(I18n.tr("Provide a brief comment for the changes you are uploading:", new Object[0])));
        this.hcbUploadComment.setToolTipText(I18n.tr("Enter an upload comment", new Object[0]));
        this.hcbUploadComment.setMaxTextLength(255);
        BasicUploadSettingsPanel.populateHistoryComboBox(this.hcbUploadComment, HISTORY_KEY, new LinkedList<String>());
        CommentModelListener commentModelListener = new CommentModelListener(this.hcbUploadComment, this.changesetCommentModel);
        this.hcbUploadComment.getEditor().addActionListener(commentModelListener);
        this.hcbUploadComment.getEditorComponent().addFocusListener(commentModelListener);
        pnl.add((Component)this.hcbUploadComment, GBC.eol().fill(2));
        pnl.add((Component)this.uploadCommentFeedback, GBC.eol().insets(0, 3, 0, 0).fill(2));
        return pnl;
    }

    protected JPanel buildUploadSourcePanel() {
        JPanel pnl = new JPanel(new GridBagLayout());
        pnl.setBorder(BorderFactory.createTitledBorder(I18n.tr("Specify the data source for the changes", new Object[0])));
        JMultilineLabel obtainSourceOnce = new JMultilineLabel("<html>(<a href=\"urn:changeset-source\">" + I18n.tr("just once", new Object[0]) + "</a>)</html>");
        obtainSourceOnce.addHyperlinkListener(e -> {
            if (HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType())) {
                this.automaticallyAddSource();
            }
        });
        this.obtainSourceAutomatically.setSelected(Config.getPref().getBoolean("upload.source.obtainautomatically", false));
        this.obtainSourceAutomatically.addActionListener(e -> {
            if (this.obtainSourceAutomatically.isSelected()) {
                this.automaticallyAddSource();
            }
            obtainSourceOnce.setVisible(!this.obtainSourceAutomatically.isSelected());
        });
        JPanel obtainSource = new JPanel(new GridBagLayout());
        obtainSource.add((Component)this.obtainSourceAutomatically, GBC.std().anchor(17));
        obtainSource.add((Component)obtainSourceOnce, GBC.std().anchor(17));
        obtainSource.add((Component)new JLabel(), GBC.eol().fill(2));
        if (Config.getPref().getBoolean("upload.show.automatic.source", true)) {
            pnl.add((Component)obtainSource, GBC.eol().insets(0, 0, 10, 3).fill(2));
        }
        this.hcbUploadSource.setToolTipText(I18n.tr("Enter a source", new Object[0]));
        this.hcbUploadSource.setMaxTextLength(255);
        BasicUploadSettingsPanel.populateHistoryComboBox(this.hcbUploadSource, SOURCE_HISTORY_KEY, BasicUploadSettingsPanel.getDefaultSources());
        CommentModelListener sourceModelListener = new CommentModelListener(this.hcbUploadSource, this.changesetSourceModel);
        this.hcbUploadSource.getEditor().addActionListener(sourceModelListener);
        this.hcbUploadSource.getEditorComponent().addFocusListener(sourceModelListener);
        pnl.add((Component)this.hcbUploadSource, GBC.eol().fill(2));
        pnl.add((Component)this.hcbUploadSourceFeedback, GBC.eol().insets(0, 3, 0, 0).fill(2));
        if (this.obtainSourceAutomatically.isSelected()) {
            this.automaticallyAddSource();
        }
        pnl.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                if (BasicUploadSettingsPanel.this.obtainSourceAutomatically.isSelected()) {
                    BasicUploadSettingsPanel.this.automaticallyAddSource();
                }
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
        return pnl;
    }

    protected void automaticallyAddSource() {
        String source = MainApplication.getMap().mapView.getLayerInformationForSourceTag();
        this.hcbUploadSource.setText(Utils.shortenString(source, 255));
        this.changesetSourceModel.setComment(this.hcbUploadSource.getText());
    }

    protected void refreshHistoryComboBoxes() {
        BasicUploadSettingsPanel.populateHistoryComboBox(this.hcbUploadComment, HISTORY_KEY, new LinkedList<String>());
        BasicUploadSettingsPanel.populateHistoryComboBox(this.hcbUploadSource, SOURCE_HISTORY_KEY, BasicUploadSettingsPanel.getDefaultSources());
    }

    private static void populateHistoryComboBox(HistoryComboBox hcb, String historyKey, List<String> defaultValues) {
        hcb.setPossibleItemsTopDown(Config.getPref().getList(historyKey, defaultValues));
        hcb.discardAllUndoableEdits();
    }

    protected void discardAllUndoableEdits() {
        this.hcbUploadComment.discardAllUndoableEdits();
        this.hcbUploadSource.discardAllUndoableEdits();
    }

    public static List<String> getDefaultSources() {
        return Arrays.asList("knowledge", "survey", "Bing");
    }

    protected void build() {
        JPanel pnl;
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.add(this.buildUploadCommentPanel());
        this.add(this.buildUploadSourcePanel());
        this.add(this.pnlUploadParameterSummary);
        if (Config.getPref().getBoolean("upload.show.review.request", true)) {
            pnl = new JPanel(new GridBagLayout());
            pnl.add((Component)this.cbRequestReview, GBC.eol().fill(2));
            this.add(pnl);
            this.cbRequestReview.addItemListener(e -> this.changesetReviewModel.setReviewRequested(e.getStateChange() == 1));
        }
        pnl = new JPanel(new GridBagLayout());
        pnl.add((Component)this.areaValidatorFeedback, GBC.eol().fill(2));
        this.add(pnl);
    }

    public BasicUploadSettingsPanel(ChangesetCommentModel changesetCommentModel, ChangesetCommentModel changesetSourceModel, ChangesetReviewModel changesetReviewModel) {
        this.changesetCommentModel = Objects.requireNonNull(changesetCommentModel, "changesetCommentModel");
        this.changesetSourceModel = Objects.requireNonNull(changesetSourceModel, "changesetSourceModel");
        this.changesetReviewModel = Objects.requireNonNull(changesetReviewModel, "changesetReviewModel");
        changesetCommentModel.addChangeListener(new ChangesetCommentChangeListener(this.hcbUploadComment));
        changesetSourceModel.addChangeListener(new ChangesetCommentChangeListener(this.hcbUploadSource));
        changesetReviewModel.addChangeListener(new ChangesetReviewChangeListener());
        this.build();
    }

    void setUploadTagDownFocusTraversalHandlers(ActionListener handler) {
        BasicUploadSettingsPanel.setHistoryComboBoxDownFocusTraversalHandler(handler, this.hcbUploadComment);
        BasicUploadSettingsPanel.setHistoryComboBoxDownFocusTraversalHandler(handler, this.hcbUploadSource);
    }

    private static void setHistoryComboBoxDownFocusTraversalHandler(ActionListener handler, HistoryComboBox hcb) {
        hcb.getEditor().addActionListener(handler);
        hcb.getEditorComponent().addKeyListener(new HistoryComboBoxKeyAdapter(hcb, handler));
    }

    public void rememberUserInput() {
        if (BasicUploadSettingsPanel.getHistoryMaxAgeKey() > 0L) {
            this.hcbUploadComment.addCurrentItemToHistory();
            Config.getPref().putList(HISTORY_KEY, this.hcbUploadComment.getHistory());
            Config.getPref().putLong(HISTORY_LAST_USED_KEY, TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis()));
        }
        this.hcbUploadSource.addCurrentItemToHistory();
        Config.getPref().putList(SOURCE_HISTORY_KEY, this.hcbUploadSource.getHistory());
        Config.getPref().putBoolean("upload.source.obtainautomatically", this.obtainSourceAutomatically.isSelected());
    }

    public void startUserInput() {
        this.hcbUploadComment.requestFocusInWindow();
        this.hcbUploadComment.getEditorComponent().requestFocusInWindow();
        this.uploadCommentValidator.validate();
        this.uploadSourceValidator.validate();
    }

    public void initEditingOfUploadComment() {
        this.hcbUploadComment.getEditor().selectAll();
        this.hcbUploadComment.requestFocusInWindow();
    }

    public void initEditingOfUploadSource() {
        this.hcbUploadSource.getEditor().selectAll();
        this.hcbUploadSource.requestFocusInWindow();
    }

    void setUploadedPrimitives(List<OsmPrimitive> primitives) {
        this.areaValidator.computeArea(primitives);
    }

    public UploadParameterSummaryPanel getUploadParameterSummaryPanel() {
        return this.pnlUploadParameterSummary;
    }

    public void forceUpdateActiveField() {
        BasicUploadSettingsPanel.updateModelIfFocused(this.hcbUploadComment, this.changesetCommentModel);
        BasicUploadSettingsPanel.updateModelIfFocused(this.hcbUploadSource, this.changesetSourceModel);
    }

    private static void updateModelIfFocused(HistoryComboBox hcb, ChangesetCommentModel changesetModel) {
        if (hcb.getEditorComponent().hasFocus()) {
            changesetModel.setComment(hcb.getText());
        }
    }

    static long getHistoryMaxAgeKey() {
        return Config.getPref().getLong(HISTORY_MAX_AGE_KEY, TimeUnit.HOURS.toSeconds(4L));
    }

    static long getHistoryLastUsedKey() {
        return Config.getPref().getLong(HISTORY_LAST_USED_KEY, 0L);
    }

    class ChangesetReviewChangeListener
    implements ChangeListener {
        ChangesetReviewChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (!(e.getSource() instanceof ChangesetReviewModel)) {
                return;
            }
            boolean newState = ((ChangesetReviewModel)e.getSource()).isReviewRequested();
            if (BasicUploadSettingsPanel.this.cbRequestReview.isSelected() != newState) {
                BasicUploadSettingsPanel.this.cbRequestReview.setSelected(newState);
            }
        }
    }

    static class ChangesetCommentChangeListener
    implements ChangeListener {
        private final HistoryComboBox destination;

        ChangesetCommentChangeListener(HistoryComboBox destination) {
            this.destination = destination;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (!(e.getSource() instanceof ChangesetCommentModel)) {
                return;
            }
            String newComment = ((ChangesetCommentModel)e.getSource()).getComment();
            if (!this.destination.getText().equals(newComment)) {
                this.destination.setText(newComment);
            }
        }
    }

    static class CommentModelListener
    extends FocusAdapter
    implements ActionListener {
        private final HistoryComboBox source;
        private final ChangesetCommentModel destination;

        CommentModelListener(HistoryComboBox source, ChangesetCommentModel destination) {
            this.source = source;
            this.destination = destination;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.destination.setComment(this.source.getText());
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.destination.setComment(this.source.getText());
        }
    }

    static final class HistoryComboBoxKeyAdapter
    extends KeyAdapter {
        private final HistoryComboBox hcb;
        private final ActionListener handler;

        HistoryComboBoxKeyAdapter(HistoryComboBox hcb, ActionListener handler) {
            this.hcb = hcb;
            this.handler = handler;
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (e.getKeyCode() == 9) {
                this.handler.actionPerformed(new ActionEvent(this.hcb, 0, "focusDown"));
            }
        }
    }
}

