/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.coor.conversion.LatLonParser;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.datatransfer.ClipboardUtils;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.gui.widgets.SelectAllOnFocusGainedDecorator;
import org.openstreetmap.josm.io.NameFinder;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.OsmUrlToBounds;
import org.openstreetmap.josm.tools.Shortcut;

public class JumpToAction
extends JosmAction {
    private final JosmTextField url = new JosmTextField();
    private final JosmTextField place = new JosmTextField();
    private final JosmTextField lat = new JosmTextField();
    private final JosmTextField lon = new JosmTextField();
    private final JosmTextField zm = new JosmTextField();

    public JumpToAction() {
        super(I18n.tr("Jump to Position", new Object[0]), "dialogs/position", I18n.tr("Opens a dialog that allows to jump to a specific location", new Object[0]), Shortcut.registerShortcut("tools:jumpto", I18n.tr("Tool: {0}", I18n.tr("Jump to Position", new Object[0])), 74, 5006), true, "action/jumpto", false);
        MainApplication.addMapFrameListener((o, n) -> this.updateEnabledState());
        this.setHelpId(HelpUtil.ht("/Action/JumpToPosition"));
    }

    public void showJumpToDialog() {
        if (!MainApplication.isDisplayingMapView()) {
            return;
        }
        MapView mv = MainApplication.getMap().mapView;
        Optional<Bounds> boundsFromClipboard = Optional.ofNullable(ClipboardUtils.getClipboardStringContent()).map(OsmUrlToBounds::parse);
        if (boundsFromClipboard.isPresent() && Config.getPref().getBoolean("jumpto.use.clipboard", true)) {
            this.setBounds(boundsFromClipboard.get());
            this.place.setText("");
        } else {
            this.setBounds(mv.getState().getViewArea().getCornerBounds());
        }
        this.updateUrl(true);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JLabel("<html>" + I18n.tr("Enter Lat/Lon to jump to position.", new Object[0]) + "<br>" + I18n.tr("You can also paste an URL from www.openstreetmap.org", new Object[0]) + "<br></html>"), "North");
        OsmLonLatListener x = new OsmLonLatListener();
        this.lat.getDocument().addDocumentListener(x);
        this.lon.getDocument().addDocumentListener(x);
        this.zm.getDocument().addDocumentListener(x);
        this.url.getDocument().addDocumentListener(new OsmURLListener());
        SelectAllOnFocusGainedDecorator.decorate(this.place);
        SelectAllOnFocusGainedDecorator.decorate(this.lat);
        SelectAllOnFocusGainedDecorator.decorate(this.lon);
        SelectAllOnFocusGainedDecorator.decorate(this.zm);
        SelectAllOnFocusGainedDecorator.decorate(this.url);
        JPanel p = new JPanel(new GridBagLayout());
        panel.add((Component)p, "North");
        p.add((Component)new JLabel(I18n.tr("Enter a place name to search for", new Object[0])), GBC.eol());
        p.add((Component)this.place, GBC.eol().fill(2));
        p.add((Component)new JSeparator(), GBC.eol().fill(2).insets(3, 5, 3, 5));
        p.add((Component)new JLabel(I18n.tr("Latitude", new Object[0])), GBC.eol());
        p.add((Component)this.lat, GBC.eol().fill(2));
        p.add((Component)new JLabel(I18n.tr("Longitude", new Object[0])), GBC.eol());
        p.add((Component)this.lon, GBC.eol().fill(2));
        p.add((Component)new JLabel(I18n.tr("Zoom (in metres)", new Object[0])), GBC.eol());
        p.add((Component)this.zm, GBC.eol().fill(2));
        p.add((Component)new JSeparator(), GBC.eol().fill(2).insets(3, 5, 3, 5));
        p.add((Component)new JLabel(I18n.tr("URL", new Object[0])), GBC.eol());
        p.add((Component)this.url, GBC.eol().fill(2));
        String[] buttons = new String[]{I18n.tr("Jump there", new Object[0]), I18n.tr("Cancel", new Object[0])};
        LatLon ll = null;
        double zoomLvl = 100.0;
        while (ll == null) {
            int option = new JumpToPositionDialog(buttons, panel).showDialog().getValue();
            if (option != 1) {
                return;
            }
            if (this.place.hasFocus() && !this.place.getText().trim().isEmpty()) {
                try {
                    List<NameFinder.SearchResult> searchResults = NameFinder.queryNominatim(this.place.getText());
                    if (!searchResults.isEmpty()) {
                        NameFinder.SearchResult searchResult = searchResults.get(0);
                        new Notification(I18n.tr("Jumping to: {0}", searchResult.getName())).setIcon(1).show();
                        mv.zoomTo(searchResult.getBounds());
                    }
                    return;
                }
                catch (IOException | RuntimeException ex) {
                    Logging.warn(ex);
                }
            }
            try {
                zoomLvl = Double.parseDouble(this.zm.getText());
                ll = new LatLon(Double.parseDouble(this.lat.getText()), Double.parseDouble(this.lon.getText()));
            }
            catch (NumberFormatException ex) {
                try {
                    ll = LatLonParser.parse(this.lat.getText() + "; " + this.lon.getText());
                }
                catch (IllegalArgumentException ex2) {
                    JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("Could not parse Latitude, Longitude or Zoom. Please check.", new Object[0]), I18n.tr("Unable to parse Lon/Lat", new Object[0]), 0);
                }
            }
        }
        double zoomFactor = 1.0 / mv.getDist100Pixel();
        mv.zoomToFactor(mv.getProjection().latlon2eastNorth(ll), zoomFactor * zoomLvl);
    }

    private void parseURL() {
        if (!this.url.hasFocus()) {
            return;
        }
        String urlText = this.url.getText();
        Bounds b = OsmUrlToBounds.parse(urlText);
        this.setBounds(b);
    }

    private void setBounds(Bounds b) {
        if (b != null) {
            LatLon center = b.getCenter();
            this.lat.setText(Double.toString(center.lat()));
            this.lon.setText(Double.toString(center.lon()));
            this.zm.setText(Double.toString(OsmUrlToBounds.getZoom(b)));
        }
    }

    private void updateUrl(boolean force) {
        if (!(this.lat.hasFocus() || this.lon.hasFocus() || this.zm.hasFocus() || force)) {
            return;
        }
        try {
            double dlat = Double.parseDouble(this.lat.getText());
            double dlon = Double.parseDouble(this.lon.getText());
            double zoomLvl = Double.parseDouble(this.zm.getText());
            this.url.setText(OsmUrlToBounds.getURL(dlat, dlon, (int)zoomLvl));
        }
        catch (NumberFormatException e) {
            Logging.debug(e.getMessage());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.showJumpToDialog();
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(MainApplication.isDisplayingMapView());
    }

    class OsmLonLatListener
    implements DocumentListener {
        OsmLonLatListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            JumpToAction.this.updateUrl(false);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            JumpToAction.this.updateUrl(false);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            JumpToAction.this.updateUrl(false);
        }
    }

    class OsmURLListener
    implements DocumentListener {
        OsmURLListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            JumpToAction.this.parseURL();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            JumpToAction.this.parseURL();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            JumpToAction.this.parseURL();
        }
    }

    static class JumpToPositionDialog
    extends ExtendedDialog {
        JumpToPositionDialog(String[] buttons, JPanel panel) {
            super((Component)MainApplication.getMainFrame(), I18n.tr("Jump to Position", new Object[0]), buttons);
            this.setButtonIcons("ok", "cancel");
            this.configureContextsensitiveHelp(HelpUtil.ht("/Action/JumpToPosition"), true);
            this.setContent(panel);
            this.setCancelButton(2);
        }
    }
}

