/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import opennlp.tools.ml.model.AbstractDataIndexer;
import opennlp.tools.ml.model.ComparableEvent;
import opennlp.tools.ml.model.Event;
import opennlp.tools.util.ObjectStream;

public class OnePassDataIndexer
extends AbstractDataIndexer {
    @Override
    public void index(ObjectStream<Event> eventStream) throws IOException {
        int cutoff = this.trainingParameters.getIntParameter("Cutoff", 5);
        boolean sort = this.trainingParameters.getBooleanParameter("sort", true);
        HashMap<String, Integer> predicateIndex = new HashMap<String, Integer>();
        this.display("Indexing events using cutoff of " + cutoff + "\n\n");
        this.display("\tComputing event counts...  ");
        List<Event> events = this.computeEventCounts(eventStream, predicateIndex, cutoff);
        this.display("done. " + events.size() + " events\n");
        this.display("\tIndexing...  ");
        List<ComparableEvent> eventsToCompare = this.index(events, predicateIndex);
        events = null;
        predicateIndex = null;
        this.display("done.\n");
        this.display("Sorting and merging events... ");
        this.sortAndMerge(eventsToCompare, sort);
        this.display("Done indexing.\n");
    }

    private List<Event> computeEventCounts(ObjectStream<Event> eventStream, Map<String, Integer> predicatesInOut, int cutoff) throws IOException {
        Event ev;
        HashSet<String> predicateSet = new HashSet<String>();
        HashMap<String, Integer> counter = new HashMap<String, Integer>();
        LinkedList<Event> events = new LinkedList<Event>();
        while ((ev = eventStream.read()) != null) {
            events.add(ev);
            OnePassDataIndexer.update(ev.getContext(), predicateSet, counter, cutoff);
        }
        this.predCounts = new int[predicateSet.size()];
        int index = 0;
        for (String predicate : predicateSet) {
            this.predCounts[index] = (Integer)counter.get(predicate);
            predicatesInOut.put(predicate, index);
            ++index;
        }
        return events;
    }

    protected List<ComparableEvent> index(List<Event> events, Map<String, Integer> predicateIndex) {
        HashMap<String, Integer> omap = new HashMap<String, Integer>();
        int numEvents = events.size();
        int outcomeCount = 0;
        ArrayList<ComparableEvent> eventsToCompare = new ArrayList<ComparableEvent>(numEvents);
        ArrayList<Integer> indexedContext = new ArrayList<Integer>();
        for (Event ev : events) {
            int ocID;
            String[] econtext = ev.getContext();
            String oc = ev.getOutcome();
            if (omap.containsKey(oc)) {
                ocID = (Integer)omap.get(oc);
            } else {
                ocID = outcomeCount++;
                omap.put(oc, ocID);
            }
            for (String pred : econtext) {
                if (!predicateIndex.containsKey(pred)) continue;
                indexedContext.add(predicateIndex.get(pred));
            }
            if (indexedContext.size() > 0) {
                int[] cons = new int[indexedContext.size()];
                for (int ci = 0; ci < cons.length; ++ci) {
                    cons[ci] = (Integer)indexedContext.get(ci);
                }
                ComparableEvent ce = new ComparableEvent(ocID, cons);
                eventsToCompare.add(ce);
            } else {
                this.display("Dropped event " + ev.getOutcome() + ":" + Arrays.asList(ev.getContext()) + "\n");
            }
            indexedContext.clear();
        }
        this.outcomeLabels = OnePassDataIndexer.toIndexedStringArray(omap);
        this.predLabels = OnePassDataIndexer.toIndexedStringArray(predicateIndex);
        return eventsToCompare;
    }
}

