/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.lm.cache;

import edu.berkeley.nlp.lm.ContextEncodedNgramLanguageModel;
import edu.berkeley.nlp.lm.cache.ContextEncodedLmCache;
import edu.berkeley.nlp.lm.util.Annotations;
import java.util.Arrays;

public final class ContextEncodedDirectMappedLmCache
implements ContextEncodedLmCache {
    private static final long serialVersionUID = 1L;
    private static int pos = 0;
    private static final int VAL_AND_WORD_OFFSET = pos++;
    private static final int CONTEXT_OFFSET = pos++;
    private static final int OUTPUT_CONTEXT_OFFSET = pos++;
    private static final int STRUCT_LENGTH = pos;
    private static int NUM_ORDER_BITS = 4;
    private static int NUM_OFFSETS_BITS = 64 - NUM_ORDER_BITS;
    private static long ORDER_BIT_MASK = (1L << NUM_ORDER_BITS) - 1L << NUM_OFFSETS_BITS;
    private static long OFFSET_BIT_MASK = (1L << NUM_OFFSETS_BITS) - 1L;
    private static long WORD_MASK = -4294967296L;
    private static long FLOAT_MASK = 0xFFFFFFFFL;
    private final long[] threadUnsafeArray;
    private final ThreadLocal<long[]> threadSafeArray;
    private final int cacheSize;
    private final boolean threadSafe;

    public ContextEncodedDirectMappedLmCache(int cacheBits, boolean threadSafe) {
        this.cacheSize = (1 << cacheBits) - 1;
        this.threadSafe = threadSafe;
        if (threadSafe) {
            this.threadUnsafeArray = null;
            this.threadSafeArray = new ThreadLocal<long[]>(){

                @Override
                protected long[] initialValue() {
                    return ContextEncodedDirectMappedLmCache.this.allocCache();
                }
            };
        } else {
            this.threadSafeArray = null;
            this.threadUnsafeArray = this.allocCache();
        }
    }

    private long[] allocCache() {
        long[] array = new long[STRUCT_LENGTH * this.cacheSize];
        Arrays.fill(array, -1L);
        return array;
    }

    @Override
    public float getCached(long contextOffset, int contextOrder, int word, int hash, @Annotations.OutputParameter ContextEncodedNgramLanguageModel.LmContextInfo outputPrefix) {
        long[] array = !this.threadSafe ? this.threadUnsafeArray : this.threadSafeArray.get();
        int cachedWordHere = this.getWord(hash, array);
        if (word >= 0 && word == cachedWordHere && this.getLong(hash, CONTEXT_OFFSET, array) == ContextEncodedDirectMappedLmCache.combine(contextOrder, contextOffset)) {
            float f = this.getVal(hash, array);
            if (outputPrefix == null) {
                return f;
            }
            long outputOrderAndOffset = this.getLong(hash, OUTPUT_CONTEXT_OFFSET, array);
            if (outputOrderAndOffset >= 0L) {
                outputPrefix.order = ContextEncodedDirectMappedLmCache.orderOf(outputOrderAndOffset);
                outputPrefix.offset = ContextEncodedDirectMappedLmCache.offsetOf(outputOrderAndOffset);
                return f;
            }
        }
        return Float.NaN;
    }

    @Override
    public void putCached(long contextOffset, int contextOrder, int word, float score, int hash, @Annotations.OutputParameter ContextEncodedNgramLanguageModel.LmContextInfo outputPrefix) {
        long[] array = !this.threadSafe ? this.threadUnsafeArray : this.threadSafeArray.get();
        this.setWordAndVal(hash, word, score, array);
        this.setOutputContextOrderAndOffset(hash, outputPrefix == null ? -1 : outputPrefix.order, outputPrefix == null ? -1L : outputPrefix.offset, array);
        this.setContextOrderAndOffset(hash, contextOrder, contextOffset, array);
    }

    private static long offsetOf(long key) {
        return key & OFFSET_BIT_MASK;
    }

    private static int orderOf(long key) {
        return (int)((key & ORDER_BIT_MASK) >>> NUM_OFFSETS_BITS);
    }

    private int getWord(int hash, long[] array) {
        return (int)((array[ContextEncodedDirectMappedLmCache.startOfStruct(hash) + VAL_AND_WORD_OFFSET] & WORD_MASK) >>> 32);
    }

    private long getLong(int hash, int off, long[] array) {
        return array[ContextEncodedDirectMappedLmCache.startOfStruct(hash) + off];
    }

    private float getVal(int hash, long[] array) {
        return Float.intBitsToFloat((int)array[ContextEncodedDirectMappedLmCache.startOfStruct(hash) + VAL_AND_WORD_OFFSET]);
    }

    private void setWordAndVal(int hash, int word, float val, long[] array) {
        long together;
        array[ContextEncodedDirectMappedLmCache.startOfStruct((int)hash) + ContextEncodedDirectMappedLmCache.VAL_AND_WORD_OFFSET] = together = this.combineWordAndVal(word, val);
    }

    private long combineWordAndVal(int word, float val) {
        return (long)word << 32 | (long)Float.floatToIntBits(val) & FLOAT_MASK;
    }

    private void setContextOrderAndOffset(int hash, int order, long offset, long[] array) {
        long together = ContextEncodedDirectMappedLmCache.combine(order, offset);
        this.setLong(hash, together, CONTEXT_OFFSET, array);
    }

    private void setOutputContextOrderAndOffset(int hash, int order, long offset, long[] array) {
        long together = ContextEncodedDirectMappedLmCache.combine(order, offset);
        this.setLong(hash, together, OUTPUT_CONTEXT_OFFSET, array);
    }

    private static long combine(int order, long offset) {
        return (long)order << NUM_OFFSETS_BITS | offset;
    }

    private void setLong(int hash, long l, int off, long[] array) {
        array[ContextEncodedDirectMappedLmCache.startOfStruct((int)hash) + off] = l;
    }

    private static int startOfStruct(int hash) {
        return hash * STRUCT_LENGTH;
    }

    @Override
    public int capacity() {
        return this.cacheSize;
    }
}

