/*
 * Decompiled with CFR 0.152.
 */
package net.loomchild.segment.srx.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.loomchild.segment.util.IORuntimeException;
import net.loomchild.segment.util.XmlException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SrxVersion {
    VERSION_1_0("1.0"),
    VERSION_2_0("2.0");

    private static final int HEADER_BUFFER_LENGHT = 1024;
    private static final Pattern VERSION_PATTERN;
    private String versionString;

    private SrxVersion(String versionString) {
        this.versionString = versionString;
    }

    public String toString() {
        return this.versionString;
    }

    public static SrxVersion parse(String versionString) {
        for (SrxVersion version : SrxVersion.values()) {
            if (!version.versionString.equals(versionString)) continue;
            return version;
        }
        throw new XmlException("Unrecognized SRX version: " + versionString + ".");
    }

    public static SrxVersion parse(BufferedReader reader) {
        try {
            if (!reader.markSupported()) {
                throw new IllegalArgumentException("Mark not supported for reader.");
            }
            reader.mark(1024);
            char[] headerBuffer = new char[1024];
            int count = reader.read(headerBuffer);
            String header = new String(headerBuffer, 0, count);
            reader.reset();
            Matcher matcher = VERSION_PATTERN.matcher(header);
            String versionString = null;
            if (matcher.find()) {
                versionString = matcher.group(1);
            }
            return SrxVersion.parse(versionString);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    static {
        VERSION_PATTERN = Pattern.compile("<srx[^>]+version=\"([^\"]+)\"");
    }
}

