char volume_accumulateSamples_iso_frag[] = "#version 110\n"
                                           "\n"
                                           "uniform sampler3D volumeTexture;\n"
                                           "\n"
                                           "uniform float IsoSurfaceValue;\n"
                                           "\n"
                                           "varying vec3 lightDirection;\n"
                                           "\n"
                                           "vec4 accumulateSamples(vec3 ts, vec3 te, vec3 dt, float scale, float cutoff, int num_iterations)\n"
                                           "{\n"
                                           "    vec3 texcoord = te.xyz;\n"
                                           "\n"
                                           "    float normalSampleDistance = length(dt);\n"
                                           "    vec3 deltaX = vec3(normalSampleDistance, 0.0, 0.0);\n"
                                           "    vec3 deltaY = vec3(0.0, normalSampleDistance, 0.0);\n"
                                           "    vec3 deltaZ = vec3(0.0, 0.0, normalSampleDistance);\n"
                                           "\n"
                                           "    vec4 previousColor = texture3D( volumeTexture, texcoord);\n"
                                           "\n"
                                           "    float targetValue = IsoSurfaceValue;\n"
                                           "\n"
                                           "    while(num_iterations>0)\n"
                                           "    {\n"
                                           "        vec4 color = texture3D( volumeTexture, texcoord);\n"
                                           "\n"
                                           "        float m = (previousColor.a-targetValue) * (color.a-targetValue);\n"
                                           "        if (m <= 0.0)\n"
                                           "        {\n"
                                           "            float r = (targetValue-color.a)/(previousColor.a-color.a);\n"
                                           "            texcoord = texcoord - r*dt;\n"
                                           "\n"
                                           "#if 0\n"
                                           "            color = texture3D( volumeTexture, texcoord);\n"
                                           "#else\n"
                                           "            color.r = 1.0;\n"
                                           "            color.g = 1.0;\n"
                                           "            color.b = 1.0;\n"
                                           "            color.a = 1.0;\n"
                                           "#endif\n"
                                           "            float px = texture3D( volumeTexture, texcoord + deltaX).a;\n"
                                           "            float py = texture3D( volumeTexture, texcoord + deltaY).a;\n"
                                           "            float pz = texture3D( volumeTexture, texcoord + deltaZ).a;\n"
                                           "\n"
                                           "            float nx = texture3D( volumeTexture, texcoord - deltaX).a;\n"
                                           "            float ny = texture3D( volumeTexture, texcoord - deltaY).a;\n"
                                           "            float nz = texture3D( volumeTexture, texcoord - deltaZ).a;\n"
                                           "\n"
                                           "            vec3 grad = vec3(px-nx, py-ny, pz-nz);\n"
                                           "            if (grad.x!=0.0 || grad.y!=0.0 || grad.z!=0.0)\n"
                                           "            {\n"
                                           "                vec3 normal = normalize(grad);\n"
                                           "                float lightScale = 0.1 +  max(0.0, dot(normal.xyz, lightDirection))*0.9;\n"
                                           "\n"
                                           "                color.r *= lightScale;\n"
                                           "                color.g *= lightScale;\n"
                                           "                color.b *= lightScale;\n"
                                           "            }\n"
                                           "            return color;\n"
                                           "        }\n"
                                           "\n"
                                           "        previousColor = color;\n"
                                           "\n"
                                           "        texcoord += dt;\n"
                                           "\n"
                                           "        --num_iterations;\n"
                                           "    }\n"
                                           "\n"
                                           "    return vec4(0.0, 0.0, 0.0, 0.0);\n"
                                           "}\n"
                                           "\n";
