char volume_accumulateSamples_lit_frag[] = "#version 110\n"
                                           "\n"
                                           "uniform sampler3D volumeTexture;\n"
                                           "uniform float AlphaFuncValue;\n"
                                           "\n"
                                           "varying vec3 lightDirection;\n"
                                           "\n"
                                           "vec4 accumulateSamples(vec3 ts, vec3 te, vec3 dt, float scale, float cutoff, int num_iterations)\n"
                                           "{\n"
                                           "    vec3 texcoord = te.xyz;\n"
                                           "    vec4 fragColor = vec4(0.0, 0.0, 0.0, 0.0);\n"
                                           "\n"
                                           "    float normalSampleDistance = length(dt);\n"
                                           "    vec3 deltaX = vec3(normalSampleDistance, 0.0, 0.0);\n"
                                           "    vec3 deltaY = vec3(0.0, normalSampleDistance, 0.0);\n"
                                           "    vec3 deltaZ = vec3(0.0, 0.0, normalSampleDistance);\n"
                                           "\n"
                                           "    while(num_iterations>0 && fragColor.a<cutoff)\n"
                                           "    {\n"
                                           "        vec4 color = texture3D( volumeTexture, texcoord);\n"
                                           "\n"
                                           "        if (color.a>AlphaFuncValue)\n"
                                           "        {\n"
                                           "\n"
                                           "            float px = texture3D( volumeTexture, texcoord + deltaX).a;\n"
                                           "            float py = texture3D( volumeTexture, texcoord + deltaY).a;\n"
                                           "            float pz = texture3D( volumeTexture, texcoord + deltaZ).a;\n"
                                           "\n"
                                           "            float nx = texture3D( volumeTexture, texcoord - deltaX).a;\n"
                                           "            float ny = texture3D( volumeTexture, texcoord - deltaY).a;\n"
                                           "            float nz = texture3D( volumeTexture, texcoord - deltaZ).a;\n"
                                           "\n"
                                           "            vec3 grad = vec3(px-nx, py-ny, pz-nz);\n"
                                           "            if (grad.x!=0.0 || grad.y!=0.0 || grad.z!=0.0)\n"
                                           "            {\n"
                                           "                vec3 normal = normalize(grad);\n"
                                           "                float lightScale = 0.1 +  max(0.0, dot(normal.xyz, lightDirection))*0.9;\n"
                                           "\n"
                                           "                color.r *= lightScale;\n"
                                           "                color.g *= lightScale;\n"
                                           "                color.b *= lightScale;\n"
                                           "            }\n"
                                           "\n"
                                           "            float r = color.a * ((1.0-fragColor.a)*scale);\n"
                                           "            fragColor.rgb += color.rgb*r;\n"
                                           "            fragColor.a += r;\n"
                                           "        }\n"
                                           "\n"
                                           "        texcoord += dt;\n"
                                           "\n"
                                           "        --num_iterations;\n"
                                           "    }\n"
                                           "\n"
                                           "    if (num_iterations>0) fragColor.a = 1.0;\n"
                                           "\n"
                                           "    return fragColor;\n"
                                           "}\n"
                                           "\n";
