/* 
 * STDragWebView
 * This is a modified version of Adium's ESWebView used to enable ordinary drag and drop on WebViews
 *
 * Changes are copyright (C) 2010 Sveinbjorn Thordarson <sveinbjornt@simnet.is>
 *
 * Adium source code is protected by the copyright of its respective developers.
 * 
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU
 * General Public License as published by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
 * Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along with this program; if not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#import "STDragWebView.h"

@implementation STDragWebView

- (id)initWithFrame:(NSRect)frameRect frameName:(NSString *)frameName groupName:(NSString *)groupName
{
	if ((self = [super initWithFrame:frameRect frameName:frameName groupName:groupName]))
		draggingDelegate = NULL;
	
	return self;
}

//Accepting Drags ------------------------------------------------------------------------------------------------------
#pragma mark Accepting Drags

- (NSDragOperation)draggingEntered:(id <NSDraggingInfo>)sender
{
	if (draggingDelegate && [draggingDelegate respondsToSelector:@selector(draggingEntered:)]) 
		return [draggingDelegate draggingEntered:sender];
	else
		return [super draggingEntered:sender];
}

- (void)draggingExited:(id <NSDraggingInfo>)sender;
{
	if (draggingDelegate && [draggingDelegate respondsToSelector:@selector(draggingExited:)]) 
		return [draggingDelegate draggingExited:sender];
	else
		return [super draggingExited:sender];
}

- (NSDragOperation)draggingUpdated:(id <NSDraggingInfo>)sender
{
	if (draggingDelegate && [draggingDelegate respondsToSelector:@selector(draggingUpdated:)]) 
		return [draggingDelegate draggingUpdated:sender];
	else
		return [super draggingUpdated:sender];
}

- (BOOL)prepareForDragOperation:(id <NSDraggingInfo>)sender
{
	if (draggingDelegate && [draggingDelegate respondsToSelector:@selector(prepareForDragOperation:)]) 
		return [draggingDelegate prepareForDragOperation:sender];
	else
		return [super prepareForDragOperation:sender];
}

- (BOOL)performDragOperation:(id <NSDraggingInfo>)sender
{
	if (draggingDelegate && [draggingDelegate respondsToSelector:@selector(performDragOperation:)])
		return [draggingDelegate performDragOperation:sender];
	else
		return [super performDragOperation:sender];
}

- (void)concludeDragOperation:(id <NSDraggingInfo>)sender
{
	if (draggingDelegate && [draggingDelegate respondsToSelector:@selector(concludeDragOperation:)])
		[draggingDelegate concludeDragOperation:sender];
	else
		[super concludeDragOperation:sender];
}


@end
