; Beginning of Licence
;
; This software is licensed only for personal and educational use and
; not for the production of commercial software.  Modifications to this
; program are allowed but the resulting source must be annotated to
; indicate the nature of and the author of these changes.  
;
; Any modified source is bound by this licence and must remain available 
; as open source under the same conditions it was supplied and with this 
; licence at the top.

; This software is supplied AS IS without any warranty.  In no way shall 
; Mark Tarver or Lambda Associates be held liable for any damages resulting 
; from the use of this program.

; The terms of these conditions remain binding unless the individual 
; holds a valid license to use Qi commercially.  This license is found 
; in the final page of 'Functional Programming in Qi'.  In that event 
; the terms of that license apply to the license holder. 
;
; (c) copyright Mark Tarver, 2008
; End of Licence

(IN-PACKAGE :qi)

(DEFUN unify (X Y Continuation)
  (lzy= (lazyderef X) (lazyderef Y) Continuation))

(DEFUN lzy= (X Y Continuation)
   (COND ((EQUAL X Y) (FUNCALL Continuation))
         ((var? X) 
          (PROGV (LIST X) (LIST Y) (FUNCALL Continuation)))
         ((var? Y) 
          (PROGV (LIST Y) (LIST X) (FUNCALL Continuation)))
         ((AND (CONSP X) (CONSP Y))
          (lzy= (lazyderef (CAR X)) 
                (lazyderef (CAR Y))
                (FUNCTION (LAMBDA () 
                              (lzy= (lazyderef (CDR X)) 
				                    (lazyderef (CDR Y)) 
                                    Continuation)))))
         (T NIL)))

(DEFUN deref (X)
  (COND ((AND (var? X) (BOUNDP X)) 
         (LET ((Value (SYMBOL-VALUE X))) 
              (IF (EQ Value X)
                  X
                 (deref Value))))
        ((CONSP X) (CONS (deref (CAR X)) (deref (CDR X))))
        ((TUPLE-P X) (@p (deref (fst X))  (deref (snd X))))
        (T X)))

(DEFUN lazyderef (X)
  (IF (AND (var? X) (BOUNDP X)) 
      (lazyderef (SYMBOL-VALUE X))
      X))

(DEFUN unify! (X Y Continuation)
  (lzy=! (lazyderef X) (lazyderef Y) Continuation))

(DEFUN lzy=! (X Y Continuation)
   (COND ((EQUAL X Y) (FUNCALL Continuation))
         ((AND (var? X) (NOT (occurs X Y)))
          (PROGV (LIST X) (LIST Y) (FUNCALL Continuation)))
         ((AND (var? Y) (NOT (occurs Y X)))
          (PROGV (LIST Y) (LIST X) (FUNCALL Continuation)))
         ((AND (CONSP X) (CONSP Y))
          (lzy=! (lazyderef (CAR X)) 
                 (lazyderef (CAR Y))
                 (FUNCTION (LAMBDA () 
                              (lzy=! (lazyderef (CDR X)) 
				                     (lazyderef (CDR Y)) 
                                     Continuation)))))
         (T NIL)))

(DEFUN identical (X Y Continuation)
  (lzy== (lazyderef X) (lazyderef Y) Continuation))

(DEFUN lzy== (X Y Continuation)
   (COND ((EQUAL X Y) (FUNCALL Continuation))
         ((AND (CONSP X) (CONSP Y))
          (lzy== (lazyderef (CAR X)) 
                 (lazyderef (CAR Y))
                 (FUNCTION (LAMBDA () 
                              (lzy== (lazyderef (CDR X)) 
				                     (lazyderef (CDR Y)) 
                                     Continuation)))))
         (T NIL)))

(DEFUN occurs (X Y)
  (COND ((EQ X Y))
        ((CONSP Y) (OR (occurs X (lazyderef (CAR Y)))
                       (occurs X (lazyderef (CDR Y)))))
        (T NIL))) 

(DEFUN is (X Y Continuation)
  (PROGV (LIST X) (LIST Y) (FUNCALL Continuation)))

(DEFUN bind (X Y Continuation)
  (PROGV (LIST X) (LIST Y) (FUNCALL Continuation)))

(DEFUN when (X Continuation)
  (COND ((EQ X 'true) (FUNCALL Continuation))
        ((EQ X 'false) NIL)
        (T (error "when expects a boolean: not ~S%" X))))

(DEFUN fwhen (X Continuation)
  (COND ((EQ X 'true) (FUNCALL Continuation))
        ((EQ X 'false) NIL)
        (T (error "when expects a boolean: not ~S%" X))))

(DEFUN call (Literal Continuation)
  (LET ((Pred (lazyderef (CAR Literal)))
        (Terms (lazyderef (CDR Literal))))
       (COND ((EQ Pred 'qi_=) (APPLY 'unify (APPEND Terms (LIST Continuation))))
             ((EQ Pred '=!) (APPLY 'unify! (APPEND Terms (LIST Continuation))))
			 ((EQ Pred '==) (APPLY 'identical (APPEND Terms (LIST Continuation))))
             (T (APPLY Pred (APPEND Terms (LIST Continuation)))))))

(DEFUN findall (Pattern Literal Out Continuation)
   (LET ((Store (GENSYM "Store"))
         (Pred (CAR Literal))
         (Terms (CDR Literal)))
         (SET Store NIL)
         (APPLY Pred
                (APPEND Terms 
                        (LIST (FUNCTION (LAMBDA () (store Pattern Store))))))
          (LET ((Bag (NREVERSE (SYMBOL-VALUE Store))))
                (MAKUNBOUND Store)
                (PROGV (LIST Out) 
                       (LIST Bag)
                       (FUNCALL Continuation)))))                 

(DEFUN store (Pattern Store)
  (SET Store (CONS (deref Pattern) (SYMBOL-VALUE Store)))
  NIL)

(DEFUN goalstack (V681 Continuation)
 (BLOCK failure
  (PROG2 (+infs)
    (bind V681 (FUNCTION-LAMBDA-EXPRESSION Continuation)
     #'(LAMBDA NIL (FUNCALL Continuation))))))

        
  