; Beginning of Licence
;
; This software is licensed only for personal and educational use and
; not for the production of commercial software.  Modifications to this
; program are allowed but the resulting source must be annotated to
; indicate the nature of and the author of these changes.  
;
; Any modified source is bound by this licence and must remain available 
; as open source under the same conditions it was supplied and with this 
; licence at the top.

; This software is supplied AS IS without any warranty.  In no way shall 
; Mark Tarver or Lambda Associates be held liable for any damages resulting 
; from the use of this program.

; The terms of these conditions remain binding unless the individual 
; holds a valid license to use Qi commercially.  This license is found 
; in the final page of 'Functional Programming in Qi'.  In that event 
; the terms of that license apply to the license holder. 
;
; (c) copyright Mark Tarver, 2008
; End of Licence

(IN-PACKAGE :qi)

(DEFMACRO datatype (D &REST Rules)
  `(process-datatype (QUOTE ,D) 
     (compile '<datatype-rules> 
              (QUOTE ,Rules) 
              "syntax error in datatype here: ~%~%~{~S ~}")))

(DEFUN <datatype-rules> (Stream)
 (OR
  (BLOCK localfailure
   (LET ((<datatype-rule> (<datatype-rule> Stream)))
    (IF (NOT (failure? <datatype-rule>))
     (LET ((<datatype-rules> (<datatype-rules> <datatype-rule>)))
      (IF (NOT (failure? <datatype-rules>))
       (LIST (FIRST <datatype-rules>)
        (CONS (SECOND <datatype-rule>) (SECOND <datatype-rules>)))
       NIL))
     NIL)))
  (BLOCK localfailure
   (LET ((<e> (<e> Stream)))
    (IF (NOT (failure? <e>)) (LIST (FIRST <e>) NIL) NIL)))))

(DEFUN <datatype-rule> (Stream)
 (OR
  (BLOCK localfailure
   (LET ((<side-conditions> (<side-conditions> Stream)))
    (IF (NOT (failure? <side-conditions>))
     (LET ((<premises> (<premises> <side-conditions>)))
      (IF (NOT (failure? <premises>))
       (LET ((<singleunderline> (<singleunderline> <premises>)))
        (IF (NOT (failure? <singleunderline>))
         (LET ((<conclusion> (<conclusion> <singleunderline>)))
          (IF (NOT (failure? <conclusion>))
           (LIST (FIRST <conclusion>)
            (@p 'single
             (CONS (SECOND <side-conditions>)
              (CONS (SECOND <premises>) (CONS (SECOND <conclusion>) NIL)))))
           NIL))
         NIL))
       NIL))
     NIL)))
  (BLOCK localfailure
   (LET ((<side-conditions> (<side-conditions> Stream)))
    (IF (NOT (failure? <side-conditions>))
     (LET ((<premises> (<premises> <side-conditions>)))
      (IF (NOT (failure? <premises>))
       (LET ((<doubleunderline> (<doubleunderline> <premises>)))
        (IF (NOT (failure? <doubleunderline>))
         (LET ((<conclusion> (<conclusion> <doubleunderline>)))
          (IF (NOT (failure? <conclusion>))
           (LIST (FIRST <conclusion>)
            (@p 'double
             (CONS (SECOND <side-conditions>)
              (CONS (SECOND <premises>) (CONS (SECOND <conclusion>) NIL)))))
           NIL))
         NIL))
       NIL))
     NIL)))))

(DEFUN <side-conditions> (Stream)
 (OR
  (BLOCK localfailure
   (LET ((<side-condition> (<side-condition> Stream)))
    (IF (NOT (failure? <side-condition>))
     (LET ((<side-conditions> (<side-conditions> <side-condition>)))
      (IF (NOT (failure? <side-conditions>))
       (LIST (FIRST <side-conditions>)
        (CONS (SECOND <side-condition>) (SECOND <side-conditions>)))
       NIL))
     NIL)))
  (BLOCK localfailure
   (LET ((<e> (<e> Stream)))
    (IF (NOT (failure? <e>)) (LIST (FIRST <e>) NIL) NIL)))))

(DEFUN <side-condition> (Stream)
 (OR
  (BLOCK localfailure
   (IF (AND (CONSP (FIRST Stream)) (EQ (FIRST (FIRST Stream)) 'if))
    (LET ((<expr> (<expr> (LIST (REST (FIRST Stream)) (SECOND Stream)))))
     (IF (NOT (failure? <expr>))
      (LIST (FIRST <expr>) (CONS 'if (CONS (SECOND <expr>) NIL))) NIL))
    NIL))
  (BLOCK localfailure
   (IF (AND (CONSP (FIRST Stream)) (EQ (FIRST (FIRST Stream)) 'let))
    (LET
     ((<variable?> (<variable?> (LIST (REST (FIRST Stream)) (SECOND Stream)))))
     (IF (NOT (failure? <variable?>))
      (LET ((<expr> (<expr> <variable?>)))
       (IF (NOT (failure? <expr>))
        (LIST (FIRST <expr>)
         (CONS 'let (CONS (SECOND <variable?>) (CONS (SECOND <expr>) NIL))))
        NIL))
      NIL))
    NIL))))

(DEFUN <variable?> (Stream)
 (OR
  (BLOCK localfailure
   (IF (CONSP (FIRST Stream))
    (LIST (FIRST (LIST (REST (FIRST Stream)) (SECOND Stream)))
     (if (not (variable? (CAAR Stream))) (RETURN-FROM localfailure NIL)
      (CAAR Stream)))
    NIL))))

(DEFUN <expr> (Stream)
 (OR
  (BLOCK localfailure
   (IF (CONSP (FIRST Stream))
    (LIST (FIRST (LIST (REST (FIRST Stream)) (SECOND Stream)))
     (if
      (or (element? (CAAR Stream) (CONS '>> (CONS (semi-colon) NIL)))
       (or (singleunderline? (CAAR Stream)) (doubleunderline? (CAAR Stream))))
      (RETURN-FROM localfailure NIL) (remove-bar (CAAR Stream))))
    NIL))))

(DEFUN remove-bar (V409)
 (COND
  ((AND (CONSP V409) (CONSP (CDR V409)) (CONSP (CDR (CDR V409)))
    (NULL (CDR (CDR (CDR V409)))) (EQ (CAR (CDR V409)) 'bar#))
   (CONS (CAR V409) (CAR (CDR (CDR V409)))))
  ((CONSP V409) (CONS (remove-bar (CAR V409)) (remove-bar (CDR V409))))
  (T V409)))

(DEFUN <premises> (Stream)
 (OR
  (BLOCK localfailure
   (LET ((<premise> (<premise> Stream)))
    (IF (NOT (failure? <premise>))
     (LET ((<semi-colon> (<semi-colon> <premise>)))
      (IF (NOT (failure? <semi-colon>))
       (LET ((<premises> (<premises> <semi-colon>)))
        (IF (NOT (failure? <premises>))
         (LIST (FIRST <premises>)
          (CONS (SECOND <premise>) (SECOND <premises>)))
         NIL))
       NIL))
     NIL)))
  (BLOCK localfailure
   (LET ((<e> (<e> Stream)))
    (IF (NOT (failure? <e>)) (LIST (FIRST <e>) NIL) NIL)))))

(DEFUN <semi-colon> (Stream)
 (OR
  (BLOCK localfailure
   (IF (CONSP (FIRST Stream))
    (LIST (FIRST (LIST (REST (FIRST Stream)) (SECOND Stream)))
     (IF (EQ (CAAR Stream) (semi-colon)) (CAAR Stream) (RETURN-FROM localfailure NIL)))
    NIL))))

(DEFUN <premise> (Stream)
 (OR
  (BLOCK localfailure
   (IF (AND (CONSP (FIRST Stream)) (EQ (FIRST (FIRST Stream)) '!))
    (LIST (FIRST (LIST (REST (FIRST Stream)) (SECOND Stream))) '!) NIL))
  (BLOCK localfailure
   (LET ((<formulae> (<formulae> Stream)))
    (IF (NOT (failure? <formulae>))
     (IF (AND (CONSP (FIRST <formulae>)) (EQ (FIRST (FIRST <formulae>)) '>>))
      (LET
       ((<formula>
         (<formula> (LIST (REST (FIRST <formulae>)) (SECOND <formulae>)))))
       (IF (NOT (failure? <formula>))
        (LIST (FIRST <formula>) (@p (SECOND <formulae>) (SECOND <formula>)))
        NIL))
      NIL)
     NIL)))
  (BLOCK localfailure
   (LET ((<formula> (<formula> Stream)))
    (IF (NOT (failure? <formula>))
     (LIST (FIRST <formula>) (@p NIL (SECOND <formula>))) NIL)))))

(DEFUN <conclusion> (Stream)
 (OR
  (BLOCK localfailure
   (LET ((<formulae> (<formulae> Stream)))
    (IF (NOT (failure? <formulae>))
     (IF (AND (CONSP (FIRST <formulae>)) (EQ (FIRST (FIRST <formulae>)) '>>))
      (LET
       ((<formula>
         (<formula> (LIST (REST (FIRST <formulae>)) (SECOND <formulae>)))))
       (IF (NOT (failure? <formula>))
        (LET ((<semi-colon> (<semi-colon> <formula>)))
         (IF (NOT (failure? <semi-colon>))
          (LIST (FIRST <semi-colon>)
           (@p (SECOND <formulae>) (SECOND <formula>)))
          NIL))
        NIL))
      NIL)
     NIL)))
  (BLOCK localfailure
   (LET ((<formula> (<formula> Stream)))
    (IF (NOT (failure? <formula>))
     (LET ((<semi-colon> (<semi-colon> <formula>)))
      (IF (NOT (failure? <semi-colon>))
       (LIST (FIRST <semi-colon>) (@p NIL (SECOND <formula>))) NIL))
     NIL)))
  (BLOCK localfailure (LIST (FIRST Stream) NIL))))

(DEFUN <formulae> (Stream)
 (OR
  (BLOCK localfailure
   (LET ((<formula> (<formula> Stream)))
    (IF (NOT (failure? <formula>))
     (IF (AND (CONSP (FIRST <formula>)) (EQ (FIRST (FIRST <formula>)) (comma)))
      (LET
       ((<formulae>
         (<formulae> (LIST (REST (FIRST <formula>)) (SECOND <formula>)))))
       (IF (NOT (failure? <formulae>))
        (LIST (FIRST <formulae>) (cons (SECOND <formula>) (SECOND <formulae>)))
        NIL))
      NIL)
     NIL)))
  (BLOCK localfailure
   (LET ((<formula> (<formula> Stream)))
    (IF (NOT (failure? <formula>))
     (LIST (FIRST <formula>) (cons (SECOND <formula>) NIL)) NIL)))
  (BLOCK localfailure
   (LET ((<e> (<e> Stream)))
    (IF (NOT (failure? <e>)) (LIST (FIRST <e>) NIL) NIL)))))

(DEFUN <formula> (Stream)
 (OR
  (BLOCK localfailure
   (LET ((<expr> (<expr> Stream)))
    (IF (NOT (failure? <expr>))
     (IF (AND (CONSP (FIRST <expr>)) (EQ (FIRST (FIRST <expr>)) (colon)))
      (LET ((<type> (<type> (LIST (REST (FIRST <expr>)) (SECOND <expr>)))))
       (IF (NOT (failure? <type>))
        (LIST (FIRST <type>)
         (CONS (curry (SECOND <expr>)) (CONS (colon) (CONS (SECOND <type>) NIL))))
        NIL))
      NIL)
     NIL)))
  (BLOCK localfailure
   (LET ((<expr> (<expr> Stream))) (IF (NOT (failure? <expr>)) <expr> NIL)))))

(DEFUN curry (V1)
 (COND ((AND (CONSP V1) (wrapper (extraspecial? (CAR V1)))) V1)
  ((AND (CONSP V1) (wrapper (special? (CAR V1))))
   (THE LIST (MAPCAR 'curry V1)))
  ((AND (CONSP V1) (CONSP (CDR V1)) (NULL (CDR (CDR V1))))
   (LIST (curry (CAR V1)) (curry (CAR (CDR V1)))))
  ((AND (CONSP V1) (CONSP (CDR V1)))
   (LET* ((V2 (CDR V1))) (curry (CONS (LIST (CAR V1) (CAR V2)) (CDR V2)))))
  ((TUPLE-P V1) (@p (curry (fst V1)) (curry (snd V1))))
  (T V1)))

(SETQ *special* '(make-string where cons @p error output /. set let do))

(SETQ *extraspecial* '(datatype synonyms rule multi make-string fun define input+))

(DEFUN special? (V5) (THE SYMBOL (element? V5 *special*)))

(DEFUN extraspecial? (V7) (THE SYMBOL (element? V7 *extraspecial*)))

(DEFUN specialise (V9) (SETQ *special* (CONS V9 *special*)) V9)

(DEFUN unspecialise (V10) (SETQ *special* (THE LIST (remove V10 *special*))) V10)

(DEFUN extraspecialise (V12) (SETQ *extraspecial* (CONS V12 *extraspecial*)))

(DEFUN unextraspecialise (V13)
 (SETQ *extraspecial* (THE LIST (remove V13 *special*))))

(DEFUN <type> (Stream)
 (OR
  (BLOCK localfailure
   (LET ((<expr> (<expr> Stream)))
    (IF (NOT (failure? <expr>))
     (LIST (FIRST <expr>) (normalise-type (curry-type (SECOND <expr>)))) NIL)))))

(DEFUN <doubleunderline> (Stream)
 (OR
  (BLOCK localfailure
   (IF (CONSP (FIRST Stream))
    (LIST (FIRST (LIST (REST (FIRST Stream)) (SECOND Stream)))
     (if (doubleunderline? (CAAR Stream)) (CAAR Stream)
      (RETURN-FROM localfailure NIL)))
    NIL))))

(DEFUN <singleunderline> (Stream)
 (OR
  (BLOCK localfailure
   (IF (CONSP (FIRST Stream))
    (LIST (FIRST (LIST (REST (FIRST Stream)) (SECOND Stream)))
     (if (singleunderline? (CAAR Stream)) (CAAR Stream)
      (RETURN-FROM localfailure NIL)))
    NIL))))

(DEFUN curry-type (V1)
 (COND
  ((AND (CONSP V1) (CONSP (CDR V1)) (EQ '--> (CAR (CDR V1)))
    (CONSP (CDR (CDR V1))) (CONSP (CDR (CDR (CDR V1))))
    (EQ '--> (CAR (CDR (CDR (CDR V1))))) (CONSP (CDR (CDR (CDR (CDR V1))))))
   (curry-type (LIST (CAR V1) '--> (CDR (CDR V1)))))
  ((AND (CONSP V1) (EQ 'cons (CAR V1)) (CONSP (CDR V1)) (CONSP (CDR (CDR V1)))
    (NULL (CAR (CDR (CDR V1)))) (NULL (CDR (CDR (CDR V1)))))
   (curry-type (LIST 'list (CAR (CDR V1)))))
  ((AND (CONSP V1) (CONSP (CDR V1)) (EQ '* (CAR (CDR V1)))
    (CONSP (CDR (CDR V1))) (CONSP (CDR (CDR (CDR V1))))
    (EQ '* (CAR (CDR (CDR (CDR V1))))))
   (curry-type (LIST (CAR V1) '* (CDR (CDR V1)))))
  ((CONSP V1) (THE LIST (MAPCAR 'curry-type V1))) 
  (T V1)))

(DEFUN singleunderline? (V19)
 (THE SYMBOL
  (and (THE SYMBOL (symbol? V19)) (procchar #\_ (THE LIST (explode V19))))))

(DEFUN doubleunderline? (V22)
 (THE SYMBOL
  (and (THE SYMBOL (symbol? V22)) (procchar #\= (THE LIST (explode V22))))))

(DEFUN procchar (V36 V37)
 (COND
  ((AND (CONSP V37) (CONSP (CDR V37)) (NULL (CDR (CDR V37)))
    (AND (ABSEQUAL (CAR V37) (CAR (CDR V37)))
     (ABSEQUAL V36 (CAR (CDR V37)))))
   'true)
  ((AND (CONSP V37) (ABSEQUAL V36 (CAR V37)))
   (procchar (CAR V37) (CDR V37)))
  (T 'false)))

(DEFUN process-datatype (V53 V54) 
  (remember-datatype (s-prolog (rules->horn-clauses V53 V54))))

(DEFUN remember-datatype (D)
  (LET ((Type (CAR D)))
       (PUSHNEW Type *datatypes*)
       (PUSHNEW Type *alldatatypes*)
       Type))

(SETQ *alldatatypes* NIL)
(SETQ *datatypes* NIL)
  
(DEFUN rules->horn-clauses (V57 V58)
 (COND ((NULL V58) NIL)
  ((AND (CONSP V58) (TUPLE-P (CAR V58)) (EQ 'single (fst (CAR V58))))
   (CONS (rule->horn-clause V57 (snd (CAR V58)))
    (rules->horn-clauses V57 (CDR V58))))
  ((AND (CONSP V58) (TUPLE-P (CAR V58)) (EQ 'double (fst (CAR V58))))
   (rules->horn-clauses V57
    (APPEND (double->singles (snd (CAR V58))) (CDR V58))))
  (T (implementation_error 'rules->horn-clauses))))

(DEFUN double->singles (V63) (LIST (right-rule V63) (left-rule V63)))

(DEFUN right-rule (V64) (@p 'single V64))

(DEFUN left-rule (V65)
 (COND
  ((AND (CONSP V65) (CONSP (CDR V65)) (CONSP (CDR (CDR V65)))
    (TUPLE-P (CAR (CDR (CDR V65)))) (NULL (fst (CAR (CDR (CDR V65)))))
    (NULL (CDR (CDR (CDR V65)))))
   (LET* ((V66 (CDR V65)))
    (LET ((Q (gensym "Q")))
     (LET ((NewConclusion (@p (LIST (snd (CAR (CDR V66)))) Q)))
      (LET ((NewPremises (LIST (@p (MAPCAR 'right->left (CAR V66)) Q))))
       (@p 'single (LIST (CAR V65) NewPremises NewConclusion)))))))
  (T (implementation_error 'left-rule))))

(DEFUN right->left (V71)
 (COND ((AND (TUPLE-P V71) (NULL (fst V71))) (snd V71))
  (T (error "syntax error with ==========~%"))))

(DEFUN rule->horn-clause (V1 V2)
 (COND
  ((AND (CONSP V2) (CONSP (CDR V2)) (CONSP (CDR (CDR V2)))
    (TUPLE-P (CAR (CDR (CDR V2)))) (NULL (CDR (CDR (CDR V2)))))
   (LET* ((V3 (CDR V2)) (V4 (CDR V3)) (V5 (CAR V4)))
    (LIST (rule->horn-clause-head V1 (snd V5)) ':-
     (rule->horn-clause-body (CAR V2) (CAR V3) (fst V5)))))
  (T (implementation_error 'rule->horn-clause))))

(DEFUN rule->horn-clause-head (V10 V11) (LIST V10 (mode-ify V11) 'Context))

(DEFUN mode-ify (V12)
 (COND ((wrapper (rule-bound?)) V12)
  ((AND (CONSP V12) (CONSP (CDR V12)) (EQ (colon) (CAR (CDR V12)))
    (CONSP (CDR (CDR V12))) (NULL (CDR (CDR (CDR V12)))))
   (LIST 'mode (LIST (CAR V12) (colon) (LIST 'mode (CAR (CDR (CDR V12))) '+)) '-))
  (T V12)))

(DEFUN rule-bound? ()
  (IF (BOUNDP '*rule-bound*) 'true 'false))

(DEFUN rule->horn-clause-body (V13 V14 V15)
 (LET ((Variables (MAPCAR 'extract-vars V15)))
  (LET ((Predicates (MAPCAR #'(LAMBDA (X) (gensym "cl")) V15)))
   (LET
    ((SearchLiterals
      (construct-search-literals Predicates Variables 'Context 'Context1)))
    (LET ((SearchClauses (construct-search-clauses Predicates V15 Variables)))
     (LET ((SideLiterals (MAPCAR 'construct-side-literal V13)))
      (LET
       ((PremissLiterals
         (MAPCAR #'(LAMBDA (X) (construct-premiss-literal X (empty? V15))) V14)))
                 (APPEND SearchLiterals SideLiterals PremissLiterals))))))))

(DEFUN construct-search-literals (V21 V22 V23 V24)
 (COND ((AND (NULL V21) (NULL V22)) NIL) (T (csl-help V21 V22 V23 V24))))

(DEFUN csl-help (V27 V28 V29 V30)
 (COND ((AND (NULL V27) (NULL V28)) (LIST (LIST 'bind 'ContextOut V29)))
  ((AND (CONSP V27) (CONSP V28))
   (CONS (CONS (CAR V27) (CONS V29 (CONS V30 (CAR V28))))
    (csl-help (CDR V27) (CDR V28) V30 (THE SYMBOL (gensym "Context")))))
  (T (implementation_error 'csl-help))))

(DEFUN construct-search-clauses (V31 V32 V33)
 (COND ((AND (NULL V31) (NULL V32) (NULL V33)) 'skip)
  ((AND (CONSP V31) (CONSP V32) (CONSP V33))
   (construct-search-clause (CAR V31) (CAR V32) (CAR V33))
   (construct-search-clauses (CDR V31) (CDR V32) (CDR V33)))
  (T (implementation_error 'construct-search-clauses))))

(DEFUN construct-search-clause (V34 V35 V36)
 (s-prolog
  (LIST (construct-base-search-clause V34 V35 V36)
   (construct-recursive-search-clause V34 V35 V36))))

(DEFUN construct-base-search-clause (V37 V38 V39)
 (LIST (CONS V37 (CONS (CONS (mode-ify V38) 'In) (CONS 'In V39))) ':- NIL))

(DEFUN construct-recursive-search-clause (V40 V41 V42) (DECLARE (IGNORE V41))
 (LIST
  (CONS V40
   (CONS (CONS 'Assumption 'Assumptions) (CONS (CONS 'Assumption 'Out) V42)))
  ':- (LIST (CONS V40 (CONS 'Assumptions (CONS 'Out V42))))))

(DEFUN construct-side-literal (V43)
 (COND
  ((AND (CONSP V43) (EQ 'if (CAR V43)) (CONSP (CDR V43))
    (NULL (CDR (CDR V43))))
   (CONS 'when (CDR V43)))
  ((AND (CONSP V43) (EQ 'let (CAR V43)) (CONSP (CDR V43))
    (CONSP (CDR (CDR V43))) (NULL (CDR (CDR (CDR V43)))))
   (CONS 'is (CDR V43)))
  (T (implementation_error 'construct-side-literal))))

(DEFUN construct-premiss-literal (V48 V49)
 (COND
  ((TUPLE-P V48)
   (LIST 't* (recursive_cons_form (snd V48))
    (construct-context V49 (fst V48))))
  ((EQ '! V48) (LIST '!)) 
   (T (implementation_error 'construct-premiss-literal))))

(DEFUN construct-context (V54 V55)
 (COND ((AND (EQ 'true V54) (NULL V55)) 'Context)
  ((AND (EQ 'false V54) (NULL V55)) 'ContextOut)
  ((CONSP V55)
   (LIST 'cons (recursive_cons_form (CAR V55))
    (construct-context V54 (CDR V55))))
  (T (implementation_error 'construct-context))))

(DEFUN recursive_cons_form (V56)
 (COND
  ((CONSP V56)
   (LIST 'cons (recursive_cons_form (CAR V56))
    (recursive_cons_form (CDR V56))))
  (T V56)))

(DEFUN preclude (V)
 (LET ((FilterDatatypes (SETQ *datatypes* (difference *datatypes* V))))
  (LET
   ((Synonyms
     (compile-synonyms (SETQ *synonyms* (syn-difference *synonyms* V)))))
   (alltypes))))

(DEFUN alltypes NIL (APPEND *datatypes* (MAPCAR 'head *synonyms*)))

(DEFUN include (V2)
 (LET ((ValidTypes (intersection V2 *alldatatypes*)))
  (LET ((ValidSynonyms (syn-intersection *allsynonyms* V2)))
   (LET
    ((NewSynonyms
      (compile-synonyms (SETQ *synonyms* (union ValidSynonyms *synonyms*)))))
    (LET ((NewDatatypes (SETQ *datatypes* (union ValidTypes *datatypes*))))
     (alltypes))))))

(DEFUN preclude-all-but (V3)
 (LET ((Datatypes (preclude (difference *alldatatypes* V3))))
  (LET
   ((Synonyms (preclude (MAPCAR 'head (syn-difference *allsynonyms* V3)))))
   (alltypes))))

(DEFUN include-all-but (V4)
 (LET ((Datatypes (include (difference *alldatatypes* V4))))
  (LET ((Synonyms (include (MAPCAR 'head (syn-difference *allsynonyms* V4)))))
   (alltypes))))

(DEFUN syn-difference (V5 V6)
 (mapcan #'(LAMBDA (S) (if (THE SYMBOL (element? (head S) V6)) NIL (LIST S)))
  V5))

(DEFUN syn-intersection (V9 V0)
 (mapcan #'(LAMBDA (S) (if (THE SYMBOL (element? (head S) V0)) (LIST S) NIL))
  V9))
(SETQ *alldatatypes* NIL)