/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdkuilib.internal.repository;

import com.android.SdkConstants;
import com.android.sdkuilib.internal.repository.SwtUpdaterData;
import com.android.sdkuilib.internal.repository.icons.ImageFactory;
import com.android.sdkuilib.ui.GridDataBuilder;
import com.android.sdkuilib.ui.GridLayoutBuilder;
import com.android.sdkuilib.ui.SwtBaseDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public abstract class UpdaterBaseDialog
extends SwtBaseDialog {
    private final SwtUpdaterData mSwtUpdaterData;

    protected UpdaterBaseDialog(Shell parentShell, SwtUpdaterData swtUpdaterData, String title) {
        super(parentShell, 65536, String.format("%1$s - %2$s", "Android SDK Manager", title));
        this.mSwtUpdaterData = swtUpdaterData;
    }

    public SwtUpdaterData getSwtUpdaterData() {
        return this.mSwtUpdaterData;
    }

    @Override
    protected void createContents() {
        Shell shell = this.getShell();
        this.setWindowImage(shell);
        GridLayoutBuilder.create((Composite)shell).columns(2);
    }

    protected void createCloseButton() {
        Button close = new Button((Composite)this.getShell(), 8);
        close.setText("Close");
        GridDataBuilder.create((Control)close).hFill().vBottom();
        close.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UpdaterBaseDialog.this.close();
            }
        });
    }

    @Override
    protected void postCreate() {
    }

    @Override
    protected void close() {
        super.close();
    }

    private void setWindowImage(Shell shell) {
        ImageFactory imgFactory;
        String imageName = "android_icon_16.png";
        if (SdkConstants.currentPlatform() == 3) {
            imageName = "android_icon_128.png";
        }
        if (this.mSwtUpdaterData != null && (imgFactory = this.mSwtUpdaterData.getImageFactory()) != null) {
            shell.setImage(imgFactory.getImageByName(imageName));
        }
    }
}

