/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.data;

import com.vladium.emma.EMMARuntimeException;
import com.vladium.emma.IAppErrorCodes;
import com.vladium.emma.Processor;
import com.vladium.emma.data.DataFactory;
import com.vladium.emma.data.ICoverageData;
import com.vladium.emma.data.IMergeable;
import com.vladium.emma.data.IMetaData;
import com.vladium.emma.data.SessionData;
import com.vladium.logging.Logger;
import com.vladium.util.Files;
import com.vladium.util.IConstants;
import com.vladium.util.IProperties;
import com.vladium.util.asserts.$assert;
import com.vladium.util.exception.Exceptions;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;

public final class MergeProcessor
extends Processor
implements IAppErrorCodes {
    private File[] m_dataPath = IConstants.EMPTY_FILE_ARRAY;
    private File m_sdataOutFile;
    private int m_dataFileCount;
    private static final Class[] EXPECTED_FAILURES = new Class[]{EMMARuntimeException.class, IllegalArgumentException.class, IllegalStateException.class};

    public static MergeProcessor create() {
        return new MergeProcessor();
    }

    public final synchronized void setDataPath(String[] stringArray) {
        this.m_dataPath = stringArray == null || stringArray.length == 0 ? IConstants.EMPTY_FILE_ARRAY : Files.pathToFiles(stringArray, true);
    }

    public final synchronized void setSessionOutFile(String string) {
        if (string == null) {
            this.m_sdataOutFile = null;
        } else {
            File file = new File(string);
            if (file.exists() && !file.isFile()) {
                throw new IllegalArgumentException("not a file: [" + file.getAbsolutePath() + "]");
            }
            this.m_sdataOutFile = file;
        }
    }

    protected void validateState() {
        super.validateState();
        if (this.m_dataPath == null) {
            throw new IllegalStateException("data path not set");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _run(IProperties iProperties) {
        Object object;
        Serializable serializable;
        Logger logger = this.m_log;
        boolean bl = this.m_log.atVERBOSE();
        if (bl) {
            logger.verbose("[EMMA v0.0, build 0 (unsupported private build) (unknown)]");
            logger.verbose("input data path:");
            logger.verbose("{");
            for (int i = 0; i < this.m_dataPath.length; ++i) {
                serializable = this.m_dataPath[i];
                object = ((File)serializable).exists() ? "" : "{nonexistent} ";
                logger.verbose("  " + (String)object + ((File)serializable).getAbsolutePath());
            }
            logger.verbose("}");
        } else {
            logger.info("processing input files ...");
        }
        File file = this.m_sdataOutFile;
        if (file == null) {
            file = new File(iProperties.getProperty("session.out.file", "coverage.es"));
        }
        serializable = null;
        try {
            Object object2;
            Serializable serializable2;
            object = null;
            ICoverageData iCoverageData = null;
            try {
                long l = logger.atINFO() ? System.currentTimeMillis() : 0L;
                for (int i = 0; i < this.m_dataPath.length; ++i) {
                    ICoverageData iCoverageData2;
                    File file2 = this.m_dataPath[i];
                    if (bl) {
                        logger.verbose("processing input file [" + file2.getAbsolutePath() + "] ...");
                    }
                    if ((serializable2 = (IMetaData)(object2 = DataFactory.load(file2))[0]) != null) {
                        if (bl) {
                            logger.verbose("  loaded " + serializable2.size() + " metadata entries");
                        }
                        object = object == null ? serializable2 : (IMetaData)object.merge((IMergeable)serializable2);
                    }
                    if ((iCoverageData2 = (ICoverageData)object2[1]) != null) {
                        if (bl) {
                            logger.verbose("  loaded " + iCoverageData2.size() + " coverage data entries");
                        }
                        iCoverageData = iCoverageData == null ? iCoverageData2 : (ICoverageData)iCoverageData.merge(iCoverageData2);
                    }
                    ++this.m_dataFileCount;
                }
                if (logger.atINFO()) {
                    long l2 = System.currentTimeMillis();
                    logger.info(this.m_dataFileCount + " file(s) read and merged in " + (l2 - l) + " ms");
                }
                if ((object == null || object.isEmpty()) && (iCoverageData == null || iCoverageData.isEmpty())) {
                    logger.warning("nothing to do: no metadata or coverage data found in any of the input files");
                    return;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.out);
            }
            if (bl) {
                if (object != null) {
                    logger.verbose("  merged metadata contains " + object.size() + " entries");
                }
                if (iCoverageData != null) {
                    logger.verbose("  merged coverage data contains " + iCoverageData.size() + " entries");
                }
            }
            $assert.ASSERT(file != null, "sdataOutFile not null");
            boolean bl2 = false;
            File file3 = null;
            File file4 = Files.canonicalizeFile(file);
            for (int i = 0; i < this.m_dataPath.length; ++i) {
                object2 = Files.canonicalizeFile(this.m_dataPath[i]);
                if (!file4.equals(object2)) continue;
                bl2 = true;
                break;
            }
            if (bl2) {
                File file5 = file4.getParentFile();
                if (file5 == null) {
                    file5 = new File("");
                }
                object2 = Files.getFileName(file4) + "emma";
                try {
                    file3 = Files.createTempFile(file5, (String)object2, ".et");
                }
                catch (IOException iOException) {
                    throw new EMMARuntimeException(iOException);
                }
                logger.warning("the specified output file is one of the input files [" + file4 + "]");
                logger.warning("all merged data will be written to a temp file first [" + file3.getAbsolutePath() + "]");
            }
            long l = logger.atINFO() ? System.currentTimeMillis() : 0L;
            serializable2 = null;
            try {
                Serializable serializable3 = serializable2 = file3 != null ? file3 : file4;
                if (object == null || object.isEmpty()) {
                    DataFactory.persist(iCoverageData, (File)serializable2, false);
                } else if (iCoverageData == null || iCoverageData.isEmpty()) {
                    DataFactory.persist((IMetaData)object, (File)serializable2, false);
                } else {
                    DataFactory.persist(new SessionData((IMetaData)object, iCoverageData), (File)serializable2, false);
                }
            }
            catch (IOException iOException) {
                if (serializable2 != null) {
                    ((File)serializable2).delete();
                }
                throw new EMMARuntimeException(iOException);
            }
            catch (Error error) {
                if (serializable2 != null) {
                    ((File)serializable2).delete();
                }
                throw error;
            }
            if (bl2 && !Files.renameFile(file3, file4, true)) {
                throw new EMMARuntimeException("could not rename temporary file [" + file3.getAbsolutePath() + "] to [" + file4 + "]: make sure the original file is not locked and can be deleted");
            }
            if (logger.atINFO()) {
                long l3 = System.currentTimeMillis();
                logger.info("merged/compacted data written to [" + file4 + "] {in " + (l3 - l) + " ms}");
            }
        }
        catch (SecurityException securityException) {
            serializable = new EMMARuntimeException("SECURITY_RESTRICTION:", new String[]{"EMMA"}, securityException);
        }
        catch (RuntimeException runtimeException) {
            serializable = runtimeException;
        }
        finally {
            this.reset();
        }
        if (serializable != null) {
            if (Exceptions.unexpectedFailure((Throwable)serializable, EXPECTED_FAILURES)) {
                throw new EMMARuntimeException("UNEXPECTED_FAILURE", new Object[]{((Throwable)serializable).toString(), "this private build is unsupported"}, (Throwable)serializable);
            }
            throw serializable;
        }
    }

    private MergeProcessor() {
    }

    private void reset() {
        this.m_dataFileCount = 0;
    }
}

