/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.instr;

import com.vladium.emma.EMMAProperties;
import com.vladium.emma.EMMARuntimeException;
import com.vladium.emma.IAppErrorCodes;
import com.vladium.emma.data.CoverageOptions;
import com.vladium.emma.data.CoverageOptionsFactory;
import com.vladium.emma.data.DataFactory;
import com.vladium.emma.data.IMetaData;
import com.vladium.emma.instr.InstrProcessor;
import com.vladium.emma.instr.InstrVisitor;
import com.vladium.jcd.compiler.ClassWriter;
import com.vladium.jcd.parser.ClassDefParser;
import com.vladium.logging.Logger;
import com.vladium.util.ByteArrayOStream;
import com.vladium.util.Descriptors;
import com.vladium.util.Files;
import com.vladium.util.IPathEnumerator;
import com.vladium.util.IProperties;
import com.vladium.util.Property;
import com.vladium.util.exception.Exceptions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Date;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

final class InstrProcessorST
extends InstrProcessor
implements IAppErrorCodes {
    private final Job[] m_jobs = new Job[128];
    private final InstrVisitor.InstrResult m_instrResult = new InstrVisitor.InstrResult();
    private InstrVisitor m_visitor;
    private IMetaData m_mdata;
    private byte[] m_readbuf;
    private int m_readpos;
    private ByteArrayOStream m_baos;
    private int m_jobPos;
    private long m_currentArchiveTS;
    private File m_origArchiveFile;
    private File m_tempArchiveFile;
    private JarOutputStream m_archiveOut;
    private long m_timeStamp;
    private static final int BUF_SIZE = 32768;
    private static final int JOB_QUEUE_SIZE = 128;
    private static final boolean CLEANUP_TEMP_ARCHIVE_ON_ERRORS = true;
    private static final boolean DO_RAF_EXTENSION = true;
    private static final boolean DO_DEPENDS_CHECKING = true;
    private static final Class[] EXPECTED_FAILURES = new Class[]{EMMARuntimeException.class, IllegalArgumentException.class, IllegalStateException.class};

    public final void handleArchiveStart(File file, File file2, Manifest manifest) {
        Logger logger = this.m_log;
        if (logger.atTRACE2()) {
            logger.trace2("handleArchiveStart", "[" + file + "] [" + file2 + "]");
        }
        Object object = Files.newFile(file, file2);
        this.m_currentArchiveTS = ((File)object).lastModified();
        if (this.m_outMode == InstrProcessor.OutMode.OUT_MODE_FULLCOPY || this.m_outMode == InstrProcessor.OutMode.OUT_MODE_OVERWRITE) {
            object = manifest != null ? new Manifest(manifest) : new Manifest();
            Attributes attributes = ((Manifest)object).getMainAttributes();
            if (manifest == null) {
                attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
            }
            attributes.put(new Attributes.Name("Created-By"), "EMMA v0.0.0 (unsupported private build)");
            attributes.put(Attributes.Name.IMPLEMENTATION_TITLE, "instrumented version of [" + file2.getAbsolutePath() + "]");
            attributes.put(Attributes.Name.SPECIFICATION_TITLE, "instrumented on " + new Date(this.m_timeStamp) + " [" + Property.getSystemFingerprint() + "]");
            if (this.m_outMode == InstrProcessor.OutMode.OUT_MODE_FULLCOPY) {
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(this.getFullOutFile(file, file2, false));
                    this.m_archiveOut = object != null ? new JarOutputStream((OutputStream)fileOutputStream, (Manifest)object) : new JarOutputStream(fileOutputStream);
                }
                catch (IOException iOException) {
                    throw new EMMARuntimeException(iOException);
                }
            }
            if (this.m_outMode == InstrProcessor.OutMode.OUT_MODE_OVERWRITE) {
                this.m_origArchiveFile = Files.newFile(file, file2);
                String string = Files.getFileName(file2) + "emma";
                try {
                    this.m_tempArchiveFile = Files.createTempFile(file, string, ".et");
                    if (logger.atTRACE2()) {
                        logger.trace2("handleArchiveStart", "created temp archive [" + this.m_tempArchiveFile.getAbsolutePath() + "]");
                    }
                    FileOutputStream fileOutputStream = new FileOutputStream(this.m_tempArchiveFile);
                    this.m_archiveOut = object != null ? new JarOutputStream((OutputStream)fileOutputStream, (Manifest)object) : new JarOutputStream(fileOutputStream);
                }
                catch (IOException iOException) {
                    throw new EMMARuntimeException(iOException);
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public final void handleArchiveEntry(JarInputStream var1_1, ZipEntry var2_2) {
        var3_3 = this.m_log;
        if (var3_3.atTRACE2()) {
            var3_3.trace2("handleArchiveEntry", "[" + var2_2.getName() + "]");
        }
        var4_4 = var2_2.getName();
        var5_5 = var4_4.toLowerCase();
        var6_6 = this.m_outMode == InstrProcessor.OutMode.OUT_MODE_FULLCOPY || this.m_outMode == InstrProcessor.OutMode.OUT_MODE_OVERWRITE;
        var7_7 = false;
        if (var5_5.endsWith(".class")) {
            var8_8 = var4_4.substring(0, var4_4.length() - 6).replace('/', '.');
            if (this.m_coverageFilter == null || this.m_coverageFilter.included((String)var8_8)) {
                var9_10 = null;
                try {
                    var10_11 = null;
                    var11_16 = null;
                    if (this.m_outMode == InstrProcessor.OutMode.OUT_MODE_COPY) {
                        var10_11 = new File(var8_8.replace('.', File.separatorChar).concat(".class"));
                        var11_16 = this.getFullOutFile(null, var10_11, true);
                        if (this.m_mdata.hasDescriptor(Descriptors.javaNameToVMName((String)var8_8))) {
                            return;
                        }
                        var12_18 = var11_16.lastModified();
                        if (var12_18 > 0L) {
                            var14_20 = var2_2.getTime();
                            if (var14_20 < 0L) {
                                var14_20 = this.m_currentArchiveTS;
                            }
                            if (var14_20 <= var12_18) {
                                if (var3_3.atVERBOSE()) {
                                    var3_3.verbose("destination file [" + var10_11 + "] skipped: more recent than the source");
                                }
                                return;
                            }
                        }
                    }
                    this.readZipEntry(var1_1, var2_2);
                    var12_19 = ClassDefParser.parseClass(this.m_readbuf, this.m_readpos);
                    this.m_visitor.process(var12_19, this.m_outMode == InstrProcessor.OutMode.OUT_MODE_OVERWRITE, true, true, this.m_instrResult);
                    if (this.m_instrResult.m_instrumented) {
                        ++this.m_classInstrs;
                        this.m_mdata.add(this.m_instrResult.m_descriptor, false);
                        this.m_baos.reset();
                        ClassWriter.writeClassTable(var12_19, this.m_baos);
                        if (var6_6) {
                            var2_2.setTime(this.m_timeStamp);
                            this.addJob(new EntryWriteJob(this.m_archiveOut, this.m_baos.copyByteArray(), var2_2, false));
                        }
                        this.addJob(new FileWriteJob(var11_16, this.m_baos.copyByteArray(), true));
                    }
                    if (!var6_6) ** GOTO lbl75
                    var13_22 = new byte[this.m_readpos];
                    System.arraycopy(this.m_readbuf, 0, var13_22, 0, var13_22.length);
                    ++this.m_classCopies;
                    var2_2.setTime(this.m_timeStamp);
                    this.addJob(new EntryWriteJob(this.m_archiveOut, var13_22, var2_2, true));
                }
                catch (FileNotFoundException var10_13) {
                    if (var9_10 == null) ** GOTO lbl75
                    try {
                        var9_10.close();
                    }
                    catch (Exception var10_14) {
                        throw new EMMARuntimeException(var10_14);
                    }
                }
                catch (IOException var10_15) {
                    throw new EMMARuntimeException(var10_15);
                }
                finally {
                    if (var9_10 != null) {
                        try {
                            var9_10.close();
                        }
                        catch (Exception var18_24) {
                            throw new EMMARuntimeException(var18_24);
                        }
                    }
                }
            } else {
                var7_7 = var6_6;
            }
        } else {
            var7_7 = var6_6;
            if (var7_7 && var4_4.equalsIgnoreCase("META-INF/")) {
                var7_7 = false;
            }
            if (var7_7 && var4_4.equalsIgnoreCase("META-INF/MANIFEST.MF")) {
                var7_7 = false;
            }
        }
lbl75:
        // 10 sources

        if (var7_7) {
            try {
                this.readZipEntry(var1_1, var2_2);
                var8_8 = new byte[this.m_readpos];
                System.arraycopy(this.m_readbuf, 0, var8_8, 0, ((Object)var8_8).length);
                ++this.m_classCopies;
                var2_2.setTime(this.m_timeStamp);
                this.addJob(new EntryWriteJob(this.m_archiveOut, (byte[])var8_8, var2_2, true));
            }
            catch (IOException var8_9) {
                throw new EMMARuntimeException(var8_9);
            }
        }
    }

    public final void handleArchiveEnd(File file, File file2) {
        Logger logger = this.m_log;
        if (logger.atTRACE2()) {
            logger.trace2("handleArchiveEnd", "[" + file + "] [" + file2 + "]");
        }
        this.m_currentArchiveTS = Long.MAX_VALUE;
        if (this.m_outMode == InstrProcessor.OutMode.OUT_MODE_FULLCOPY || this.m_outMode == InstrProcessor.OutMode.OUT_MODE_OVERWRITE) {
            try {
                this.drainJobQueue();
                this.m_archiveOut.flush();
                this.m_archiveOut.close();
                this.m_archiveOut = null;
            }
            catch (IOException iOException) {
                throw new EMMARuntimeException(iOException);
            }
            if (this.m_outMode == InstrProcessor.OutMode.OUT_MODE_OVERWRITE) {
                if (!Files.renameFile(this.m_tempArchiveFile, this.m_origArchiveFile, true)) {
                    throw new EMMARuntimeException("could not rename temporary file [" + this.m_tempArchiveFile + "] to [" + this.m_origArchiveFile + "]: make sure the original file is not locked and can be deleted");
                }
                if (logger.atTRACE2()) {
                    logger.trace2("handleArchiveEnd", "renamed temp archive [" + this.m_tempArchiveFile.getAbsolutePath() + "] to [" + this.m_origArchiveFile + "]");
                }
                this.m_tempArchiveFile = null;
                this.m_origArchiveFile = null;
            }
        }
    }

    public final void handleDirStart(File file, File file2) {
        Logger logger = this.m_log;
        if (logger.atTRACE2()) {
            logger.trace2("handleDirStart", "[" + file + "] [" + file2 + "]");
        }
        if (this.m_outMode == InstrProcessor.OutMode.OUT_MODE_FULLCOPY) {
            File file3 = new File(this.getFullOutDir(file, true), file2.getPath());
            this.createDir(file3, true);
        }
    }

    /*
     * Unable to fully structure code
     */
    public final void handleFile(File var1_1, File var2_2) {
        var3_3 = this.m_log;
        if (var3_3.atTRACE2()) {
            var3_3.trace2("handleFile", "[" + var1_1 + "] [" + var2_2 + "]");
        }
        var4_4 = var2_2.getPath();
        var5_5 = var4_4.toLowerCase();
        var6_6 = this.m_outMode == InstrProcessor.OutMode.OUT_MODE_FULLCOPY;
        var7_7 = this.m_outMode == InstrProcessor.OutMode.OUT_MODE_COPY;
        var8_8 = false;
        if (var5_5.endsWith(".class")) {
            var9_9 = var4_4.substring(0, var4_4.length() - 6).replace(File.separatorChar, '.');
            if (this.m_coverageFilter == null || this.m_coverageFilter.included((String)var9_9)) {
                var10_11 = null;
                try {
                    var11_12 = Files.newFile(var1_1, var2_2.getPath());
                    var12_17 = this.getFullOutFile(var1_1, var2_2, true);
                    if (this.m_outMode == InstrProcessor.OutMode.OUT_MODE_COPY) {
                        if (this.m_mdata.hasDescriptor(Descriptors.javaNameToVMName((String)var9_9))) {
                            return;
                        }
                        var13_19 = var12_17.lastModified();
                        if (var13_19 > 0L && (var15_21 = var11_12.lastModified()) <= var13_19) {
                            if (var3_3.atVERBOSE()) {
                                var3_3.verbose("destination file [" + var12_17 + "] skipped: more recent that the source file");
                            }
                            return;
                        }
                    }
                    this.readFile(var11_12);
                    var13_20 = ClassDefParser.parseClass(this.m_readbuf, this.m_readpos);
                    this.m_visitor.process(var13_20, this.m_outMode == InstrProcessor.OutMode.OUT_MODE_OVERWRITE, true, true, this.m_instrResult);
                    if (this.m_instrResult.m_instrumented) {
                        ++this.m_classInstrs;
                        this.m_mdata.add(this.m_instrResult.m_descriptor, false);
                        this.m_baos.reset();
                        ClassWriter.writeClassTable(var13_20, this.m_baos);
                        var13_20 = null;
                        var14_23 = this.m_baos.copyByteArray();
                        this.addJob(new FileWriteJob(var12_17, var14_23, var7_7));
                    }
                    if (!var6_6) ** GOTO lbl64
                    var13_20 = null;
                    var14_24 = new byte[this.m_readpos];
                    System.arraycopy(this.m_readbuf, 0, var14_24, 0, this.m_readpos);
                    ++this.m_classCopies;
                    this.addJob(new FileWriteJob(var12_17, var14_24, var7_7));
                }
                catch (FileNotFoundException var11_14) {
                    if (var10_11 == null) ** GOTO lbl64
                    try {
                        var10_11.close();
                    }
                    catch (Exception var11_15) {
                        throw new EMMARuntimeException(var11_15);
                    }
                }
                catch (IOException var11_16) {
                    throw new EMMARuntimeException(var11_16);
                }
                finally {
                    if (var10_11 != null) {
                        try {
                            var10_11.close();
                        }
                        catch (Exception var19_26) {
                            throw new EMMARuntimeException(var19_26);
                        }
                    }
                }
            } else {
                var8_8 = var6_6;
            }
        } else {
            var8_8 = var6_6;
        }
lbl64:
        // 7 sources

        if (var8_8) {
            try {
                var9_9 = Files.newFile(var1_1, var2_2.getPath());
                this.readFile((File)var9_9);
                var10_11 = new byte[this.m_readpos];
                System.arraycopy(this.m_readbuf, 0, var10_11, 0, var10_11.length);
                ++this.m_classCopies;
                var11_12 = this.getFullOutFile(var1_1, var2_2, true);
                this.addJob(new FileWriteJob(var11_12, var10_11, var7_7));
            }
            catch (IOException var9_10) {
                throw new EMMARuntimeException(var9_10);
            }
        }
    }

    public final void handleDirEnd(File file, File file2) {
        Logger logger = this.m_log;
        if (logger.atTRACE2()) {
            logger.trace2("handleDirEnd", "[" + file + "] [" + file2 + "]");
        }
        if (this.m_outMode == InstrProcessor.OutMode.OUT_MODE_OVERWRITE) {
            try {
                this.drainJobQueue();
            }
            catch (IOException iOException) {
                throw new EMMARuntimeException(iOException);
            }
        }
    }

    protected void reset() {
        this.m_visitor = null;
        this.m_mdata = null;
        this.m_readbuf = null;
        this.m_baos = null;
        for (int i = 0; i < this.m_jobs.length; ++i) {
            this.m_jobs[i] = null;
        }
        if (this.m_archiveOut != null) {
            try {
                this.m_archiveOut.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.m_tempArchiveFile != null) {
            this.m_tempArchiveFile.delete();
        }
        this.m_archiveOut = null;
        this.m_origArchiveFile = null;
        this.m_tempArchiveFile = null;
        super.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _run(IProperties iProperties) {
        Logger logger = this.m_log;
        boolean bl = logger.atVERBOSE();
        if (bl) {
            logger.verbose("[EMMA v0.0, build 0 (unsupported private build) (unknown)]");
            logger.verbose("instrumentation path:");
            logger.verbose("{");
            for (int i = 0; i < this.m_instrPath.length; ++i) {
                File file = this.m_instrPath[i];
                String string = file.exists() ? "" : "{nonexistent} ";
                logger.verbose("  " + string + file.getAbsolutePath());
            }
            logger.verbose("}");
            logger.verbose("instrumentation output mode: " + this.m_outMode);
        } else {
            logger.info("processing instrumentation path ...");
        }
        RuntimeException runtimeException = null;
        try {
            long l;
            Object object;
            Comparable<Boolean> comparable;
            File file;
            long l2;
            this.m_timeStamp = l2 = System.currentTimeMillis();
            IPathEnumerator iPathEnumerator = IPathEnumerator.Factory.create(this.m_instrPath, this.m_canonical, this);
            if (this.m_outMode != InstrProcessor.OutMode.OUT_MODE_OVERWRITE) {
                this.createDir(this.m_outDir, true);
            }
            if (this.m_outMode == InstrProcessor.OutMode.OUT_MODE_FULLCOPY) {
                file = Files.newFile(this.m_outDir, "classes");
                this.createDir(file, false);
                comparable = Files.newFile(this.m_outDir, "lib");
                this.createDir((File)comparable, false);
            }
            file = this.m_mdataOutFile;
            comparable = this.m_mdataOutMerge;
            if (file == null) {
                file = new File(iProperties.getProperty("metadata.out.file", "coverage.em"));
            }
            if (comparable == null) {
                object = iProperties.getProperty("metadata.out.merge", EMMAProperties.DEFAULT_META_DATA_OUT_MERGE.toString());
                Comparable<Boolean> comparable2 = comparable = Property.toBoolean((String)object) ? Boolean.TRUE : Boolean.FALSE;
            }
            if (bl) {
                logger.verbose("metadata output file: " + file.getAbsolutePath());
                logger.verbose("metadata output merge mode: " + comparable);
            }
            this.m_readbuf = new byte[32768];
            this.m_readpos = 0;
            this.m_baos = new ByteArrayOStream(32768);
            this.m_jobPos = 0;
            this.m_currentArchiveTS = Long.MAX_VALUE;
            object = CoverageOptionsFactory.create(iProperties);
            this.m_visitor = new InstrVisitor((CoverageOptions)object);
            this.m_mdata = DataFactory.newMetaData((CoverageOptions)object);
            try {
                iPathEnumerator.enumerate();
                this.drainJobQueue();
            }
            catch (IOException iOException) {
                throw new EMMARuntimeException("INSTR_IO_FAILURE", iOException);
            }
            if (logger.atINFO()) {
                l = System.currentTimeMillis();
                logger.info("instrumentation path processed in " + (l - l2) + " ms");
                logger.info("[" + this.m_classInstrs + " class(es) instrumented, " + this.m_classCopies + " resource(s) copied]");
            }
            try {
                if (bl && this.m_mdata != null) {
                    logger.verbose("metadata contains " + this.m_mdata.size() + " entries");
                }
                if (this.m_mdata.isEmpty()) {
                    logger.info("no output created: metadata is empty");
                } else {
                    l2 = System.currentTimeMillis();
                    DataFactory.persist(this.m_mdata, file, ((Boolean)comparable).booleanValue());
                    l = System.currentTimeMillis();
                    if (logger.atINFO()) {
                        logger.info("metadata " + (((Boolean)comparable).booleanValue() ? "merged into" : "written to") + " [" + file.getAbsolutePath() + "] {in " + (l - l2) + " ms}");
                    }
                }
            }
            catch (IOException iOException) {
                throw new EMMARuntimeException("OUT_IO_FAILURE", new Object[]{file.getAbsolutePath()}, iOException);
            }
        }
        catch (SecurityException securityException) {
            runtimeException = new EMMARuntimeException("SECURITY_RESTRICTION:", new String[]{"EMMA"}, securityException);
        }
        catch (RuntimeException runtimeException2) {
            runtimeException = runtimeException2;
        }
        finally {
            this.reset();
        }
        if (runtimeException != null) {
            if (Exceptions.unexpectedFailure(runtimeException, EXPECTED_FAILURES)) {
                throw new EMMARuntimeException("UNEXPECTED_FAILURE", new Object[]{runtimeException.toString(), "this private build is unsupported"}, runtimeException);
            }
            throw runtimeException;
        }
    }

    InstrProcessorST() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeFile(byte[] byArray, File file, boolean bl) throws IOException {
        RandomAccessFile randomAccessFile = null;
        try {
            File file2;
            if (bl && (file2 = file.getParentFile()) != null) {
                file2.mkdirs();
            }
            randomAccessFile = new RandomAccessFile(file, "rw");
            randomAccessFile.setLength(byArray.length);
            randomAccessFile.write(byArray);
        }
        finally {
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeZipEntry(byte[] byArray, ZipOutputStream zipOutputStream, ZipEntry zipEntry, boolean bl) throws IOException {
        if (bl) {
            zipOutputStream.putNextEntry(zipEntry);
            try {
                zipOutputStream.write(byArray);
            }
            finally {
                zipOutputStream.closeEntry();
            }
        }
        ZipEntry zipEntry2 = new ZipEntry(zipEntry.getName());
        zipEntry2.setTime(zipEntry.getTime());
        zipEntry2.setMethod(0);
        zipEntry2.setSize(byArray.length);
        zipEntry2.setCompressedSize(byArray.length);
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray);
        zipEntry2.setCrc(cRC32.getValue());
        zipOutputStream.putNextEntry(zipEntry2);
        try {
            zipOutputStream.write(byArray);
        }
        finally {
            zipOutputStream.closeEntry();
        }
    }

    private void addJob(Job job) throws FileNotFoundException, IOException {
        if (this.m_jobPos == 128) {
            this.drainJobQueue();
        }
        this.m_jobs[this.m_jobPos++] = job;
    }

    private void drainJobQueue() throws IOException {
        for (int i = 0; i < this.m_jobPos; ++i) {
            Job job = this.m_jobs[i];
            if (job == null) continue;
            this.m_jobs[i] = null;
            job.run();
        }
        this.m_jobPos = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFile(File file) throws IOException {
        int n = (int)file.length();
        this.ensureReadCapacity(n);
        FileInputStream fileInputStream = null;
        try {
            int n2;
            int n3;
            fileInputStream = new FileInputStream(file);
            for (n2 = 0; n2 < n && (n3 = ((InputStream)fileInputStream).read(this.m_readbuf, n2, n - n2)) >= 0; n2 += n3) {
            }
            this.m_readpos = n2;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void readZipEntry(ZipInputStream zipInputStream, ZipEntry zipEntry) throws IOException {
        int n = (int)zipEntry.getSize();
        if (n >= 0) {
            int n2;
            int n3;
            this.ensureReadCapacity(n);
            for (n2 = 0; n2 < n && (n3 = zipInputStream.read(this.m_readbuf, n2, n - n2)) >= 0; n2 += n3) {
            }
            this.m_readpos = n2;
        } else {
            int n4;
            this.ensureReadCapacity(32768);
            this.m_baos.reset();
            while ((n4 = zipInputStream.read(this.m_readbuf)) >= 0) {
                this.m_baos.write(this.m_readbuf, 0, n4);
            }
            this.m_readbuf = this.m_baos.copyByteArray();
            this.m_readpos = this.m_readbuf.length;
        }
    }

    private void ensureReadCapacity(int n) {
        if (this.m_readbuf.length < n) {
            int n2 = this.m_readbuf.length;
            this.m_readbuf = null;
            this.m_readbuf = new byte[Math.max(n2 << 1, n)];
        }
    }

    private static final class EntryWriteJob
    extends Job {
        final ZipOutputStream m_out;
        byte[] m_data;
        final ZipEntry m_entry;
        final boolean m_isCopy;

        protected void run() throws IOException {
            InstrProcessorST.writeZipEntry(this.m_data, this.m_out, this.m_entry, this.m_isCopy);
            this.m_data = null;
        }

        EntryWriteJob(ZipOutputStream zipOutputStream, byte[] byArray, ZipEntry zipEntry, boolean bl) {
            this.m_out = zipOutputStream;
            this.m_data = byArray;
            this.m_entry = zipEntry;
            this.m_isCopy = bl;
        }
    }

    private static final class FileWriteJob
    extends Job {
        final File m_outFile;
        final boolean m_mkdirs;
        byte[] m_data;

        protected void run() throws IOException {
            InstrProcessorST.writeFile(this.m_data, this.m_outFile, this.m_mkdirs);
            this.m_data = null;
        }

        FileWriteJob(File file, byte[] byArray, boolean bl) {
            this.m_outFile = file;
            this.m_data = byArray;
            this.m_mkdirs = bl;
        }
    }

    private static abstract class Job {
        private Job() {
        }

        protected abstract void run() throws IOException;
    }
}

