/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.report;

import com.vladium.emma.data.ClassDescriptor;
import com.vladium.emma.data.MethodDescriptor;
import com.vladium.emma.report.IItem;
import com.vladium.emma.report.IItemMetadata;
import com.vladium.emma.report.IItemVisitor;
import com.vladium.emma.report.Item;
import com.vladium.emma.report.MethodItem;
import com.vladium.util.IntObjectMap;
import java.util.Iterator;

public final class ClassItem
extends Item {
    final ClassDescriptor m_cls;
    final boolean[][] m_coverage;
    private int m_firstLine;
    private static final Item.ItemMetadata METADATA = new Item.ItemMetadata(3, "class", 31L);

    public ClassItem(IItem iItem, ClassDescriptor classDescriptor, boolean[][] blArray) {
        super(iItem);
        this.m_cls = classDescriptor;
        this.m_coverage = blArray;
    }

    public String getName() {
        return this.m_cls.getName();
    }

    public String getSrcFileName() {
        return this.m_cls.getSrcFileName();
    }

    public int getFirstLine() {
        if (this.m_firstLine == 0) {
            MethodDescriptor[] methodDescriptorArray = this.m_cls.getMethods();
            int n = Integer.MAX_VALUE;
            int n2 = methodDescriptorArray.length;
            for (int i = 0; i < n2; ++i) {
                int n3 = methodDescriptorArray[i].getFirstLine();
                if (n3 <= 0 || n3 >= n) continue;
                n = n3;
            }
            this.m_firstLine = n;
            return n;
        }
        return this.m_firstLine;
    }

    public ClassDescriptor getClassDescriptor() {
        return this.m_cls;
    }

    public boolean[][] getCoverage() {
        return this.m_coverage;
    }

    public boolean loaded() {
        return this.m_coverage != null;
    }

    public int getAggregate(int n) {
        int[] nArray = this.m_aggregates;
        int n2 = nArray[n];
        if (n2 < 0) {
            switch (n) {
                case 5: 
                case 11: {
                    nArray[11] = 1;
                    nArray[5] = this.m_coverage != null ? 1 : 0;
                    return nArray[n];
                }
                case 1: 
                case 3: 
                case 7: {
                    Object object;
                    boolean[][] blArray = this.m_coverage;
                    IntObjectMap intObjectMap = new IntObjectMap();
                    MethodDescriptor[] methodDescriptorArray = this.m_cls.getMethods();
                    Iterator iterator = this.getChildren();
                    while (iterator.hasNext()) {
                        MethodItem methodItem = (MethodItem)iterator.next();
                        int n3 = methodItem.getID();
                        boolean[] blArray2 = blArray == null ? null : blArray[n3];
                        MethodDescriptor methodDescriptor = methodDescriptorArray[n3];
                        int[] nArray2 = methodDescriptor.getBlockSizes();
                        object = methodDescriptor.getLineMap();
                        for (Object object2 : ((IntObjectMap)object).keys()) {
                            int[] nArray3 = (int[])intObjectMap.get((int)object2);
                            if (nArray3 == null) {
                                nArray3 = new int[4];
                                intObjectMap.put((int)object2, nArray3);
                            }
                            int[] nArray4 = (int[])((IntObjectMap)object).get((int)object2);
                            int n4 = nArray4.length;
                            nArray3[0] = nArray3[0] + n4;
                            for (int i = 0; i < n4; ++i) {
                                int n5 = nArray4[i];
                                boolean bl = blArray2 != null && blArray2[n5];
                                int n6 = nArray2[n5];
                                nArray3[1] = nArray3[1] + n6;
                                if (!bl) continue;
                                nArray3[2] = nArray3[2] + 1;
                                nArray3[3] = nArray3[3] + n6;
                            }
                        }
                    }
                    nArray[7] = intObjectMap.size();
                    int n7 = 0;
                    int n8 = 0;
                    for (int n9 : intObjectMap.keys()) {
                        Object object2;
                        object = (int[])intObjectMap.get(n9);
                        Object object3 = object[0];
                        Object object4 = object[1];
                        Object object5 = object[2];
                        object2 = object[3];
                        if (object2 <= 0) continue;
                        n7 += 100 * object5 / object3;
                        n8 += 100 * object2 / object4;
                    }
                    nArray[1] = n7;
                    nArray[3] = n8;
                    return nArray[n];
                }
            }
            return super.getAggregate(n);
        }
        return n2;
    }

    public void accept(IItemVisitor iItemVisitor, Object object) {
        iItemVisitor.visit(this, object);
    }

    public final IItemMetadata getMetadata() {
        return METADATA;
    }

    public static IItemMetadata getTypeMetadata() {
        return METADATA;
    }
}

