/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.report;

import com.vladium.emma.report.IItem;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Comparator;

public interface IItemAttribute {
    public static final int ATTRIBUTE_NAME_ID = 0;
    public static final int ATTRIBUTE_CLASS_COVERAGE_ID = 1;
    public static final int ATTRIBUTE_METHOD_COVERAGE_ID = 2;
    public static final int ATTRIBUTE_BLOCK_COVERAGE_ID = 3;
    public static final int ATTRIBUTE_LINE_COVERAGE_ID = 4;
    public static final int UNITS_COUNT = 0;
    public static final int UNITS_INSTR = 1;

    public Comparator comparator();

    public String getName();

    public void format(IItem var1, StringBuffer var2);

    public boolean passes(IItem var1, int var2);

    public static abstract class Factory {
        private static final IItemAttribute[][] ATTRIBUTES;

        public static IItemAttribute getAttribute(int n, int n2) {
            return ATTRIBUTES[n2][n];
        }

        public static IItemAttribute[] getAttributes(int n) {
            return (IItemAttribute[])ATTRIBUTES[n].clone();
        }

        private Factory() {
        }

        static {
            NameAttribute nameAttribute = new NameAttribute("name");
            FractionAttribute fractionAttribute = new FractionAttribute("class, %", 5, 11, 1, 0);
            FractionAttribute fractionAttribute2 = new FractionAttribute("method, %", 4, 10, 1, 0);
            ATTRIBUTES = new IItemAttribute[][]{{nameAttribute, fractionAttribute, fractionAttribute2, new FractionAttribute("block, %", 0, 6, 1, 0), new FractionAttribute("line, %", 1, 7, 100, 1)}, {nameAttribute, fractionAttribute, fractionAttribute2, new FractionAttribute("block, %", 2, 8, 1, 0), new FractionAttribute("line, %", 3, 7, 100, 1)}};
        }

        private static final class FractionAttribute
        extends Attribute
        implements IItemAttribute {
            final int m_numeratorAggregateID;
            final int m_denominatorAggregateID;
            private final int m_scale;
            private final DecimalFormat m_format;
            private final DecimalFormat m_nFormat;
            private final FieldPosition m_fieldPosition;
            private final Comparator m_comparator;

            public Comparator comparator() {
                return this.m_comparator;
            }

            public void format(IItem iItem, StringBuffer stringBuffer) {
                int n = iItem.getAggregate(this.m_numeratorAggregateID);
                double d = (double)n / (double)this.m_scale;
                int n2 = iItem.getAggregate(this.m_denominatorAggregateID);
                int n3 = stringBuffer.length();
                if (n2 == 0) {
                    this.m_format.format(1.0, stringBuffer, this.m_fieldPosition);
                } else {
                    this.m_format.format(d / (double)n2, stringBuffer, this.m_fieldPosition);
                }
                int n4 = Math.max(1, 5 - stringBuffer.length() + n3);
                for (int i = 0; i < n4; ++i) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append('(');
                this.m_nFormat.format(d, stringBuffer, this.m_fieldPosition);
                stringBuffer.append('/');
                stringBuffer.append(n2);
                stringBuffer.append(')');
            }

            public boolean passes(IItem iItem, int n) {
                int n2;
                int n3 = iItem.getAggregate(this.m_numeratorAggregateID);
                return (double)n3 * 100.0 >= (double)(n2 = iItem.getAggregate(this.m_denominatorAggregateID)) * (double)this.m_scale * (double)n;
            }

            FractionAttribute(String string, int n, int n2, int n3, int n4) {
                super(string);
                this.m_numeratorAggregateID = n;
                this.m_denominatorAggregateID = n2;
                this.m_scale = n3;
                this.m_format = (DecimalFormat)NumberFormat.getPercentInstance();
                this.m_fieldPosition = new FieldPosition(0);
                this.m_format.setMaximumFractionDigits(0);
                this.m_nFormat = (DecimalFormat)NumberFormat.getInstance();
                this.m_nFormat.setGroupingUsed(false);
                this.m_nFormat.setMaximumFractionDigits(n4);
                this.m_comparator = new FractionComparator();
            }

            private final class FractionComparator
            implements Comparator {
                private FractionComparator() {
                }

                public int compare(Object object, Object object2) {
                    IItem iItem = (IItem)object;
                    IItem iItem2 = (IItem)object2;
                    double d = iItem.getAggregate(FractionAttribute.this.m_numeratorAggregateID);
                    double d2 = iItem.getAggregate(FractionAttribute.this.m_denominatorAggregateID);
                    double d3 = iItem2.getAggregate(FractionAttribute.this.m_numeratorAggregateID);
                    double d4 = iItem2.getAggregate(FractionAttribute.this.m_denominatorAggregateID);
                    double d5 = d * d4 - d3 * d2;
                    return d5 > 0.0 ? 1 : (d5 < 0.0 ? -1 : 0);
                }
            }
        }

        private static final class NameAttribute
        extends Attribute
        implements IItemAttribute {
            private final Comparator m_comparator = new NameComparator();

            public Comparator comparator() {
                return this.m_comparator;
            }

            public void format(IItem iItem, StringBuffer stringBuffer) {
                stringBuffer.append(iItem.getName());
            }

            public boolean passes(IItem iItem, int n) {
                return true;
            }

            NameAttribute(String string) {
                super(string);
            }

            private static final class NameComparator
            implements Comparator {
                private NameComparator() {
                }

                public int compare(Object object, Object object2) {
                    IItem iItem = (IItem)object;
                    IItem iItem2 = (IItem)object2;
                    return iItem.getName().compareTo(iItem2.getName());
                }
            }
        }

        private static abstract class Attribute
        implements IItemAttribute {
            private final String m_name;

            public String getName() {
                return this.m_name;
            }

            protected Attribute(String string) {
                if (string == null) {
                    throw new IllegalArgumentException("null input: name");
                }
                this.m_name = string;
            }
        }
    }
}

